<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('comptes', function (Blueprint $table) {
            $table->string('adresse')->nullable()->change();
            $table->string('email')->nullable()->change();
            $table->string('site')->nullable()->change();
            $table->string('tel')->nullable()->change();
            $table->string('fax')->nullable()->change();
            $table->string('date_creation')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('comptes', function (Blueprint $table) {
            $table->string('adresse')->nullable(false)->change();
            $table->string('email')->nullable(false)->change();
            $table->string('site')->nullable(false)->change();
            $table->string('tel')->nullable(false)->change();
            $table->string('fax')->nullable(false)->change();
            $table->string('date_creation')->nullable(false)->change();
        });
    }
};
