<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('rh_documents', function (Blueprint $table) {
            $table->id();
            $table->string('nom');
            $table->string('path');
            $table->unsignedBigInteger('rh_id')->nullable();
            $table->timestamps();

            $table->foreign('rh_id')->references('id')->on('users');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('rh_documents');
    }
};
