var pa_map = undefined;
var pa_table = undefined;
var pa_style = {
    fillColor: '#29ABE2',
    weight: 2,
    opacity: 1,
    color: 'white',
    dashArray: '3',
    fillOpacity: 0.7
}
var pa_googleSat = L.tileLayer('https://www.google.com/maps/vt?lyrs=s@189&gl=ma&x={x}&y={y}&z={z}', {
    maxZoom: 20,
});

var pa_googlehybrid = L.tileLayer('https://www.google.com/maps/vt?lyrs=y@189&gl=ma&x={x}&y={y}&z={z}', {
    maxZoom: 20,

});

var pa_googlemap = L.tileLayer('https://www.google.com/maps/vt?lyrs=m@189&gl=ma&x={x}&y={y}&z={z}', {
    maxZoom: 20,
});

var pa_map_layers_group = new L.featureGroup();

$(document).ready(function () {

   pa_table = $('#pa_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: true,
        pageLength: 20,
        lengthChange: false,
        bFilter: true,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: true,
        searching: true,
        scrollX: false,
        ajax: assetBaseUrl + 'centre_donnees/pa/datatable?filters=[]',
        dom: "lBfrtip",
        buttons: [
            {
                "extend": 'excel',
                "text": '',
                "titleAttr": 'excel',
                'title': 'Projets-' + current_date.replaceAll("/", "-"),
                "action": newexportaction
            },
        ],
        columnDefs: [
            { lassName: 'text-left', targets: [0] },
             
        ],
        columns: [
            {
                data: 'zone',
            },
                      
        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },

    }).on("xhr.dt", function (e, settings, json, xhr) {

        //$("#dt_dossiers_count").text(json.recordsFiltered);
    });

    pa_map = new L.Map('pa_map', {
        zoomControl: false,
        center: new L.LatLng(32.62087018318113, -6.262207031250001),
        zoom: 6,
        editable: true,
        drawControl: true,
        preferCanvas: true,
        attributionControl: false,
        fullscreenControl: true,

    });

    L.Control.ZoomExtent = L.Control.extend(
        {
            options:
            {
                position: 'topleft',
            },
            onAdd: function (map) {
                var controlDiv = L.DomUtil.create('div', 'leaflet-draw-toolbar leaflet-bar');

                L.DomEvent
                    .addListener(controlDiv, 'click', L.DomEvent.stopPropagation)
                    .addListener(controlDiv, 'click', L.DomEvent.preventDefault)
                    .addListener(controlDiv, 'click', function () {

                        var group = new L.featureGroup();
                        pa_map.eachLayer(function (layer) {
                            if (layer instanceof L.Path) {
                                group.addLayer(layer);
                            }

                        });
                        pa_map.fitBounds(group.getBounds());
                    });


                var controlUI = L.DomUtil.create('a', 'leaflet-draw-edit-remove fa-solid fa-magnifying-glass-location', controlDiv);
                controlUI.title = 'Zoom étendu';
                controlUI.href = '#';
                return controlDiv;
            }
        });

    var ZoomExtentControl = new L.Control.ZoomExtent();
    pa_map.addControl(ZoomExtentControl);

    pa_googlehybrid.addTo(pa_map);

    loadPA();
});

function loadPA() {
 
    $.ajax({
        url: assetBaseUrl + "centre_donnees/pa/getall",
        type: "GET",
        dataType: "json",
        processData: false,
        contentType: false,
        success: function (response) {


            pa_map_layers_group = new L.featureGroup();

            response.forEach(element => {

                var geometry = L.geoJSON(JSON.parse(element.geometry));
                geometry.addTo(pa_map);
                geometry.setStyle(pa_style);

                geometry.bindPopup(element.zone);
                pa_map_layers_group.addLayer(geometry);
            });

            pa_map.fitBounds(pa_map_layers_group.getBounds());
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
}