var paiements_table = undefined;
var add_paiement_modal = undefined;

 
$(document).ready(function () {
    paiements_table = $('#paiements_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: true,
        pageLength: 25,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: true,
        searching: false,
        scrollX: false,
        ajax: assetBaseUrl + "paiements/datatable?filters=[]&projet_id=" + projet_id,
        dom: "lBfrtip",
        buttons: [
            {
                "extend": 'excel',
                "text": '',
                "titleAttr": 'excel',
                'title': 'Echantillions-' + current_date.replaceAll("/", "-"),
                "action": newexportaction
            },
        ],
        columnDefs: [
            { lassName: 'text-center', targets: [0] },
     
        ],
        columns: [
            {
                data: 'card',
            },
            

        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },

    }).on("xhr.dt", function (e, settings, json, xhr) {

        //$("#dt_dossiers_count").text(json.recordsFiltered);
    });

    echantillons_table.on('draw', function () {

    })

    $('.timepicker').timepicker({
        showInputs: true,
        showMeridian: false
    });

    add_paiement_modal = new bootstrap.Modal(document.getElementById('add_paiement_modal'), {
        backdrop: 'static',
        keyboard: false
    });

});


$("#add_paiement_btn").click(function () {

   

    add_paiement_modal.show();
});



$("#add_paiement_form").submit(function (event) {
    event.preventDefault();

    showLoading('Chargement...', 'veuillez patienter...');

    $("#add_paiement_modal_save_btn").attr('disabled', 'disabled');

    var formData = new FormData(this);

    formData.append("projet_id", projet_id);
    $.ajax({
        url: assetBaseUrl + "paiements/store",
        type: "POST",
        dataType: "json",
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
            closeLoading();
            $("#add_paiement_modal_save_btn").removeAttr('disabled');
            if (response.success == 1) {
                add_paiement_modal.hide();
                paiements_table.ajax.reload();
            }
            else {


            }

        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});

 

$("body").on("click", ".validate_paiement_btn", function () {
    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");

    var id = $(this).attr("id");
    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous certain(e) de vouloir valider le paiement ?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: assetBaseUrl + "paiements/validate",
                type: "POST",
                dataType: "json",
                data: {
                    id: id,
                    _token: csrfToken,
                },
                success: function (response) {
                    paiements_table.ajax.reload();

                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText);
                },
            });
        }
    });
});


$("body").on("click", ".rejeter_paiement_btn", function () {

    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
    var id = $(this).attr("id");
    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous certain(e) de vouloir rejeter le paiement ?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: assetBaseUrl + "paiements/reject",
                type: "POST",
                dataType: "json",
                data: {
                    id: id,
                    _token: csrfToken,
                },
                success: function (response) {
                    paiements_table.ajax.reload();

                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText);
                },
            });
        }
    });
});

 