var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
var plle_style = {
    fillColor: '#358eb0',
    weight: 3,
    opacity: 1,
    color: '#ffc000',
    fillOpacity: 0.60
}


function initMap(div_id, lot_id) {
    var lot_data = undefined;
    var googlehybrid = L.tileLayer('https://www.google.com/maps/vt?lyrs=y@189&gl=ma&x={x}&y={y}&z={z}', {
        maxZoom: 20,

    });

    var map = new L.Map(div_id, {
        zoomControl: true,
        center: new L.LatLng(32.62087018318113, -6.262207031250001),
        zoom: 6,
        editable: true,
        drawControl: true,
        preferCanvas: true,
        attributionControl: false
    });

    googlehybrid.addTo(map);


    $.ajax({
        url: assetBaseUrl + 'lots/get',
        type: "POST",
        data: {
            _token: csrfToken,
            id: lot_id,
        },

        success: function(result) {
            lot_data = result.lot;

            var layers_group = new L.featureGroup();
            var geojson = L.geoJSON(JSON.parse(lot_data.geometry));
            geojson.setStyle(plle_style);
            geojson.addTo(map);
            layers_group.addLayer(geojson);
            map.fitBounds(layers_group.getBounds());

                var popupContent = `
            <div style="font-size: 14px;    padding: 0px 8px 16px 8px;">
                <h6 style="font-size: 1.1rem; color: #115555;margin-bottom: 15px !important;text-align: center;">Lot numéro ${lot_data.numero}</h6>            
                <span style="display: block;width:100%" class="mt-1"><i class="fa-solid fa-circle-info mr-2"></i>Référence Foncière: <b style="color: #115555;">${lot_data.ref_fonciere}</b></span>
                <span style="display: block;width:100%" class="mt-1"><i class="fa-solid fa-ruler-combined mr-2"></i>Surface: <b style="color: #115555;">${lot_data.surface}</b></span>
                <span style="display: block;width:100%" class="mt-1"><i class="fa-solid fa-layer-group mr-2"></i>Nombre de Niveaux:  <b style="color: #115555;">${lot_data.nombre_niveaux}</b></span>
                <span style="display: block;width:100%" class="mt-1"><i class="fa-solid fa-circle-info mr-2"></i>Sous-sol: <b  ${lot_data.sous_sol == 1 ? 'style="color:#3f9416"> Oui' : 'style="color:#fb5151"> Non'}</b></span>
            </div>
            `;

            geojson.bindPopup(popupContent);
        }
    });



}
$(document).ready(function() {
    initMap('mapdiv', lot_id);
    
});
