var entreprises_table = undefined;


$(document).ready(function () {


    entreprises_table = $('#entreprises_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: false,
        pageLength: 10,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: false,
        searching: false,
        scrollX: false,
        ajax: null,
        buttons: [],
        dom: "lBfrtip",
        columnDefs: [
            { className: 'text-left', targets: [0] },
            { className: 'text-center', targets: [1, 2, 3, 4, 5] },
        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },

    });

    loadPrestataireTypeEntreprise();
});


$("#entreprise_demander_devis_btn").click(function () {

    $("#client_demande_devis_form [name='type_prestataire']").val("entreprise");
    demande_devis_modal_table.ajax.url(assetBaseUrl + `projets/intervenants/datatable?filters=[{"column":"type","value":"entreprise"}]`).load();;
    $("#client_demande_devis_modal_prestatire_txt").text("Entreprise");
    $("#client_demande_devis_modal_prestatire_txt_2").text("une nouvelle entreprise");
    demande_devis_modal.show();
})

function refresh_entreprise_retunu_div() {
    $html = `<div>
    <i style="font-size: 4rem;color: #d5a44f;margin: auto;display: block;text-align: center;padding: 12px;" class="fa-solid fa-circle-info"></i>
        <span style="font-size: 1.25rem; color: #d5a44f; text-align: center; margin: auto; display: block;">Vous devez accepter une offre de prix</span>
   </div> `;


    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");

    $.ajax({
        url: assetBaseUrl + "projets/demandes_contrat/get",
        type: "POST",
        data: {
            _token: csrfToken,
            projet_id: projet_id,
            type_prestataire: 'entreprise',
        },
        success: function (response) {

            response.forEach(demande_contrat => {
                if (demande_contrat.type == "entreprise") {

                    $contrat_html = "";


                    if (demande_contrat.etat == "en_cours") {

                        $contrat_html = `<div  style="background: #fefefe;border: 1px #7a7a7a solid;" class="document-card">
                        <h6 class="mt-1" style="text-align: center;font-size: 0.85rem;font-weight: 500;color: #003a62;">
                            <i style="font-size: 2rem; width: 100%; color: #286baf; margin-bottom: 8px;" class="fa-solid fa-file-contract"></i>
                            Contrat
                        </h6>
                        <span style="width: 100%; display: block; text-align: center;">En attente du contrat</span>
                        <span style="width: 100%; display: block; text-align: center;">Le prestataire est tenu de charger le contrat</span>
                    </div>`;

                    }

                    if (demande_contrat.etat == "uploaded" && demande_contrat.accepted == 0) {
                        $contrat_html = `<div class="document-card">
                        <h6 class="mt-1" style="text-align: center;font-size: 0.85rem;font-weight: 500;color: #003a62;">
                            <i style="font-size: 2rem; width: 100%; color: #286baf; margin-bottom: 8px;" class="fa-solid fa-file-contract"></i>
                            Contrat
                        </h6>
                        <span style="width: 100%; display: block; text-align: center;">Contrat chargé le ${formatDate(demande_contrat.contrat_file.created_at)}</span>
                       <div class="mt-1" style="margin: auto; display: block;text-align: center;">
                            <button type_document="CONTRAT" file_id="${demande_contrat.contrat_file.id}" type="button" class="btn  download_doc_link"> <i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                        </div>

                         <div class="mt-1" style="padding: 8px;border-top: 1px #e1e1e1 solid;margin: auto; display: block;text-align: center;">
                            <button style="min-width:90px;" id="${demande_contrat.id}" type="button" class="btn btn-big contrat_accept_btn"> <i class="fa-solid fa-thumbs-up"></i>&nbsp;Accepter</button>
                            <button  style="min-width:90px;" id="${demande_contrat.id}"  type="button" class="btn btn-big btn-danger contrat_reject_btn"> <i class="fa-solid fa-xmark"></i>&nbsp;Rejeter</button>
                        </div>
                    </div>`;
                    }
                    if (demande_contrat.etat == "uploaded" && demande_contrat.accepted == 1) {
                        $contrat_html = `<div style="background: #eeffea;border: 1px #55cf18 solid;" class="document-card">
                        <h6 class="mt-1" style="text-align: center;font-size: 0.85rem;font-weight: 500;color: #58a137;">
                            <i style="font-size: 2rem; width: 100%; color: #58a137; margin-bottom: 8px;" class="fa-solid fa-file-contract"></i>
                            Contrat
                        </h6>
                        <span style="width: 100%; display: block; text-align: center;">Vous avez approuvé le contrat</span>
                       <div class="mt-1" style="margin: auto; display: block;text-align: center;">
                            <button type_document="CONTRAT" file_id="${demande_contrat.contrat_file.id}" type="button" class="btn  download_doc_link"> <i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                        </div>                                      
                    </div>`;
                    }

                    $html = `<div class="row">
                                <div class="col-sm-8 col-12" style="padding:8px">
                                    <div class="row ">
                                        <div class="col-12 col-sm-6">
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text" style="width: 100px;">${pretsatires_list[selected_prestataire_index].full_name} :</span>
                                                </div>
                                                <input style="background: unset;border: unset;border-bottom: 1px #ced4da dashed;" readonly="" class="form-control" value="${demande_contrat.prestataire.organisme_ste}">
                                            </div>
                                        </div>
                                        <div class="col-12 col-sm-6">
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text" style="width: 100px;">Ville :</span>
                                                </div>
                                                <input style="background: unset;border: unset;border-bottom: 1px #ced4da dashed;" readonly="" class="form-control" value="${demande_contrat.prestataire.ville != undefined ? demande_contrat.prestataire.ville.nom : ''}">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row mt-1">
                                        <div class="col-12 col-sm-6">
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text" style="width: 100px;">Téléphone :</span>
                                                </div>
                                                <input style="background: unset;border: unset;border-bottom: 1px #ced4da dashed;" readonly="" class="form-control" value="${demande_contrat.prestataire.tel}">
                                            </div>
                                        </div>
                                        <div class="col-12 col-sm-6">
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text" style="width: 100px;">Email :</span>
                                                </div>
                                                <input style="background: unset;border: unset;border-bottom: 1px #ced4da dashed;" readonly="" class="form-control" value="${demande_contrat.prestataire.email}">
                                            </div>
                                        </div>

                                    </div>
                                    <div class="row mt-1">   
                                        <div class="col-12 col-sm-6">
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text" style="width: 100px;">Honoraire :</span>
                                                </div>
                                                <input style="background: unset;border: unset;border-bottom: 1px #ced4da dashed;" readonly="" class="form-control" value="${formatNumber(demande_contrat.prix_offre)} MAD">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4 col-12">
                                    ${$contrat_html}
                                </div>
                            </div>
                    `;


                }
            });
            $(".entreprise_retenu_div").html($html);
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
}

function refresh_entreprise_data() {
    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
    $.ajax({
        url: assetBaseUrl + "projets/demandes_devis/get",
        type: "POST",
        data: {
            _token: csrfToken,
            projet_id: projet_id,
            type: "entreprise"
        },
        success: function (response) {
            entreprises_table.rows().clear().draw();
            response.forEach(demande_devis => {
                insert_row_entreprises_table(demande_devis);
            });
         
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
}


function insert_row_entreprises_table(demande_devis) {
    var prestataire_html = `<img src="${demande_devis.prestataire.avatar}" class="user-image rounded-circle" style="height: 30px;float: left; border: #1e6f6c solid; border-width: 1px;margin-right: 6px; margin-left: 6px;"><b style="margin-top: 6px; display: block;">${demande_devis.prestataire.organisme_ste}</b>`;
    var ville_html = `<b></b>`;
    if (demande_devis.prestataire.ville != undefined) {
        var ville_html = `<b>${demande_devis.prestataire.ville.nom}</b>`;
    }

    var tel_html = `<b>${demande_devis.prestataire.tel}</b>`;
    var prix_offre_html = '<b style="color:#b3772a">En attente...</b>';;
    var devis_html = '<b style="color:#b3772a">En attente...</b>';
    var btn_html = '<b style="color:#b3772a">En attente...</b>';
    var reponse_detail_html = '<b style="color:#b3772a">En attente...</b>';

    if (demande_devis.etat == "devis_uploaded") {
        prix_offre_html = `<b style="color:#4f9942">${formatNumber(demande_devis.prix_offre)} <span style="color:gray" class="ml-1">MAD<span></b> `;
        devis_html = `<button file_id="${demande_devis.file_id}" type_document="DEVIS"   type="button" class="btn  download_doc_link"><i class="fa-solid fa-download mr-1"></i>Télécharger le devis</button>`;
        btn_html = `<button demande_id="${demande_devis.id}" type="button" class="btn mt-1 mb-1  entreprises_table_add_to_retenu_btn"><i class="fa-solid fa-check mr-1"></i>Accepter l'offre</button>`;
        reponse_detail_html = `<button demande_id="${demande_devis.id}" type="button" class="btn reponse_demande_devis_detail"><i class="fa-solid fa-circle-info mr-1"></i>Détail de l'offre</button>`;

    }
    if (demande_devis.accepted == 1) {
        btn_html = '<b style="color:#658f30"><i class="fa-regular fa-thumbs-up mr-1"></i>Offre de prix acceptée</b>';
    }



    entreprises_table.row.add([prestataire_html, ville_html, tel_html, prix_offre_html, devis_html, btn_html, demande_devis]).draw();
}


$("body").on('click', '.entreprises_table_add_to_retenu_btn', function () {
    var demande_id = $(this).attr('demande_id');


    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");

    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous sûr de vouloir accepter l'offre ?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {


            $.ajax({
                url: assetBaseUrl + "projets/demande_devis/accept",
                type: "POST",
                data: {
                    _token: csrfToken,
                    demande_id: demande_id,
                    projet_id: projet_id,
                    type: "entreprise"
                },
                success: function (response) {
                    if (response.success == 1) {
                        loadPrestataireType();
                    }
                    else {
                        if (response.error == "DEMANDE_CONTRAT_EN_COURS") {
                            gl_alert('error', 'TamkinInvest', "Il est impossible d'accepter l'offre tant qu'une offre du contrat est en attente.");
                        }
                        if (response.error == "DEMANDE_CONTRAT_ALREADY_UPLOADED") {
                            gl_alert('error', 'TamkinInvest', "Il est impossible d'accepter l'offre tant qu'une offre du contrat est en attente.");
                        }

                    }

                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText);
                },
            });


        }
    });
});


function loadPrestataireTypeEntreprise() {
  
    refresh_entreprise_retunu_div();
    refresh_entreprise_data();


}