var eb_data_modal = undefined;
var eb_current_data = undefined;

$(document).ready(function () {
    load_eb_data();

    eb_data_modal = new bootstrap.Modal(document.getElementById('eb_data_modal'), {
        backdrop: 'static',
        keyboard: false
    });


    $(document).ready(function () {
        $('[data-toggle="tooltip"]').tooltip();
    });


});

$(".eb-btn").click(function () {

    $(this).toggleClass('active');
    $(this).find('.data-span').toggleClass('active');

    update_expression_besoin();
});


$(".data-span").click(function (event) {

    event.stopPropagation();

    var data_inputs = $(this).attr('data-inputs');

    var surface = $(this).parent().attr('surface');
    var nombre = $(this).parent().attr('nombre');

    $("#eb_data_modal_nombre").val(nombre);
    $("#eb_data_modal_surface").val(surface);

    $(".eb_data_modal_nombre_div").css('display', 'none');
    $(".eb_data_modal_surface_div").css('display', 'none');

    if (data_inputs == "surface") {

        $(".eb_data_modal_surface_div").css('display', 'block');
    }
    if (data_inputs == "nombre") {
        $(".eb_data_modal_nombre_div").css('display', 'block');
    }

    eb_current_data = this;
    eb_data_modal.show();
});



$("#eb_data_modal_form").submit(function (event) {
    event.preventDefault();

    var surface = $("#eb_data_modal_surface").val();
    var nombre = $("#eb_data_modal_nombre").val();



    eb_current_data.parentElement.setAttribute("nombre", nombre);
    eb_current_data.parentElement.setAttribute("surface", surface);


    if (surface > 0) {
        

        eb_current_data.textContent=`${lang_data["Surface"]} :${surface} m²`;
    }
    if (nombre > 0) {
         
        eb_current_data.textContent=`${lang_data["Nombre"]} :${nombre}`;
    }

    eb_data_modal.hide();

    update_expression_besoin();
});


function get_eb_json() {

    var data = [];
    $(".eb-btn").each(function () {
        var name = $(this).attr('data');
        var active = $(this).hasClass('active') ? 1 : 0;

        var surface = $(this).attr('surface');
        var nombre = $(this).attr('nombre');
        data.push({
            name: name,
            active: active,
            surface: surface,
            nombre: nombre,
        });
    });

    return data;
}


function load_eb_data() {
    var eb_data = JSON.parse(projetdata.eb_data);

    eb_data.forEach(element => {
        if (element.active == 1) {
            $(".eb-btn[data='" + element.name + "']").addClass('active');

            $(".eb-btn[data='" + element.name + "'] .data-span").addClass('active');


            $(".eb-btn[data='" + element.name + "']").attr('surface', element.surface);
            $(".eb-btn[data='" + element.name + "']").attr('nombre', element.nombre);

            //Surface :0 m²
            //Nombre :0

            if (element.surface > 0) {
                $(".eb-btn[data='" + element.name + "'] .data-span").text(`${lang_data["Surface"]} :${element.surface} m²`);
            }
            if (element.nombre > 0) {
                $(".eb-btn[data='" + element.name + "'] .data-span").text(`${lang_data["Nombre"]} :${element.nombre}`);
            }

        }

    });
}

function update_expression_besoin(client_eb_tertiaire_type = null) {


    var description = $("#descripition_projet").val();
    var eb_data = JSON.stringify(get_eb_json());

    $.ajax({
        url: assetBaseUrl + "client/projet/update_expression_besoin_client",
        type: "POST",
        data: {
            _token: csrfToken,
            projet_id: projet_id,
            client_eb_habitation: "",
            client_eb_tertiaire_type: "",
            client_eb_standing: "",
            description: description,
            eb_data: eb_data

        },
        success: function (response) {

        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
}