var reunions_table = undefined;
var client_add_reunion_modal = undefined;
const videoContainer = document.getElementById('video-container');
$(document).ready(function () {
    reunions_table = $('#reunions_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: false,
        pageLength: 25,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: true,
        searching: false,
        scrollX: false,
        ajax: assetBaseUrl + "reunions/client_datatable?filters=[]&projet_id=" + projet_id,
        dom: "lBfrtip",
        buttons: [
            {
                "extend": 'excel',
                "text": '',
                "titleAttr": 'excel',
                'title': 'Dossiers-' + current_date.replaceAll("/", "-"),
                "action": newexportaction
            },
        ],
        columnDefs: [
            { lassName: 'text-left', targets: [0, 1, 2] },

        ],
        columns: [

            {
                data: 'participants',
            },


            {
                data: 'date',
            },

            {
                data: 'actions',
            },



        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },

    }).on("xhr.dt", function (e, settings, json, xhr) {

        //$("#dt_dossiers_count").text(json.recordsFiltered);
    });

    reunions_table.on('draw', function () {

    })

    $('.timepicker').timepicker({
        showInputs: true,
        showMeridian: false
    });

    client_add_reunion_modal = new bootstrap.Modal(document.getElementById('client_add_reunion_modal'), {
        backdrop: 'static',
        keyboard: false
    });

});


$("#add_reunion_btn").click(function () {

    $("#add_reunion_modal_object_select").val("Assistance").change();
    client_add_reunion_modal.show();
});

$(".participant_card").click(function () {
    $(this).toggleClass("selected");
});


$("#client_add_reunion_modal_form").submit(function (event) {
    event.preventDefault();

    showLoading('Chargement...', 'Création d\'une nouvelle réunion, veuillez patienter');

    $("#client_add_reunion_modal_save").attr('disabled', 'disabled');

    var formData = new FormData(this);


    var participants = [];
    $(".participant_card").each(function () {




        if ($(this).hasClass("selected") || $(this).hasClass("host")) {

            if (!participants.some(str => str.includes($(this).attr("user_id")))) {
                participants.push($(this).attr("user_id"));
            }

        }

    });


    formData.append("participants", JSON.stringify(participants));
    formData.append("projet_id", projet_id);
    $.ajax({
        url: assetBaseUrl + "reunion/new",
        type: "POST",
        dataType: "json",
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
            closeLoading();
            $("#client_add_reunion_modal_save").removeAttr('disabled');
            if (response.success == 1) {
                client_add_reunion_modal.hide();
                reunions_table.ajax.reload();
            }
            else {

                if (response.error == "ONLY_ONE_PARTICIPANT") {
                    gl_alert('error', 'TamkinInvest', "La réunion ne peut pas être créée, le nombre de participants doit être supérieur à 1.");
                }
                if (response.error == "WRONG_DATE") {
                    gl_alert('error', 'TamkinInvest', "La réunion ne peut pas être créée, Veuillez sélectionner une date valide.");
                }

            }

        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});

$("body").on("click", ".join_meet_btn", function () {
    var id = $(this).attr("id");
    createFrameAndJoinRoom(id);
});

$("#add_reunion_modal_object_select").change(function () {

    if ($(this).val() == "Autre") {
        $(".objet_autre_div").css("display", "block");
    }
    else {
        $(".objet_autre_div").css("display", "none");
    }
});


$("body").on("click", ".copy_meet_url_btn", function () {
    var id = $(this).attr("id");
    var url = "https://tamkininvest.ma/rooms/" + id;
    navigator.clipboard.writeText(url);

    $.toast({
        heading: "TamkinInvest",
        text: 'Le lien de la réunion a été copié.',
        icon: "success",
        position: "bottom-right",
        hideAfter: 3000,
        stack: false,
    });
});


$("#quit_reunion_btn").click(function () {
    $("#videochat_div").css('display', 'none');
    $("#reunions_div").css('display', 'block');
    window.call.leave();
    window.call.destroy();
    window.call = null;
});

function createFrameAndJoinRoom(room_id) {

    $("#videochat_div").css('display', 'block');
    $("#reunions_div").css('display', 'none');

    var room_name = room_id;

    window.call = window.Daily.createFrame(videoContainer, {
        iframeStyle: {
            width: '100%',
            height: '100%',
            border: 'none',
            allow: 'camera; microphone; fullscreen; display-capture'
        }
    });
    call.join({
        url: `https://tamkintest.daily.co/${room_name}?name=${auth_user.nom + ' ' + auth_user.prenom}`,

    });

    call.on('joined-meeting', () => {
        console.log('Participant has joined the video chat session');

    });
}
$("#prendre_rendez_vous_btn").click(function () {

    Swal.fire({
        title: 'Confirmation',
        text:  lang_data["Souhaitez-vous être appelé pour organiser une réunion ?"],
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: assetBaseUrl + "client/projet/client_first_time",
                type: "POST",
                data: {
                    _token: csrfToken,
                    projet_id: projet_id,
                },
                success: function (response) {

                    Swal.fire({
                        title: `AlomraneAssist`,
                        text: lang_data["Vous serez contacté par votre conseiller dans les meilleurs délais."],
                        icon: "success",
                        showCancelButton: false,
                        confirmButtonColor: '#88C241',
                        cancelButtonColor: '#F83F37',
                        confirmButtonText:  lang_data['Retourner à mon projet'],
                        allowOutsideClick: false,
                        cancelButtonText: ""
                    }).then((result) => {
                        location.href = "/client/projet/" + projet_id ;
                    });
                }
            });
        }
    });

})
$("#first_reunion_btn").click(function () {


    $.ajax({
        url: assetBaseUrl + "client/projet/client_first_time",
        type: "POST",
        data: {
            _token: csrfToken,
            projet_id: projet_id,
        },
        success: function (response) {

            Swal.fire({
                title: `AlomraneAssist`,
                text: lang_data["Vous serez contacté par votre conseiller dans les meilleurs délais."],
                icon: "success",
                showCancelButton: false,
                confirmButtonColor: '#88C241',
                cancelButtonColor: '#F83F37',
                confirmButtonText:  lang_data['Commencer mon projet'],
                allowOutsideClick: false,
                cancelButtonText: ""
            }).then((result) => {
                location.href = "/client/projet/" + projet_id ;
            });
        }
    });



});
$("body").on("click", ".ask_for_different_meeting_time_btn", function () {
   


    Swal.fire({
        title: 'Confirmation',
        text: lang_data["Souhaitez-vous être appelé pour organiser une réunion ?"],
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: assetBaseUrl + "client/projet/client_first_time",
                type: "POST",
                data: {
                    _token: csrfToken,
                    projet_id: projet_id,
                },
                success: function (response) {

                    Swal.fire({
                        title: `AlomraneAssist`,
                        text: lang_data["Vous serez contacté par votre conseiller dans les meilleurs délais."],
                        icon: "success",
                        showCancelButton: false,
                        confirmButtonColor: '#88C241',
                        cancelButtonColor: '#F83F37',
                        confirmButtonText: 'Retourner à mon projet',
                        allowOutsideClick: false,
                        cancelButtonText: ""
                    }).then((result) => {
                        location.href = "/client/projet/" + projet_id ;
                    });
                }
            });
        }
    });
});
 