var current_data = undefined;
$(document).ready(function () {
    load_data("all");
    load_evolution_des_avances_chart("all");
    load_depot_dossiers_attribution_chart("all");
    $(".select2").select2();
    $(".select2nc").select2({
        minimumResultsForSearch: -1
    });
});


function load_data(id_douar) {
    $.ajax({
        url: assetBaseUrl + "dashboard/getStats?douar_id=" + id_douar + "&t=" + Date.now(),
        type: 'get',
        dataType: 'json',
        success: function (response) {

            current_data = response;
            $(".baraques_count").text(formatNumber(response.baraques_count));
            $(".menages_count").text(formatNumber(response.menages_count));
            $(".commerces_count").text(formatNumber(response.commerces_count));
            $(".menages_hommes").text(formatNumber(response.menages_hommes));
            $(".menages_femmes").text(formatNumber(response.menages_femmes));
            $(".menages_maries").text(formatNumber(response.menages_maries));
            $(".menages_veufs").text(formatNumber(response.menages_veufs));
            $(".menages_celibataires").text(formatNumber(response.menages_celibataires));

            $(".menages_mere_celibataire").text(formatNumber(response.menages_mere_celibataire));
            $(".menages_abandonnes").text(formatNumber(response.menages_abandonnes));
            $(".menages_divorces").text(formatNumber(response.menages_divorces));
            $(".taux_menages").text(formatNumber(response.taux_menages, 3));


            $(".menages_divorces_h").text(formatNumber(response.menages_divorces_h));

            $(".menages_divorces_f").text(formatNumber(response.menages_divorces_f));


            $(".baraques_vide_count").text(formatNumber(response.baraques_vide, 0));
            $(".baraques_only_commerce_count").text(formatNumber(response.baraques_only_commerce, 0));

            $(".baraques_fermes").text(formatNumber(response.baraques_fermes));
            $(".baraques_occupees").text(formatNumber(response.baraques_occupees));
            $(".baraques_occupees_taux").text(formatNumber(response.baraques_occupees_taux * 100, 2) + " %");
            $(".baraques_vide_taux").text(formatNumber(response.baraques_vide_taux * 100, 2) + " %");



            $(".ATTRIBUTION_count").text(formatNumber(response.ATTRIBUTION_count));
            $(".decision_commision_valides_count").text(formatNumber(response.decision_commision_valides_count));
            $(".decision_commision_rejetes_count").text(formatNumber(response.decision_commision_rejetes_count));
            $(".decision_commision_ajournes_count").text(formatNumber(response.decision_commision_ajournes_count));


            $(".ATTRIBUTION_taux").text(formatNumber(response.ATTRIBUTION_taux * 100, 2) + " %");
            $(".decision_commision_valides_taux").text(formatNumber(response.decision_commision_valides_taux * 100, 2) + " %");
            $(".decision_commision_rejetes_taux").text(formatNumber(response.decision_commision_rejetes_taux * 100, 2) + " %");
            $(".decision_commision_ajournes_taux").text(formatNumber(response.decision_commision_ajournes_taux * 100, 2) + " %");

            
            $(".RECU_VERSEMENT_20000_count").text(formatNumber(response.RECU_VERSEMENT_20000_count));
            $(".PROJET_PV_AFFECTATION_count").text(formatNumber(response.PROJET_PV_AFFECTATION_count));
            $(".ATTESTATION_AFFECTATION_count").text(formatNumber(response.ATTESTATION_AFFECTATION_count));

            $(".RECU_VERSEMENT_20000_taux").text(formatNumber(response.RECU_VERSEMENT_20000_taux * 100, 2) + " %");
            $(".PROJET_PV_AFFECTATION_taux").text(formatNumber(response.PROJET_PV_AFFECTATION_taux * 100, 2) + " %");
            $(".ATTESTATION_AFFECTATION_taux").text(formatNumber(response.ATTESTATION_AFFECTATION_taux * 100, 2) + " %");

             
            $(".REGLEMENT_AVANCE_80000_count").text(formatNumber(response.REGLEMENT_AVANCE_80000_count));
            $(".CONTRAT_VENTE_count").text(formatNumber(response.CONTRAT_VENTE_count));
            $(".ATTESTATION_REMISE_CLES_count").text(formatNumber(response.ATTESTATION_REMISE_CLES_count));

            $(".REGLEMENT_AVANCE_80000_taux").text(formatNumber(response.REGLEMENT_AVANCE_80000_taux * 100, 2) + " %");
            $(".CONTRAT_VENTE_taux").text(formatNumber(response.CONTRAT_VENTE_taux * 100, 2) + " %");
            $(".ATTESTATION_REMISE_CLES_taux").text(formatNumber(response.ATTESTATION_REMISE_CLES_taux * 100, 2) + " %");

            load_repartitions_chart();

        }
    });
}


$(".douar_btn").click(function () {
    $(".douar_btn").removeClass('active');
    $(this).addClass('active');

    load_data($(this).attr('douar'));
});

function getRandomColor() {
    // Generate a random color in hexadecimal format
    let letters = '0123456789ABCDEF';
    let color = '#';
    for (let i = 0; i < 6; i++) {
        color += letters[Math.floor(Math.random() * 16)];
    }
    return color;
}
function load_repartitions_chart(response) {

    var chart_dom = document.getElementById('repartitions_chart');

    var chart = echarts.init(chart_dom, null, {
        renderer: 'canvas',
        useDirtyRect: false
    });


    var i = 0;
    var data = [
        {
            value: current_data.menages_maries,
            name: "Mariés",
            itemStyle:
            {
                color: "#e97132"
            }
        },
        {
            value: current_data.menages_veufs,
            name: "Veufs",
            itemStyle:
            {
                color: "#1B5583"
            }
        },
        {
            value: current_data.menages_celibataires,
            name: "Célibataires",
            itemStyle:
            {
                color: "#E5BE01"
            }
        },
        {
            value: current_data.menages_divorces,
            name: "Divorcés",
            itemStyle:
            {
                color: "#008F39"
            }
        },
        {
            value: current_data.menages_mere_celibataire,
            name: "Mères célibataires",
            itemStyle:
            {
                color: "#E55137"
            }
        },
        {
            value: current_data.menages_abandonnes,
            name: "Abandonnés",
            itemStyle:
            {
                color: "#434750"
            }
        }

    ];


    var options = {
        title: {
            text: 'Répartistion démographique',
            left: 'right',
            padding: [10, 10, 10, 10],
            textStyle: {
                color: '#000000',
                fontWeight: 'normal',
                fontSize: 14
            }
        },
        tooltip: {
            trigger: 'item'
        },
        legend: {
            orient: 'horizontal',
            left: 'center',
            bottom: 'bottom',
            show: true,
        },
        grid: { containLabel: true },

        toolbox: {
            show: true,
            feature: {
                mark: { show: true },
                dataView: { show: false, readOnly: false },
                restore: { show: false },
                saveAsImage: { show: false }
            }
        },
        series: [
            {
                label: {
                    show: true,
                    formatter: '{b}: {d}%',  // Show name and percentage on labels
                    overflow: "break",
                    alignTo: 'edge',
                    minMargin: 5,
                    edgeDistance: 10,
                    lineHeight: 15,
                },
                labelLine: {
                    length: 15,
                    length2: 10,
                    maxSurfaceAngle: 80
                },

                type: 'pie',
                radius: [10, 130],
                center: ['50%', '50%'],
                itemStyle: {
                    borderRadius: 8
                },
                data: data
            }
        ]
    };

    if (options && typeof options === 'object') {
        chart.setOption(options);
    }

    window.addEventListener('resize', chart.resize);

}


function load_evolution_des_avances_chart(arrondissement) {

    $.ajax({
        url: assetBaseUrl + "dashboard/evolution_des_avances_chart?arrondissement=" + arrondissement,
        type: "GET",
        success: function (response) {


            var dom = document.getElementById('evolution_des_avances_chart');
            var myChart = echarts.init(dom, null, {
                renderer: 'canvas',
                useDirtyRect: false
            });
            var app = {};
        
            var option;
        
            option = {
                title: {
                    text: 'Evolution des avances',
                    left: 'left',
                    textStyle: {
                        color: '#000000',
                        fontWeight: 'normal',
                        fontSize: 14
                    }
                },
                xAxis: {
                    type: 'category',
                    data: response.data
                },
                yAxis: {
                    type: 'value'
                },
                tooltip: {
                    show: true,
                    trigger: "axis",
                    triggerOn: "mousemove",
                },
                series: [
                    {
                        data: response.values,
                        type: 'line'
                    }
                ]
            };
        
            if (option && typeof option === 'object') {
                myChart.setOption(option);
            }
        
            window.addEventListener('resize', myChart.resize);
          
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });

  

}

function load_depot_dossiers_attribution_chart(arrondissement) {

    $.ajax({
        url: assetBaseUrl + "dashboard/depot_dossiers_attribution_chart?arrondissement=" + arrondissement,
        type: "GET",
        success: function (response) {


            var dom = document.getElementById('depot_dossiers_attribution_chart');
            var myChart = echarts.init(dom, null, {
                renderer: 'canvas',
                useDirtyRect: false
            });
            var app = {};
        
            var option;
        
            option = {
                title: {
                    text: 'Dossiers d\'attribution',
                    left: 'left',
                    textStyle: {
                        color: '#000000',
                        fontWeight: 'normal',
                        fontSize: 14
                    }
                },
                xAxis: {
                    type: 'category',
                    data: response.data
                },
                yAxis: {
                    type: 'value'
                },
                tooltip: {
                    show: true,
                    trigger: "axis",
                    triggerOn: "mousemove",
                },
                series: [
                    {
                        data: response.values,
                        type: 'line'
                    }
                ]
            };
        
            if (option && typeof option === 'object') {
                myChart.setOption(option);
            }
        
            window.addEventListener('resize', myChart.resize);
          
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });

  

}


