var etude_marche_atouts_table = undefined;
var etude_marche_faiblesses_table = undefined;
var chiffre_affaire_table = undefined;
var postes_comparaison_table = undefined;
var comparables_retenues_table = undefined;
var dossier_photo_modal_file_events = undefined;
var lot_data = undefined;
var lightGallery_list = [];
var produits_data = undefined;
var uploaded_files = [];
var documents_decision = [];
var documents_to_delete = [];

var image_sat_layers_group = new L.featureGroup();
var pc_map_layers_group = new L.featureGroup();

$(document).ready(function () {

    $(".select2").select2();
    $(".select2nc").select2({
        minimumResultsForSearch: -1
    });
    initLightGallery();

    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");

    etude_marche_atouts_table = $('#etude_marche_atouts_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: false,
        pageLength: 10,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: false,
        searching: false,
        scrollX: false,
        ajax: null,
        buttons: [],
        dom: "lBfrtip",
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },

    });

    etude_marche_faiblesses_table = $('#etude_marche_faiblesses_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: false,
        pageLength: 10,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: false,
        searching: false,
        scrollX: false,
        ajax: null,
        buttons: [],
        dom: "lBfrtip",
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },

    });

    chiffre_affaire_table = $('#chiffre_affaire_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: false,
        pageLength: 10,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: false,
        searching: false,
        scrollX: false,
        ajax: null,
        buttons: [],
        dom: "lBfrtip",
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },

    });

    postes_comparaison_table = $('#postes_comparaison_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: true,
        pageLength: 15,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: false,
        searching: false,
        scrollX: false,
        ajax: null,
        buttons: [],
        dom: "lBfrtip",
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },

    });

    comparables_retenues_table = $('#comparables_retenues_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: true,
        pageLength: 15,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: false,
        searching: false,
        scrollX: false,
        ajax: null,
        buttons: [],
        dom: "lBfrtip",
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },

    });


    $.ajax({
        url: assetBaseUrl + 'lots/get',
        type: "POST",
        data: {
            _token: csrfToken,
            id: lot_id,
        },

        success: function (result) {
            lot_data = result.lot;


            var geojson = L.geoJSON(JSON.parse(lot_data.geometry));
            geojson.setStyle(plle_style);
            geojson.addTo(image_sat_map);
            image_sat_layers_group.addLayer(geojson);
            image_sat_map.fitBounds(image_sat_layers_group.getBounds());

            var pc_geojson = L.geoJSON(JSON.parse(lot_data.geometry));
            pc_geojson.setStyle(plle_style);
            pc_geojson.addTo(postes_comparaison_map);

            pc_map_layers_group.addLayer(geojson);
            postes_comparaison_map.fitBounds(pc_map_layers_group.getBounds());
        }
    });

    $.ajax({
        url: assetBaseUrl + 'produits/getFromProjet',
        type: "POST",
        data: {
            _token: csrfToken,
            projet_id: projet_id,
            etude_marche_id: etude_marche_id
        },

        success: function (result) {
            produits_data = result.produits;
            result.produits.forEach(produit => {
                insert_row_chiffre_affaire_table(produit);
            });

            $("#postes_comparaison_produits_select").change();
        }
    });



});

function insert_row_chiffre_affaire_table(produit) {

    var produit_html = `<b>${produit.type}</b>`;
    var surface_vendable_html = `<span>${produit.surface_vendable}</span>`;
    var pu_html = `<span id="${produit.id}" class="chiffre_affaire_produit_pu">0 MAD</span>`;
    var pu_adopte_html = `<span  id="${produit.id}" class="chiffre_affaire_produit_pu_adopte">0 MAD</span>`;
    var cf_html = `<span id="${produit.id}" class="chiffre_affaire_produit_cf">0 MAD</span>`;

    chiffre_affaire_table.row.add([produit_html, surface_vendable_html, pu_html, pu_adopte_html, cf_html, produit]).draw();

}


//Postes Compraison
var raduisCircle = undefined;
var offres_markers_group = [];

var postes_comparaison_offre_marker_icon = L.icon({
    iconUrl: assetBaseUrl + 'images/postes_comparaison_offre_marker.png',
    iconSize: [30, 30], // size of the icon  
    iconAnchor: [15, 15], // point of the icon which will correspond to marker's location   
    popupAnchor: [0, -15] // point from which the popup should open relative to the iconAnchor
});

var postes_comparaison_expertise_marker_icon = L.icon({
    iconUrl: assetBaseUrl + 'images/postes_comparaison_expertise_marker.png',
    iconSize: [30, 30], // size of the icon  
    iconAnchor: [15, 15], // point of the icon which will correspond to marker's location   
    popupAnchor: [15, -15] // point from which the popup should open relative to the iconAnchor
});

var postes_comparaison_vente_omrane_marker_icon = L.icon({
    iconUrl: assetBaseUrl + 'images/postes_comparaison_vente_omrane_marker.png',
    iconSize: [30, 30], // size of the icon  
    iconAnchor: [15, 15], // point of the icon which will correspond to marker's location   
    popupAnchor: [15, -15] // point from which the popup should open relative to the iconAnchor
});

$("#postes_comparaison_search_btn").click(function () {
    $("#postes_comparaison_search_count").text("0");
    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
    var sources = [];

    $(".postes_comparaison_search_source:checked").each(function () {
        sources.push($(this).attr('source'));
    });
    $.ajax({
        url: assetBaseUrl + 'centre_donnees/offres/search',
        type: "GET",
        data: {
            _token: csrfToken,
            projet_id: projet_id,
            lat: lot_lng,
            lng: lot_lat,
            raduis: $("#postes_comparaison_search_rayon").val(),
            sources: sources.join(','),
            surface_min: $("#postes_comparaison_search_surface_min").val(),
            surface_max: $("#postes_comparaison_search_surface_max").val(),
            produit_id: $("#postes_comparaison_produits_select").val(),
        },

        success: function (response) {
            postes_comparaison_table.rows().clear().draw();

            offres_markers_group.forEach(offre_marker => {
                offre_marker.remove();
            });

            $("#postes_comparaison_search_count").text(response.length);
            response.forEach(offre => {
                insert_row_postes_comparaison_table(offre);

                var popup_title = '';
                if (offre.source == "OFFRE") {
                    popup_title = "Offre";
                }
                if (offre.source == "VENTE_ORMANE") {
                    popup_title = "Vente Al Omrane";
                }
                if (offre.source == "EXPERTISE") {
                    popup_title = "Expertise";
                }

                var popupContent = `
                <div style="font-size: 14px;">
                    <h6 style="font-size: 1.1rem; color: #115555;margin-bottom: 16px !important;text-align: center;">${popup_title}</h6>    
                    <span style="display: block;width:100%;color:gray" class="mt-1"><i class="fa-solid fa-caret-right mr-2"></i>Type: <b style="color:#115555">${offre.type}</b></span>
                    <span style="display: block;width:100%;color:gray" class="mt-1"><i class="fa-solid fa-caret-right mr-2"></i>Référence Foncière: <b style="color:#115555">${offre.tf}</b></span>
                    <span style="display: block;width:100%;color:gray" class="mt-1"><i class="fa-solid fa-caret-right mr-2"></i>Date: <b style="color:#115555">${formatDate(offre.date_valeur)}</b></span>
                    <span style="display: block;width:100%;color:gray" class="mt-1"><i class="fa-solid fa-caret-right mr-2"></i>Surface: <b style="color:#115555">${formatNumber(offre.surface, 2)}</b></span>
                    <span style="display: block;width:100%;color:gray" class="mt-1"><i class="fa-solid fa-caret-right mr-2"></i>Prix unitaire: <b style="color:#115555">${formatNumber(offre.prix_unitaire, 2)}</b></span>
                    <span style="display: block;width:100%;color:gray" class="mt-1"><i class="fa-solid fa-caret-right mr-2"></i>Prix total: <b style="color:#115555">${formatNumber(offre.prix_total, 2)}</b></span>
                </div>
                 `;

                if (offre.source == "OFFRE") {
                    var marker = L.marker([offre.lng, offre.lat], { icon: postes_comparaison_offre_marker_icon }).addTo(postes_comparaison_map);
                    marker.id = offre.id;
                    marker.bindPopup(popupContent);
                    offres_markers_group.push(marker);
                }
                if (offre.source == "VENTE_ORMANE") {
                    var marker = L.marker([offre.lng, offre.lat], { icon: postes_comparaison_vente_omrane_marker_icon }).addTo(postes_comparaison_map);
                    marker.id = offre.id;
                    marker.bindPopup(popupContent);
                    offres_markers_group.push(marker);
                }
                if (offre.source == "EXPERTISE") {
                    var marker = L.marker([offre.lng, offre.lat], { icon: postes_comparaison_expertise_marker_icon }).addTo(postes_comparaison_map);
                    marker.id = offre.id;
                    marker.bindPopup(popupContent);
                    offres_markers_group.push(marker);
                }


            });

            drawRaduiscircle();
        }
    });

});

function drawRaduiscircle() {

    if (raduisCircle != undefined) {
        raduisCircle.remove();
    }
    raduisCircle = L.circle([lot_lat, lot_lng], {
        radius: parseFloat($("#postes_comparaison_search_rayon").val()),
        color: 'white',
        fillOpacity: 0.4,
        dashArray: [1, 4],

    }).addTo(postes_comparaison_map);
    raduisCircle.bringToBack();

    var layers_group = new L.featureGroup();
    layers_group.addLayer(raduisCircle);
    postes_comparaison_map.fitBounds(layers_group.getBounds());

}



$("body").on('click', '.postes_comparaison_a', function () {
    var id = $(this).attr('id');

    offres_markers_group.forEach(offre_marker => {
        if (offre_marker.id == id) {
            offre_marker.openPopup();
        }

    });
});

function insert_row_postes_comparaison_table(offre) {

    var tf_html = `<a id="${offre.id}" class="postes_comparaison_a" href="javascript:;"><span><input type="checkbox" style="vertical-align: sub;" class="postes_comparaison_cb" id="${offre.id}"><b class="ml-1">${offre.tf}</b></span></a>`;

    var date_html = `<span>${formatDate(offre.date_valeur)}</span>`;
    var surface_html = `<span>${formatNumber(offre.surface, 2)}</span>`;
    var prix_total_html = `<span>${formatNumber(offre.prix_total, 2)}</span>`;
    var prix_unitaire_html = `<span>${formatNumber(offre.prix_unitaire, 2)}</span>`;

    var source = '';
    var source_color = '';

    if (offre.source == "OFFRE") {
        source = "Offre";
        source_color = '#3f9e4a';
    }
    if (offre.source == "VENTE_ORMANE") {
        source = "Vente Al Omrane";
        source_color = '#118c9c';
    }
    if (offre.source == "EXPERTISE") {
        source = "Expertise";
        source_color = '#e8374a';
    }
    var source_html = `<span style="color:${source_color}">${source}</span>`;

    postes_comparaison_table.row.add([tf_html, source_html, date_html, surface_html, prix_total_html, prix_unitaire_html, offre]).draw();

}

function insert_row_comparables_retenues_table(offre) {

    var tf_html = `<b>${offre.tf}</b>`;
    var source_html = `<span>${offre.source}</span>`;
    var date_html = `<span>${formatDate(offre.date_valeur)}</span>`;
    var surface_html = `<span>${formatNumber(offre.surface, 2)}</span>`;
    var prix_total_html = `<span>${formatNumber(offre.prix_total, 2)}</span>`;
    var prix_unitaire_html = `<span>${formatNumber(offre.prix_unitaire, 2)}</span>`;

    comparables_retenues_table.row.add([tf_html, source_html, date_html, surface_html, prix_total_html, prix_unitaire_html, offre]).draw();

}

$("#postes_comparaison_produits_select").change(function () {
    postes_comparaison_table.rows().clear().draw();
    $("#postes_comparaison_add_to_retenus_list_btn").attr('disabled', 'disabled');
    $(".poste_comparaison_card").addClass('disabled');
    update_postes_comparaison_comparables_retenus_table();
});

function update_postes_comparaison_comparables_retenus_table() {
    comparables_retenues_table.rows().clear().draw();
    produits_data.forEach(produit => {
        if (produit.id == $("#postes_comparaison_produits_select").val()) {
            $(".poste_comparaison_card").removeClass('disabled');
            produit.comparables_retenus.forEach(offre => {
                insert_row_comparables_retenues_table(offre);
            });
        }
    });

    update_chiffre_affaire();
}

function update_chiffre_affaire() {

    var g_chiffre_affaire = 0;
    produits_data.forEach(produit => {
        g_chiffre_affaire += update_ciffre_affaire_produit(produit);

        $("#postes_comparaison_global_cf").text(formatNumber(g_chiffre_affaire) + " MAD");
    });
}

function update_ciffre_affaire_produit(produit) {

    var g_prix_unitaire = 0;
    var g_prix_unitaire_adopte = 0;
    var g_chiffre_affaire = 0;
    produit.comparables_retenus.forEach(offre => {

        g_prix_unitaire += offre.prix_unitaire;
        g_prix_unitaire_adopte += Math.round(offre.prix_unitaire);
        //g_chiffre_affaire += offre.prix_total;
    });

    if (produit.comparables_retenus.length > 0) {
        g_prix_unitaire = g_prix_unitaire / produit.comparables_retenus.length;
        g_prix_unitaire_adopte = Math.round(g_prix_unitaire_adopte / produit.comparables_retenus.length);
        //g_chiffre_affaire = g_chiffre_affaire* ;
    }
    g_chiffre_affaire = produit.surface_vendable * g_prix_unitaire_adopte;

    $(".chiffre_affaire_produit_pu[id='" + produit.id + "']").text(formatNumber(g_prix_unitaire) + " MAD");
    $(".chiffre_affaire_produit_pu_adopte[id='" + produit.id + "']").text(formatNumber(g_prix_unitaire_adopte) + " MAD");
    $(".chiffre_affaire_produit_cf[id='" + produit.id + "']").text(formatNumber(g_chiffre_affaire) + " MAD");

    return g_chiffre_affaire;
}

$('body').on('change', ".postes_comparaison_cb", function () {

    if ($(".postes_comparaison_cb:checked").length > 0) {
        $("#postes_comparaison_add_to_retenus_list_btn").removeAttr("disabled");
    } else {

        $("#postes_comparaison_add_to_retenus_list_btn").attr("disabled", "disabled");
    }
});


$("#postes_comparaison_add_to_retenus_list_btn").click(function () {

    $('.postes_comparaison_cb:checked').each(function () {
        var tr = $(this).closest('tr');
        var data = postes_comparaison_table.row(tr).data();
        var offre = data[data.length - 1];

        produits_data.forEach(produit => {
            if (produit.id == $("#postes_comparaison_produits_select").val()) {

                var exsist = false
                produit.comparables_retenus.forEach(comparable => {
                    if (comparable.cd_offre_id == offre.id) {
                        exsist = true;
                    }
                });

                if (!exsist) {
                    var offre_clone = JSON.parse(JSON.stringify(offre));
                    offre_clone.id = null;
                    offre_clone.etude_marche_id = etude_marche_id;
                    offre_clone.produit_id = produit.id;
                    offre_clone.cd_offre_id = offre.id;
                    produit.comparables_retenus.push(offre_clone);
                }

            }
        });
        $(this).prop('checked', false);

    });
    $("#postes_comparaison_add_to_retenus_list_btn").attr('disabled', 'disabled');

    update_postes_comparaison_comparables_retenus_table();
});

//Atouts
$("#etude_marche_atouts_table_add_btn").click(function () {
    $("#etude_marche_atout_modal_content").val("");
    $("#etude_marche_atout_modal").modal('show');
})

$("#etude_marche_atout_modal_save").click(function () {
    $("#etude_marche_atout_modal").modal('hide');

    var atout = {
        content: $("#etude_marche_atout_modal_content").val(),
        id: null
    };
    insert_row_etude_marche_atouts_table(atout);
});

function insert_row_etude_marche_atouts_table(atout) {

    var atout_html = `<span style="color: #3b8512;"><input type="checkbox" style="vertical-align: sub;" class="etude_marche_atouts_table_cb" data="${atout.content}" id="${atout.id}"><b class="ml-1"><i class="fa-regular fa-thumbs-up mr-1"></i>${atout.content}</b></span>`;
    etude_marche_atouts_table.row.add([atout_html, atout]).draw();
}
$('body').on('change', ".etude_marche_atouts_table_cb", function () {

    if ($(".etude_marche_atouts_table_cb:checked").length > 0) {
        $("#etude_marche_atouts_table_delete_btn").removeAttr("disabled");
    } else {

        $("#etude_marche_atouts_table_delete_btn").attr("disabled", "disabled");
    }
});
$("#etude_marche_atouts_table_delete_btn").click(function () {
    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous sûr de vouloir supprimer  les éléments sélectionnés?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {

            $('input[type="checkbox"]:checked').each(function () {
                var tr = $(this).closest('tr');


                etude_marche_atouts_table.rows(tr).remove().draw();

            });
            $("#etude_marche_atouts_table_delete_btn").attr("disabled", "disabled");
        }
    });
});

//Faiblesses
$("#etude_marche_faiblesses_table_add_btn").click(function () {
    $("#etude_marche_faiblesse_modal_content").val("");
    $("#etude_marche_faiblesse_modal").modal('show');
})

$("#etude_marche_faiblesse_modal_save").click(function () {
    $("#etude_marche_faiblesse_modal").modal('hide');

    var atout = {
        content: $("#etude_marche_faiblesse_modal_content").val(),
        id: null
    };
    insert_row_etude_marche_faiblesse_table(atout);
});

function insert_row_etude_marche_faiblesse_table(faiblesse) {

    var faiblesse_html = `<span style="color: #fb5151;"><input type="checkbox" style="vertical-align: sub;" class="etude_marche_faiblesses_table_cb" data="${faiblesse.content}" id="${faiblesse.id}"><b class="ml-1"><i class="fa-regular fa-thumbs-down mr-1"></i>${faiblesse.content}</b></span>`;
    etude_marche_faiblesses_table.row.add([faiblesse_html, faiblesse]).draw();
}
$('body').on('change', ".etude_marche_faiblesses_table_cb", function () {

    if ($(".etude_marche_faiblesses_table_cb:checked").length > 0) {
        $("#etude_marche_faiblesses_table_delete_btn").removeAttr("disabled");
    } else {

        $("#etude_marche_faiblesses_table_delete_btn").attr("disabled", "disabled");
    }
});
$("#etude_marche_faiblesses_table_delete_btn").click(function () {
    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous sûr de vouloir supprimer  les éléments sélectionnés?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {

            $('input[type="checkbox"]:checked').each(function () {
                var tr = $(this).closest('tr');


                etude_marche_faiblesses_table.rows(tr).remove().draw();

            });
            $("#etude_marche_faiblesses_table_delete_btn").attr("disabled", "disabled");
        }
    });
});


//store 
$("#save_etude_marche").click(function () {
    store_etude_marche();
});
function store_etude_marche(valider = 0) {

    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");

    var atouts = [];
    var faiblesses = [];

    $(".etude_marche_atouts_table_cb").each(function () {
        atouts.push($(this).attr('data'));
    })

    $(".etude_marche_faiblesses_table_cb").each(function () {
        faiblesses.push($(this).attr('data'));
    })


    $("#save_etude_marche").attr('disabled', 'disabled');
    $.ajax({
        url: assetBaseUrl + 'etude_marche/store',
        type: "POST",
        data: {
            _token: csrfToken,
            id: etude_marche_id,
            description_physique: $("#description_physique").val(),
            produits: JSON.stringify(produits_data),
            atouts: JSON.stringify(atouts),
            faiblesses: JSON.stringify(faiblesses),

            documents_decision: JSON.stringify(documents_decision),
            documents_to_delete: JSON.stringify(documents_to_delete),
            documents: JSON.stringify(uploaded_files),
        },

        success: function (result) {
            $.toast({
                heading: "TamkinInvest",
                text: 'Enregistrement terminé avec succès',
                icon: "success",
                position: "bottom-right",
                hideAfter: 3000,
                stack: false,
            });
            $("#save_etude_marche").removeAttr('disabled');

            if (valider == 1) {
                Swal.fire({
                    title: 'Confirmation',
                    text: "Êtes-vous sûr de vouloir valider l'etude de marché?",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#88C241',
                    cancelButtonColor: '#F83F37',
                    confirmButtonText: 'Oui',
                    cancelButtonText: 'Non'
                }).then((result) => {
                    if (result.isConfirmed) {

                        $.ajax({
                            url: assetBaseUrl + 'etude_marche/validate',
                            type: "POST",
                            data: {
                                _token: csrfToken,
                                id: etude_marche_id
                            },

                            success: function (result) {
                                location.reload();
                            }
                        });

                    }
                });


            }
        }
    });
}

$("#valider_etude_marche").click(function () {
    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");

    Swal.fire({
        title: 'Confirmation',
        text: "L'étude de marché doit être enregistrée avant la validation. Êtes-vous sûr de vouloir continuer ?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {
            store_etude_marche(1);

        }
    });


});


//photos

function initLightGallery() {
    lightGallery_list.forEach(lg => {
        lg.destroy();
    });
    lightGallery_list = [];
    $("div[id^=photos_]").each(function () {
        var lg = lightGallery(document.getElementById($(this).attr('id')), {
            plugins: [lgZoom, lgThumbnail, lgFullscreen, lgRotate],
            selector: ".gallery-img",
            thumbnail: true,
            animateThumb: true,
            zoomFromOrigin: true,
            allowMediaOverlap: false,
            toggleThumb: true,
            exThumbImage: "data-src",
            fullScreen: true,
            mousewheel: true
        });

        lightGallery_list.push(lg);
    });
}


$('body').on('click', '.upload_photo_link', function () {

    var file_type = 'jpg jpeg png bmp';
    var type_document = $(this).attr('type_document');

    $("#dossier_photo_modal_file_type_label").text('Fichier ' + file_type.toUpperCase());
    $("#dossier_photo_modal_file").attr('data-allowed-file-extensions', file_type);

    $("#store_dossier_photo_form [name='type_document']").val(type_document);

    if (dossier_photo_modal_file_events != undefined) {
        $("#dossier_photo_modal_file").data('dropify').destroy();
    }

    $("#dossier_photo_modal_file").remove();

    $("#dossier_photo_modal_file_div").append(`<input id="dossier_photo_modal_file" data-max-file-size-preview="2M" data-allowed-file-extensions="${file_type}"  type="file" name="file" />`);


    dossier_photo_modal_file_events = $('#dossier_photo_modal_file').dropify({
        messages: {
            'default': 'Faites glisser et déposez un fichier ici',
            'replace': 'Glisser-déposer ou cliquer pour remplacer',
            'remove': 'Supprimer',
            'error': 'Ooops, something wrong happended.'
        },
        error: {
            'fileSize': 'The file size is too big ({{ value }} max).',
            'imageFormat': 'The image format is not allowed ({{ value }} only).'
        }
    });
    $("#dossier_photo_modal_save").attr('disabled', 'disabled');
    $("#dossier_photo_modal").modal('show');


    $('#dossier_photo_modal_file').change(function () {
        if ($("#dossier_photo_modal_file").val().length > 0) {
            $("#dossier_photo_modal_save").removeAttr('disabled');
        }
    });


});


$("#store_dossier_photo_form").submit(function (event) {

    showLoading('Chargement...', 'Le fichier est en cours de chargement, veuillez patienter');

    event.preventDefault();
    var formData = new FormData(this);

    $.ajax({
        url: assetBaseUrl + "etude_marche/file/upload",
        type: "POST",
        dataType: "json",
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
            closeLoading();
            uploaded_files.push(response.document);
            var url = assetBaseUrl + "/files/etudes_marche/" + response.document.id + "/" + response.document.filename;
            console.log(response.document);
            $(".phototheque[type_document='" + response.document.type_document + "']").append(
                `<a  id="photos_${response.document.type_document}" class="costume-img" href="${url}" style="margin: 0px;">
                <img  data-src="${url}" style="border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="${url}" class="gallery-img costume-img hk-gallery">
                </br>
                <input item_id="${response.document.id}" type_document="${response.document.type_document}" class="select_photo_cb" style="margin: auto;display: block;position: relative;" type="checkbox">
            </a>`);


            $("#dossier_photo_modal").modal('hide');

            initLightGallery();
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});


$("body").on('change', '.select_photo_cb', function () {
    var type_document = $(this).attr('type_document');

    if ($(".select_photo_cb[type_document='" + type_document + "']:checked").length > 0) {
        $(".delete_photo_link[type_document='" + type_document + "']").removeAttr('disabled');
    } else {
        $(".delete_photo_link[type_document='" + type_document + "']").attr('disabled', 'disabled');

    }
});

$('body').on('click', '.delete_photo_link', function () {
    var type_document = $(this).attr('type_document');

    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous certain(e) de vouloir supprimer les photos ?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {
            $(".select_photo_cb[type_document='" + type_document + "']:checked").each(function () {
                $(this).parent().remove();
                documents_to_delete.push($(this).attr('item_id'));
            });
            $(".delete_photo_link[type_document='" + type_document + "']").attr('disabled', 'disabled');
        }
    });


});
