 
$("#provinces_filter").change(function () {
    refresh_situation_filters('province');
});
$("#arrondissements_filter").change(function () {
    refresh_situation_filters('arrondissement');
});
$("#annexes_administratives_filter").change(function () {
    refresh_situation_filters('annexe_administrative');
});
$("#douars_filter").change(function () {
    refresh_situation_filters('douar');
});



function fill_situation_filter_arrondissement(province_id) {
    $("#arrondissements_filter").empty();
    $("#arrondissements_filter").append(new Option('Indifferent', 'all'));
    arrondissements.forEach(arrondissement => {
        if (province_id != 'all') {
            if (arrondissement.province_id == province_id) {
                $("#arrondissements_filter").append(new Option(arrondissement.nom, arrondissement.id));
            }
        }
        else {
            $("#arrondissements_filter").append(new Option(arrondissement.nom, arrondissement.id));
        }
    });
}


function fill_situation_filter_annexe_administrative(province_id, arrondissement_id) {
    $("#annexes_administratives_filter").empty();
    $("#annexes_administratives_filter").append(new Option('Indifferent', 'all'));
    var filtred_arrondissements = [];

    arrondissements.forEach(arrondissement => {
        if (province_id != 'all') {
            if (arrondissement.province_id == province_id) {
                filtred_arrondissements.push(arrondissement);
            }
        }
        else {
            filtred_arrondissements.push(arrondissement);
        }
    });

    filtred_arrondissements.forEach(arrondissement => {
        annexes_administratives.forEach(annexe => {
            if (annexe.arrondissement_id == arrondissement.id) {
                if (arrondissement_id != 'all') {
                    if (annexe.arrondissement_id == arrondissement_id) {
                        $("#annexes_administratives_filter").append(new Option(annexe.nom, annexe.id));
                    }
                }
                else {
                    $("#annexes_administratives_filter").append(new Option(annexe.nom, annexe.id));
                }
            }
        });
    });

}


function fill_situation_filter_douar(province_id, arrondissement_id, annexe_administrative_id) {
    $("#douars_filter").empty();
    $("#douars_filter").append(new Option('Indifferent', 'all'));
    var filtred_arrondissements = [];

    arrondissements.forEach(arrondissement => {
        if (province_id != 'all') {
            if (arrondissement.province_id == province_id) {
                filtred_arrondissements.push(arrondissement);
            }
        }
        else {
            filtred_arrondissements.push(arrondissement);
        }
    });

    var filtred_annexes_administratives = [];
    filtred_arrondissements.forEach(arrondissement => {
        annexes_administratives.forEach(annexe => {
            if (annexe.arrondissement_id == arrondissement.id) {
                if (arrondissement_id != 'all') {
                    if (annexe.arrondissement_id == arrondissement_id) {
                        filtred_annexes_administratives.push(annexe);
                    }
                }
                else {
                    filtred_annexes_administratives.push(annexe);
                }
            }
        });
    });

    filtred_annexes_administratives.forEach(annexe => {
        douars.forEach(douar => {
            if (douar.annexe_administrative_id == annexe.id) {
                if (annexe_administrative_id != 'all') {
                    if (annexe.id == annexe_administrative_id) {
                        $("#douars_filter").append(new Option(douar.nom, douar.id));
                    }
                }
                else {
                    $("#douars_filter").append(new Option(douar.nom, douar.id));
                }
            }
        });
    });

}


function refresh_situation_filters(trigger_source) {
    if (trigger_source == 'province') {
        console.log('trigger_source province')
        fill_situation_filter_arrondissement($("#provinces_filter").val(), 'all');
        fill_situation_filter_annexe_administrative($("#provinces_filter").val(), 'all');
        fill_situation_filter_douar($("#provinces_filter").val(), 'all', 'all');
    }
    if (trigger_source == 'arrondissement') {
        var province_id = undefined;

        if ($("#arrondissements_filter").val() == 'all') {
            refresh_situation_filters('province');
            return;
        }

        arrondissements.forEach(arrondissement => {
            if (arrondissement.id == $("#arrondissements_filter").val()) {
                province_id = arrondissement.province_id;
            }
        });

        $("#provinces_filter").val(province_id);
        $('#provinces_filter').trigger('change.select2');

        fill_situation_filter_annexe_administrative(province_id, $("#arrondissements_filter").val());
        fill_situation_filter_douar(province_id, $("#arrondissements_filter").val(), 'all');
    }

    if (trigger_source == 'annexe_administrative') {
        var province_id = undefined;
        var arrondissement_id = undefined;

        if ($("#annexes_administratives_filter").val() == 'all') {
            refresh_situation_filters('arrondissement');
            return;
        }

        annexes_administratives.forEach(annexe => {
            if (annexe.id == $("#annexes_administratives_filter").val()) {
                arrondissement_id = annexe.arrondissement_id;
            }
        });

        arrondissements.forEach(arrondissement => {
            if (arrondissement.id == arrondissement_id) {
                province_id = arrondissement.province_id;
            }
        });

        $("#provinces_filter").val(province_id);
        $('#provinces_filter').trigger('change.select2');

        $("#arrondissements_filter").val(arrondissement_id);
        $('#arrondissements_filter').trigger('change.select2');

        fill_situation_filter_douar(province_id, $("#arrondissements_filter").val(), $("#annexes_administratives_filter").val(), 'all');
    }

    if (trigger_source == 'douar') {
        var province_id = undefined;
        var arrondissement_id = undefined;
        var annexe_administrative_id = undefined;

        if ($("#douars_filter").val() == 'all') {
            refresh_situation_filters('annexe_administrative');
            return;
        }

        douars.forEach(douar => {
            if (douar.id == $("#douars_filter").val()) {
                annexe_administrative_id = douar.annexe_administrative_id;
            }
        });

        annexes_administratives.forEach(annexe => {
            if (annexe.id == annexe_administrative_id) {
                arrondissement_id = annexe.arrondissement_id;
            }
        });

        arrondissements.forEach(arrondissement => {
            if (arrondissement.id == arrondissement_id) {
                province_id = arrondissement.province_id;
            }
        });

        $("#provinces_filter").val(province_id);
        $('#provinces_filter').trigger('change.select2');

        $("#arrondissements_filter").val(arrondissement_id);
        $('#arrondissements_filter').trigger('change.select2');

        $("#annexes_administratives_filter").val(annexe_administrative_id);
        $('#annexes_administratives_filter').trigger('change.select2');


    }
}



function filter_dossiers_table(start = 0, load_geometries = true) {
    var filters = [];




    // if ($("#filters_situation").val() != 'all') {
    //     var column = "situation";
    //     var table = "";
    //     var value = $("#filters_situation").val();
    //     filters.push({ column: column, table: table, value: value });
    // }


    // var column = "province";
    // var table = "";
    // var value = $("#filters_province").val();
    // filters.push({ column: column, table: table, value: value });


    // var column = "commune";
    // var table = "";
    // var value = $("#filters_commune").val();
    // filters.push({ column: column, table: table, value: value });


    if ($("#douars_filter").val() != "all") {
        var column = "douar_vf_id";
        var table = "";
        var value = $("#douars_filter").val();
        filters.push({ column: column, table: table, value: value });
    }

    if ($("#filters_cin").val() != "all") {
        var column = "chef_menage_cin";
        var table = "menages";
        var value = $("#filters_cin").val();
        if (value.length > 0) {
            filters.push({ column: column, table: table, value: value });
        }

    }
 if ($("#filters_full_num").val() != '') {
        var column = "full_num";
        var table = "";
        var value = $("#filters_full_num").val();
        filters.push({ column: column, table: table, value: value });
    }

    dossiers_table.ajax.url(assetBaseUrl + "geoportail/baraques_datatable?offset=" + start + "&limit=30&filters=" + JSON.stringify(filters)).load();
    if (load_geometries) {
        loadDossiers(filters);
    }

}


$("#v_tab_filters_btn").click(function () {
    $("#v_tab_list_btn").removeClass('active');
    $("#v_tab_filters_btn").addClass('active');

    $("#dossiers_filters_div").addClass('active');
    $("#dossiers_result_div").removeClass('active');
});

$("#v_tab_list_btn").click(function () {
    $("#v_tab_filters_btn").removeClass('active');
    $("#v_tab_list_btn").addClass('active');

    $("#dossiers_filters_div").removeClass('active');
    $("#dossiers_result_div").addClass('active');
});



$("#filters_tab_apply").click(function () {
    filter_dossiers_table();

    $("#v_tab_filters_btn").removeClass('active');
    $("#v_tab_list_btn").addClass('active');

    $("#dossiers_filters_div").removeClass('active');
    $("#dossiers_result_div").addClass('active');
});

$("#date_dossier_from_active").change(function () {
    if ($(this).prop('checked')) {
        $("#date_dossier_from_filter").removeAttr('disabled');
    }
    else {
        $("#date_dossier_from_filter").attr('disabled', 'disabled');
    }
});


$("#date_dossier_to_active").change(function () {
    if ($(this).prop('checked')) {
        $("#date_dossier_to_filter").removeAttr('disabled');
    }
    else {
        $("#date_dossier_to_filter").attr('disabled', 'disabled');
    }
});

function reset_filters() {

    $("#filters_situation").val('all').change();



    $("#filters_tab_apply").click();
}

$("#filters_tab_rest").click(function () {
    reset_filters();
})