var map = undefined;
var dossiers_features = [];
var dossiers_geojson = undefined;
var map_fullscreen = false;
var dossiers_points_features = [];
var dossiers_points_geojson = undefined;

var source_initialized = false;

var show_dossier_centers = true;

var show_dossier_limites = true;

var last_etude_geotechnique_request_params = undefined;
var test = undefined;

var selected_baraque_id = undefined;
var visible_orthophotos = [];

var load_orthophoto = true;

$(document).ready(function () {
    map = new maplibregl.Map({
        container: 'map',
        style: {
            version: 8,
            sources: {
                osm: {
                    type: 'raster',
                    tiles: ['https://www.google.com/maps/vt?lyrs=y@189&gl=ma&x={x}&y={y}&z={z}'],
                    tileSize: 256,
                    attribution: '',
                    maxzoom: 22
                },
            },

            layers: [{
                id: 'osm',
                type: 'raster',
                source: 'osm'
            },],

            "glyphs": "https://fonts.openmaptiles.org/{fontstack}/{range}.pbf",
        },

        attributionControl: false,
        center: [-7.654050582652985, 33.57450237191334],
        zoom: 12,
        pitch: 0,
        antialias: false,


    });

    map.on('load', function () {



        initdata();
    });
    var intervalId = window.setInterval(function () {
        rSize();
    }, 100);




});


$(".orth_cb").change(function () {
    var id = $(this).attr('id');
    if ($(this).prop('checked')) {
        loadBaseLayer(id);
        initdata();
    }
    else {
        if (map.getLayer('raster-layer-' + id)) {
            map.removeLayer('raster-layer-' + id);
        }
        if (map.getSource('raster-source-' + id)) {
            map.removeSource('raster-source-' + id);
        }
    }
});



function initdata() {
    cleanMap();

    init_sources();

    if ($("#vuew_3d_cb").prop('checked')) {
        initTerrain3d();
    }
    loadDossiers();



}
const dossier_min_popup = new maplibregl.Popup({
    closeButton: false,
    closeOnClick: false
});

const dossier_popup = new maplibregl.Popup({
    closeButton: true,
    closeOnClick: false
});
function loadDossiers(filters = []) {

    dossiers_features = [];
    dossiers_points_features = [];

    if (map.getLayer('dossiers_fill')) {
        map.removeLayer('dossiers_fill');
    }
    if (map.getLayer('dossiers_line')) {
        map.removeLayer('dossiers_line');
    }
    if (map.getLayer('dossiers_centers')) {
        map.removeLayer('dossiers_centers');
    }
    if (map.getLayer('dossiers_symboles')) {
        map.removeLayer('dossiers_symboles');
    }



    if (map.getSource('dossiers')) {
        map.removeSource('dossiers');
    }
    if (map.getSource('dossiers_points')) {
        map.removeSource('dossiers_points');
    }

    var add_markers = false;
    if (window.location.hash == "#client-index") {
        add_markers = true;
    }

    $.ajax({
        url: assetBaseUrl + "geoportail/map_get_baraques?filters=" + JSON.stringify(filters) + '&t=' + Date.now(),
        type: 'get',
        dataType: 'json',
        success: function (response) {


            response.forEach(element => {

                if (add_markers) {
                    var marker = new maplibregl.Marker()
                        .setLngLat([element.lng, element.lat])
                        .addTo(map);
                }


                if (element.lat != 0) {
                    var point_f = {
                        type: "Feature",
                        properties: {
                            id: element.id,
                            numero: element.numero,
                            color: element.color
                        },
                        geometry: {
                            coordinates: [
                                element.lng,
                                element.lat
                            ],
                            type: "Point"
                        }
                    };
                    dossiers_points_features.push(point_f);
                }


                try {
                    var geojson = JSON.parse(element.geometry);

                    geojson.properties = {};
                    geojson.properties.id = element.id;
                    geojson.properties.numero = element.numero;
                    geojson.numero = element.numero;
                    geojson.properties.color = element.color;
                    geojson.properties.orthophotos = element.orthophotos;
                    dossiers_features.push(geojson);


                }
                catch {

                }
            });



            dossiers_geojson = {
                "type": "FeatureCollection",
                'features': dossiers_features,
            };

            dossiers_points_geojson = {
                "type": "FeatureCollection",
                'features': dossiers_points_features,
            };

            map.addSource('dossiers', {
                type: 'geojson',
                data: dossiers_geojson
            });

            map.addSource('dossiers_points', {
                type: 'geojson',
                data: dossiers_points_geojson
            });

            map.addLayer({
                'id': 'dossiers_fill',
                'type': 'fill',
                'source': 'dossiers',
                'paint': {
                    'fill-color': ['get', 'color'],
                    'fill-opacity': 0.65,
                }
            });

            map.addLayer({
                'id': 'dossiers_line',
                'type': 'line',
                'source': 'dossiers',
                'paint': {
                    'line-color': '#000',
                    'line-width': 2,
                }
            });


            map.addLayer({
                "id": "dossiers_symboles",
                "type": "symbol",
                "source": "dossiers",
                "layout": {
                    "symbol-placement": "point",
                    "text-font": ["Metropolis Semi Bold"],
                    "text-field": '{numero}',
                    "text-offset": [0, 1],
                    "icon-overlap": "always",
                    "text-allow-overlap": false,
                    "text-size": 11,
                    "visibility": "visible"

                },
                "paint": {
                    "text-color": "#ffffff",
                    "text-halo-color": "black",
                    "text-halo-width": 1,
                    "text-halo-blur": 0,
                    "text-opacity": [
                        "interpolate",
                        ["linear"],
                        ["zoom"],
                        17.9, 0,
                        18, 1
                    ]
                }
            });
        }

    });



    var dossier_min_popup = new maplibregl.Popup({
        openingAnimation: {
            duration: 1000,
            easing: 'easeOutElastic',
            transform: 'scale'
        },
        closingAnimation: {
            duration: 300,
            easing: 'easeInBack',
            transform: 'scale'
        }
    })

    map.on('mouseenter', 'dossiers_fill', function (e) {
        this.getCanvas().style.cursor = 'pointer';

        const coordinates = e.features[0].geometry.coordinates.slice();

        while (Math.abs(e.lngLat.lng - coordinates[0]) > 180) {
            coordinates[0] += e.lngLat.lng > coordinates[0] ? 360 : -360;
        }
        var html = `<div class="row dossier_row">
        <div class="col-2" style="border-right: 1px #cecece dashed;">
        <i class="fa-regular fa-folder-open dossier_row_icon"></i>
        </div>
        <div class="col-10">
        <b style="font-family:  'Roboto';"> Numéro : DO-2023-6</b>
        <br>
        <span style="font-family:  'Roboto';"> Dossier : 10/11/2023</span>, 
        <span style="font-family:  'Roboto';"> Demande : 10/11/2023</span>
        <br>
        <span style="color: #287fc9; font-weight: 500; font-family: Roboto;">Saisie de la demande</span>
        </div>   
        </div>`;
        //dossier_min_popup.setLngLat(coordinates).setHTML(html).addTo(this);
    });

    map.on('mouseleave', 'dossiers_fill', function (e) {
        this.getCanvas().style.cursor = '';
        dossier_min_popup.remove();
    });

    map.on('click', 'dossiers_fill', function (e) {


        this.getCanvas().style.cursor = 'pointer';
        const coordinates = e.lngLat;
        if (map.getLayer("dossiers_fill_selected_layer") != undefined) {
            map.removeLayer("dossiers_fill_selected_layer");
        }
        if (map.getSource("dossiers_fill_selected_source") != undefined) {
            map.removeSource("dossiers_fill_selected_source");
        }


        map.addSource('dossiers_fill_selected_source', {
            type: 'geojson',
            data: e.features[0].toJSON()
        });

        map.addLayer({
            'id': 'dossiers_fill_selected_layer',
            'type': 'fill',
            'source': 'dossiers_fill_selected_source',
            'paint': {
                'fill-color': '#fc6125',
                'fill-opacity': 1,
            }
        });

        handleDossierMarkerClick(e.features[0].properties.id, coordinates);

    });




    map.on('zoom', () => {
        const currentZoom = map.getZoom();

        // if (currentZoom < 9) {

        //     map.setLayoutProperty("douars_symbols", 'visibility', 'none');
        //     map.setLayoutProperty("douars_centers", 'visibility', 'none');
        // }
        // else {
        //     map.setLayoutProperty("douars_symbols", 'visibility', 'visible');
        //     map.setLayoutProperty("douars_centers", 'visibility', 'visible');
        // }

    });



    map.on('moveend', async () => {
        // Call your async function here

        if (map.getZoom() >= 15) {
            await map_moveend_function();
        }
        else {
            const layers = map.getStyle().layers;
            if (layers) {
                layers.forEach(layer => {
                    if (layer.id.startsWith('raster-layer-')) {
                        var ortho_id = layer.id.replace('raster-layer-', '');
                        try {
                            map.removeLayer(layer.id);
                        }
                        catch (ex) {
                        }
                        try {
                            map.removeSource('raster-source-' + ortho_id);
                        }
                        catch (ex) {
                        }

                    }
                });
            }
        }



    });


    map.on('sourcedata', onSourceData);
}

function map_moveend_function() {

    refreshBaseLayers();

}

function refreshBaseLayers() {

    if (!load_orthophoto) {
        return;
    }
    const features = map.queryRenderedFeatures();

    visible_orthophotos = [];

    features.forEach(feature => {
        var orthophotos = JSON.parse(feature.properties.orthophotos);

        orthophotos.forEach(orthophoto => {

            if (!visible_orthophotos.includes(orthophoto)) {
                visible_orthophotos.push(orthophoto);
            }
        });
    });

    const layers = map.getStyle().layers;
    if (layers) {
        layers.forEach(layer => {
            if (layer.id.startsWith('raster-layer-')) {
                var ortho_id = layer.id.replace('raster-layer-', '');
                if (!visible_orthophotos.includes(ortho_id)) {
                    try {
                        map.removeLayer(layer.id);
                    }
                    catch (ex) {
                    }
                    try {
                        map.removeSource('raster-source-' + ortho_id);
                    }
                    catch (ex) {
                    }
                }

            }
        });
    }
    visible_orthophotos.forEach(orthophoto_id => {
        loadBaseLayer(orthophoto_id);
    });
}
function loadBaseLayer(id) {
    if (map.getSource('raster-source-' + id)) {
        map.addSource('raster-source-' + id, {
            type: 'raster',
            tiles: [
                'https://vsbmaroc.com/app_terrain/basemap_tile/' + id + '/{z}/{x}/{y}'
            ],
            tileSize: 256,
            maxzoom: 22
        });


        map.addLayer({
            id: 'raster-layer-' + id,
            type: 'raster',
            source: 'raster-source-' + id,
            paint: {
                'raster-opacity': 1
            }
        });

    }






}

function onSourceData(e) {
    if (e.sourceId && e.sourceId.startsWith('raster-source-') && e.isSourceLoaded) {
        const firstLayerId = map.getStyle().layers[1].id;
        map.moveLayer('raster-layer-' + e.sourceId.slice('raster-source-'.length), firstLayerId);

    }
}
$("#vuew_3d_cb").change(function () {
    initdata();
});

function cleanMap() {

    map.getStyle().layers.forEach(layer => {
        if (layer.type != 'raster') {
            map.removeLayer(layer.id);
        }

    });
    Object.keys(map.getStyle().sources).forEach(elem => {
        if (map.getStyle().sources[elem].type != 'raster') {
            map.removeSource(elem);
        }
    });

    map.listImages().forEach(image => {
        map.removeImage(image);
    });


    map.setTerrain();
}


function init_sources() {

    map.addSource('communes', {
        type: 'geojson',
        data: assetBaseUrl + 'mapping/communes.geojson?v=2'
    });

    map.addSource('communes_centers', {
        type: 'geojson',
        data: assetBaseUrl + 'mapping/communes_centers.geojson?v=2'
    });

    map.addSource('provinces', {
        type: 'geojson',
        data: assetBaseUrl + 'mapping/provinces.geojson?v=2'
    });
    map.addSource('douars', {
        type: 'geojson',
        data: assetBaseUrl + 'mapping/douars.geojson?v=2'
    });




    source_initialized = true;

}

function init_layer_communes() {
    map.addLayer({
        'id': 'communes_fill',
        'type': 'fill',
        'source': 'communes',
        'paint': {
            'fill-color': 'white',
            'fill-opacity': 0.15,
        }
    });
    map.addLayer({
        'id': 'communes_line',
        'type': 'line',
        'source': 'communes',
        'paint': {
            'line-color': '#FFFF20',
            'line-width': 1,

        }
    });

    map.addLayer({
        "id": "communes_symboles",
        "type": "symbol",
        "source": "communes_centers",
        "layout": {
            "symbol-placement": "point",
            "text-font": ["Metropolis Semi Bold"],
            "text-field": '{nom}',
            "text-offset": [0, -1],
            "icon-overlap": "always",
            "text-allow-overlap": true,
            "text-size": 13,

        },
        "paint": {
            "text-color": "#76C88B",
            "text-halo-color": "black",
            "text-halo-width": 1,
            "text-halo-blur": 0
        }
    });
}


function init_layer_provinces() {

    map.addLayer({
        'id': 'limite_province_line',
        'type': 'line',
        'source': 'provinces',
        'paint': {
            'line-color': '#FF0000',
            'line-width': 2,

        }
    });
}
function init_layer_douars() {
    map.addLayer({
        "id": "douars_centers",
        'type': 'circle',
        'source': 'douars',
        'paint': {
            'circle-radius': 1.5,
            'circle-color': '#ffffff',
        }
    });
    map.addLayer({
        "id": "douars_symbols",
        "type": "symbol",
        "source": "douars",
        "layout": {
            "symbol-placement": "point",
            "text-font": ["Metropolis Semi Bold"],
            "text-field": '{id}',
            "text-size": 11,
            "text-offset": [0, -1],

        },
        "paint": {
            "text-color": "#FFFFFF",
            "text-halo-color": "black",
            "text-halo-width": 1,
            "text-halo-blur": 0
        }
    });
}


function rSize() {
    var side_panel_h = $(".side_panel").height();
    var dossiers_filter_h = $("#myTab").height();
    $("#dossiers_result_list").css('height', (side_panel_h - dossiers_filter_h - 40) + 'px');
};



$(window).on("resize", function () {
    //rSize();
});



$("#baselayer_google_streets").click(function () {

    $("#baselayer_google_streets").removeClass('disabled');
    $("#baselayer_google_sat").addClass('disabled');
    $("#baselayer_google_hybrid").addClass('disabled');

    map.setStyle({
        version: 8,
        sources: {
            osm: {
                type: 'raster',
                tiles: ['https://www.google.com/maps/vt?lyrs=m@189&gl=ma&x={x}&y={y}&z={z}'],
                tileSize: 256,
                attribution: '',
                maxzoom: 22
            },
        },
        layers: [{
            id: 'osm',
            type: 'raster',
            source: 'osm'
        },],
        "glyphs": "https://fonts.openmaptiles.org/{fontstack}/{range}.pbf",
    });
    initdata();
});

$("#baselayer_google_sat").click(function () {

    $("#baselayer_google_streets").addClass('disabled');
    $("#baselayer_google_sat").removeClass('disabled');
    $("#baselayer_google_hybrid").addClass('disabled');

    map.setStyle({
        version: 8,
        sources: {
            osm: {
                type: 'raster',
                tiles: ['https://www.google.com/maps/vt?lyrs=s@189&gl=ma&x={x}&y={y}&z={z}'],
                tileSize: 256,
                attribution: '',
                maxzoom: 22
            },
        },
        layers: [{
            id: 'osm',
            type: 'raster',
            source: 'osm'
        },],
        "glyphs": "https://fonts.openmaptiles.org/{fontstack}/{range}.pbf",
    });
    initdata();
});

$("#baselayer_google_hybrid").click(function () {

    $("#baselayer_google_streets").addClass('disabled');
    $("#baselayer_google_sat").addClass('disabled');
    $("#baselayer_google_hybrid").removeClass('disabled');

    map.setStyle({
        version: 8,
        sources: {
            osm: {
                type: 'raster',
                tiles: ['https://www.google.com/maps/vt?lyrs=y@189&gl=ma&x={x}&y={y}&z={z}'],
                tileSize: 256,
                attribution: '',
                maxzoom: 22
            },
        },
        layers: [{
            id: 'osm',
            type: 'raster',
            source: 'osm'
        },],
        "glyphs": "https://fonts.openmaptiles.org/{fontstack}/{range}.pbf",
    });
    initdata();
});


$("#vue_3d").click(function () {

    $("#vue_2d").addClass('disabled');
    $("#vue_3d").removeClass('disabled');

    if (map.getSource('terrainSource')) {
        map.removeSource('terrainSource');
    }

    map.addSource('terrainSource', {
        'type': 'raster-dem',
        'url': 'https://api.maptiler.com/tiles/terrain-rgb-v2/tiles.json?key=zW43iuG1uAEGN0AUvT7O',
        'tileSize': 256,
    });
    map.setPitch(60);
    map.setTerrain({ 'source': 'terrainSource', 'exaggeration': 1 });
});


$("#vue_2d").click(function () {

    $("#vue_2d").removeClass('disabled');
    $("#vue_3d").addClass('disabled');
    map.setPitch(0);
    map.setTerrain();
});

$(".side-panel-toggle").click(function () {
    $(".side_panel").toggleClass('folded');
    $(".side_panel .nav").toggleClass('hidden');
    $(".side_panel .tab-content").toggleClass('hidden');

    $(".side-panel-toggle i").toggleClass('fa-chevron-left');
    $(".side-panel-toggle i").toggleClass('fa-chevron-right');



});
var lightGallery_list = [];
function initLightGallery() {
    lightGallery_list.forEach(lg => {
        lg.destroy();
    });
    lightGallery_list = [];
    $("div[id^=photos_]").each(function () {
        var lg = lightGallery(document.getElementById($(this).attr('id')), {
            plugins: [lgZoom, lgThumbnail, lgFullscreen, lgRotate],
            selector: ".gallery-img",
            thumbnail: true,
            animateThumb: true,
            zoomFromOrigin: true,
            allowMediaOverlap: false,
            toggleThumb: true,
            exThumbImage: "data-src",
            fullScreen: true,
            mousewheel: true
        });

        lightGallery_list.push(lg);
    });
}
function handleDossierMarkerClick(id, coordinates) {

    selected_baraque_id = id;
    var html = `<div style="width: 450px;">   
                        <div style=" padding: 8px; background: #ffffff; width: 90px; height: 90px; position: absolute; z-index: 99; top: -26px; left: -26px; border-radius: 50%; border: 2px #ce6700 solid;">
                           <svg fill="#ce6700" viewBox="-1 0 19 19" xmlns="http://www.w3.org/2000/svg" class="cf-icon-svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><path d="M16.417 9.583A7.917 7.917 0 1 1 8.5 1.666a7.917 7.917 0 0 1 7.917 7.917zm-2.792-1.198a.396.396 0 0 0-.149-.54L8.661 5.104a.396.396 0 0 0-.393 0l-2.31 1.324v-.895a.318.318 0 0 0-.317-.317h-.968a.318.318 0 0 0-.317.317v1.813l-.872.5a.396.396 0 1 0 .393.686l4.589-2.629 4.619 2.63a.395.395 0 0 0 .54-.148zm-1.02.786L8.467 6.815l-4.11 2.356v4.465a.318.318 0 0 0 .316.317h7.615a.318.318 0 0 0 .317-.317zm-6.647.607h1.647v1.668H5.958zm5.045 1.668H9.356V9.778h1.647z"></path></g></svg>
                        </div>
                    <div class="dossier_popup_loader" style="transition: 0.5s;pointer-events:none; opacity:1;position: absolute; height: 100%; width: 100%; background: #0F91C8; z-index: 99; border-radius: 8px;">
                        <div style="width: 100%;height: 120px;position: absolute;top: calc(50% - 60px);">
                            <img style="color:white;margin: auto;display: block;width:120px;height:120px" src="images/Dual Ring-1s-200px.svg?v=2">
                            <b style="color:white;font-family: 'Roboto'; font-size: 1rem; text-align: center; display: block;">Chargement...</b>
                        </div>                             
                    </div>


                    <div class="row mt-2">         
                        <div   class="col-12 projet_popup_title_div " style="border-bottom: 1pxrgb(197, 197, 197) dashed; border-radius:8px 8px 0px 0px;padding:0px">
                            <b  class="projet_popup_numero" style="margin: 6px 0px;text-align: center; width: 100%; display: block; font-size: 1rem; color: #bf5217;">...</b>
                              
                        </div>  
                    </div>  
                    <div class="row mt-2">           
                        <div class="col-12">
                            <span style=" text-align: right; display: block; margin: auto;"><i class="fa-solid fa-users mr-1"></i>Nombre de menages : <b   class="baraque_popup_menages_count"></b></span>      
                        </div>                              
                    </div>  

                    <div class="row baraque_popup_menages_list" style="padding: 8px;" >           
                                                    
                    </div> 

                    <div class="row mt-2">           
                        <div class="col-12">
                            <span style=" text-align: right; display: block; margin: auto;"><i class="fa-solid fa-shop mr-1"></i>Nombre de commerces : <b class="baraque_popup_commerces_count"></b></span>      
                        </div>                              
                    </div>  

                    <div class="row baraque_popup_commerces_list" style="padding: 8px;" >           
                                                    
                    </div> 
                    
                    <div class="row">
                        <div class="col-12">
                            <div id="photos_BARAQUE" class="phototheque hk-gallery" type_document="PHOTOS_BARAQUE" style="height:130px; width: 100%; overflow-x: auto; padding: 8px; background: #f7813e42; box-shadow: unset !important; border: unset;">
                            </div>
                        </div>
                    </div>

                     <div class="row mt-1">
                        <button id="baraque_more_info_btn" style="margin: 8px;width: 100%;  " type="button" class="btn">
                             
                            <i class="fa-solid fa-circle-info mr-2"></i></i>Plus de détail
                        </button>
                    </div>
                   
                </div>`;

    dossier_popup.setLngLat(coordinates).setHTML(html).addTo(map);

    $.ajax({
        url: assetBaseUrl + "geoportail/baraque/data/" + id,
        type: 'get',
        dataType: 'json',
        success: function (response) {
            $(".dossier_popup_loader").css('opacity', '0');


            // $(".projet_popup_title_div").css('background', response.avancement_color);
            $(".projet_popup_numero").text(response.full_num);
            $(".baraque_popup_menages_count").text(response.menages.length);
            $(".baraque_popup_commerces_count").text(response.commerces.length);

            $(".baraque_popup_menages_list").empty();
            $(".baraque_popup_commerces_list").empty();


            response.menages.forEach(menage => {
                var conjoin_html = `
                <h5 style="font-size: 0.75rem; border-bottom: 1px #b1b1b1 dashed; padding-bottom: 8px; color: rgb(113 113 113);">Conjoint</h5>
                    <div class="row">
                        <div class="col-7">
                            <span style="margin: auto;display: block;font-weight: 500; color: #bf5217;"><i class="fa-solid fa-user mr-2"></i> ${menage.conjoint_nom}</span>
                           
                        </div>
                        <div class="col-5">
                            <span style="margin: auto;display: block;font-weight: 400; color: #bf5217;"><i class="fa-solid fa-address-card mr-2"></i>CIN :${menage.conjoint_cin == null ? 'ND' : menage.conjoint_cin}</span>
                       
                            </div>
                    </div>`;

                if (menage.conjoint_nom != null) {
                    if (menage.conjoint_nom.length == 0) {
                        conjoin_html = "";
                    }
                }
                else {
                    conjoin_html = "";
                }

                var menage_html = `
                <div class="col-12 mt-1" style="border: 1px #cecece solid; padding: 8px; border-radius: 8px; background: #fcfcfc78;">

                <div class="row">
                        
                        
                    </div>
                     <div class="row">
                        <div class="col-7">
                            <span style="margin: auto;display: block;font-weight: 500; color: #bf5217;"><i class="fa-solid fa-user mr-2"></i>${menage.chef_menage_nom} ${menage.chef_menage_prenom}</span>
                            <span style="margin: auto;display: block;font-weight: 400; color: #bf5217;"><i class="fa-solid fa-address-card mr-2"></i>CIN : ${menage.chef_menage_cin == null ? 'ND' : menage.chef_menage_cin}</span>

                        </div>
                        <div class="col-5">
                            <span style="margin: auto;display: block;font-weight: 500; color: #bf5217;">${menage.situation}</span>
                          
                        </div>
                    </div>
                    
                    ${conjoin_html}
                     
                </div>
                `;

                $(".baraque_popup_menages_list").append(menage_html);
            });

            response.commerces.forEach(commerce => {

                var commerce_html = `
                <div class="col-12 mt-1" style="border: 1px #cecece solid; padding: 8px; border-radius: 8px; background: #fcfcfc78;">

                <div class="row">
                        
                        
                    </div>
                     <div class="row">
                        <div class="col-7">
                            <span style="margin: auto;display: block;font-weight: 500; color: #bf5217;"><i class="fa-solid fa-user mr-2"></i>${commerce.nom} ${commerce.prenom}</span>
                            <span style="margin: auto;display: block;font-weight: 400; color: #bf5217;"><i class="fa-solid fa-address-card mr-2"></i>CIN : ${commerce.cin == null ? 'ND' : commerce.cin}</span>

                        </div>
                        <div class="col-5">
                            <span style="margin: auto;display: block;font-weight: 500; color: #bf5217;">${commerce.type_activite}</span>
                          
                        </div>
                    </div>
                    
                  
                     
                </div>
                `;
                $(".baraque_popup_commerces_list").append(commerce_html);
            });
            $("#photos_BARAQUE").empty();
            response.documents.forEach(document => {
                var photo_html = `
                  <a class="costume-img" href="https://vsbmaroc.com/files/baraques_documents/${document.id}/${document.filename}" style="margin: 0px;">
                        <img data-src="https://vsbmaroc.com/files/baraques_documents/${document.id}/${document.filename}" style="border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="https://vsbmaroc.com/files/baraques_documents/${document.id}/${document.filename}" class="gallery-img costume-img hk-gallery" data-lg-id="${document.id}">
                        
                    </a>
                `;

                $("#photos_BARAQUE").append(photo_html);
            });

            initLightGallery();



        }
    });
}

$("#zoom_in").click(function () {
    map.zoomIn();
});

$("#zoom_out").click(function () {
    map.zoomOut();
});

$("#reset_orientation").click(function () {
    map.resetNorth();
});

$("#full_screen").click(function () {
    if (map_fullscreen) {
        map_fullscreen = false;


        if (document.fullscreenElement) {
            document.exitFullscreen();
        } else if (document.mozFullScreenElement) {
            document.mozCancelFullScreen();
        } else if (document.webkitFullscreenElement) {
            document.webkitExitFullscreen();
        } else if (document.msFullscreenElement) {
            document.msExitFullscreen();
        }
        $("#full_screen > i").addClass("fa-up-right-and-down-left-from-center");
        $("#full_screen > i").removeClass("fa-down-left-and-up-right-to-center");
    }
    else {
        map_fullscreen = true;
        map.getContainer().requestFullscreen();


        $("#full_screen > i").removeClass("fa-up-right-and-down-left-from-center");
        $("#full_screen > i").addClass("fa-down-left-and-up-right-to-center");
    }


});

$("body").on('click', '.dossier_row', function () {

    var lat = parseFloat($(this).attr('lat'));
    var lng = parseFloat($(this).attr('lng'));
    var id = $(this).attr('item_id');

    if (lng == 0 || lat == 0)
        return;
    map.flyTo({
        center: [lng, lat],
        essential: true,
        zoom: 18
    });
    if (map.getLayer("dossiers_fill_selected_layer") != undefined) {
        map.removeLayer("dossiers_fill_selected_layer");
    }
    if (map.getSource("dossiers_fill_selected_source") != undefined) {
        map.removeSource("dossiers_fill_selected_source");
    }


    handleDossierMarkerClick(id, [lng, lat]);


});

$("#couche_communes").change(function () {
    if ($(this).prop('checked')) {
        init_layer_communes();
    }
    else {
        if (map.getLayer('communes_fill')) {
            map.removeLayer('communes_fill');
        }
        if (map.getLayer('communes_line')) {
            map.removeLayer('communes_line');
        }
        if (map.getLayer('communes_symboles')) {
            map.removeLayer('communes_symboles');
        }
    }

});

$("#couche_provinces").change(function () {
    if ($(this).prop('checked')) {
        init_layer_provinces();
    }
    else {
        if (map.getLayer('limite_province_line')) {
            map.removeLayer('limite_province_line');
        }
    }
});

$("#couche_douars_centres").change(function () {
    if ($(this).prop('checked')) {
        init_layer_douars();
    }
    else {
        if (map.getLayer('douars_centers')) {
            map.removeLayer('douars_centers');
        }
        if (map.getLayer('douars_symbols')) {
            map.removeLayer('douars_symbols');
        }
    }
});


$("#couche_dossiers_centres").change(function () {
    if ($(this).prop('checked')) {
        map.addLayer({
            'id': 'dossiers_centers',
            'type': 'circle',
            'source': 'dossiers_points',
            'paint': {
                'circle-radius': {
                    'base': 1.75,
                    'stops': [
                        [0, 5],
                        [20, 5]
                    ]
                },
                'circle-color': ['get', 'etat_avancement_color'],
                "circle-stroke-width": 2,
                "circle-stroke-color": '#fff'
            }
        });
    }
    else {
        if (map.getLayer('dossiers_centers')) {
            map.removeLayer('dossiers_centers');
        }
    }

});

$("#couche_dossiers_limites").change(function () {
    if ($(this).prop('checked')) {
        map.addLayer({
            'id': 'dossiers_fill',
            'type': 'fill',
            'source': 'dossiers',
            'paint': {
                'fill-color': ['get', 'etat_avancement_color'],
                'fill-opacity': 0.55,
            }
        });

        map.addLayer({
            'id': 'dossiers_line',
            'type': 'line',
            'source': 'dossiers',
            'paint': {
                'line-color': '#fff',
                'line-width': 2,
            }
        });

    }
    else {
        if (map.getLayer('dossiers_fill')) {
            map.removeLayer('dossiers_fill');
        }
        if (map.getLayer('dossiers_line')) {
            map.removeLayer('dossiers_line');
        }
    }

});


function loadBaseLayer(id) {

    map.addSource('raster-source-' + id, {
        type: 'raster',
        tiles: [
            assetBaseUrl + 'app_terrain/basemap_tile/' + id + '/{z}/{x}/{y}'
        ],
        tileSize: 256,
        maxzoom: 22
    });

    // Add the first raster layer
    map.addLayer({
        id: 'raster-layer-' + id,
        type: 'raster',
        source: 'raster-source-' + id,
        paint: {
            'raster-opacity': 1
        }
    });




}

$("body").on('click', '#baraque_more_info_btn', function () {

    window.open(assetBaseUrl + 'baraques/show/' + selected_baraque_id, '_blank', 'noopener,noreferrer').focus();

});

document.getElementById('opacity-slider').addEventListener('input', (e) => {
    const newOpacity = parseFloat(e.target.value);
    map.setPaintProperty('dossiers_fill', 'fill-opacity', newOpacity);
});

document.getElementById('opacity-slider-orthophoto').addEventListener('input', (e) => {
    const newOpacity = parseFloat(e.target.value);

    const rasterLayers = map.getStyle().layers.filter(layer =>
        layer.id.startsWith('raster-layer-')
    );

    rasterLayers.forEach(layer => {
        map.setPaintProperty(layer.id, 'raster-opacity', newOpacity);
    });

});

$("#orthophoto-toggle").change(function () {

    const visible = $(this).prop('checked');

    if (!visible) {
        load_orthophoto = false;
        const layers = map.getStyle().layers;
        if (layers) {
            layers.forEach(layer => {
                if (layer.id.startsWith('raster-layer-')) {
                    var ortho_id = layer.id.replace('raster-layer-', '');
                    try {
                        map.removeLayer(layer.id);
                    }
                    catch (ex) {
                    }
                    try {
                        map.removeSource('raster-source-' + ortho_id);
                    }
                    catch (ex) {
                    }
                }
            });
        }
    }
    else {
        load_orthophoto = true;
        refreshBaseLayers();
    }
})