var prestataires_table = undefined;
var current_tab = "comptes";
var prestataires_table_last_url = assetBaseUrl + 'users/datatble?demande=0&proposition=0&filters=[]';

$(document).ready(function () {
    prestataires_table = $('#users_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: true,
        pageLength: 25,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: true,
        searching: false,
        scrollX: false,
        ajax: prestataires_table_last_url,
        dom: "lBfrtip",
        buttons: [
            {
                "extend": 'excel',
                "text": '',
                "titleAttr": 'excel',
                'title': 'Dossiers-' + current_date.replaceAll("/", "-"),
                "action": newexportaction
            },
        ],
        columnDefs: [
            { lassName: 'text-left', targets: [0] },
            { className: 'text-center', targets: [1, 2, 3, 4, 5] }
        ],
        columns: [
            {
                data: 'organisme_ste',
            },
            {
                data: 'role',
            },
            {
                data: 'nom',
            },
            {
                data: 'prenom',
            },
            {
                data: 'tel',
            },
            {
                data: 'email',
            },
            {
                data: 'ville',
            },
            {
                data: 'invitation',
            }

        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },

    }).on("xhr.dt", function (e, settings, json, xhr) {

        //$("#dt_dossiers_count").text(json.recordsFiltered);
    });

    prestataires_table.on('draw', function () {

    })


    $(".select2").select2();
    $(".select2nc").select2({
        minimumResultsForSearch: -1
    });

});


$("#prestataires_add").click(function () {
    document.getElementById("store_user_form").reset();
    $("#add_prestataire_modal").modal('show');
});


$("#store_user_form").submit(function (event) {

    event.preventDefault();
    var formData = new FormData(this);
    $.ajax({
        url: assetBaseUrl + "user/store",
        type: "POST",
        dataType: "json",
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
            if (response.success == 1) {
                $("#add_prestataire_modal").modal('hide');
                $.toast({
                    heading: "TamkinInvest",
                    text: 'Le prestataire a été créé avec succès.',
                    icon: "success",
                    position: "bottom-right",
                    hideAfter: 3000,
                    stack: false,
                });
                prestataires_table.ajax.reload();
            }
            else {
                Swal.fire({
                    icon: "error",
                    title: "TamkinInvest",
                    text: "Cet email est déjà présent dans notre base de données.",

                });

            }


        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});

$("body").on('change', '.prestataire_cb', function () {
    if ($(".prestataire_cb:checked").length > 0) {
        $("#prestataires_delete").removeAttr("disabled");
        $("#send_invitation").removeAttr("disabled");
        $("#edit_etat_engagement").removeAttr("disabled");

    } else {

        $("#prestataires_delete").attr("disabled", "disabled");
        $("#send_invitation").attr("disabled", "disabled");
        $("#edit_etat_engagement").attr("disabled", "disabled");
    }
});



$("#send_invitation").click(function () {
    loading_popup = Swal.fire({
        title: 'Chargement',
        html: 'Envoie des invitation...',
        timer: 2000000000,
        timerProgressBar: true,
        hideOnOverlayClick: false,
        hideOnContentClick: false,
        allolwOutsideClick: false,
        closeClick: false,
        helpers: {
            overlay: { closeClick: false }
        },
        didOpen: () => {
            Swal.showLoading()

        },
        willClose: () => {

        }
    }).then((result) => {

    })


    $(".prestataire_cb:checked").each(function () {

        $.ajax({
            url: assetBaseUrl + "send-invitation-mail/" + $(this).attr('item_id'),
            type: "GET",
            dataType: "json",

            success: function (response) {
                Swal.close();

                $.toast({
                    heading: "TamkinInvest",
                    text: 'Invitation(s) envoyée(s).',
                    icon: "success",
                    position: "bottom-right",
                    hideAfter: 3000,
                    stack: false,
                });

                prestataires_table.ajax.reload();
                $("#prestataires_delete").attr("disabled", "disabled");
                $("#send_invitation").attr("disabled", "disabled");
                $("#edit_etat_engagement").attr("disabled", "disabled");
            },
            error: function (xhr, status, error) {
                console.log(xhr.responseText);
            },
        });



    });

});


$("body").on('click', '.prestataire_a', function () {

    $.ajax({
        url: assetBaseUrl + "user/" + $(this).attr('item_id'),
        type: "GET",
        dataType: "json",

        success: function (response) {
            $("#store_user_form [name='id']").val(response.id);
            $("#store_user_form [name='nom']").val(response.nom);
            $("#store_user_form [name='prenom']").val(response.prenom);
            $("#store_user_form [name='email']").val(response.email);
            $("#store_user_form [name='tel']").val(response.tel);
            $("#store_user_form [name='organisme_ste']").val(response.organisme_ste);
            $("#store_user_form [name='role_id']").val(response.role_id).change();

            $("#add_prestataire_modal_type_client").val(response.type_client);

            if (response.validation_completed_date != null) {
                $("#store_user_form [name='email']").attr('disabled', 'disabled');
            }
            else {
                $("#store_user_form [name='email']").removeAttr('disabled');
            }

            $("#add_prestataire_modal_rol_id").change();

            $("#add_prestataire_modal").modal('show');

        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });

});

$("#add_prestataire_modal_rol_id").change(function () {

    if ($(this).val() == "12ad84c3-2f03-4348-a7d3-3ec8cd9292ef") {
        $(".client_type_div").css('display', 'block');
    }
    else {
        $(".client_type_div").css('display', 'none');
        $(".organisme_ste_div").css('display', 'block');
    }

    $("#add_prestataire_modal_type_client").change();
});

$("#add_prestataire_modal_type_client").change(function () {

    if ($("#add_prestataire_modal_rol_id").val() == "12ad84c3-2f03-4348-a7d3-3ec8cd9292ef") {
        if ($(this).val() == "Personne physique") {
            $(".organisme_ste_div").css('display', 'none');
        }
        else {
            $(".organisme_ste_div").css('display', 'block');
        }
    }

});


$(document).on('shown.bs.tab', 'a[data-toggle="tab"]', function (e) {
    var target = $(e.target).attr("href");
    current_tab = target;

    if (current_tab == "#demande") {
        $("#prestataires_add").css('display', 'none');
    }
    if (current_tab == "#propositions") {
        $("#prestataires_add").css('display', 'none');
    }
    if (current_tab == "#comptes") {
        $("#prestataires_add").css('display', 'inline-block');
    }
    filter_prestataires_table();

});

function filter_prestataires_table() {
    var filters = [];
    var demande = 0;
    var proposition = 0;
    if (current_tab == "#demande") {
        demande = 1;
    }
    if (current_tab == "#propositions") {
        proposition = 1;
    }


    prestataires_table_last_url = assetBaseUrl + 'users/datatble?demande=' + demande + '&proposition=' + proposition + 'filters=[]';

    if (prestataires_table.ajax != undefined) {
        prestataires_table.ajax.url(prestataires_table_last_url).load();
    }

}