var menages_table = undefined;

var tab_filter = undefined;

$(document).ready(function () {
  menages_table = $("#menages_table")
    .DataTable({
      responsive: false,
      autoWidth: false,
      bPaginate: true,
      pageLength: 25,
      lengthChange: false,
      bFilter: false,
      bInfo: false,
      ordering: false,
      processing: true,
      serverSide: true,
      searching: false,
      scrollX: false,
      ajax: assetBaseUrl + "menages/menages_datatable?filters=[]",
      dom: "lBfrtip",
      buttons: [
        {
          extend: "excel",
          text: "",
          titleAttr: "excel",
          title: "Menages -" + current_date.replaceAll("/", "-"),
          action: newexportaction,
        },
      ],

      columnDefs: [
        { lassName: "text-left", targets: [0] },
        { className: "text-center", targets: [1, 2,3,4,5] },
      ],

      columns: [
        {
          data: "dossier",
        },
        {
          data: "chef_menage",
        },
        {
          data: "cin",
        },
        {
          data: "arrondissement",
        },
        {
          data: "annexe_administrative",
        },
        {
          data: "quartier",
        },
        {
          data: "etat_avancement",
        },
        {
          data: "depot",
        },
      ],
      language: {
        url: assetBaseUrl + "languages/datatable_fr.json",
      },
    })
    .on("xhr.dt", function (e, settings, json, xhr) {
      $("#dt_menages_count").text(
        formatNumber(json.recordsFiltered, 0, ".", " ")
      );
    });

  menages_table.on("draw", function () {
    $(".select2").select2();
    $(".select2nc").select2({
      minimumResultsForSearch: -1,
    });
  });
});

$("#provinces_filter").change(function () {
  refresh_situation_filters("province");
});

$("#arrondissements_filter").change(function () {
  refresh_situation_filters("arrondissement");
});

$("#annexes_administratives_filter").change(function () {
  refresh_situation_filters("annexe_administrative");
});

$("#douars_filter").change(function () {
  refresh_situation_filters("douar");
});

function fill_situation_filter_arrondissement(province_id) {
  $("#arrondissements_filter").empty();

  $("#arrondissements_filter").append(new Option("Indifferent", "all"));

  arrondissements.forEach((arrondissement) => {
    if (province_id != "all") {
      if (arrondissement.province_id == province_id) {
        $("#arrondissements_filter").append(
          new Option(arrondissement.nom, arrondissement.id)
        );
      }
    } else {
      $("#arrondissements_filter").append(
        new Option(arrondissement.nom, arrondissement.id)
      );
    }
  });
}

function fill_situation_filter_annexe_administrative(
  province_id,
  arrondissement_id
) {
  $("#annexes_administratives_filter").empty();

  $("#annexes_administratives_filter").append(new Option("Indifferent", "all"));

  var filtred_arrondissements = [];

  arrondissements.forEach((arrondissement) => {
    if (province_id != "all") {
      if (arrondissement.province_id == province_id) {
        filtred_arrondissements.push(arrondissement);
      }
    } else {
      filtred_arrondissements.push(arrondissement);
    }
  });

  filtred_arrondissements.forEach((arrondissement) => {
    annexes_administratives.forEach((annexe) => {
      if (annexe.arrondissement_id == arrondissement.id) {
        if (arrondissement_id != "all") {
          if (annexe.arrondissement_id == arrondissement_id) {
            $("#annexes_administratives_filter").append(
              new Option(annexe.nom, annexe.id)
            );
          }
        } else {
          $("#annexes_administratives_filter").append(
            new Option(annexe.nom, annexe.id)
          );
        }
      }
    });
  });
}

function fill_situation_filter_douar(
  province_id,
  arrondissement_id,
  annexe_administrative_id
) {
  $("#douars_filter").empty();

  $("#douars_filter").append(new Option("Indifferent", "all"));

  var filtred_arrondissements = [];

  arrondissements.forEach((arrondissement) => {
    if (province_id != "all") {
      if (arrondissement.province_id == province_id) {
        filtred_arrondissements.push(arrondissement);
      }
    } else {
      filtred_arrondissements.push(arrondissement);
    }
  });

  var filtred_annexes_administratives = [];

  filtred_arrondissements.forEach((arrondissement) => {
    annexes_administratives.forEach((annexe) => {
      if (annexe.arrondissement_id == arrondissement.id) {
        if (arrondissement_id != "all") {
          if (annexe.arrondissement_id == arrondissement_id) {
            filtred_annexes_administratives.push(annexe);
          }
        } else {
          filtred_annexes_administratives.push(annexe);
        }
      }
    });
  });

  filtred_annexes_administratives.forEach((annexe) => {
    douars.forEach((douar) => {
      if (douar.annexe_administrative_id == annexe.id) {
        if (annexe_administrative_id != "all") {
          if (annexe.id == annexe_administrative_id) {
            $("#douars_filter").append(new Option(douar.nom, douar.id));
          }
        } else {
          $("#douars_filter").append(new Option(douar.nom, douar.id));
        }
      }
    });
  });
}

function refresh_situation_filters(trigger_source) {
  if (trigger_source == "province") {
    console.log("trigger_source province");

    fill_situation_filter_arrondissement($("#provinces_filter").val(), "all");

    fill_situation_filter_annexe_administrative(
      $("#provinces_filter").val(),
      "all"
    );

    fill_situation_filter_douar($("#provinces_filter").val(), "all", "all");
  }

  if (trigger_source == "arrondissement") {
    var province_id = undefined;

    if ($("#arrondissements_filter").val() == "all") {
      refresh_situation_filters("province");

      return;
    }

    arrondissements.forEach((arrondissement) => {
      if (arrondissement.id == $("#arrondissements_filter").val()) {
        province_id = arrondissement.province_id;
      }
    });

    $("#provinces_filter").val(province_id);

    $("#provinces_filter").trigger("change.select2");

    fill_situation_filter_annexe_administrative(
      province_id,
      $("#arrondissements_filter").val()
    );

    fill_situation_filter_douar(
      province_id,
      $("#arrondissements_filter").val(),
      "all"
    );
  }

  if (trigger_source == "annexe_administrative") {
    var province_id = undefined;

    var arrondissement_id = undefined;

    if ($("#annexes_administratives_filter").val() == "all") {
      refresh_situation_filters("arrondissement");

      return;
    }

    annexes_administratives.forEach((annexe) => {
      if (annexe.id == $("#annexes_administratives_filter").val()) {
        arrondissement_id = annexe.arrondissement_id;
      }
    });

    arrondissements.forEach((arrondissement) => {
      if (arrondissement.id == arrondissement_id) {
        province_id = arrondissement.province_id;
      }
    });

    $("#provinces_filter").val(province_id);

    $("#provinces_filter").trigger("change.select2");

    $("#arrondissements_filter").val(arrondissement_id);

    $("#arrondissements_filter").trigger("change.select2");

    fill_situation_filter_douar(
      province_id,
      $("#arrondissements_filter").val(),
      $("#annexes_administratives_filter").val(),
      "all"
    );
  }

  if (trigger_source == "douar") {
    var province_id = undefined;

    var arrondissement_id = undefined;

    var annexe_administrative_id = undefined;

    if ($("#douars_filter").val() == "all") {
      refresh_situation_filters("annexe_administrative");

      return;
    }

    douars.forEach((douar) => {
      if (douar.id == $("#douars_filter").val()) {
        annexe_administrative_id = douar.annexe_administrative_id;
      }
    });

    annexes_administratives.forEach((annexe) => {
      if (annexe.id == annexe_administrative_id) {
        arrondissement_id = annexe.arrondissement_id;
      }
    });

    arrondissements.forEach((arrondissement) => {
      if (arrondissement.id == arrondissement_id) {
        province_id = arrondissement.province_id;
      }
    });

    $("#provinces_filter").val(province_id);

    $("#provinces_filter").trigger("change.select2");

    $("#arrondissements_filter").val(arrondissement_id);

    $("#arrondissements_filter").trigger("change.select2");

    $("#annexes_administratives_filter").val(annexe_administrative_id);

    $("#annexes_administratives_filter").trigger("change.select2");
  }
}

$("#meilisearch_term").change(function () {
  filter_tab_douar_index_table();
});

function filter_tab_douar_index_table() {
  var filters = [];

  $(".dt_filter").each(function () {
    var column = $(this).attr("column");

    var table = $(this).attr("table");

    var value = $(this).val();

    var params = $(this).attr("params");

    if (value != "all" && value.trim().length > 0) {
      filters.push({
        column: column,
        table: table,
        value: value,
        params: params,
      });
    }
  });

  var searchTerm = "";

  if ($("#meilisearch_term").val().length > 3) {
    searchTerm = $("#meilisearch_term").val();
  }

  if (tab_filter != undefined) {
    var column = tab_filter;

    filters.push({ column: column, table: "", value: "", params: "" });
  }

  $(".document_filter").each(function () {
    var value = $(this).val();

    if (value != "all") {
      filters.push({
        column: "document_filter",
        etat: $("#document_etat_filter").val(),
        value: value,
      });
    }
  });

  menages_table.ajax
    .url(
      assetBaseUrl +
        "menages/menages_datatable" +
        "?searchTerm=" +
        searchTerm +
        "&filters=" +
        JSON.stringify(filters)
    )
    .load();
}

$("#document_etat_filter").change(function () {
  filter_tab_douar_index_table();
});

$(".document_filter").change(function () {
  filter_tab_douar_index_table();
});

$(".dt_filter").change(function () {
  filter_tab_douar_index_table();
});

$(".dt_filter").keyup(function () {
  filter_tab_douar_index_table();
});

$(".custom_filter").change(function () {
  filter_tab_douar_index_table();
});

$(document).ready(function () {
  $('a[data-toggle="tab"]').on("shown.bs.tab", function (event) {
    tab_filter = event.target.id;

    filter_tab_douar_index_table();
  });
});
