
var current_selected_file_id = undefined;
$(document).ready(function () {

    $("#verification_doc_select").change();
});

$("#verification_doc_select").change(function () {
    var doc_id = $(this).val();

    if (doc_id == "null") {
        reset_viewer();
    }
    else {
        loadFile(doc_id);

    }
    if ($("#verification_doc_select option:selected").text() == "Réception de la structure") {
        $("#verification_reception_structure_detail_div").css('display', 'block');
        $("#save_dossier").css('display', 'block');
        $("#verification_detail_div").css('display', 'block');
    }
    if ($("#verification_doc_select option:selected").text() == "Réception de la finition") {
        $("#verification_reception_finitions_detail_div").css('display', 'block');
        $("#save_dossier").css('display', 'block');
        $("#verification_detail_div").css('display', 'block');

    }
    if ($("#verification_doc_select option:selected").text() == "Autorisation de construire") {

        $("#verification_detail_div").css('display', 'block');
        $("#verification_2_autorisation_construire_div").css('display', 'block');

    }
});

function reset_viewer() {

    $("#verification_reception_structure_detail_div").css('display', 'none');
    $("#verification_reception_finitions_detail_div").css('display', 'none');
    $("#verification_2_autorisation_construire_div").css('display', 'none');
    $("#verification_detail_div").css('display', 'none');
    // $("#save_dossier").css('display', 'none');

    $(".verification_document_etat").val('Aucun fichier importé');
    $(".valider_document").attr('disabled', 'disabled');
    $(".rejeter_document").attr('disabled', 'disabled');
    $(".cin_missing_document").attr('disabled', 'disabled');
    $(".incomplet_document").attr('disabled', 'disabled');


    $(".verification_document_etat").css('font-weight', '400');
    $(".verification_document_etat").css('color', '#888888');
    $("#verification_document_pdf_view").attr('src', '');

    $("#verification_date_div").css('display', 'none');
    $(".verification_date_div_edit").removeAttr('disabled');
}

function loadFile(document_id) {

    if (document_id == null)
        return;
    $("#verif_photo_img").attr('src', assetBaseUrl + 'images/verif_no_photo.png');
    reset_viewer();
    showLoading('Chargement...', 'Le fichier est en cours de chargement, veuillez patienter');
    reset_viewer();
    current_selected_file_id = document_id;
    $.ajax({
        url: assetBaseUrl + "menages/file_data/" + document_id,
        type: "GET",
        success: function (response) {
            closeLoading();

            $(".verification_document_etat").val(response.decision);

            if (response.decision == "Rejeté") {
                $(".verification_document_etat").val(response.decision + " (" + response.motif_rejet + ")");
            }
            if (response.decision == "En attente") {

                $(".valider_document").removeAttr('disabled');
                $(".rejeter_document").removeAttr('disabled');
                $(".verification_document_etat").css('font-weight', '500');
                $(".verification_document_etat").css('color', '#FF8600');

                $(".cin_missing_document").removeAttr('disabled');
                $(".incomplet_document").removeAttr('disabled');
            }

            else {
                if (response.decision == "Validé") {
                    $(".verification_document_etat").css('color', '#779E25');
                }
                else {
                    $(".verification_document_etat").css('color', '#F44141');
                }
                $(".verification_document_etat").css('font-weight', '500');

            }



            if (response.decision == "CIN introuvable") {
                $(".valider_document").removeAttr('disabled');

            }
            // if (response.v1_incomplet == 0) {
            //     $(".incomplet_document").removeAttr('disabled');
            // }

            $("#verification_document_pdf_view").attr('src', assetBaseUrl + 'menages/file/' + response.id);

            if (response.type_document != "AUTORISATION_CONSTRUIRE") {


                if (response.date_document != null) {

                    $("#verification_date_div_input").data('daterangepicker').setStartDate(formatDate(response.date_document));

                    $("#verification_date_div").css('display', 'block');
                    $("#verification_detail_div").css('display', 'block');

                    $(".verification_date_div_save").removeAttr('disabled');
                }
                else {

                }

            }

            if (response.type_document == "PV_RECEPTION_FINITION") {
                if (response.photo_doc != null) {


                    $("#verif_photo_img").attr('src', assetBaseUrl + 'dossiers/file/' + response.photo_doc.id);
                }
            }

        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
}




$(".restore_doc_etat_btn").click(function () {
    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous sûr de restorer l'etat du document ?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {


            $.ajax({
                url: assetBaseUrl + "sv_restore_document_etat",
                type: "POST",
                data: {
                    _token: csrfToken,
                    id: current_selected_file_id,
                },
                success: function (response) {

                    if (response.success == 1) {
                        loadFile(current_selected_file_id);
                    }



                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText);
                },
            });


        }
    });
});

$(".valider_document").click(function () {
    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous sûr de vouloir valider le document ?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {


            $.ajax({
                url: assetBaseUrl + "menages/validate_document",
                type: "POST",
                data: {
                    _token: csrfToken,
                    id: current_selected_file_id,
                },
                success: function (response) {

                    if (response.success == 1) {
                        loadFile(current_selected_file_id);
                    }



                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText);
                },
            });


        }
    });

});

$("#motif_rejet_modal_accept").click(function () {
    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous sûr de vouloir rejeter le document ?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {

            $("#motif_rejet_modal").modal("hide");

            $.ajax({
                url: assetBaseUrl + "menages/rejeter_document",
                type: "POST",
                data: {
                    _token: csrfToken,
                    id: current_selected_file_id,
                    motif_rejet: $("#motif_rejet_modal_content").val()
                },
                success: function (response) {

                    if (response.success == 1) {
                        loadFile(current_selected_file_id);
                    }



                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText);
                },
            });


        }
    });
});

$(".rejeter_document").click(function () {   

    $("#motif_rejet_modal").modal("show");
});


$(".cin_missing_document").click(function () {
    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous sûr de vouloir continuer ?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {


            $.ajax({
                url: assetBaseUrl + "dossiers/cin_missing_document",
                type: "POST",
                data: {
                    _token: csrfToken,
                    id: current_selected_file_id,
                },
                success: function (response) {

                    if (response.success == 1) {
                        loadFile(current_selected_file_id);
                    }



                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText);
                },
            });


        }
    });
});



$(".incomplet_document").click(function () {
    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous sûr de vouloir continuer ?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {


            $.ajax({
                url: assetBaseUrl + "dossiers/incomplet_document",
                type: "POST",
                data: {
                    _token: csrfToken,
                    id: current_selected_file_id,
                },
                success: function (response) {

                    if (response.success == 1) {
                        loadFile(current_selected_file_id);
                    }



                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText);
                },
            });


        }
    });
});
//Pétitionnaires//////////////////////////////
var petitionnaires_table = undefined;
var petitionnaires_table_edit_row = undefined;

$(document).ready(function () {
    petitionnaires_table = $('#petitionnaires_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: false,
        pageLength: 25,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: false,
        searching: false,
        scrollX: false,
        ajax: null,
        dom: "lBfrtip",
        buttons: [
        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        }
    });

});



function petitionnaires_add(petitionnaire) {
    var nom_html = `<input   type="checkbox" item_id="${petitionnaire.id}" class="petitionnaire_cb" style="display:none;vertical-align: middle;position: relative;">&nbsp<a  item_id="${petitionnaire.id}" href="javascript:;" class="petitionnaire_a">${petitionnaire.nom}</a>`;
    var prenom_html = '<span> ' + petitionnaire.prenom + '</span>';
    var cin_html = '<span> ' + petitionnaire.cin + '</span>';
    var tel_html = '<span> ' + petitionnaire.tel + '</span>';


    if (petitionnaires_table_edit_row == undefined) {
        petitionnaires_table.row.add([nom_html, prenom_html, cin_html, tel_html, petitionnaire]).draw();
    }
    else {
        petitionnaires_table.row(petitionnaires_table_edit_row).data([nom_html, prenom_html, cin_html, tel_html, petitionnaire]).draw();
    }
}




$("body").on('click', '.petitionnaire_a', function () {

    document.getElementById("petitionnaire_form").reset();
    petitionnaires_table_edit_row = $(this).closest('tr');
    var data = petitionnaires_table.rows(petitionnaires_table_edit_row).data()[0];
    data = data[data.length - 1];

    $("#demandes_petetionnaire_modal_id").val(data.id);

    $("#demandes_petetionnaire_modal_nom").val(data.nom);
    $("#demandes_petetionnaire_modal_prenom").val(data.prenom);
    $("#demandes_petetionnaire_modal_cin").val(data.cin);
    $("#demandes_petetionnaire_modal_tel").val(data.tel);


    $("#demandes_petetionnaire_modal").modal('show');

});

$('#petitionnaire_form').submit(function (e) {
    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
    e.preventDefault();
    showLoading('BATIR', 'Chargement...');

    $.ajax({
        url: assetBaseUrl + "petitionnaire/check_cin",
        type: "POST",
        data: {
            cin: $("#demandes_petetionnaire_modal_cin").val(),
            source_id: dossier.demande.id,
            _token: csrfToken,
        },
        dataType: "json",
        success: function (response) {



            if (response.exists == 0) {

                $.ajax({
                    url: assetBaseUrl + "petitionnaire/update",
                    type: "POST",
                    data: {
                        id: $("#demandes_petetionnaire_modal_id").val(),
                        nom: $("#demandes_petetionnaire_modal_nom").val(),
                        prenom: $("#demandes_petetionnaire_modal_prenom").val(),
                        cin: $("#demandes_petetionnaire_modal_cin").val(),
                        tel: $("#demandes_petetionnaire_modal_tel").val(),
                        _token: csrfToken,
                    },
                    dataType: "json",
                    complete: function (response) {
                        closeLoading();

                        location.reload();
                    }
                });


                $("#demandes_petetionnaire_modal").modal('hide');

            }
            else {
                closeLoading();
                gl_alert('error', 'Batir', `Une demande avec un pétitionnaire portant le même numéro de CIN existe déjà dans la base de données.<br>
                Demande numéro : <a href="/demandes/show/${response.demande_id}">${response.demande_num}</a>`);
            }

        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});

$(".valider_cin").click(function () {
    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous sûr de vouloir valider le(s) Pétitionnaire(s) ?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {

            $.ajax({
                url: assetBaseUrl + "dossiers/valider_cin",
                type: "POST",
                data: {
                    _token: csrfToken,
                    id: dossier.id,
                },
                success: function (response) {
                    if (response.success == 1) {
                        $(".valider_cin").remove();
                    }
                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText);
                },
            });


        }
    });
})

$(".valider_type_reconstruction").click(function () {
    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous sûr de vouloir continuer ?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {

            $.ajax({
                url: assetBaseUrl + "dossiers/edit_type_reconstruction",
                type: "POST",
                data: {
                    _token: csrfToken,
                    id: dossier.id,
                    type: $("#v_demande_type").val()
                },
                success: function (response) {
                    location.reload();
                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText);
                },
            });


        }
    });
});


$(".v1_cin_missing").click(function () {
    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous sûr de vouloir continuer ?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {

            $.ajax({
                url: assetBaseUrl + "dossiers/report_v1_cin_missing",
                type: "POST",
                data: {
                    _token: csrfToken,
                    id: dossier.id,
                },
                success: function (response) {
                    if (response.success == 1) {
                        $(".v1_cin_missing").remove();
                    }
                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText);
                },
            });


        }
    });
})


$(".v1_duplicated_cin").click(function () {
    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous sûr de vouloir continuer ?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {

            $.ajax({
                url: assetBaseUrl + "dossiers/report_v1_cin_duplicated",
                type: "POST",
                data: {
                    _token: csrfToken,
                    id: dossier.id,
                },
                success: function (response) {
                    if (response.success == 1) {
                        $(".v1_duplicated_cin").remove();
                    }
                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText);
                },
            });


        }
    });
})

$(".v2_autorisation_construire_date_edit").click(function () {
    $(".v2_autorisation_construire_date_edit").attr('disabled', 'disabled');
    $("#v2_autorisation_construire_date").removeAttr('disabled');
})

$(".v2_autorisation_construire_date_save").click(function () {
    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous sûr de vouloir continuer ?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {

            $.ajax({
                url: assetBaseUrl + "dossiers/v2_confirme",
                type: "POST",
                data: {
                    _token: csrfToken,
                    id: $("#verification_doc_select").val(),
                    date_document: $("#v2_autorisation_construire_date").val()
                },
                success: function (response) {

                    if (response.success == 1) {
                        $(".v2_autorisation_construire_date_save").attr('disabled', 'disabled');
                        $("#v2_autorisation_construire_date").attr('disabled', 'disabled');

                    }
                    else {
                        if (response.error == 'DATE_IN_FUTURE') {
                            var msg = "Veuillez indiquer une date valide.";
                            gl_alert('error', 'Batir', msg);
                        }
                        if (response.error == 'DATE_LT_DATE_SEISME') {
                            var msg = "La date de document indiquée est incorrecte (antérieure à la date du séisme).";
                            gl_alert('error', 'Batir', msg);
                        }
                    }



                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText);
                },
            });


        }
    });
})

//verification date
$(".verification_date_div_edit").click(function () {
    $(".verification_date_div_edit").attr('disabled', 'disabled');
    $("#verification_date_div_input").removeAttr('disabled');
});



$(".verification_date_div_save").click(function () {
    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous sûr de vouloir continuer ?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {

            $.ajax({
                url: assetBaseUrl + "dossiers/update_date_doc",
                type: "POST",
                data: {
                    _token: csrfToken,
                    id: $("#verification_doc_select").val(),
                    date_document: $("#verification_date_div_input").val()
                },
                success: function (response) {
                    if (response.success == 1) {
                        $(".verification_date_div_save").attr('disabled', 'disabled');
                        $("#verification_date_div_input").attr('disabled', 'disabled');
                    }
                    else {
                        if (response.error == 'DATE_IN_FUTURE') {
                            var msg = "Veuillez indiquer une date valide.";
                            gl_alert('error', 'Batir', msg);
                        }
                        if (response.error == 'DATE_LT_DATE_SEISME') {
                            var msg = "La date de document indiquée est incorrecte (antérieure à la date du séisme).";
                            gl_alert('error', 'Batir', msg);
                        }
                    }


                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText);
                },
            });


        }
    });
})