var projets_table = undefined;
var projets_table = undefined;
var projet_detail_map = undefined;
var projet_detail_projet_geometry = undefined;
var googleSat = L.tileLayer('https://www.google.com/maps/vt?lyrs=s@189&gl=ma&x={x}&y={y}&z={z}', {
    maxZoom: 20,
});
var googlehybrid = L.tileLayer('https://www.google.com/maps/vt?lyrs=y@189&gl=ma&x={x}&y={y}&z={z}', {
    maxZoom: 20,
});
var googlemap = L.tileLayer('https://www.google.com/maps/vt?lyrs=m@189&gl=ma&x={x}&y={y}&z={z}', {
    maxZoom: 20,
});
var projet_detail_map_layers_group = new L.featureGroup();
$(document).ready(function () {
    projets_table = $('#projets_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: true,
        pageLength: 10,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: true,
        searching: false,
        scrollX: false,
        ajax: assetBaseUrl + 'projets/projets_datatable?filters=[]',
        dom: "lBfrtip",
        buttons: [
            {
                "extend": 'excel',
                "text": '',
                "titleAttr": 'excel',
                'title': 'Projets-' + current_date.replaceAll("/", "-"),
                "action": newexportaction
            },
        ],
        columnDefs: [
            { lassName: 'text-left', targets: [0] },
            { className: 'text-center', targets: [1, 2, 3, 4, 5, 6] }
        ],
        columns: [
            {
                data: 'projet',
            },
            {
                data: 'province',
            },
            {
                data: 'promoteur',
            },
            {
                data: 'nbr_immeubles',
            },
            {
                data: 'nbr_appartements',
            },
            {
                data: 'appartements_affectes',
            },
            {
                data: 'taux_affectation',
            },
        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },
    }).on("xhr.dt", function (e, settings, json, xhr) {
        //$("#dt_dossiers_count").text(json.recordsFiltered);
    });
    projets_table.on('draw', function () {
        $(".select2").select2();
        $(".select2nc").select2({
            minimumResultsForSearch: -1
        });
    })
    projet_detail_stock_table = $('#projet_detail_stock_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: true,
        pageLength: 10,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: true,
        searching: false,
        scrollX: false,
        ajax: assetBaseUrl + 'centre_donnees/stock/datatable?filters=[]&projet_id=0',
        dom: "lBfrtip",
        buttons: [
            {
                "extend": 'excel',
                "text": '',
                "titleAttr": 'excel',
                'title': 'Projets-' + current_date.replaceAll("/", "-"),
                "action": newexportaction
            },
        ],
        columnDefs: [
            { lassName: 'text-left', targets: [0] },
            { className: 'text-center', targets: [1, 2, 3, 4, 5] }
        ],
        columns: [
            {
                data: 'numero',
            },
            {
                data: 'immeuble',
            },
            {
                data: 'tf',
            },
            {
                data: 'surface',
            },
            {
                data: 'niveau',
            },
            {
                data: 'affectation',
            },
        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },
    }).on("xhr.dt", function (e, settings, json, xhr) {
    });
    projet_detail_map = new L.Map('projet_detail_map', {
        zoomControl: false,
        center: new L.LatLng(32.62087018318113, -6.262207031250001),
        zoom: 6,
        editable: true,
        drawControl: true,
        preferCanvas: true,
        attributionControl: false,
        fullscreenControl: true,
    });
    L.Control.ZoomExtent = L.Control.extend(
        {
            options:
            {
                position: 'topleft',
            },
            onAdd: function (map) {
                var controlDiv = L.DomUtil.create('div', 'leaflet-draw-toolbar leaflet-bar');
                L.DomEvent
                    .addListener(controlDiv, 'click', L.DomEvent.stopPropagation)
                    .addListener(controlDiv, 'click', L.DomEvent.preventDefault)
                    .addListener(controlDiv, 'click', function () {
                        projet_detail_map_layers_group = new L.featureGroup();
                        projet_detail_map.eachLayer(function (layer) {
                            if (layer instanceof L.Path) {
                                projet_detail_map_layers_group.addLayer(layer);
                            }
                        });
                        projet_detail_map.fitBounds(projet_detail_map_layers_group.getBounds());
                    });
                var controlUI = L.DomUtil.create('a', 'leaflet-draw-edit-remove fa-solid fa-magnifying-glass-location', controlDiv);
                controlUI.title = 'Zoom étendu';
                controlUI.href = '#';
                return controlDiv;
            }
        });
    var ZoomExtentControl = new L.Control.ZoomExtent();
    projet_detail_map.addControl(ZoomExtentControl);
    googlehybrid.addTo(projet_detail_map);
});


$("#generer_bons_btn").click(function () {
    // document.getElementById("generate_bons_form").reset();
    $("#generate_bons_modal").modal('show');
});


$("body").on("click", ".projet_a", function () {
    $("#projets_tab_detail_sidebar").addClass("active");
    var projet_id = $(this).attr('id');
    showLoading('VSB-Casa', 'Chargement...');
    $.ajax({
        url: assetBaseUrl + "centre_donnees/projets/get?id=" + projet_id,
        type: "GET",
        dataType: "json",
        processData: false,
        contentType: false,
        success: function (response) {
            closeLoading();
            projet_detail_stock_table.ajax.url(`${assetBaseUrl}centre_donnees/stock/datatable?filters=[]&projet_id=${projet_id}`).load();
            if (projet_detail_projet_geometry != undefined) {
                projet_detail_projet_geometry.remove();
            }
            var layers_group = new L.featureGroup();
            projet_detail_projet_geometry = L.geoJSON(JSON.parse(response.delimitation));
            //projet_detail_projet_geometry.setStyle(plle_style);
         
            projet_detail_projet_geometry.addTo(projet_detail_map);
            layers_group.addLayer(projet_detail_projet_geometry);
            projet_detail_map.fitBounds(layers_group.getBounds());
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});
$(".cd_sidebar_toggle_btn_close").click(function () {
    $(".cd_sidebar").removeClass("active");
});
$('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
    var target = $(e.target).attr("href") // activated tab
    if (target == "#map") {
        mappe_map.invalidateSize();
        mappe_map.fitBounds(mappe_map_layers_group.getBounds());
    }
    if (target == "#projets") {
        projet_detail_map.invalidateSize();
        projet_detail_map.fitBounds(projet_detail_map_layers_group.getBounds());
    }
    if (target == "#pa") {
        pa_map.invalidateSize();
        pa_map.fitBounds(pa_map_layers_group.getBounds());
    }
});

