var ratissages_resident_modal_documents_table = undefined;

$(document).ready(function () {
    ratissages_resident_modal_documents_table = $('#ratissages_resident_modal_documents_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: false,
        pageLength: 25,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: false,
        searching: false,
        scrollX: false,
        ajax: null,
        dom: "lBfrtip",
        buttons: [
        ],
        columnDefs: { className: 'text-left', targets: '_all' },

        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        }
    });
});

$("#ratissages_resident_modal_documents_add_btn").click(function () {
    $("#resident_document_modal").modal('show');
});


$("#upload_document_resident_form").submit(function (event) {
    event.preventDefault();
    var formData = new FormData(this);
    $.ajax({
        url: assetBaseUrl + "resident/store_resident_document",
        type: "POST",
        dataType: "json",
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
            ratissages_resident_modal_documents_table_add(response);
            $("#resident_document_modal").modal('hide');
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});

function ratissages_resident_modal_documents_table_add(resident_doc) {
    var nom_html = `<input  type="checkbox" class="resident_doc_cb" style="vertical-align: middle;position: relative;">&nbsp<a filename="${resident_doc.filename}" item_id="${resident_doc.id}" href="javascript:;" class="resident_doc_a">${resident_doc.nom}</a>`;
    var taille_html = '<span> ' + resident_doc.file_size_formated + '</span>';
    var type_html = '<span> Fichier ' + resident_doc.file_type + '</span>';
    var date_html = '<span> ' + resident_doc.created_at_formated + '</span>';

    ratissages_resident_modal_documents_table.row.add([nom_html, taille_html, type_html, date_html, resident_doc]).draw();
}

$('#resident_form').submit(function (e) { 
    e.preventDefault();   
      var residents_documents = [];
        ratissages_resident_modal_documents_table.rows().every(function (rowIdx, tableLoop, rowLoop) {
            residents_documents.push(this.data()[this.data().length - 1]);
        });
        var resident = {
            id: null,
            nom: $("#ratissages_resident_modal_nom").val(),
            prenom: $("#ratissages_resident_modal_prenom").val(),
            cin: $("#ratissages_resident_modal_cin").val(),
            niveau: $("#ratissages_resident_modal_niveau").val(),
            type_occupation: $("#ratissages_resident_modal_type_occupation").val(),
            residents_documents: residents_documents
        };
        residents_add(resident);
        $("#ratissages_resident_modal").modal('hide');
});


function residents_add(resident) {
    var cin_html = `<input  type="checkbox" item_id="${resident.id}" class="resident_cb" style="vertical-align: middle;position: relative;">&nbsp<a  item_id="${resident.id}" href="javascript:;" class="resident_a">${resident.cin}</a>`;
    var nom_html = '<span> ' + resident.nom +' '+ resident.prenom+'</span>';
    var occupation_html = '<span> ' + resident.type_occupation + '</span>';
     var niveau = resident.menage != null
        ? resident.menage.niveau
        : resident.niveau;

    var niveau_html = `<span>${niveau ?? ''}</span>`;
    var documents_html = '<span> ' + resident.residents_documents.length + ' document(s) </span>';

    if (residents_table_edit_row == undefined) {
        residents_table.row.add([cin_html, nom_html, occupation_html, niveau_html, documents_html, resident]).draw();
    }
    else {
        residents_table.row(residents_table_edit_row).data([cin_html, nom_html, occupation_html, niveau_html, documents_html, resident]).draw();
    }
}


$("body").on('click', '.resident_a', function () {

    document.getElementById("resident_form").reset();
    ratissages_resident_modal_documents_table.rows().clear().draw();
    residents_table_edit_row = $(this).closest('tr');
    var data = residents_table.rows(residents_table_edit_row).data()[0];
    data = data[data.length - 1];

    console.log(data)

    $("#ratissages_resident_modal_nom").val(data.nom);
    $("#ratissages_resident_modal_prenom").val(data.prenom);
    $("#ratissages_resident_modal_cin").val(data.cin);
    var niveau = data.menage != null
        ? data.menage.niveau
        : data.niveau;

    $("#ratissages_resident_modal_niveau").val(niveau ?? '');
    $("#ratissages_resident_modal_type_occupation").val(String(data.type_occupation))
    .trigger("change");


    data.residents_documents.forEach(document => {
        document.created_at_formated = formatDateTime(document.created_at);
        document.file_size_formated = formatFileSize(document.file_size);

        ratissages_resident_modal_documents_table_add(document);
    });
    $("#ratissages_resident_modal").modal('show');

});

$("body").on('click', '.resident_doc_a', function () {
    var id = $(this).attr('item_id');
    var filename = $(this).attr('filename');
    downloadFile(assetBaseUrl + "files/resident_documents/" + id + "/" + filename);
});


$("#ratissages_resident_modal_cin").on('keyup', function () {
    $("#resident_form_submit").prop(
        'disabled',
        $(this).val().trim().length <= 3
    );
});