var ratissage_document_modal_file_events = undefined;
var ratissage_document_modal_photo_events = undefined;
var ratissage_photo_modal_file_events = undefined;
var uploaded_files = [];
var documents_decision = [];
var lightGallery_list = [];
var documents_to_delete = [];

var CHEF_MENAGE_DOCUMENT_TYPES = [
  "CM_MENAGE_CIN",
  "ATTESTATION_DEMOLITION",
  "CM_ACT_DIVORCE",
  "CM_ACT_DECES",
  "CM_CIN_CONJOINT",
  "CM_ACT_MARIAGE",
  "ATTESTATION_NON_IMPOSITION_CONJOINT",
  "ATTESTATION_RESIDENCE_CONJOINT",
  "ATTESTATION_DEMOLITION_CONJOINT",
];

var COMMERCE_DOCUMENT_TYPES = [
  "COMMERCE_CIN",
  "COMMERCE_ATTESTATION_DEMOLITION",
];

$(document).ready(function () {
  $(".select2").select2();
  $(".select2nc").select2({
    minimumResultsForSearch: -1,
  });

  $(".multi-select").select2({
    placeholder: "Sélectionnez un/une ou plusieurs",
  });

  $(function () {
    $('[data-toggle="popover"]').popover();
  });

  initLightGallery();

  $(".rtable").DataTable({
    responsive: false,
    autoWidth: false,
    bPaginate: false,
    lengthChange: false,
    bFilter: false,
    scrollX: true,
    bInfo: false,
    ordering: false,
    processing: false,
    serverSide: false,
    searching: false,
    ajax: null,
    language: {
      url: assetBaseUrl + "languages/datatable_fr.json",
    },
  });
});

function initLightGallery() {
  lightGallery_list.forEach((lg) => {
    lg.destroy();
  });
  lightGallery_list = [];
  $("div[id^=photos_]").each(function () {
    var lg = lightGallery(document.getElementById($(this).attr("id")), {
      plugins: [lgZoom, lgThumbnail, lgFullscreen, lgRotate],
      selector: ".gallery-img",
      thumbnail: true,
      animateThumb: true,
      zoomFromOrigin: true,
      allowMediaOverlap: false,
      toggleThumb: true,
      exThumbImage: "data-src",
      fullScreen: true,
      mousewheel: true,
    });

    lightGallery_list.push(lg);
  });
}

function isChefMenageDocument(type_document) {
  return CHEF_MENAGE_DOCUMENT_TYPES.some((prefix) =>
    type_document.startsWith(prefix)
  );
}

$("body").on("click", ".download_doc_link", function () {
  var file_id = $(this).attr("file_id");
  var type_document = $(this).attr("type_document");

  if (!file_id) {
    return; // Don't download if no file
  }

  // Determine which download endpoint to use
  var downloadUrl;
  if (isChefMenageDocument(type_document)) {
    downloadUrl = assetBaseUrl + "ratissages/menage/file/" + file_id;
  } else {
    downloadUrl = assetBaseUrl + "ratissages/file/" + file_id;
  }

  downloadFile(downloadUrl);
});

function isMenageDocument(type_document) {
  return (
    CHEF_MENAGE_DOCUMENT_TYPES.some((prefix) =>
      type_document.startsWith(prefix)
    ) ||
    COMMERCE_DOCUMENT_TYPES.some((prefix) => type_document.startsWith(prefix))
  );
}

$("body").on("click", ".upload_doc_link", function () {
  var file_type = $(this).attr("file_type");
  var type_document = $(this).attr("type_document");
  var chef_menage_id = $(this).attr("chef_menage_id");
  var menage_id = $(this).attr("menage_id");
  var commerce_id = $(this).attr("commerce_id");
  $(".document_modal_date_doc").css("display", "block");
  $(".document_modal_insert_photo_row").css("display", "none");

  $("#ratissage_document_modal_file_type_label").text(
    "Fichier " + file_type.toUpperCase()
  );
  $("#ratissage_document_modal_file").attr(
    "data-allowed-file-extensions",
    file_type
  );
  $("#store_ratissage_document_form [name='type_document']").val(type_document);

  // Store chef_menage_id if it's a chef_menage document
  if (chef_menage_id) {
    $("#store_ratissage_document_form [name='chef_menage_id']").val(
      chef_menage_id
    );
  } else {
    $("#store_ratissage_document_form [name='chef_menage_id']").val("");
  }

  // Store menage_id if provided
  if (menage_id) {
    $("#store_ratissage_document_form [name='menage_id']").val(menage_id);
  } else {
    $("#store_ratissage_document_form [name='menage_id']").val("");
  }

  if (commerce_id) {
    $("#store_ratissage_document_form [name='commerce_id']").val(commerce_id);
  } else {
    $("#store_ratissage_document_form [name='commerce_id']").val("");
  }

  if (ratissage_document_modal_file_events != undefined) {
    $("#ratissage_document_modal_file").data("dropify").destroy();
  }
  $("#ratissage_document_modal_file").remove();
  $("#ratissage_document_modal_file_div").append(
    `<input id="ratissage_document_modal_file" data-max-file-size-preview="100M" data-allowed-file-extensions="${file_type}"  type="file" name="file" />`
  );
  // if (type_document == "PLAN_ARCHITECTE_PDF") {
  //     $(".document_modal_plan_type").css('display', 'block');
  // }
  // else
  // {
  //     $(".document_modal_plan_type").css('display', 'none');
  // }
  ratissage_document_modal_file_events = $(
    "#ratissage_document_modal_file"
  ).dropify({
    messages: {
      default: "Faites glisser et déposez un fichier ici",
      replace: "Glisser-déposer ou cliquer pour remplacer",
      remove: "Supprimer",
      error: "Ooops, something wrong happended.",
    },
    error: {
      fileSize: "The file size is too big ({{ value }} max).",
      imageFormat: "The image format is not allowed ({{ value }} only).",
    },
  });

  $("#ratissage_document_modal_save").attr("disabled", "disabled");
  $("#ratissage_document_modal").modal("show");
  $("#ratissage_document_modal_file").change(function () {
    if ($("#ratissage_document_modal_file").val().length > 0) {
      $("#ratissage_document_modal_save").removeAttr("disabled");
    }
  });
  $("#date_document").change(function () {
    if ($("#ratissage_document_modal_file").val().length > 0) {
      $("#ratissage_document_modal_save").removeAttr("disabled");
    }
  });
});

$("#store_ratissage_document_form").submit(function (event) {
  showLoading(
    "Chargement...",
    "Le fichier est en cours de chargement, veuillez patienter"
  );
  $("#ratissage_document_modal_save").attr("disabled", "disabled");
  event.preventDefault();
  var formData = new FormData(this);
  formData.append("ratissage_id", ratissage.id);
  var documentType = formData.get("type_document");
  var chef_menage_id = formData.get("chef_menage_id");
  var menage_id = formData.get("menage_id");
  var commerce_id = formData.get("commerce_id");

  // Determine which endpoint to use
  var uploadUrl;
  if (
    (chef_menage_id || menage_id || commerce_id) &&
    isMenageDocument(documentType)
  ) {
    // Use menage document upload for chef_menage documents
    uploadUrl = assetBaseUrl + "ratissages/menage/file/upload";
    if (chef_menage_id) {
      formData.append("chef_menage_id", chef_menage_id);
    }
    if (menage_id) {
      formData.append("menage_id", menage_id);
    }
    if (commerce_id) {
      formData.append("commerce_id", commerce_id);
    }
  } else {
    // Use ratissage document upload for ratissage documents
    uploadUrl = assetBaseUrl + "ratissages/file/upload";
    formData.append("ratissage_id", ratissage.id);
  }

  $.ajax({
    url: uploadUrl,
    type: "POST",
    dataType: "json",
    data: formData,
    processData: false,
    contentType: false,
    success: function (response) {
      closeLoading();
      $("#ratissage_document_modal_save").removeAttr("disabled");
      if (response.success == 1) {
        var update = false;
        for (var i = 0; i < uploaded_files.length; i++) {
          if (
            uploaded_files[i].type_document == response.document.type_document
          ) {
            uploaded_files[i] = response.document;
            update = true;
          }
        }
        if (!update) {
          uploaded_files.push(response.document);
        }
        $(
          ".download_doc_link[type_document='" +
            response.document.type_document +
            "']"
        ).removeAttr("disabled");
        $(
          ".download_doc_link[type_document='" +
            response.document.type_document +
            "']"
        ).attr("file_id", response.document.id);
        $(
          ".download_depot_date[type_document='" +
            response.document.type_document +
            "']"
        ).text(response.document.formated_created_at);
        $(
          ".download_depot_date[type_document='" +
            response.document.type_document +
            "']"
        ).css("color", "black");
        $(
          ".download_doc_date[type_document='" +
            response.document.type_document +
            "']"
        ).text(response.document.formated_date_document);
        $(
          ".download_doc_date[type_document='" +
            response.document.type_document +
            "']"
        ).css("color", "black");
        $(
          ".upload_doc_icon[type_document='" +
            response.document.type_document +
            "']"
        ).css("color", "#68a334");
        $(
          ".upload_doc_icon[type_document='" +
            response.document.type_document +
            "']"
        ).removeClass("fa-file-circle-xmark");
        $(
          ".upload_doc_icon[type_document='" +
            response.document.type_document +
            "']"
        ).addClass("fa-file-circle-check");
        $(
          ".upload_doc_no_file_label[type_document='" +
            response.document.type_document +
            "']"
        ).hide();
        $("#ratissage_document_modal").modal("hide");
      } else {
        if (response.error == "NOT_WGS84") {
          var msg =
            "La géométrie est incorrecte,Veuillez vous assurer que le système de coordonnées utilisé est WGS84.";
          gl_alert("error", "AVROYAL-Assist", msg);
        }
        if (response.error == "WRONG_GEOJSON_FILE") {
          var msg =
            "Le fichier que vous avez importé ne correspond pas au format GeoJSON.";
          gl_alert("error", "AVROYAL-Assist", msg);
        }
        if (response.error == "EMPTY_DATE_DOCUMENT") {
          var msg = "Veuillez indiquer la date de document.";
          gl_alert("error", "AVROYAL-Assist", msg);
        }
        if (response.error == "DATE_IN_FUTURE") {
          var msg = "Veuillez indiquer une date valide.";
          gl_alert("error", "AVROYAL-Assist", msg);
        }
        if (response.error == "DATE_LT_DATE_SEISME") {
          var msg =
            "La date de document indiquée est incorrecte (antérieure à la date du séisme).";
          gl_alert("error", "AVROYAL-Assist", msg);
        }
        if (response.error == "PHOTO_IS_REQUIRED") {
          var msg =
            "Une photo est nécessaire afin de charger le PV de réception de la finition";
          gl_alert("error", "AVROYAL-Assist", msg);
        }
        if (response.error == "ATT_DEMOLITION_NO_REFERENCE") {
          var msg =
            "Veuillez indiquer la référance de l'attestation de démolition.";
          gl_alert("error", "AVROYAL-Assist", msg);
        }

        if (response.error == "ATT_DEMOLITION_NO_CODE_TOPO") {
          var msg = "Veuillez indiquer le code topo.";
          gl_alert("error", "AVROYAL-Assist", msg);
        }
      }
    },
    error: function (xhr, status, error) {
      console.log(xhr.responseText);
    },
  });
});

$("body").on("change", ".select_photo_cb", function () {
  var type_document = $(this).attr("type_document");

  if (
    $(".select_photo_cb[type_document='" + type_document + "']:checked")
      .length > 0
  ) {
    $(".delete_photo_link[type_document='" + type_document + "']").removeAttr(
      "disabled"
    );
  } else {
    $(".delete_photo_link[type_document='" + type_document + "']").attr(
      "disabled",
      "disabled"
    );
  }
});

$("body").on("click", ".delete_photo_link", function () {
  var type_document = $(this).attr("type_document");

  Swal.fire({
    title: "Confirmation",
    text: "Êtes-vous certain(e) de vouloir supprimer les photos ?",
    icon: "warning",
    showCancelButton: true,
    confirmButtonColor: "#88C241",
    cancelButtonColor: "#F83F37",
    confirmButtonText: "Oui",
    cancelButtonText: "Non",
  }).then((result) => {
    if (result.isConfirmed) {
      $(".select_photo_cb[type_document='" + type_document + "']:checked").each(
        function () {
          $(this).parent().remove();
          documents_to_delete.push($(this).attr("item_id"));
        }
      );
      $(".delete_photo_link[type_document='" + type_document + "']").attr(
        "disabled",
        "disabled"
      );
    }
  });
});

$("#save_ratissage").click(function () {
  store();
});

function store() {
  $("#save_ratissage").prop("disabled", true);
  var csrfToken = document
    .querySelector('meta[name="_token"]')
    .getAttribute("content");
  $("#save_ratissage .spinner-border").css("display", "inline-block");

  var classe = $("#expertise_classification").val() || "";
  var risques = $("#expertise_risques").val() || [];
  var mesures_urgences = $("#expertise_mesures_urgences").val() || [];

  $.ajax({
    url: assetBaseUrl + "ratissages/store",
    type: "POST",
    data: {
      _token: csrfToken,
      id: ratissage.id,
      documents: JSON.stringify(uploaded_files),
      documents_to_delete: JSON.stringify(documents_to_delete),
    },
    success: function (response) {
      $("#save_ratissage .spinner-border").css("display", "none");

      if (response.success == 1) {
        $("#save_ratissage").prop("disabled", false);

        $.toast({
          heading: "AVROYAL-Assist",
          text: "Enregistrement terminé avec succès",
          icon: "success",
          position: "bottom-left",
          hideAfter: 3000,
          stack: false,
        });

        $("#save_ratissage").removeAttr("disabled");

        location.reload();
      } else {
        $("#save_ratissage").prop("disabled", false);
        // if (response.error == "NO_DECISION_COMISSION") {
        //   gl_alert(
        //     "error",
        //     "VSB",
        //     "Merci d'ajouter la décision de la commission pour enregistrer."
        //   );
        // }
      }
    },
    error: function (xhr, status, error) {
      console.log(xhr.responseText);
    },
  });
}

$('button[data-toggle="tab"]').on("shown.bs.tab", function (e) {
  $(".rtable").DataTable().columns.adjust();
});
