var menages_table = undefined;
var current_tab = "found_recensement_cin";

$(document).ready(function () {
    menages_table = $('#menages_table').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: true,
        pageLength: 25,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: true,
        searching: false,
        scrollX: false,
        ajax: assetBaseUrl + 'recoupement/menages_datatable?filters=[]&tab=found_recensement_cin',
        dom: "lBfrtip",
        buttons: [
            {
                "extend": 'excel',
                "text": '',
                "titleAttr": 'excel',
                'title': 'Ménages-' + current_date.replaceAll("/", "-"),
                "action": newexportaction
            },
        ],
        columnDefs: [
            { lassName: 'text-left', targets: [0] },
            { className: 'text-center', targets: [1, 2, 3, 4, 5] }
        ],
        columns: [
            {
                data: 'cin',
            },
            {
                data: 'nom',
            },
            {
                data: 'prenom',
            },
            {
                data: 'conjoint_cin',
            },
            {
                data: 'conjoint_nom',
            },
            {
                data: 'conjoint_prenom',
            }

        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },

    }).on("xhr.dt", function (e, settings, json, xhr) {

        $("#dt_dossiers_count").text(json.recordsFiltered);
    });

    menages_table.on('draw', function () {
        $(".select2").select2();
        $(".select2nc").select2({
            minimumResultsForSearch: -1
        });
    })




});


function filter_tab_douar_index_table() {
    var filters = [];

    $(".dt_filter").each(function () {
        var column = $(this).attr('column');
        var table = $(this).attr('table');
        var value = $(this).val();
        if (value != 'all' && value.trim().length > 0) {
            filters.push({ column: column, table: table, value: value });
        }
    });




    if (current_tab == "found_recensement_cin") {
        menages_table.ajax.url(assetBaseUrl + 'recoupement/menages_datatable?filters='+ JSON.stringify(filters)+'&tab=found_recensement_cin').load();
    }
    if (current_tab == "found_recensement_nom") {
        menages_table.ajax.url(assetBaseUrl + 'recoupement/menages_datatable?filters='+ JSON.stringify(filters)+'&tab=found_recensement_nom').load();
    }
    if (current_tab == "not_found_recensement") {
        menages_table.ajax.url(assetBaseUrl + 'recoupement/menages_datatable?filters='+ JSON.stringify(filters)+'&tab=not_found_recensement').load();
    }
    if (current_tab == "localises") {
        menages_table.ajax.url(assetBaseUrl + 'recoupement/recensement_datatable?filters='+ JSON.stringify(filters)+'&tab=localises').load();
    }
    if (current_tab == "non_localises") {
        menages_table.ajax.url(assetBaseUrl + 'recoupement/recensement_datatable?filters='+ JSON.stringify(filters)+'&tab=non_localises').load();
    }
    
}

$("#filter_recenses_par_cin_btn").click(function () {
    $(".filter_btn").removeClass('btn_active');
    $(this).addClass('btn_active');
    current_tab = "found_recensement_cin";

    filter_tab_douar_index_table();
});


$("#filter_recenses_par_nom_btn").click(function () {
    $(".filter_btn").removeClass('btn_active');
    $(this).addClass('btn_active');
    current_tab = "found_recensement_nom";

    filter_tab_douar_index_table();
});


$("#filter_non_recenses_trouves_btn").click(function () {
    $(".filter_btn").removeClass('btn_active');
    $(this).addClass('btn_active');
    current_tab = "not_found_recensement";

    filter_tab_douar_index_table();
});


$("#filter_recenses_non_trouves_localises_btn").click(function () {
    $(".filter_btn").removeClass('btn_active');
    $(this).addClass('btn_active');
    current_tab = "localises";

    filter_tab_douar_index_table();
});


$("#filter_recenses_non_trouves_non_localises_btn").click(function () {
    $(".filter_btn").removeClass('btn_active');
    $(this).addClass('btn_active');
    current_tab = "non_localises";

    filter_tab_douar_index_table();
});


$(".menages_table_export_excel").click(function () {
    menages_table.buttons(0).trigger();
})


$("#provinces_filter").change(function () {
    refresh_situation_filters('province');
});

$("#communes_filter").change(function () {
    refresh_situation_filters('commune');
});
$("#douars_filter").change(function () {
    refresh_situation_filters('douar');
});

function fill_situation_filter_cercle(province_id) {
    $("#cercles_filter").empty();
    $("#cercles_filter").append(new Option('Indifferent', 'all'));
    cercles.forEach(cercle => {
        if (province_id != 'all') {
            if (cercle.province_id == province_id) {
                $("#cercles_filter").append(new Option(cercle.nom, cercle.id));
            }
        }
        else {
            $("#cercles_filter").append(new Option(cercle.nom, cercle.id));
        }
    });
}

function fill_situation_filter_commune(province_id) {

    $("#communes_filter").empty();
    $("#communes_filter").append(new Option('Indifferent', 'all'));
    communes.forEach(commune => {
        if (province_id != 'all') {
            if (commune.province_id == province_id) {
                $("#communes_filter").append(new Option(commune.nom, commune.id));
            }
        }
        else {
            $("#communes_filter").append(new Option(commune.nom, commune.id));
        }
    });



}


function fill_situation_filter_douar(province_id, commune_id) {
    $("#douars_filter").empty();
    $("#douars_filter").append(new Option('Indifferent', 'all'));

    var filtred_communes = [];

    communes.forEach(commune => {
        if (province_id != 'all') {
            if (commune.province_id == province_id) {
                filtred_communes.push(commune);
            }
        }
        else {
            filtred_communes.push(commune);
        }
    });

    filtred_communes.forEach(commune => {
        douars.forEach(douar => {
            if (douar.commune_id == commune.id) {
                if (commune_id != 'all') {
                    if (commune.id == commune_id) {
                        $("#douars_filter").append(new Option(douar.nom, douar.id));
                    }
                }
                else {
                    $("#douars_filter").append(new Option(douar.nom, douar.id));
                }
            }
        });
    });

}
function refresh_situation_filters(trigger_source) {
    if (trigger_source == 'province') {

        fill_situation_filter_commune($("#provinces_filter").val(), 'all');
        fill_situation_filter_douar($("#provinces_filter").val(), 'all', 'all');
    }

    if (trigger_source == 'commune') {
        var province_id = undefined;

        if ($("#communes_filter").val() == 'all') {
            refresh_situation_filters('cercle');
            return;
        }

        communes.forEach(commune => {
            if (commune.id == $("#communes_filter").val()) {
                province_id = commune.province_id;
            }
        });


        $("#provinces_filter").val(province_id);
        $('#provinces_filter').trigger('change.select2');



        fill_situation_filter_douar(province_id, $("#cercles_filter").val(), $("#communes_filter").val(), 'all');
    }

    if (trigger_source == 'douar') {
        var province_id = undefined;

        var commune_id = undefined;

        if ($("#douars_filter").val() == 'all') {
            refresh_situation_filters('commune');
            return;
        }

        douars.forEach(douar => {
            if (douar.id == $("#douars_filter").val()) {
                commune_id = douar.commune_id;
            }
        });

        communes.forEach(commune => {
            if (commune.id == commune_id) {
                province_id = commune.province_id;
            }
        });


        $("#provinces_filter").val(province_id);
        $('#provinces_filter').trigger('change.select2');

        $("#communes_filter").val(commune_id);
        $('#communes_filter').trigger('change.select2');


    }
}


$(".dt_filter").change(function () {
    filter_tab_douar_index_table();
});

