
var etude_dossier_modal_cins_datatable = undefined;
var etude_dossier_modal_membres_commission_datatable = undefined;
var current_check_cin_menage = undefined;
var modal_etude_dossier_modal_add_membres_commission_datatable = undefined;
var etudes_dossiers_datatable = undefined;

var dossier_document_modal_file_events = undefined;

var pv_etude_check_ids = [];
$(document).ready(function () {
    etude_dossier_modal_cins_datatable = $("#etude_dossier_modal_cins_datatable").DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: false,
        pageLength: 15,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: false,
        searching: false,
        scrollX: false,
        ajax: null,
        dom: "lBfrtip",
        buttons: [

        ],
        columnDefs: { className: "text-left", targets: "_all" },

        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },
    });

    etude_dossier_modal_membres_commission_datatable = $("#etude_dossier_modal_membres_commission_datatable").DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: false,
        pageLength: 15,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: false,
        searching: false,
        scrollX: false,
        ajax: null,
        dom: "lBfrtip",
        buttons: [

        ],
        columnDefs: { className: "text-left", targets: "_all" },

        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },
    });




    modal_etude_dossier_modal_add_membres_commission_datatable = $("#modal_etude_dossier_modal_add_membres_commission_datatable").DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: true,
        pageLength: 25,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: true,
        searching: false,
        scrollX: false,
        ajax: assetBaseUrl + "travaux_commissions/membres_datatable?filters=[]",
        dom: "lBfrtip",
        buttons: [

        ],
        columnDefs: { className: "text-center", targets: "_all" },
        columns: [
            {
                data: "nom_complet",
            },

            {
                data: "province",
            },
            {
                data: "arrondissement",
            },
            {
                data: "annexe_administrative",
            },
            {
                data: "organisme_ste",
            },

            {
                data: "membre_role",
            },



        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },
    });


    etudes_dossiers_datatable = $('#etudes_dossiers_datatable').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: true,
        pageLength: 25,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: true,
        searching: false,
        scrollX: false,
        ajax: assetBaseUrl + 'travaux_commissions/etudes_pv_datatable?filters=[]',
        dom: "lBfrtip",
        buttons: [
            {
                "extend": 'excel',
                "text": '',
                "titleAttr": 'excel',
                'title': 'PV etudes -' + current_date.replaceAll("/", "-"),
                "action": newexportaction
            },
        ],
        columnDefs: [
            { lassName: 'text-left', targets: [0] },
            { className: 'text-center', targets: [1, 2, 3, 4, 5] }
        ],
        columns: [
            {
                data: 'reference',
            },
            {
                data: 'date',
            },
            {
                data: 'province',
            },
            {
                data: 'arrondissement',
            },
            {
                data: 'annexe_administrative',
            },
            {
                data: 'cin',
            },
            {
                data: 'pv_etude_generated',
            },
            {
                data: 'pv_etude_signed',
            }

        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },

    }).on("xhr.dt", function (e, settings, json, xhr) {

        json.data.forEach(row => {

            if (!pv_etude_check_ids.includes(row.pv_etude_id)) {
                pv_etude_check_ids.push(row.pv_etude_id);
            }
        });
    });


    etudes_dossiers_datatable.on('draw', function () {
        initSelect();
    })


    window.setInterval(function () {
        pv_etude_check_generating_docs();
    }, 1000);
});

$("#etude_dossier_new_btn").click(function () {

    $("#etude_dossier_modal_id").val("");

    etude_dossier_modal_cins_datatable.rows().clear().draw();
    etude_dossier_modal_membres_commission_datatable.rows().clear().draw();

    $('#etude_dossier_modal button').filter(function () {
        return $(this).text().trim() !== 'Fermer';
    }).show();
    $("#etude_dossier_modal").modal("show");
});


$("#etude_dossier_modal_cin_add").click(function () {
    $("#etude_dossier_new_cin_modal_cin").val("");
    $("#etude_dossier_new_cin_modal_cin").change();
    $("#etude_dossier_new_cin_modal_decision_div").css('display', 'block');
    $("#etude_dossier_new_cin_modal_target").val("ETUDE_PV");

    $("#etude_dossier_new_cin_modal_decision_motif_div").css('display', 'none');

    $("#etude_dossier_new_cin_modal").modal("show");
});

$("#etude_dossier_new_cin_modal_decision").change(function () {
    $("#etude_dossier_new_cin_modal_decision_motif_div").css('display', 'none');
    if ($("#etude_dossier_new_cin_modal_decision").val() == "Rejeté") {
        $("#etude_dossier_new_cin_modal_decision_motif_div").css('display', 'block');
    }
});

$("#etude_dossier_new_cin_modal_cin").change(function () {

    current_check_cin_menage = undefined;
    var csrfToken = document
        .querySelector('meta[name="_token"]')
        .getAttribute("content");
    $("#etude_dossier_new_cin_modal_save").attr('disabled', 'disabled');
    var cin = $(this).val();
    $.ajax({
        url: assetBaseUrl + "travaux_commissions/check_cin",
        type: "POST",
        dataType: "json",
        data: {
            _token: csrfToken,
            cin: cin
        },

        success: function (response) {



            $("#etude_dossier_new_cin_modal_conjoints_div").empty();

            $("#etude_dossier_new_cin_modal_nom").val("");
            $("#etude_dossier_new_cin_modal_prenom").val("");
            $("#etude_dossier_new_cin_modal_resultat_tahssine_span").html("");

            if (response.success == 1) {
                $("#etude_dossier_new_cin_modal_save").removeAttr('disabled');

                current_check_cin_menage = response.chef_menage;

                $("#etude_dossier_new_cin_modal_nom").val(response.chef_menage.chef_menage_nom);
                $("#etude_dossier_new_cin_modal_prenom").val(response.chef_menage.chef_menage_prenom);
                $("#etude_dossier_new_cin_modal_resultat_tahssine_span").html(response.chef_menage.tahssine_html + ' - ' + response.chef_menage.tahssine_date);


                response.chef_menage.conjoints.forEach(conjoint => {
                    $("#etude_dossier_new_cin_modal_conjoints_div").append(`
                          <div class="col-12">
                          <span style="margin-top: 12px; border-bottom: 1px #ffc9ab solid; width: 100%; display: block; margin-bottom: 8px; font-weight: 500; text-align: center; color: #b1531e;">Conjoint ${conjoint.index}</span>
                                <div class="input-group input-group-sm mb-3">
                                    <div class="input-group-prepend">
                                        <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">Nom</span>
                                    </div>
                                    <input readonly class="form-control" value="${conjoint.prenom} ${conjoint.nom}">
                                </div>
                            </div>
                        
                        
                            <div class="col-12">
                                <div class="input-group input-group-sm mb-3">
                                    <div class="input-group-prepend">
                                        <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">CIN</span>
                                    </div>
                                    <input readonly class="form-control" value="${conjoint.cin}">
                                </div>
                            </div>
                        
                    
                            <div class="col-12">
                                <div class="input-group input-group-sm mb-3">
                                    <div class="input-group-prepend">
                                        <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">Résultat TAHSSINE</span>
                                    </div>
                                    <span style="padding-top: 5px;">${conjoint.tahssine_html} - ${conjoint.tahssine_date}</span>
                                </div>
                            </div>
                        `);
                });
            }
            else {

            }
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});



$('#etude_dossier_new_cin_modal_form').submit(function (e) {
    e.preventDefault();
    $("#etude_dossier_new_cin_modal").modal('hide');

    var target = $("#etude_dossier_new_cin_modal_target").val();

    if (target == "ETUDE_PV") {
        current_check_cin_menage.decision = $("#etude_dossier_new_cin_modal_decision").val();
        current_check_cin_menage.motif_rejet = $("#etude_dossier_new_cin_modal_motif_rejet").val();

        etude_dossier_row_insertRow(current_check_cin_menage);
    }
    if (target == "PV_TAS") {
        pv_tas_modal_cins_datatable_insertRow(current_check_cin_menage);
    }



    current_check_cin_menage = undefined;
});

function etude_dossier_row_insertRow(chef_menage, edit = false) {

    var cin_html = '<input type="checkbox" class="etude_dossier_row_cb" style="vertical-align: middle;margin-left:4px;"><a  style="vertical-align: middle; margin-left: 6px;color: #71ba18;font-weight: 500;" href="javascript:;"><i style="margin-right:6px;font-size:15px" class="fa-solid fa-address-card"></i>' + chef_menage.chef_menage_cin + '</span></a>';
    var nom_html = '<span> ' + chef_menage.chef_menage_prenom + ' ' + chef_menage.chef_menage_nom + '</span>';
    var conjoints_html = '<span> ' + '-' + '</span>';

    if (chef_menage.conjoints.length > 0) {
        conjoints_html = '<select class="form-control select2"> ';
        chef_menage.conjoints.forEach(conjoint => {
            conjoints_html += `<option>${conjoint.nom + ' ' + conjoint.prenom}</option>`;
        });
        conjoints_html += '</select> ';
    }


    var resultat_tahssine_html = '<span> ' + '-' + '</span>';
    var decision_html = "";
    if (chef_menage.decision == "Validé") {
        decision_html = '<span style="color:#88bc02"><i class="fa-solid fa-check mr-1"></i>' + chef_menage.decision + '</span>';
    }
    if (chef_menage.decision == "Ajourné") {
        decision_html = '<span style="color:#e98047"><i class="fa-solid fa-check mr-1"></i>' + chef_menage.decision + '</span>';
    }
    if (chef_menage.decision == "Rejeté") {
        decision_html = '<span style="color:#ff5353"><i class="fa-solid fa-check mr-1"></i>' + chef_menage.decision + '- '+chef_menage.motif_rejet+'</span>';
    }




    etude_dossier_modal_cins_datatable.row.add([cin_html, nom_html, conjoints_html, decision_html, chef_menage]).draw();

}

$('body').on('change', ".etude_dossier_row_cb", function () {

    if ($(".etude_dossier_row_cb:checked").length > 0) {
        $("#etude_dossier_modal_cin_delete").removeAttr("disabled");
    } else {

        $("#etude_dossier_modal_cin_delete").attr("disabled", "disabled");
    }
});

$("#etude_dossier_modal_cin_delete").click(function () {

    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous sûr de vouloir supprimer les dossiers sélectionnés de la liste?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {

            $('input[type="checkbox"]:checked').each(function () {
                var tr = $(this).closest('tr');

                etude_dossier_modal_cins_datatable.rows(tr).remove().draw();

            });
            $("#etude_dossier_modal_cin_delete").attr("disabled", "disabled");
        }
    });
});


$("#etude_dossier_modal_membre_commission_add").click(function () {
    $("#etude_dossier_membre_commission_modal").modal('show');
});


$("body").on('click', '.etude_dossier_select_membre_btn', function () {
    var membre_id = $(this).attr('id');
    var nom_complet = $(this).attr('nom_complet');
    var organisme_ste = $(this).attr('organisme_ste');
    var membre_role = $(this).attr('membre_role');

    var target = $("#etude_dossier_membre_commission_modal_target").val();
    var membre = {
        id: membre_id,
        nom_complet: nom_complet,
        organisme_ste: organisme_ste,
        membre_role: membre_role,
        target: target
    };

    etude_dossier_membre_commission_row_insertRow(membre);

    $("#etude_dossier_membre_commission_modal").modal('hide');
});



function etude_dossier_membre_commission_row_insertRow(membre, edit = false) {


    var nom_complet_html = '<input type="checkbox" class="etude_dossier_membre_commission_row_cb" style="vertical-align: middle;margin-left:4px;"><a  style="vertical-align: middle; margin-left: 6px;color: #71ba18;font-weight: 500;" href="javascript:;"><i style="margin-right:6px;font-size:15px" class="fa-solid fa-user-tie"></i>' + membre.nom_complet + '</span></a>';

    if (membre.target == "PV_TAS") {
        nom_complet_html = '<input type="checkbox" class="tas_membre_commission_row_cb" style="vertical-align: middle;margin-left:4px;"><a  style="vertical-align: middle; margin-left: 6px;color: #71ba18;font-weight: 500;" href="javascript:;"><i style="margin-right:6px;font-size:15px" class="fa-solid fa-user-tie"></i>' + membre.nom_complet + '</span></a>';

    }
    var organisme_html = '<span> ' + membre.organisme_ste + '</span>';
    var role_html = '<span> ' + membre.membre_role + '</span>';

    if (membre.target == "ETUDE_PV") {
        etude_dossier_modal_membres_commission_datatable.row.add([nom_complet_html, organisme_html, role_html, membre]).draw();
    }
    if (membre.target == "PV_TAS") {
        pv_tas_modal_membres_commission_datatable.row.add([nom_complet_html, organisme_html, role_html, membre]).draw();
    }
}

$('body').on('change', ".etude_dossier_membre_commission_row_cb", function () {

    if ($(".etude_dossier_membre_commission_row_cb:checked").length > 0) {
        $("#etude_dossier_modal_membre_commission_delete").removeAttr("disabled");
    } else {

        $("#etude_dossier_modal_membre_commission_delete").attr("disabled", "disabled");
    }
});

$("#etude_dossier_modal_membre_commission_delete").click(function () {

    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous sûr de vouloir supprimer les dossiers sélectionnés de la liste?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {

            $('input[type="checkbox"]:checked').each(function () {
                var tr = $(this).closest('tr');

                etude_dossier_modal_membres_commission_datatable.rows(tr).remove().draw();

            });
            $("#etude_dossier_modal_membre_commission_delete").attr("disabled", "disabled");
        }
    });
});


$("#etude_dossier_modal_membre_commission_add").click(function () {

    $("#etude_dossier_membre_commission_modal_target").val("ETUDE_PV");
    $("#etude_dossier_membre_commission_modal").modal('show');
});


$("#etude_dossier_modal_provinces_filter").change(function () {
    etude_dossier_refresh_situation_filters('province');
});
$("#etude_dossier_modal_arrondissements_filter").change(function () {
    etude_dossier_refresh_situation_filters('arrondissement');
});
$("#etude_dossier_modal_annexes_administratives_filter").change(function () {
    etude_dossier_refresh_situation_filters('annexe_administrative');
});


function etude_dossier_fill_situation_filter_arrondissement(province_id) {
    $("#etude_dossier_modal_arrondissements_filter").empty();
    $("#etude_dossier_modal_arrondissements_filter").append(new Option('Indifferent', 'all'));
    arrondissements.forEach(arrondissement => {
        if (province_id != 'all') {
            if (arrondissement.province_id == province_id) {
                $("#etude_dossier_modal_arrondissements_filter").append(new Option(arrondissement.nom, arrondissement.id));
            }
        }
        else {
            $("#etude_dossier_modal_arrondissements_filter").append(new Option(arrondissement.nom, arrondissement.id));
        }
    });
}


function etude_dossier_fill_situation_filter_annexe_administrative(province_id, arrondissement_id) {
    $("#etude_dossier_modal_annexes_administratives_filter").empty();
    $("#etude_dossier_modal_annexes_administratives_filter").append(new Option('Indifferent', 'all'));
    var filtred_arrondissements = [];

    arrondissements.forEach(arrondissement => {
        if (province_id != 'all') {
            if (arrondissement.province_id == province_id) {
                filtred_arrondissements.push(arrondissement);
            }
        }
        else {
            filtred_arrondissements.push(arrondissement);
        }
    });

    filtred_arrondissements.forEach(arrondissement => {
        annexes_administratives.forEach(annexe => {
            if (annexe.arrondissement_id == arrondissement.id) {
                if (arrondissement_id != 'all') {
                    if (annexe.arrondissement_id == arrondissement_id) {
                        $("#etude_dossier_modal_annexes_administratives_filter").append(new Option(annexe.nom, annexe.id));
                    }
                }
                else {
                    $("#etude_dossier_modal_annexes_administratives_filter").append(new Option(annexe.nom, annexe.id));
                }
            }
        });
    });

}



function etude_dossier_refresh_situation_filters(trigger_source) {
    if (trigger_source == 'province') {

        etude_dossier_fill_situation_filter_arrondissement($("#etude_dossier_modal_provinces_filter").val(), 'all');
        etude_dossier_fill_situation_filter_annexe_administrative($("#etude_dossier_modal_provinces_filter").val(), 'all');

    }
    if (trigger_source == 'arrondissement') {
        var province_id = undefined;

        if ($("#etude_dossier_modal_arrondissements_filter").val() == 'all') {
            etude_dossier_refresh_situation_filters('province');
            return;
        }

        arrondissements.forEach(arrondissement => {
            if (arrondissement.id == $("#etude_dossier_modal_arrondissements_filter").val()) {
                province_id = arrondissement.province_id;
            }
        });
        console.log(province_id);
        $("#etude_dossier_modal_provinces_filter").val(province_id);
        $('#etude_dossier_modal_provinces_filter').trigger('change.select2');

        etude_dossier_fill_situation_filter_annexe_administrative(province_id, $("#etude_dossier_modal_arrondissements_filter").val());

    }

    if (trigger_source == 'annexe_administrative') {
        var province_id = undefined;
        var arrondissement_id = undefined;

        if ($("#etude_dossier_modal_annexes_administratives_filter").val() == 'all') {
            etude_dossier_refresh_situation_filters('arrondissement');
            return;
        }

        annexes_administratives.forEach(annexe => {
            if (annexe.id == $("#etude_dossier_modal_annexes_administratives_filter").val()) {
                arrondissement_id = annexe.arrondissement_id;
            }
        });

        arrondissements.forEach(arrondissement => {
            if (arrondissement.id == arrondissement_id) {
                province_id = arrondissement.province_id;
            }
        });

        $("#etude_dossier_modal_provinces_filter").val(province_id);
        $('#etude_dossier_modal_provinces_filter').trigger('change.select2');

        $("#etude_dossier_modal_arrondissements_filter").val(arrondissement_id);
        $('#etude_dossier_modal_arrondissements_filter').trigger('change.select2');

    }


}

$("#store_etude_dossiers_form").submit(function (e) {

    e.preventDefault();
    if ($("#etude_dossier_modal_annexes_administratives_filter").val() == "all") {

        Swal.fire({
            icon: "error",
            title: "VSB-assist",
            text: "Merci de sélectionner l’annexe administrative.",
        });
        return;
    }
    if ($("#etude_dossier_modal_arrondissements_filter").val() == "all") {

        Swal.fire({
            icon: "error",
            title: "VSB-assist",
            text: "Merci de sélectionner l'arrondissement.",
        });
        return;
    }
    if ($("#etude_dossier_modal_provinces_filter").val() == "all") {

        Swal.fire({
            icon: "error",
            title: "VSB-assist",
            text: "Merci de sélectionner la province.",
        });
        return;
    }



    var csrfToken = document
        .querySelector('meta[name="_token"]')
        .getAttribute("content");



    var province_id = $("#etude_dossier_modal_provinces_filter").val();
    var arrondissement_id = $("#etude_dossier_modal_arrondissements_filter").val();
    var annexe_administrative_id = $("#etude_dossier_modal_annexes_administratives_filter").val();


    var dossiers = [];
    var membres = [];

    etude_dossier_modal_cins_datatable.rows().every(function (rowIdx, tableLoop, rowLoop) {
        dossiers.push(this.data()[this.data().length - 1]);
    });

    etude_dossier_modal_membres_commission_datatable.rows().every(function (rowIdx, tableLoop, rowLoop) {
        membres.push(this.data()[this.data().length - 1]);
    });


    showLoading(
        "Chargement...",
        "Le fichier est en cours de chargement, veuillez patienter"
    );

    $.ajax({
        url: assetBaseUrl + "travaux_commissions/pv_etude_store",
        type: "POST",

        data: {
            _token: csrfToken,
            province_id: province_id,
            arrondissement_id: arrondissement_id,
            annexe_administrative_id: annexe_administrative_id,
            dossiers: JSON.stringify(dossiers),
            membres: JSON.stringify(membres),
            id: $("#etude_dossier_modal_id").val()
        },

        success: function (response) {

            closeLoading();

            if (response.success == 1) {

                etudes_dossiers_datatable.ajax.reload(null, false);
                $("#etude_dossier_modal").modal('hide');

            } else {
                if (response.error == "NO_DOSSIER") {
                    gl_alert(
                        "error",
                        "VSB-Assist",
                        "Merci d’ajouter au moins un dossier."
                    );
                }
                if (response.error == "NO_MEMBRE") {
                    gl_alert(
                        "error",
                        "VSB-Assist",
                        "Merci d’ajouter au moins un membre de la commission."
                    );
                }

                if (response.error == "RECENSEMENT_VALIDE_FALSE") {
                    gl_alert(
                        "error",
                        "VSB-Assist",
                        `Les données de recensement doivent être validées pour la CIN ${response.menage.cins_list} afin de pouvoir l’ajouter à la liste des dossiers.`
                    );
                }

                if (response.error == "DOISSIER_ETUDE_COMPLET_VALIDE_FALSE") {
                    gl_alert(
                        "error",
                        "VSB-Assist",
                        `le dossier d'étude doit  être validé et complet pour la CIN ${response.menage.cins_list} afin de pouvoir l’ajouter à la liste des dossiers.`
                    );
                }
                if (response.error == "ETUDE_ALEADY_VALIDATED") {
                    gl_alert(
                        "error",
                        "VSB-Assist",
                        `Le dossier portant la CIN ${response.menage.cins_list} a déjà été validé par un PV d’étude.`
                    );
                }
            }
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
})

$("body").on('click', '.etude_pv_a', function () {

    var id = $(this).attr('id');

    $.ajax({
        url: assetBaseUrl + "travaux_commissions/get_pv_etude",
        type: "GET",
        data: {
            id: id
        },
        success: function (response) {

            $('#etude_dossier_modal button').filter(function () {
                return $(this).text().trim() !== 'Fermer';
            }).show();

            $("#etude_dossier_modal").modal('show');

            if (response.pv_signed == 1) {
                $('#etude_dossier_modal button').filter(function () {
                    return $(this).text().trim() !== 'Fermer';
                }).hide();
            }

            etude_dossier_modal_cins_datatable.rows().clear().draw();
            etude_dossier_modal_membres_commission_datatable.rows().clear().draw();

            $("#etude_dossier_modal_id").val(response.id);
            $("#etude_dossier_new_cin_modal_decision_div").css('display', 'block');
            $("#etude_dossier_modal_annexes_administratives_filter").val(response.annexe_administrative_id).change();

            response.dossiers.forEach(dossier => {
                dossier.chef_menage.decision = dossier.decision;
                dossier.chef_menage.motif_rejet = dossier.motif_rejet;
                etude_dossier_row_insertRow(dossier.chef_menage);
            });

            response.membres.forEach(membre => {

                etude_dossier_membre_commission_row_insertRow(membre.user);
            });





        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });

});

$("body").on('click', '.etude_pv_generated_download', function () {
    var id = $(this).attr('id');
    downloadFile(assetBaseUrl + 'travaux_commissions/downloadPVEtudeGenerated/' + id);
});


$("body").on("click", ".upload_doc_link", function () {


    var pv_id = $(this).attr('pv_id');
    var file_type = $(this).attr("file_type");
    var type_document = $(this).attr("type_document");

    $(".document_modal_date_doc").css("display", "block");
    $(".document_modal_insert_photo_row").css("display", "none");


    $("#dossier_document_modal_file_type_label").text(
        "Fichier " + file_type.toUpperCase()
    );
    $("#dossier_document_modal_file").attr(
        "data-allowed-file-extensions",
        file_type
    );
    $("#store_dossier_document_form [name='pv_id']").val(pv_id);
    $("#store_dossier_document_form [name='type_document']").val(type_document);
    if (dossier_document_modal_file_events != undefined) {
        $("#dossier_document_modal_file").data("dropify").destroy();
    }
    $("#dossier_document_modal_file").remove();
    $("#dossier_document_modal_file_div").append(
        `<input id="dossier_document_modal_file" data-max-file-size-preview="100M" data-allowed-file-extensions="${file_type}"  type="file" name="file" />`
    );

    dossier_document_modal_file_events = $(
        "#dossier_document_modal_file"
    ).dropify({
        messages: {
            default: "Faites glisser et déposez un fichier ici",
            replace: "Glisser-déposer ou cliquer pour remplacer",
            remove: "Supprimer",
            error: "Ooops, something wrong happended.",
        },
        error: {
            fileSize: "The file size is too big ({{ value }} max).",
            imageFormat: "The image format is not allowed ({{ value }} only).",
        },
    });

    $("#dossier_document_modal_save").attr("disabled", "disabled");
    $("#dossier_document_modal").modal("show");
    $("#dossier_document_modal_file").change(function () {
        if ($("#dossier_document_modal_file").val().length > 0) {
            $("#dossier_document_modal_save").removeAttr("disabled");
        }
    });
    $("#date_document").change(function () {
        if ($("#dossier_document_modal_file").val().length > 0) {
            $("#dossier_document_modal_save").removeAttr("disabled");
        }
    });

});


$("#store_dossier_document_form").submit(function (event) {

    event.preventDefault();




    showLoading(
        "Chargement...",
        "Le fichier est en cours de chargement, veuillez patienter"
    );
    $("#dossier_document_modal_save").attr("disabled", "disabled");

    var formData = new FormData(this);

    var documentType = formData.get("type_document");
    var url = "";
    if (documentType === "PV_ETUDE") {
        url = assetBaseUrl + "travaux_commissions/upload_signed_pv_etude";
    }
    if (documentType === "PV_TAS") {
        url = assetBaseUrl + "travaux_commissions/upload_signed_pv_tas";
    }
    $.ajax({
        url: url,
        type: "POST",
        dataType: "json",
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
            closeLoading();
            $("#dossier_document_modal_save").removeAttr("disabled");

            $("#dossier_document_modal").modal("hide");
            etudes_dossiers_datatable.ajax.reload(null, false);
            pv_tas_datatable.ajax.reload(null, false);



        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});


function pv_etude_check_generating_docs() {

    if (pv_etude_check_ids.length == 0)
        return;
    $.ajax({
        url: assetBaseUrl + "travaux_commissions/pv_etude_generation_stats",
        type: "GET",
        dataType: "json",
        data: {

            ids: pv_etude_check_ids.join(',')
        },

        success: function (response) {

            response.forEach(row => {

                $(`.pv_etude_cell[id='${row.id}']`).html(row.pv_generation_html);

            });
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
}