
var membres_datatable = undefined;

$(document).ready(function () {
    membres_datatable = $("#membres_datatable").DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: true,
        pageLength: 25,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: true,
        searching: false,
        scrollX: false,
        ajax: assetBaseUrl + "travaux_commissions/membres_datatable?filters=[]",
        dom: "lBfrtip",
        buttons: [
            {
                extend: "excel",
                text: '<button class="btn"><i class="fa fa-file-excel-o" ></i>  Exporter Excel</button>',
                titleAttr: "excel",
                title: "",
                action: newexportaction,
            },
        ],
        columnDefs: { className: "text-left", targets: "_all" },
        columns: [
            {
                data: "email",
            },
            {
                data: "nom",
            },
            {
                data: "prenom",
            },
            {
                data: "tel",
            },
            {
                data: "organisme_ste",
            },
            {
                data: "membre_role",
            },
            {
                data: "date",
            },
            {
                data: "invitation",
            },
        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },
    });
});

$("#prestataires_add").click(function () {
    document.getElementById("store_user_form").reset();
    $("#add_prestataire_modal").modal("show");
});


$("#store_user_form").submit(function (event) {
    event.preventDefault();
    var formData = new FormData(this);
    $.ajax({
        url: assetBaseUrl + "travaux_commissions/store_membre",
        type: "POST",
        dataType: "json",
        data: formData,
        processData: false,
        contentType: false,
        success: function (response) {
            if (response.success == 1) {
                $("#add_prestataire_modal").modal("hide");
                $.toast({
                    heading: "VSB",
                    text: "Le membre de comission a été créé avec succès.",
                    icon: "success",
                    position: "bottom-right",
                    hideAfter: 3000,
                    stack: false,
                });
                membres_datatable.ajax.reload();
            } else {
                Swal.fire({
                    icon: "error",
                    title: "VSB",
                    text: "Cet email est déjà présent dans notre base de données.",
                });
            }
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});

$("body").on("change", "#role_id_select_modal", function () {
    $('#organisme_ste_inpt_modal').prop('readonly', false);
    $('#promoteur_rib_div').css('display', 'none');
    let role_id = $("#role_id_select_modal").val();
    $('#organisme_ste_inpt_modal').val('');
    if (role_id === "8f812788-7d32-45c2-ba9a-9b5504230c49") {
        $('#organisme_ste_inpt_modal').prop('readonly', true);
        var selectedOptionText = $('#role_id_select_modal option:selected').text();
        $('#organisme_ste_inpt_modal').val(selectedOptionText);
    }

    if (role_id === "e6c37f7b-5825-4192-ae8f-808c2267eef2") {
        $('#promoteur_rib_div').css('display', 'block');
    }
});

$("body").on("change", ".prestataire_cb", function () {
    if ($(".prestataire_cb:checked").length > 0) {
        $("#prestataires_delete").removeAttr("disabled");
        $("#send_invitation").removeAttr("disabled");
        $("#edit_etat_engagement").removeAttr("disabled");
    } else {
        $("#prestataires_delete").attr("disabled", "disabled");
        $("#send_invitation").attr("disabled", "disabled");
        $("#edit_etat_engagement").attr("disabled", "disabled");
    }
});

$("#prestataires_delete").click(function () {
    var csrfToken = document
        .querySelector('meta[name="_token"]')
        .getAttribute("content");

    Swal.fire({
        title: "Confirmation",
        text: "Êtes-vous sûr de vouloir supprimer  les 'éléments sélectionnés?",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#88C241",
        cancelButtonColor: "#F83F37",
        confirmButtonText: "Oui",
        cancelButtonText: "Non",
    }).then((result) => {
        if (result.isConfirmed) {
            var ids = [];
            $(".prestataire_cb:checked").each(function () {
                ids.push($(this).attr("item_id"));
            });

            $.ajax({
                url: assetBaseUrl + "user/delete",
                type: "POST",
                data: {
                    _token: csrfToken,
                    ids: ids.join(","),
                },
                success: function (response) {
                    $("#add_prestataire_modal").modal("hide");
                    $.toast({
                        heading: "BATIRE",
                        text: "Le prestataire a été créé avec succès.",
                        icon: "success",
                        position: "bottom-right",
                        hideAfter: 3000,
                        stack: false,
                    });
                    prestataires_table.ajax.reload();
                    $("#prestataires_delete").attr("disabled", "disabled");
                },
                error: function (xhr, status, error) {
                    console.log(xhr.responseText);
                },
            });
        }
    });
});

$("body").on("click", ".prestataire_a", function () {
    $.ajax({
        url: assetBaseUrl + "user/" + $(this).attr("item_id"),
        type: "GET",
        dataType: "json",

        success: function (response) {
            $("#store_user_form [name='id']").val(response.id);
            $("#store_user_form [name='nom']").val(response.nom);
            $("#store_user_form [name='prenom']").val(response.prenom);
            $("#store_user_form [name='email']").val(response.email);
            $("#store_user_form [name='tel']").val(response.tel);
            $("#store_user_form [name='organisme_ste']").val(response.organisme_ste);
            $("#store_user_form [name='role_id']").val(response.role_id).change();

            $("#store_user_form [name='membre_role']").val(response.membre_role);
            $("#store_user_form [name='nom_ar']").val(response.nom_ar);
            $("#store_user_form [name='prenom_ar']").val(response.prenom_ar);

            if (response.validation_completed_date != null) {
                $("#store_user_form [name='email']").attr("disabled", "disabled");
            } else {
                $("#store_user_form [name='email']").removeAttr("disabled");
            }
            $("#add_prestataire_modal").modal("show");
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});

$("#send_invitation").click(function () {
    console.log("send_invitation");
    loading_popup = Swal.fire({
        title: "Chargement",
        html: "Envoie des invitation...",
        timer: 2000000000,
        timerProgressBar: true,
        hideOnOverlayClick: false,
        hideOnContentClick: false,
        allolwOutsideClick: false,
        closeClick: false,
        helpers: {
            overlay: { closeClick: false },
        },
        didOpen: () => {
            Swal.showLoading();
        },
        willClose: () => { },
    }).then((result) => { });

    $(".prestataire_cb:checked").each(function () {
        $.ajax({
            url: assetBaseUrl + "send-invitation-mail/" + $(this).attr("item_id"),
            type: "GET",
            dataType: "json",

            success: function (response) {
                Swal.close();

                $.toast({
                    heading: "BATIRE",
                    text: "Invitation(s) envoyée(s).",
                    icon: "success",
                    position: "bottom-right",
                    hideAfter: 3000,
                    stack: false,
                });

                prestataires_table.ajax.reload();
                $("#prestataires_delete").attr("disabled", "disabled");
                $("#send_invitation").attr("disabled", "disabled");
                $("#edit_etat_engagement").attr("disabled", "disabled");
            },
            error: function (xhr, status, error) {
                console.log(xhr.responseText);
            },
        });
    });
});
