var pv_tas_datatable = undefined;
var pv_tas_modal_cins_datatable = undefined;
var pv_tas_modal_membres_commission_datatable = undefined;

var pv_tas_check_ids = [];

var current_pv_tas = undefined;

var pv_tas_modal_projets_datatable = undefined;
var pv_tas_modal_projets_datatable_edit = undefined;
$(document).ready(function () {



    pv_tas_modal_projets_datatable_edit = $("#pv_tas_modal_projets_datatable_edit").DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: false,
        pageLength: 15,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: false,
        searching: false,
        scrollX: false,
        ajax: null,
        dom: "lBfrtip",
        buttons: [

        ],
        columnDefs: { className: "text-left", targets: "_all" },

        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },
    });

    pv_tas_modal_projets_datatable = $("#pv_tas_modal_projets_datatable").DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: false,
        pageLength: 15,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: false,
        searching: false,
        scrollX: false,
        ajax: null,
        dom: "lBfrtip",
        buttons: [

        ],
        columnDefs: { className: "text-left", targets: "_all" },

        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },
    });
    pv_tas_modal_cins_datatable = $("#pv_tas_modal_cins_datatable").DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: false,
        pageLength: 15,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: false,
        searching: false,
        scrollX: false,
        ajax: null,
        dom: "lBfrtip",
        buttons: [

        ],
        columnDefs: { className: "text-left", targets: "_all" },

        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },
    });

    pv_tas_modal_membres_commission_datatable = $("#pv_tas_modal_membres_commission_datatable").DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: false,
        pageLength: 15,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: false,
        searching: false,
        scrollX: false,
        ajax: null,
        dom: "lBfrtip",
        buttons: [

        ],
        columnDefs: { className: "text-left", targets: "_all" },

        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },
    });



    pv_tas_datatable = $('#pv_tas_datatable').DataTable({
        responsive: false,
        autoWidth: false,
        bPaginate: true,
        pageLength: 25,
        lengthChange: false,
        bFilter: false,
        bInfo: false,
        ordering: false,
        processing: true,
        serverSide: true,
        searching: false,
        scrollX: false,
        ajax: assetBaseUrl + 'travaux_commissions/pv_tas_datatable?filters=[]',
        dom: "lBfrtip",
        buttons: [
            {
                "extend": 'excel',
                "text": '',
                "titleAttr": 'excel',
                'title': 'PV etudes -' + current_date.replaceAll("/", "-"),
                "action": newexportaction
            },
        ],
        columnDefs: [
            { lassName: 'text-left', targets: [0] },
            { className: 'text-center', targets: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10] }
        ],
        columns: [
            {
                data: 'reference',
            },
            {
                data: 'date',
            },
            {
                data: 'province',
            },
            {
                data: 'arrondissement',
            },
            {
                data: 'annexe_administrative',
            },
            {
                data: 'projet',
            },
            {
                data: 'stock',
            },
            {
                data: 'cin',
            },
            {
                data: 'pv_tas_generated',
            },
            {
                data: 'bons',
            },
            {
                data: 'pv_tas_signed',
            },


        ],
        language: {
            url: assetBaseUrl + "languages/datatable_fr.json",
        },

    }).on("xhr.dt", function (e, settings, json, xhr) {

        json.data.forEach(row => {

            if (!pv_tas_check_ids.includes(row.pv_tas_id)) {
                pv_tas_check_ids.push(row.pv_tas_id);
            }
        });



    });

    pv_tas_datatable.on('draw', function () {
        initSelect();
    })
    $("#pv_tas_modal_projet").change();


    pv_tas_modal_cins_datatable.on('draw', function () {
        initSelect();
    })

    window.setInterval(function () {
        pv_tast_check_generating_docs();
    }, 1000);


});



$("#pv_tas_modal_provinces_filter").change(function () {
    refresh_situation_filters('province');
});
$("#pv_tas_modal_arrondissements_filter").change(function () {
    refresh_situation_filters('arrondissement');
});
$("#pv_tas_modal_annexes_administratives_filter").change(function () {
    refresh_situation_filters('annexe_administrative');
});


function fill_situation_filter_arrondissement(province_id) {
    $("#pv_tas_modal_arrondissements_filter").empty();
    $("#pv_tas_modal_arrondissements_filter").append(new Option('Indifferent', 'all'));
    arrondissements.forEach(arrondissement => {
        if (province_id != 'all') {
            if (arrondissement.province_id == province_id) {
                $("#pv_tas_modal_arrondissements_filter").append(new Option(arrondissement.nom, arrondissement.id));
            }
        }
        else {
            $("#pv_tas_modal_arrondissements_filter").append(new Option(arrondissement.nom, arrondissement.id));
        }
    });
}


function fill_situation_filter_annexe_administrative(province_id, arrondissement_id) {
    $("#pv_tas_modal_annexes_administratives_filter").empty();
    $("#pv_tas_modal_annexes_administratives_filter").append(new Option('Indifferent', 'all'));
    var filtred_arrondissements = [];

    arrondissements.forEach(arrondissement => {
        if (province_id != 'all') {
            if (arrondissement.province_id == province_id) {
                filtred_arrondissements.push(arrondissement);
            }
        }
        else {
            filtred_arrondissements.push(arrondissement);
        }
    });

    filtred_arrondissements.forEach(arrondissement => {
        annexes_administratives.forEach(annexe => {
            if (annexe.arrondissement_id == arrondissement.id) {
                if (arrondissement_id != 'all') {
                    if (annexe.arrondissement_id == arrondissement_id) {
                        $("#pv_tas_modal_annexes_administratives_filter").append(new Option(annexe.nom, annexe.id));
                    }
                }
                else {
                    $("#pv_tas_modal_annexes_administratives_filter").append(new Option(annexe.nom, annexe.id));
                }
            }
        });
    });

}



function refresh_situation_filters(trigger_source) {
    if (trigger_source == 'province') {

        fill_situation_filter_arrondissement($("#pv_tas_modal_provinces_filter").val(), 'all');
        fill_situation_filter_annexe_administrative($("#pv_tas_modal_provinces_filter").val(), 'all');

    }
    if (trigger_source == 'arrondissement') {
        var province_id = undefined;

        if ($("#pv_tas_modal_arrondissements_filter").val() == 'all') {
            refresh_situation_filters('province');
            return;
        }

        arrondissements.forEach(arrondissement => {
            if (arrondissement.id == $("#pv_tas_modal_arrondissements_filter").val()) {
                province_id = arrondissement.province_id;
            }
        });
        console.log(province_id);
        $("#pv_tas_modal_provinces_filter").val(province_id);
        $('#pv_tas_modal_provinces_filter').trigger('change.select2');

        fill_situation_filter_annexe_administrative(province_id, $("#pv_tas_modal_arrondissements_filter").val());

    }

    if (trigger_source == 'annexe_administrative') {
        var province_id = undefined;
        var arrondissement_id = undefined;

        if ($("#pv_tas_modal_annexes_administratives_filter").val() == 'all') {
            refresh_situation_filters('arrondissement');
            return;
        }

        annexes_administratives.forEach(annexe => {
            if (annexe.id == $("#pv_tas_modal_annexes_administratives_filter").val()) {
                arrondissement_id = annexe.arrondissement_id;
            }
        });

        arrondissements.forEach(arrondissement => {
            if (arrondissement.id == arrondissement_id) {
                province_id = arrondissement.province_id;
            }
        });

        $("#pv_tas_modal_provinces_filter").val(province_id);
        $('#pv_tas_modal_provinces_filter').trigger('change.select2');

        $("#pv_tas_modal_arrondissements_filter").val(arrondissement_id);
        $('#pv_tas_modal_arrondissements_filter').trigger('change.select2');

    }


}


function pv_tast_check_generating_docs() {

    if (pv_tas_check_ids.length == 0)
        return;
    $.ajax({
        url: assetBaseUrl + "travaux_commissions/pv_tas_generation_stats",
        type: "GET",
        dataType: "json",
        data: {

            ids: pv_tas_check_ids.join(',')
        },

        success: function (response) {

            response.forEach(row => {

                $(`.pv_tas_stock_cell[id='${row.id}']`).html(row.stock_generation_html);
                $(`.pv_tas_pv_cell[id='${row.id}']`).html(row.pv_generation_html);
                $(`.pv_tas_bons_cell[id='${row.id}']`).html(row.bons_generation_html);
            });
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
}


$("#pv_tas_new_btn").click(function () {

    current_pv_tas = undefined;
    $("#pv_tas_modal_id").val("");

    pv_tas_modal_cins_datatable.rows().clear().draw();
    pv_tas_modal_membres_commission_datatable.rows().clear().draw();

    $("#pv_tas_modal_projet_div_edit").css("display", "none");
    $("#pv_tas_modal_projet_div_new").css("display", "block");
    $("#pv_tas_modal_stock_stats_div").css("display", "flex");
    $("#pv_tas_dossier_membre_div").css("display", "none");


    $('#pv_tas_modal button').filter(function () {
        return $(this).text().trim() !== 'Fermer';
    }).show();

    $("#pv_tas_modal").modal("show");
});

$("#pv_tas_modal_projet").change(function () {

    var csrfToken = document
        .querySelector('meta[name="_token"]')
        .getAttribute("content");

    var projet_id = $("#pv_tas_modal_projet").val();

    $.ajax({
        url: assetBaseUrl + "travaux_commissions/pv_tas_get_douars",
        type: "POST",
        dataType: "json",
        data: {
            _token: csrfToken,
            projet_id: projet_id
        },

        success: function (response) {
            console.log(response);
            $("#pv_tas_modal_douar").empty();
            $("#pv_tas_modal_douar").append(` <option value="all" selected>Tous les douars</option>`);
            response.forEach(douar => {

                $("#pv_tas_modal_douar").append(`<option value="${douar.douar.id}">${douar.douar.nom}</option>`);
            });

            $("#pv_tas_modal_douar").change();
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
});

$("#pv_tas_modal_douar").change(function () {
    refresh_stock_stats();
});

function refresh_stock_stats() {

    var csrfToken = document
        .querySelector('meta[name="_token"]')
        .getAttribute("content");
    var projet_id = $("#pv_tas_modal_projet").val();
    var douar_id = $("#pv_tas_modal_douar").val();
    $.ajax({
        url: assetBaseUrl + "travaux_commissions/pv_tas_get_stock_stats",
        type: "POST",
        dataType: "json",
        data: {
            _token: csrfToken,
            projet_id: projet_id,
            douar_id: douar_id
        },

        success: function (response) {
            $("#pv_tas_modal_stock_total_label").text(response.stock_total);
            $("#pv_tas_modal_stock_disponible_label").text(response.stock_disponible);
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
}


$("#store_pv_tas_form").submit(function (e) {

    e.preventDefault();
    if ($("#pv_tas_modal_annexes_administratives_filter").val() == "all") {

        Swal.fire({
            icon: "error",
            title: "VSB-assist",
            text: "Merci de sélectionner l’annexe administrative.",
        });
        return;
    }
    if ($("#pv_tas_modal_arrondissements_filter").val() == "all") {

        Swal.fire({
            icon: "error",
            title: "VSB-assist",
            text: "Merci de sélectionner l'arrondissement.",
        });
        return;
    }
    if ($("#pv_tas_modal_provinces_filter").val() == "all") {

        Swal.fire({
            icon: "error",
            title: "VSB-assist",
            text: "Merci de sélectionner la province.",
        });
        return;
    }



    var csrfToken = document
        .querySelector('meta[name="_token"]')
        .getAttribute("content");



    var province_id = $("#pv_tas_modal_provinces_filter").val();
    var arrondissement_id = $("#pv_tas_modal_arrondissements_filter").val();
    var annexe_administrative_id = $("#pv_tas_modal_annexes_administratives_filter").val();


    var dossiers = [];
    var membres = [];
    var projets_tas = [];

    pv_tas_modal_cins_datatable.rows().every(function (rowIdx, tableLoop, rowLoop) {
        dossiers.push(this.data()[this.data().length - 1]);
    });

    pv_tas_modal_membres_commission_datatable.rows().every(function (rowIdx, tableLoop, rowLoop) {
        membres.push(this.data()[this.data().length - 1]);
    });

    pv_tas_modal_projets_datatable.rows().every(function (rowIdx, tableLoop, rowLoop) {
        projets_tas.push(this.data()[this.data().length - 1]);
    });

    showLoading(
        "Chargement...",
        "Le fichier est en cours de chargement, veuillez patienter"
    );

    $.ajax({
        url: assetBaseUrl + "travaux_commissions/pv_tas_store",
        type: "POST",

        data: {
            _token: csrfToken,
            province_id: province_id,
            arrondissement_id: arrondissement_id,
            annexe_administrative_id: annexe_administrative_id,
            dossiers: JSON.stringify(dossiers),
            membres: JSON.stringify(membres),
            id: $("#pv_tas_modal_id").val(),
            projet_id: $("#pv_tas_modal_projet").val(),
            immeuble_id: $("#pv_tas_modal_immeuble").val(),
            projets_tas: JSON.stringify(projets_tas),

        },

        success: function (response) {
            closeLoading();

            if (response.success == 1) {

                pv_tas_datatable.ajax.reload(null, false);
                $("#pv_tas_modal").modal('hide');
            }
            else {
                if (response.error == "NO_RECU_VERSEMENT_20000_OR_ENGAGEMENT_BANQUE") {
                    gl_alert(
                        "error",
                        "VSB-Assist",
                        `La création du PV est impossible : Le reçu de versement de 20 000 Dhs / Engagment de la banque  est absent dans le dossier avec CIN : ${response.menage.cins_list} `
                    );
                }

                if (response.error == "RECU_VERSEMENT_20000_NOT_VALIDTED") {
                    gl_alert(
                        "error",
                        "VSB-Assist",
                        `La création du PV est impossible : Le reçu de versement de 20 000 Dhs n'a pas encore été validé dans le dossier avec CIN : ${response.menage.cins_list} `
                    );
                }

                if (response.error == "ENGAGEMENT_BANQUE_NOT_VALIDTED") {
                    gl_alert(
                        "error",
                        "VSB-Assist",
                        `La création du PV est impossible : l'engagment de la banque n'a pas encore été validé dans le dossier avec CIN : ${response.menage.cins_list} `
                    );
                }

                if (response.error == "WRONG_PROJET_DESTINATION") {
                    gl_alert(
                        "error",
                        "VSB-Assist",
                        `Impossible de créer le PV : le dossier portant la CIN ${response.menage.cins_list} est associé au projet ${response.projet_dossier} et non au projet ${response.projet_selected}.`
                    );
                }

                if (response.error == "NO_PROJET") {
                    gl_alert(
                        "error",
                        "VSB-Assist",
                        `Veuillez sélectionner au moins un projet.`
                    );
                }

                if (response.error == "PROJET_BLOCKED") {
                    gl_alert(
                        "error",
                        "VSB-Assist",
                        `La création du PV est impossible : le projet ${response.projet.nom} est verrouillé par un autre PV de tirage au sort.`
                    );
                }

                if (response.error == "PROJET_NOT_FOUND") {
                    gl_alert(
                        "error",
                        "VSB-Assist",
                        "Merci de préciser le projet."
                    );
                }
                if (response.error == "NO_DOSSIER") {
                    gl_alert(
                        "error",
                        "VSB-Assist",
                        "Merci d’ajouter au moins un dossier."
                    );
                }
                if (response.error == "NO_MEMBRE") {
                    gl_alert(
                        "error",
                        "VSB-Assist",
                        "Merci d’ajouter au moins un membre de la commission."
                    );
                }
                if (response.error == "DOSSIER_WITH_NO_SELECTED_APPRTEMENT") {
                    gl_alert(
                        "error",
                        "VSB-Assist",
                        "Veuillez vous assurer que vous avez sélectionné un appartement pour tous les dossiers."
                    );
                }
            }
        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });
})



$("body").on('click', '.pv_tas_a', function () {

    var id = $(this).attr('id');

    $.ajax({
        url: assetBaseUrl + "travaux_commissions/get_pv_tas",
        type: "GET",
        data: {
            id: id
        },
        success: function (response) {
            current_pv_tas = response;

            $('#pv_tas_modal button').filter(function () {
                return $(this).text().trim() !== 'Fermer';
            }).show();
            $("#pv_tas_modal").modal('show');

            if (response.pv_signed == 1) {
                $('#pv_tas_modal button').filter(function () {
                    return $(this).text().trim() !== 'Fermer';
                }).hide();
            }

            pv_tas_modal_cins_datatable.rows().clear().draw();
            pv_tas_modal_membres_commission_datatable.rows().clear().draw();
            pv_tas_modal_projets_datatable_edit.rows().clear().draw();
            $("#pv_tas_modal_id").val(response.id);

            $("#pv_tas_modal_annexes_administratives_filter").val(response.annexe_administrative_id).change();



            $("#etude_dossier_new_cin_modal_decision_div").css('display', 'none');
            $("#pv_tas_modal_projet_div_edit").css("display", "block");
            $("#pv_tas_modal_projet_div_new").css("display", "none");
            $("#pv_tas_modal_stock_stats_div").css("display", "none");

            $("#pv_tas_dossier_membre_div").css("display", "block");


            response.dossiers.forEach(dossier => {

                dossier.chef_menage.selected_appartement = dossier.selected_appartement.id;
                pv_tas_modal_cins_datatable_insertRow(dossier.chef_menage);
            });


            response.membres.forEach(membre => {

                etude_dossier_membre_commission_row_insertRow(membre.user);
            });

            response.projets_tas.forEach(projet_tas => {

                var projet_stock = 0;
                var projet_stock_disponible = 0;

                response.stock.forEach(stock => {
                    if (stock.projet_id == projet_tas.projet_id) {

                        var ignore = false;
                        if (projet_tas.douar_id != null) {
                            if (stock.douar_id != projet_tas.douar_id) {
                                ignore = true;
                            }
                        }
                        if (!ignore) {
                            if (stock.is_affected == 0) {
                                projet_stock_disponible++;
                            }
                            projet_stock++;
                        }

                    }
                });

                var projet = {
                    projet_id: projet_tas.projet_id,
                    nom: projet_tas.projet.nom,
                    douar_id: (projet_tas.douar != null ? projet_tas.douar.id : 'all'),
                    immeuble: (projet_tas.douar != null ? projet_tas.douar.nom : 'Tous les douars'),
                    stock: projet_stock,
                    stock_disponible: projet_stock_disponible
                }
                pv_tas_modal_projets_datatable_edit_insertRow(projet);
            });



        },
        error: function (xhr, status, error) {
            console.log(xhr.responseText);
        },
    });

});

$("body").on('click', '.pv_tas_stock_generated_download', function () {
    var id = $(this).attr('id');
    downloadFile(assetBaseUrl + 'travaux_commissions/download_pv_tas_stock_Generated/' + id);
});



$("#pv_tas_modal_membre_commission_add").click(function () {
    $("#etude_dossier_membre_commission_modal_target").val("PV_TAS");
    $("#etude_dossier_membre_commission_modal").modal('show');
});


$("#pv_tas_modal_cin_add").click(function () {
    $("#etude_dossier_new_cin_modal_cin").val("");
    $("#etude_dossier_new_cin_modal_cin").change();
    $("#etude_dossier_new_cin_modal_target").val("PV_TAS");

    $("#etude_dossier_new_cin_modal_decision_div").css('display', 'none');
    $("#etude_dossier_new_cin_modal").modal("show");
});

function pv_tas_modal_cins_datatable_insertRow(chef_menage, edit = false) {


    var cin_html = '<input type="checkbox" class="tas_dossier_row_cb" style="vertical-align: middle;margin-left:4px;"><a  style="vertical-align: middle; margin-left: 6px;color: #71ba18;font-weight: 500;" href="javascript:;"><i style="margin-right:6px;font-size:15px" class="fa-solid fa-address-card"></i>' + chef_menage.chef_menage_cin + '</span></a>';
    var nom_html = '<span>' + chef_menage.chef_menage_prenom + ' ' + chef_menage.chef_menage_nom + '</span>';
    var conjoints_html = '<span> ' + '-' + '</span>';

    if (chef_menage.conjoints.length > 0) {
        conjoints_html = '<select class="form-control select2"> ';
        chef_menage.conjoints.forEach(conjoint => {
            conjoints_html += `<option>${conjoint.nom + ' ' + conjoint.prenom}</option>`;
        });
        conjoints_html += '</select> ';
    }

    var apprtement_html = '<select chef_menage_id="' + chef_menage.id + '" class="form-control select2 pv_tas_select_stock">';


    if (chef_menage.selected_appartement != undefined) {
        apprtement_html += `<option value="">Veuillez sélectionner</option>`;
    }
    else {
        apprtement_html += `<option value="" selected>Veuillez sélectionner</option>`;
    }

    //<optgroup label = "Choose One">

    var last_projet = undefined;
    current_pv_tas.stock.forEach(appartement => {

        if (last_projet != appartement.projet_id) {
            if (last_projet != undefined) {
                apprtement_html += `</optgroup>`;
            }
            apprtement_html += `<optgroup label = "${appartement.projet_nom}">`;

            last_projet = appartement.projet_id;
        }

        apprtement_html += `<option ${chef_menage.selected_appartement == appartement.id ? 'selected' : ''} value="${appartement.id}">${appartement.immeuble.numero} - ${appartement.num} - ${appartement.TF}</option>`;
    });
    apprtement_html += '</select> ';





    pv_tas_modal_cins_datatable.row.add([cin_html, nom_html, conjoints_html, apprtement_html, chef_menage]).draw();



}

$('body').on('change', '.pv_tas_select_stock', function () {

    var row = $(this).closest('tr');
    var rowData = pv_tas_modal_cins_datatable.row(row).data();

    rowData[rowData.length - 1].selected_appartement = $(this).val();


    var apprtement_html = '<select chef_menage_id="' + rowData[rowData.length - 1].id + '" class="form-control select2 pv_tas_select_stock"> ';


    if (rowData[rowData.length - 1].selected_appartement != undefined) {
        apprtement_html += `<option value="">Veuillez sélectionner</option>`;
    }
    else {
        apprtement_html += `<option value="" selected>Veuillez sélectionner</option>`;
    }
    var last_projet = undefined;
    current_pv_tas.stock.forEach(appartement => {

        if (last_projet != appartement.projet_id) {
            if (last_projet != undefined) {
                apprtement_html += `</optgroup>`;
            }
            apprtement_html += `<optgroup label = "${appartement.projet_nom}">`;

            last_projet = appartement.projet_id;
        }

        apprtement_html += `<option ${rowData[rowData.length - 1].selected_appartement == appartement.id ? 'selected' : ''} value="${appartement.id}">${appartement.immeuble.numero} - ${appartement.num} - ${appartement.TF}</option>`;
    });
    apprtement_html += '</select> ';

    rowData[3] = apprtement_html;

    pv_tas_modal_cins_datatable.row(row).data(rowData).draw(true);
});


$("body").on('click', '.tas_pv_generated_download', function () {
    var id = $(this).attr('id');
    downloadFile(assetBaseUrl + 'travaux_commissions/download_pv_tas_Generated/' + id);
});


$("body").on('click', '.pv_tas_bons_generated_download', function () {
    var id = $(this).attr('id');
    downloadFile(assetBaseUrl + 'travaux_commissions/download_pv_tas_bons_Generated/' + id);
});

$("#pv_tas_modal_projet_add").click(function () {
    var projet = {
        projet_id: $("#pv_tas_modal_projet").val(),
        nom: $("#pv_tas_modal_projet option:selected").text(),
        douar_id: $("#pv_tas_modal_douar").val(),
        douar: $("#pv_tas_modal_douar option:selected").text(),
        stock: parseInt($("#pv_tas_modal_stock_total_label").text()),
        stock_disponible: parseInt($("#pv_tas_modal_stock_disponible_label").text())
    }
    var projets_tas = [];

    pv_tas_modal_projets_datatable.rows().every(function (rowIdx, tableLoop, rowLoop) {
        projets_tas.push(this.data()[this.data().length - 1]);
    });

    var can_be_inserted = true;
    projets_tas.forEach(projet_tas => {
        if (projet_tas.projet_id == projet.projet_id) {
            if (projet_tas.douar_id == projet.douar_id) {
                can_be_inserted = false;
            }

            if (projet_tas.douar_id != projet.douar_id) {
                if (projet_tas.douar_id == "all") {
                    can_be_inserted = false;
                }
            }
        }
    });

    if (can_be_inserted) {
        pv_tas_modal_projets_datatable_insertRow(projet);
    }
    else {
        gl_alert(
            "error",
            "VSB-Assist",
            "Le stock des appartements est déjà inclus dans la liste.."
        );
    }

});

function pv_tas_modal_projets_datatable_insertRow(projet) {

    var projet_html = '<input type="checkbox" class="pv_tas_projet_row_cb" style="vertical-align: middle;margin-left:4px;"><a  style="vertical-align: middle; margin-left: 6px;color: #71ba18;font-weight: 500;" href="javascript:;"><i style="margin-right:6px;font-size:15px" class="fa-solid fa-building mr-2"></i>' + projet.nom + '</span></a>';
    var douar_html = '<span>' + projet.douar + '</span>';
    var stock_html = '<span>' + projet.stock + '</span>';
    var stock_disponible_html = '<span>' + projet.stock_disponible + '</span>';


    pv_tas_modal_projets_datatable.row.add([projet_html, douar_html, stock_html, stock_disponible_html, projet]).draw();
}

function pv_tas_modal_projets_datatable_edit_insertRow(projet) {

    var projet_html = '<a  style="vertical-align: middle; margin-left: 6px;color: #71ba18;font-weight: 500;" href="javascript:;"><i style="margin-right:6px;font-size:15px" class="fa-solid fa-building mr-2"></i>' + projet.nom + '</span></a>';
    var douar_html = '<span>' + projet.immeuble + '</span>';
    var stock_html = '<span>' + projet.stock + '</span>';
    var stock_disponible_html = '<span>' + projet.stock_disponible + '</span>';


    pv_tas_modal_projets_datatable_edit.row.add([projet_html, douar_html, stock_html, stock_disponible_html, projet]).draw();
}


$('body').on('change', ".tas_dossier_row_cb", function () {

    if ($(".tas_dossier_row_cb:checked").length > 0) {
        $("#pv_tas_modal_cin_delete").removeAttr("disabled");
    } else {

        $("#pv_tas_modal_cin_delete").attr("disabled", "disabled");
    }
});


$("#pv_tas_modal_cin_delete").click(function () {

    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous sûr de vouloir supprimer les dossiers sélectionnés de la liste?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {

            $('input[type="checkbox"]:checked').each(function () {
                var tr = $(this).closest('tr');
                pv_tas_modal_cins_datatable.rows(tr).remove().draw();
            });
            $("#pv_tas_modal_cin_delete").attr("disabled", "disabled");
        }
    });
});


$('body').on('change', ".tas_membre_commission_row_cb", function () {

    if ($(".tas_membre_commission_row_cb:checked").length > 0) {
        $("#pv_tas_modal_membre_commission_delete").removeAttr("disabled");
    } else {

        $("#pv_tas_modal_membre_commission_delete").attr("disabled", "disabled");
    }
});


$("#pv_tas_modal_membre_commission_delete").click(function () {

    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous sûr de vouloir supprimer les dossiers sélectionnés de la liste?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {

            $('input[type="checkbox"]:checked').each(function () {
                var tr = $(this).closest('tr');

                pv_tas_modal_membres_commission_datatable.rows(tr).remove().draw();

            });
            $("#pv_tas_modal_membre_commission_delete").attr("disabled", "disabled");
        }
    });
});

$('body').on('change', ".pv_tas_projet_row_cb", function () {

    if ($(".pv_tas_projet_row_cb:checked").length > 0) {
        $("#pv_tas_modal_projet_delete").removeAttr("disabled");
    } else {

        $("#pv_tas_modal_projet_delete").attr("disabled", "disabled");
    }
});
$("#pv_tas_modal_projet_delete").click(function () {

    Swal.fire({
        title: 'Confirmation',
        text: "Êtes-vous sûr de vouloir supprimer les dossiers sélectionnés de la liste?",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#88C241',
        cancelButtonColor: '#F83F37',
        confirmButtonText: 'Oui',
        cancelButtonText: 'Non'
    }).then((result) => {
        if (result.isConfirmed) {

            $('input[type="checkbox"]:checked').each(function () {
                var tr = $(this).closest('tr');

                pv_tas_modal_projets_datatable.rows(tr).remove().draw();

            });
            $("#pv_tas_modal_projet_delete").attr("disabled", "disabled");
        }
    });
});
