import { Component, Input } from '@angular/core';
import lightGallery from 'lightgallery';
import * as i0 from "@angular/core";
const _c0 = ["*"];
const LgMethods = {
    onAfterAppendSlide: 'lgAfterAppendSlide',
    onInit: 'lgInit',
    onHasVideo: 'lgHasVideo',
    onContainerResize: 'lgContainerResize',
    onUpdateSlides: 'lgUpdateSlides',
    onAfterAppendSubHtml: 'lgAfterAppendSubHtml',
    onBeforeOpen: 'lgBeforeOpen',
    onAfterOpen: 'lgAfterOpen',
    onSlideItemLoad: 'lgSlideItemLoad',
    onBeforeSlide: 'lgBeforeSlide',
    onAfterSlide: 'lgAfterSlide',
    onPosterClick: 'lgPosterClick',
    onDragStart: 'lgDragStart',
    onDragMove: 'lgDragMove',
    onDragEnd: 'lgDragEnd',
    onBeforeNextSlide: 'lgBeforeNextSlide',
    onBeforePrevSlide: 'lgBeforePrevSlide',
    onBeforeClose: 'lgBeforeClose',
    onAfterClose: 'lgAfterClose',
    onRotateLeft: 'lgRotateLeft',
    onRotateRight: 'lgRotateRight',
    onFlipHorizontal: 'lgFlipHorizontal',
    onFlipVertical: 'lgFlipVertical',
};
export class LightgalleryComponent {
    constructor(_elementRef) {
        this._elementRef = _elementRef;
        this.lgInitialized = false;
        this._elementRef = _elementRef;
    }
    ngAfterViewChecked() {
        if (!this.lgInitialized) {
            this.registerEvents();
            this.LG = lightGallery(this._elementRef.nativeElement, this.settings);
            this.lgInitialized = true;
        }
    }
    ngOnDestroy() {
        this.LG.destroy();
        this.lgInitialized = false;
    }
    registerEvents() {
        if (this.onAfterAppendSlide) {
            this._elementRef.nativeElement.addEventListener(LgMethods.onAfterAppendSlide, ((event) => {
                this.onAfterAppendSlide &&
                    this.onAfterAppendSlide(event.detail);
            }));
        }
        if (this.onInit) {
            this._elementRef.nativeElement.addEventListener(LgMethods.onInit, ((event) => {
                this.onInit && this.onInit(event.detail);
            }));
        }
        if (this.onHasVideo) {
            this._elementRef.nativeElement.addEventListener(LgMethods.onHasVideo, ((event) => {
                this.onHasVideo && this.onHasVideo(event.detail);
            }));
        }
        if (this.onContainerResize) {
            this._elementRef.nativeElement.addEventListener(LgMethods.onContainerResize, ((event) => {
                this.onContainerResize &&
                    this.onContainerResize(event.detail);
            }));
        }
        if (this.onAfterAppendSubHtml) {
            this._elementRef.nativeElement.addEventListener(LgMethods.onAfterAppendSubHtml, ((event) => {
                this.onAfterAppendSubHtml &&
                    this.onAfterAppendSubHtml(event.detail);
            }));
        }
        if (this.onBeforeOpen) {
            this._elementRef.nativeElement.addEventListener(LgMethods.onBeforeOpen, ((event) => {
                this.onBeforeOpen && this.onBeforeOpen(event.detail);
            }));
        }
        if (this.onAfterOpen) {
            this._elementRef.nativeElement.addEventListener(LgMethods.onAfterOpen, ((event) => {
                this.onAfterOpen && this.onAfterOpen(event.detail);
            }));
        }
        if (this.onSlideItemLoad) {
            this._elementRef.nativeElement.addEventListener(LgMethods.onSlideItemLoad, ((event) => {
                this.onSlideItemLoad && this.onSlideItemLoad(event.detail);
            }));
        }
        if (this.onBeforeSlide) {
            this._elementRef.nativeElement.addEventListener(LgMethods.onBeforeSlide, ((event) => {
                this.onBeforeSlide && this.onBeforeSlide(event.detail);
            }));
        }
        if (this.onAfterSlide) {
            this._elementRef.nativeElement.addEventListener(LgMethods.onAfterSlide, ((event) => {
                this.onAfterSlide && this.onAfterSlide(event.detail);
            }));
        }
        if (this.onPosterClick) {
            this._elementRef.nativeElement.addEventListener(LgMethods.onPosterClick, ((event) => {
                this.onPosterClick && this.onPosterClick(event.detail);
            }));
        }
        if (this.onDragStart) {
            this._elementRef.nativeElement.addEventListener(LgMethods.onDragStart, ((event) => {
                this.onDragStart && this.onDragStart(event.detail);
            }));
        }
        if (this.onDragMove) {
            this._elementRef.nativeElement.addEventListener(LgMethods.onDragMove, ((event) => {
                this.onDragMove && this.onDragMove(event.detail);
            }));
        }
        if (this.onDragEnd) {
            this._elementRef.nativeElement.addEventListener(LgMethods.onDragEnd, ((event) => {
                this.onDragEnd && this.onDragEnd(event.detail);
            }));
        }
        if (this.onBeforeNextSlide) {
            this._elementRef.nativeElement.addEventListener(LgMethods.onBeforeNextSlide, ((event) => {
                this.onBeforeNextSlide &&
                    this.onBeforeNextSlide(event.detail);
            }));
        }
        if (this.onBeforePrevSlide) {
            this._elementRef.nativeElement.addEventListener(LgMethods.onBeforePrevSlide, ((event) => {
                this.onBeforePrevSlide &&
                    this.onBeforePrevSlide(event.detail);
            }));
        }
        if (this.onBeforeClose) {
            this._elementRef.nativeElement.addEventListener(LgMethods.onBeforeClose, ((event) => {
                this.onBeforeClose && this.onBeforeClose(event.detail);
            }));
        }
        if (this.onAfterClose) {
            this._elementRef.nativeElement.addEventListener(LgMethods.onAfterClose, ((event) => {
                this.onAfterClose && this.onAfterClose(event.detail);
            }));
        }
        if (this.onRotateLeft) {
            this._elementRef.nativeElement.addEventListener(LgMethods.onRotateLeft, ((event) => {
                this.onRotateLeft && this.onRotateLeft(event.detail);
            }));
        }
        if (this.onRotateRight) {
            this._elementRef.nativeElement.addEventListener(LgMethods.onRotateRight, ((event) => {
                this.onRotateRight && this.onRotateRight(event.detail);
            }));
        }
        if (this.onFlipHorizontal) {
            this._elementRef.nativeElement.addEventListener(LgMethods.onFlipHorizontal, ((event) => {
                this.onFlipHorizontal &&
                    this.onFlipHorizontal(event.detail);
            }));
        }
        if (this.onFlipVertical) {
            this._elementRef.nativeElement.addEventListener(LgMethods.onFlipVertical, ((event) => {
                this.onFlipVertical && this.onFlipVertical(event.detail);
            }));
        }
    }
}
LightgalleryComponent.ɵfac = function LightgalleryComponent_Factory(t) { return new (t || LightgalleryComponent)(i0.ɵɵdirectiveInject(i0.ElementRef)); };
LightgalleryComponent.ɵcmp = i0.ɵɵdefineComponent({ type: LightgalleryComponent, selectors: [["lightgallery"]], inputs: { settings: "settings", onAfterAppendSlide: "onAfterAppendSlide", onInit: "onInit", onHasVideo: "onHasVideo", onContainerResize: "onContainerResize", onAfterAppendSubHtml: "onAfterAppendSubHtml", onBeforeOpen: "onBeforeOpen", onAfterOpen: "onAfterOpen", onSlideItemLoad: "onSlideItemLoad", onBeforeSlide: "onBeforeSlide", onAfterSlide: "onAfterSlide", onPosterClick: "onPosterClick", onDragStart: "onDragStart", onDragMove: "onDragMove", onDragEnd: "onDragEnd", onBeforeNextSlide: "onBeforeNextSlide", onBeforePrevSlide: "onBeforePrevSlide", onBeforeClose: "onBeforeClose", onAfterClose: "onAfterClose", onRotateLeft: "onRotateLeft", onRotateRight: "onRotateRight", onFlipHorizontal: "onFlipHorizontal", onFlipVertical: "onFlipVertical" }, ngContentSelectors: _c0, decls: 1, vars: 0, template: function LightgalleryComponent_Template(rf, ctx) { if (rf & 1) {
        i0.ɵɵprojectionDef();
        i0.ɵɵprojection(0);
    } }, encapsulation: 2 });
/*@__PURE__*/ (function () { i0.ɵsetClassMetadata(LightgalleryComponent, [{
        type: Component,
        args: [{
                selector: 'lightgallery',
                template: '<ng-content></ng-content>',
                styles: [],
            }]
    }], function () { return [{ type: i0.ElementRef }]; }, { settings: [{
            type: Input
        }], onAfterAppendSlide: [{
            type: Input
        }], onInit: [{
            type: Input
        }], onHasVideo: [{
            type: Input
        }], onContainerResize: [{
            type: Input
        }], onAfterAppendSubHtml: [{
            type: Input
        }], onBeforeOpen: [{
            type: Input
        }], onAfterOpen: [{
            type: Input
        }], onSlideItemLoad: [{
            type: Input
        }], onBeforeSlide: [{
            type: Input
        }], onAfterSlide: [{
            type: Input
        }], onPosterClick: [{
            type: Input
        }], onDragStart: [{
            type: Input
        }], onDragMove: [{
            type: Input
        }], onDragEnd: [{
            type: Input
        }], onBeforeNextSlide: [{
            type: Input
        }], onBeforePrevSlide: [{
            type: Input
        }], onBeforeClose: [{
            type: Input
        }], onAfterClose: [{
            type: Input
        }], onRotateLeft: [{
            type: Input
        }], onRotateRight: [{
            type: Input
        }], onFlipHorizontal: [{
            type: Input
        }], onFlipVertical: [{
            type: Input
        }] }); })();
//# sourceMappingURL=data:application/json;base64,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