@extends('layouts.app')

@section('added_css')
<link rel="stylesheet" href="{{asset('css/datatable/datatables.min.css')}}" />
<link rel="stylesheet" type="text/css" href="{{asset('chart.js/dist/Chart.min.css')}}">
<script src="{{asset('chart.js/dist/Chart.js')}}"></script>
<style>
    .m-footer {
        color: #ff1308 !important;
        font-weight: 600;
    }

    .small-box>.inner {
        padding: 0.75rem;
    }

    .small-box {
        margin-bottom: 10px;
    }


    .text-styling {
        font-size: 14px;
        color: #000;

    }

    .text-center {
        font-size: 14px;
        color: #000;
    }

    .table>thead>tr>th {
        background: #e8e8e8;
        color: #000000 !important;
        font-weight: 400;
        padding-left: 8px;
        border-bottom: 1px #cbcbcb solid !important;
        text-transform: uppercase;
        font-weight: 500;
        font-size: 0.70rem;
    }


    .m-thead {
        font-family: Lato;
        font-weight: 700 !important;
        font-size: 15px !important;
    }


    .m-thead-mobile {
        font-family: Lato;
        font-weight: 600 !important;
        font-size: 13px !important;

    }
</style>
@endsection

@section('content')
<div style="padding-top: 16px;margin-left: 8px">

    <div style="margin-top:8px;padding-left: 10px;padding-right: 10px;">
        <div class="box" style="margin-bottom: 0.5em;border: none;">
            <div class="filters" style="margin-bottom: 4px;">
                <div class="row">
                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Province :</span>
                            </div>
                            <select id="provinces_filter" class="form-control select2 m-tout dt_filter" column="province_id" table="">
                                <option value="all" selected>Indifferent</option>
                                @foreach($provinces as $province)
                                <option value="{{$province->id}}">{{$province->nom}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>


                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Arrondissement :</span>
                            </div>
                            <select id="arrondissements_filter" class="form-control select2 m-tout dt_filter" column="arrondissement_id" table="">
                                <option value="all" selected>Indifferent</option>

                                @foreach($arrondissements as $arrondissement)
                                <option value="{{$arrondissement->id}}">{{$arrondissement->nom}}</option>
                                @endforeach

                            </select>
                        </div>
                    </div>

                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Annexe Administrative :</span>
                            </div>
                            <select id="annexes_administratives_filter" class="form-control select2 m-tout dt_filter" column="annexe_administrative_id" table="">
                                <option value="all" selected>Indifferent</option>

                                @foreach($annexes_administratives as $annexe)
                                <option value="{{$annexe->id}}">{{$annexe->nom}}</option>
                                @endforeach

                            </select>
                        </div>
                    </div>

                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Douar :</span>
                            </div>
                            <select id="douars_filter" class="form-control select2 m-tout dt_filter" column="douar_id" table="">
                                <option value="all" selected>Indifferent</option>
                                @foreach($douars as $douar)
                                <option value="{{$douar->id}}">{{$douar->nom}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>



                <div class="row">

                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Démolution :</span>
                            </div>
                            <select id="demolution_filter" class="form-control select2 m-tout custom_filter">
                                <option value="all" selected>Indifferent</option>
                                <option value="1">Oui</option>
                                <option value="0">Non</option>
                            </select>
                        </div>
                    </div>

                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Attribution :</span>
                            </div>
                            <select id="relogement_filter" class="form-control select2 m-tout custom_filter">
                                <option value="all" selected>Indifferent</option>
                                <option value="1">Oui</option>
                                <option value="0">Non</option>
                            </select>
                        </div>
                    </div>

                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Zone PA :</span>
                            </div>
                            <select id="zone_pa_filter" class="form-control select2 m-tout custom_filter">
                                <option value="all" selected>Indifferent</option>
                            </select>
                        </div>
                    </div>

                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Reference foncière :</span>
                            </div>
                            <select id="reference_fonciere_filter" class="form-control select2 m-tout custom_filter">
                                <option value="all" selected>Indifferent</option>
                            </select>
                        </div>
                    </div>

                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Commerce :</span>
                            </div>
                            <select id="commerce_filter" class="form-control select2 m-tout custom_filter">
                                <option value="all" selected>Indifferent</option>
                                <option value="1">Oui</option>
                                <option value="0">Non</option>
                            </select>
                        </div>
                    </div>
                </div>
                <hr>
            </div>
        </div>




        <div class="table-responsive">

            <div class="row">
                <div class="col-lg-3">
                    <button class="mr-3 btn dossiers_table_export_excel"><i class="fa fa-file-excel-o"></i> Exporter Excel</button>
                    <span>Nombre des baraques : <b style="color:#63a013" id="dt_baraques_count">0</b></span>
                </div>

                <div class="input-group input-group-sm col-3">
                    <!-- <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text" style="width: 160px;">Nom :</span>
                        </div>
                        <input placeholder="Nom" class="form-control dt_filter" column="menages" table="">
                    </div> -->
                </div>

                <div class="input-group input-group-sm col-3">
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text" style="width: 160px;">CIN :</span>
                        </div>
                        <input placeholder="CIN" class="form-control dt_filter" column="chef_menage_cin" table="menages" params="remove_spaces">
                    </div>
                </div>


                <div class="input-group input-group-sm col-3">
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text" style="width: 160px;">Numero baraque :</span>
                        </div>
                        <input placeholder="Numero baraque" class="form-control dt_filter" column="numero" table="">
                    </div>
                </div>
            </div>

            <table class="table table-striped datatables dataTable no-footer display nowrap" id="baraques_table" style="min-width: 1200px;margin-top: 10px !important;">
                <thead>
                    <th>N°</th>
                    <th>Province</th>
                    <th>Arrondissement</th>
                    <th>Douar</th>
                    <th>Surface</th>
                    <th>Ménages</th>
                    <th>Commerces</th>
                    <th>Demolution</th>                
                    <th>Zone PA</th>
                    <th>Ref Fonciere</th>
                    <th>Attribution</th>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
    </div>
</div>




@endsection
<script>
    var provinces = @json($provinces);
    var arrondissements = @json($arrondissements);
    var annexes_administratives = @json($annexes_administratives);
    var douars = @json($douars);
</script>
@push('added_scripts')
<script src="{{asset('js/baraques/index.js').'?t='.time()}}"></script>
@endpush