@extends('layouts.app')
@section('added_css')
<link rel="stylesheet" href="{{asset('css/datatable/datatables.min.css')}}" />
<link rel="stylesheet" type="text/css" href="{{asset('chart.js/dist/Chart.min.css')}}">
<script src="{{asset('chart.js/dist/Chart.js')}}"></script>
<style>
    .m-footer {
        color: #ff1308 !important;
        font-weight: 600;
    }

    .small-box>.inner {
        padding: 0.75rem;
    }

    .small-box {
        margin-bottom: 10px;
    }

    .text-styling {
        font-size: 14px;
        color: #000;
    }

    .text-center {
        font-size: 14px;
        color: #000;
    }

    .table>thead>tr>th {
        background: #e8e8e8;
        color: #000000 !important;
        font-weight: 400;
        padding-left: 8px;
        border-bottom: 1px #cbcbcb solid !important;
        text-transform: uppercase;
        font-weight: 500;
        font-size: 0.70rem;
    }

    .m-thead {
        font-family: Lato;
        font-weight: 700 !important;
        font-size: 15px !important;
    }

    .m-thead-mobile {
        font-family: Lato;
        font-weight: 600 !important;
        font-size: 13px !important;
    }

    .costume-img-2 {
        max-width: unset !important;
        width: auto;
        margin: 2px 4px !important;
        /* height: 260px; */
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        /* display: inline-block; */
        float: none;
        border-radius: 4px;
        transition: transform 0.2s, 0.35s ease-in-out !important;
        cursor: pointer;
    }

    .photo_side_bar {
        background: #fdfdfd;
        width: 40%;
        position: fixed;
        right: -55%;
        height: 100%;
        z-index: 9999999999;
        box-shadow: 0px 10px 30px 0px rgb(0 0 0 / 30%);
        transition: all 0.35s;
        opacity: 0;
        top: 45px;
    }

    .photo_side_bar.active {
        right: 0px;
        opacity: 1;
    }

    [type=radio]:checked+label,
    [type=radio]:not(:checked)+label {
        font-weight: 300;
        position: relative;
        padding-left: 35px;
        cursor: pointer;
        display: inline-block;
        height: 25px;
        line-height: 25px;
        -webkit-transition: .28s ease;
        -o-transition: .28s ease;
        transition: .28s ease;
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none;
        font-size: 14px;
        font-weight: 400;
    }

    .progress {
        height: 0.8rem !important;
        border-radius: 0px !important;
    }

    . {
        background-color: #115555 !important;
    }

    .progress {
        position: relative;
        /* Make the progress container a positioning context */
    }


    .progress-number {
        position: absolute;
        /* Position the number absolutely */
        top: 50%;
        /* Move it down by 50% */
        left: 50%;
        /* Move it right by 50% */
        transform: translate(-50%, -50%);
        /* Center it precisely */
        font-size: 12px;
        /* Adjust font size as needed */
        color: #c0665b;
        /* Adjust text color as needed */
        font-weight: bold;
        /* Optional: Make the number bold */
        z-index: 1;
        /* Ensure the number is above the progress bar */
    }
</style>
@endsection
@section('content')
<div style="padding-top: 16px;margin-left: 8px">
    <div class="row">
        <div class="col-9">
            <nav class="hk-breadcrumb" aria-label="breadcrumb">
                <ol class="breadcrumb breadcrumb-light bg-transparent">
                    <li class="breadcrumb-item"><a href="{{route('baraques')}}">Baraques</a></li>
                    <li class="breadcrumb-item " aria-current="page">Baraque N°: {{$baraque->equipe->prefix.$baraque->numero}}</li>
                </ol>
            </nav>
            @include('baraques/details_infos_generales')
            @include('baraques/details_occupants')
            @include('baraques/details_commerces')
        </div>
        <div class="col-12 col-md-3 " style="padding-top: 8px;">
            <div class="row" style="background: #f2f2f2; padding: 8px; border-radius: 6px; border: 1px #d2d2d2 solid;">
                <i style="text-align: center; margin: auto; font-size:20px; color: #d07979;" class="fa-regular fa-folder-open"></i>
                <b class="mt-2" style="font-size: 1rem;color: #c0665b;width:100%;text-align: center;">Baraque
                    N° : {{$baraque->equipe->prefix}}{{$baraque->numero}}</b>

                <div class="row mt-3">
                    <div class="d-flex align-items-center w-100">
                        <i class="fa-solid fa-users mr-1"></i>
                        <b style="width: 160px;min-width: 160px;display: inline-block;">Ménages (Enquête)</b>
                        <b style="width: 160px;min-width: 160px;display: inline-block;text-align:center">{{count($baraque->menages)}}</b>
                    </div>
                </div>

                <div class="row mt-2">
                    <div class="d-flex align-items-center w-100">
                        <i class="fa-solid fa-users mr-1"></i>
                        <b style="width: 160px;min-width: 160px;display: inline-block;">Ménages (Recensement)</b>
                        <b style="width: 160px;min-width: 160px;display: inline-block;text-align:center">0</b>
                    </div>
                </div>


                <div class="row mt-2">
                    <div class="d-flex align-items-center w-100">
                        <i class="fa-solid fa-shop mr-1"></i>
                        <b style="width: 160px;min-width: 160px;display: inline-block;">Commerces</b>
                        <b style="width: 160px;min-width: 160px;display: inline-block;text-align:center">{{count($baraque->commerces)}}</b>
                    </div>
                </div>

                <h6>Démolition</h6>

                @if($baraque->baraque_demolie==1)
                <div class="row mt-2" style="width: 100%;">
                    <div class="d-flex align-items-center w-100">
                        <div style="color: #ec4401;" class="d-flex align-items-center w-100">
                            <i class="fa-solid fa-house-circle-xmark mr-1"></i>
                            <b style="width: 160px;min-width: 160px;display: inline-block;">La barque a été démolie </b>
                        </div>
                    </div>
                </div>
                @else
                <div class="row" style="width: 100%;">
                    <div style="color: gray;" class="d-flex align-items-center w-100">
                        <b style="width: 100%;min-width: 160px;display: inline-block;text-align:center"><i class="fa-solid fa-circle-info mr-1"></i>la barque n’a pas encore été démolie</b>
                    </div>
                </div>

                @endif

                <h6>Traitement</h6>
                <div class="row m-step mt-1">
                    <div class="d-flex align-items-center w-100">
                        <i class="fa-regular fa-circle-check mr-1"></i>
                        <b class="me-3" style="width: 160px;min-width: 160px;display: inline-block;">PV d'étude</b>
                        <div class="progress flex-grow-1" style="margin-bottom: 0 !important;margin-left : 15px">
                            <div class="progress-bar " role="progressbar" style="width: {{ ($menages_number > 0) ? ($baraque->DOSSIER_ATTRIBUTION_menage_number / $menages_number) * 100 : 0}}%" aria-valuenow="{{ ($menages_number > 0) ? ($baraque->DOSSIER_ATTRIBUTION_menage_number / $menages_number) * 100 : 0}}" aria-valuemin="0" aria-valuemax="100">

                            </div>
                            <span class="progress-number">{{$baraque->DOSSIER_ATTRIBUTION_menage_number .'/'. $menages_number}}</span>
                        </div>
                    </div>
                </div>



                <div class="row m-step mt-2">
                    <div class="d-flex align-items-center w-100">
                        <i class="fa-regular fa-circle-check mr-1"></i>
                        <b class="me-3" style="width: 160px;min-width: 160px;display: inline-block;">Versement 20 000 DH</b>
                        <div class="progress flex-grow-1" style="margin-bottom: 0 !important;margin-left : 15px">
                            <div class="progress-bar " role="progressbar" style="width: {{ ($menages_number > 0) ? ($baraque->RECU_VERSEMENT_20000_menage_number / $menages_number) * 100 : 0}}%" aria-valuenow="{{ ($menages_number > 0) ? ($baraque->RECU_VERSEMENT_20000_menage_number / $menages_number) * 100 : 0}}" aria-valuemin="0" aria-valuemax="100">

                            </div>
                            <span class="progress-number">{{$baraque->RECU_VERSEMENT_20000_menage_number .'/'. $menages_number}}</span>
                        </div>
                    </div>
                </div>



                <div class="row m-step mt-2">
                    <div class="d-flex align-items-center w-100">
                        <i class="fa-regular fa-circle-check mr-1"></i>
                        <b class="me-3" style="width: 160px;min-width: 160px;display: inline-block;">Attestation d'attribution</b>
                        <div class="progress flex-grow-1" style="margin-bottom: 0 !important;margin-left : 15px">
                            <div class="progress-bar " role="progressbar" style="width: {{ ($menages_number > 0) ? ($baraque->ATTESTATION_AFFECTATION_menage_number / $menages_number) * 100 : 0}}%" aria-valuenow="{{ ($menages_number > 0) ? ($baraque->ATTESTATION_AFFECTATION_menage_number / $menages_number) * 100 : 0}}" aria-valuemin="0" aria-valuemax="100">

                            </div>
                            <span class="progress-number">{{$baraque->ATTESTATION_AFFECTATION_menage_number .'/'. $menages_number}}</span>
                        </div>
                    </div>
                </div>



                <div class="row m-step mt-2">
                    <div class="d-flex align-items-center w-100">
                        <i class="fa-regular fa-circle-check mr-1"></i>
                        <b class="me-3" style="width: 160px;min-width: 160px;display: inline-block;">Règlement 80 000 DH</b>
                        <div class="progress flex-grow-1" style="margin-bottom: 0 !important;margin-left : 15px">
                            <div class="progress-bar " role="progressbar" style="width: {{ ($menages_number > 0) ? ($baraque->REGLEMENT_AVANCE_80000_menage_number / $menages_number) * 100 : 0}}%" aria-valuenow="{{ ($menages_number > 0) ? ($baraque->REGLEMENT_AVANCE_80000_menage_number / $menages_number) * 100 : 0}}" aria-valuemin="0" aria-valuemax="100">

                            </div>
                            <span class="progress-number">{{$baraque->REGLEMENT_AVANCE_80000_menage_number .'/'. $menages_number}}</span>
                        </div>
                    </div>
                </div>



                <div class="row m-step mt-2">
                    <div class="d-flex align-items-center w-100">
                        <i class="fa-regular fa-circle-check mr-1"></i>
                        <b class="me-3" style="width: 160px;min-width: 160px;display: inline-block;">Remise des clés</b>
                        <div class="progress flex-grow-1" style="margin-bottom: 0 !important;margin-left : 15px">
                            <div class="progress-bar " role="progressbar" style="width: {{ ($menages_number > 0) ? ($baraque->ATTESTATION_REMISE_CLES_menage_number / $menages_number) * 100 : 0}}%" aria-valuenow="{{ ($menages_number > 0) ? ($baraque->ATTESTATION_REMISE_CLES_menage_number / $menages_number) * 100 : 0}}" aria-valuemin="0" aria-valuemax="100">

                            </div>
                            <span class="progress-number">{{$baraque->ATTESTATION_REMISE_CLES_menage_number .'/'. $menages_number}}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@include('verification/modals')
@endsection
@push('added_scripts')
<script>
    var baraque = @json($baraque);
</script>
<script src="{{asset('js/baraques/show.js').'?t='.time()}}"></script>
<script src="{{asset('js/baraques/details_infos_generales.js').'?t='.time()}}"></script>
@endpush