@extends('layouts.app')

@section('added_css')
<link rel="stylesheet" href="{{asset('css/datatable/datatables.min.css')}}" />
<link rel="stylesheet" type="text/css" href="{{asset('chart.js/dist/Chart.min.css')}}">
<script src="{{asset('chart.js/dist/Chart.js')}}"></script>
<style>
    .m-footer {
        color: #ff1308 !important;
        font-weight: 600;
    }

    .small-box>.inner {
        padding: 0.75rem;
    }

    .small-box {
        margin-bottom: 10px;
    }


    .text-styling {
        font-size: 14px;
        color: #000;

    }

    .text-center {
        font-size: 14px;
        color: #000;
    }


    .table th,
    .table td {
        border-right: 1px solid #f4f4f4;
    }


    .table-striped tbody tr:nth-of-type(odd) {
        background-color: rgba(0, 0, 0, .05) !important;
    }

    th {
        background-color: unset !important;
    }


    .m-thead {
        font-family: Lato;
        font-weight: 700 !important;
        font-size: 15px !important;
    }


    .m-thead-mobile {
        font-family: Lato;
        font-weight: 600 !important;
        font-size: 13px !important;

    }

    .dashboard_card.active {
        background: #115558 !important;
        border-radius: 8px;
    }
</style>
@endsection

@section('content')
<div style="padding-top: 16px;margin-left: 8px;padding-bottom:12px">



    <div class="row ">

        <div class="col-8">

        </div>
        <div class="col-4">


            <div class="input-group input-group-sm  ">
                <div class="input-group mb-1">
                    <div class="input-group-prepend">
                        <span class="input-group-text" style="width: 140px; color: #b46e1a !important; font-size: 0.85rem; border-style: inset; font-weight: 500;">Province :</span>
                    </div>
                    <select class="form-control select2">
                        <option value="all">Tous</option>
                        @foreach($arrondissements as $arrondissement)

                        <option value="{{$arrondissement->id}}">{{$arrondissement->nom}}</option>
                        @endforeach
                    </select>

                </div>
            </div>


        </div>

    </div>
    <div class="row">
        <b style="margin-bottom:10px;display: block;width:100%;font-size: 1rem; margin-top: 12px; border-bottom: 1px #c0665b dashed; text-align: left;color: #c0665b;padding-left: 12px;">Recensements et dossiers des étude</b>

        <div class="col-sm-2 col-12 mt-2">
            <div class="card card-stats" style="background: #f8f8f8;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                <div class="card-content">
                    <div class="row" style="height:320px">
                        <div class="col">
                            <div class="row" style="margin-top: 6px;width: 100%;  ">

                                <svg style="display: block; margin: auto;" fill="#c0665b" height="80px" width="80px" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512 512" xml:space="preserve">
                                    <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                                    <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                                    <g id="SVGRepo_iconCarrier">
                                        <g>
                                            <g>
                                                <g>
                                                    <path d="M264.533,290.133c-30.148,0-51.2,21.052-51.2,51.2v8.533c0,41.472,23.45,68.267,59.733,68.267 c36.284,0,59.733-26.795,59.733-68.267v-8.533c0-30.148-21.06-51.2-51.2-51.2H264.533z M315.733,341.333v8.533 c0,15.394-4.164,51.2-42.667,51.2c-38.511,0-42.667-35.806-42.667-51.2v-8.533c0-20.736,13.397-34.133,34.133-34.133H281.6 C302.327,307.2,315.733,320.597,315.733,341.333z"></path>
                                                    <path d="M256.256,341.333h-0.094c-4.702,0-8.482,3.823-8.482,8.533c0,4.71,3.857,8.533,8.576,8.533 c4.71,0,8.533-3.823,8.533-8.533C264.789,345.156,260.966,341.333,256.256,341.333z"></path>
                                                    <path d="M298.01,230.374c4.753,0.307,8.806-3.157,9.165-7.851l8.525-110.797c1.894-20.309,29.193-43.46,51.234-43.46H384 c22.46,0,49.749,23.057,51.226,43.324l8.533,110.933c0.341,4.471,4.079,7.876,8.499,7.876c0.213,0,0.444-0.008,0.666-0.026 c4.693-0.358,8.209-4.463,7.851-9.165l-8.533-110.899C449.963,79.036,412.177,51.2,384,51.2h-17.067 c-31.061,0-65.493,29.747-68.241,59.076l-8.533,110.933C289.801,225.911,293.316,230.016,298.01,230.374z"></path>
                                                    <path d="M375.023,108.237c-1.161-3.49-4.42-5.837-8.09-5.837c-3.678,0-6.938,2.347-8.098,5.837 c-6.409,19.243-25.293,19.755-26.035,19.763c-4.719,0-8.533,3.823-8.533,8.533v34.133c0,28.501,19.473,68.267,51.2,68.267 c31.718,0,51.2-39.765,51.2-68.267v-34.133c0-4.71-3.823-8.533-8.533-8.533C417.766,128,381.44,127.462,375.023,108.237z M409.6,170.667c0,23.194-15.223,51.2-34.133,51.2c-18.91,0-34.133-28.006-34.133-51.2v-26.641 c8.354-1.894,18.671-6.656,26.249-16.35c11.947,11.955,31.019,15.693,42.018,16.862V170.667z"></path>
                                                    <path d="M170.667,119.467h8.533c4.71,0,8.533-3.823,8.533-8.533c0-4.71-3.823-8.533-8.533-8.533h-8.533 c-4.719,0-8.533,3.823-8.533,8.533C162.133,115.644,165.948,119.467,170.667,119.467z"></path>
                                                    <path d="M290.389,358.4c4.71,0,8.533-3.823,8.533-8.533c0-4.71-3.823-8.533-8.533-8.533h-0.094c-4.702,0-8.482,3.823-8.482,8.533 C281.813,354.577,285.67,358.4,290.389,358.4z"></path>
                                                    <path d="M85.658,134.426c1.63,16.401,8.764,30.839,9.105,31.522c7.731,15.471,19.43,38.852,58.837,38.852 c39.407,0,51.098-23.381,58.829-38.852c0.341-0.683,7.475-15.121,9.114-31.522c5.274-2.901,8.858-8.525,8.858-14.959V102.4 c0-6.306-3.439-11.819-8.533-14.771v-2.295c0-28.237-22.972-51.2-51.2-51.2h-34.133c-28.237,0-51.2,22.963-51.2,51.2v2.295 C80.23,90.581,76.8,96.094,76.8,102.4v17.067C76.8,125.901,80.384,131.524,85.658,134.426z M93.867,102.4 c4.71,0,8.533-3.823,8.533-8.533v-8.533c0-18.825,15.309-34.133,34.133-34.133h34.133c18.825,0,34.133,15.309,34.133,34.133 v8.533c0,4.71,3.814,8.533,8.533,8.533v17.067c-4.719,0-8.533,3.823-8.533,8.533c0,14.763-7.56,30.174-7.637,30.319 c-8.883,17.766-16.717,29.414-43.563,29.414c-26.854,0-34.688-11.648-43.563-29.406c-0.085-0.154-7.637-15.565-7.637-30.327 c0-4.71-3.823-8.533-8.533-8.533V102.4z"></path>
                                                    <path d="M298.667,426.667c-1.69,0-3.337,0.503-4.736,1.434l-20.864,13.909L252.194,428.1c-1.399-0.93-3.046-1.434-4.727-1.434 c-49.365,0-59.733,23.202-59.733,42.667c0,4.71,3.814,8.533,8.533,8.533c4.71,0,8.533-3.823,8.533-8.533 c0-6.861,0-24.849,40.115-25.583l23.415,15.616c2.867,1.911,6.596,1.911,9.463,0l23.424-15.616 c40.115,0.734,40.115,18.722,40.115,25.583c0,4.71,3.814,8.533,8.533,8.533c4.71,0,8.533-3.823,8.533-8.533 C358.4,449.869,348.032,426.667,298.667,426.667z"></path>
                                                    <path d="M452.83,324.267h-0.034c-4.702,0-8.516,3.797-8.533,8.499l-0.529,136.533c-0.017,4.71,3.78,8.55,8.499,8.568h0.034 c4.702,0,8.516-3.797,8.533-8.499l0.529-136.533C461.346,328.124,457.549,324.284,452.83,324.267z"></path>
                                                    <path d="M128,119.467h8.533c4.71,0,8.533-3.823,8.533-8.533c0-4.71-3.823-8.533-8.533-8.533H128 c-4.719,0-8.533,3.823-8.533,8.533C119.467,115.644,123.281,119.467,128,119.467z"></path>
                                                    <path d="M196.096,274.748l7.142-35.635c43.085,0.973,74.095,11.708,83.601,29.167c2.244,4.139,7.407,5.666,11.571,3.413 c4.139-2.253,5.666-7.433,3.413-11.571c-13.389-24.61-50.68-38.144-105.011-38.144c-4.241-0.077-8.073,2.688-8.917,6.852 l-8.533,42.556c-0.922,4.625,2.065,9.122,6.69,10.044c0.572,0.119,1.126,0.171,1.69,0.171 C191.727,281.6,195.277,278.801,196.096,274.748z"></path>
                                                    <path d="M491.076,264.542c-16.725-16.691-41.856-25.506-72.687-25.506c-4.932,0.094-8.764,3.729-8.789,8.508 c-0.009,1.741-0.606,42.59-34.133,42.59c-33.536,0-34.125-40.841-34.133-42.581c-0.009-4.702-3.831-8.508-8.533-8.508 c-4.719,0-8.533,3.814-8.533,8.533c0,19.081,9.216,53.837,42.667,58.931v43.358c0,4.71,3.814,8.533,8.533,8.533 c4.71,0,8.533-3.823,8.533-8.533V306.5c28.8-4.395,39.646-30.746,42.086-50.185c22.639,1.271,40.823,8.218,52.924,20.309 c10.274,10.249,15.923,24.132,15.923,39.108v136.533c0,4.71,3.814,8.533,8.533,8.533c4.71,0,8.533-3.823,8.533-8.533V315.733 C512,296.192,504.568,278.016,491.076,264.542z"></path>
                                                    <path d="M153.6,221.867c-9.412,0-17.067,7.654-17.067,17.067c0,6.289,3.456,11.733,8.533,14.694v62.106 c0,4.71,3.814,8.533,8.533,8.533c4.71,0,8.533-3.823,8.533-8.533v-62.106c5.069-2.961,8.533-8.405,8.533-14.694 C170.667,229.521,163.004,221.867,153.6,221.867z"></path>
                                                    <path d="M59.733,324.267c-4.719,0-8.533,3.823-8.533,8.533v136.533c0,4.71,3.814,8.533,8.533,8.533 c4.71,0,8.533-3.823,8.533-8.533V332.8C68.267,328.09,64.444,324.267,59.733,324.267z"></path>
                                                    <path d="M119.279,228.77c-0.853-4.147-4.873-6.784-8.926-6.793c-44.826,0-79.113,9.6-96.597,27.042 C4.634,258.133,0,269.099,0,281.6v170.667c0,4.71,3.814,8.533,8.533,8.533c4.71,0,8.533-3.823,8.533-8.533V281.6 c0-7.919,2.867-14.626,8.747-20.506c13.295-13.269,41.574-21.163,78.191-21.982l41.242,197.828 c0.956,4.608,5.495,7.569,10.095,6.613c4.617-0.964,7.578-5.487,6.605-10.095L119.279,228.77z"></path>
                                                </g>
                                            </g>
                                        </g>
                                    </g>
                                </svg>


                            </div>
                            <div class="row" style="width: 100%;text-align: center;padding:8px;background: #2929290f; margin-top: 8px; border-radius: 8px;">
                                <div class="col-12 col-md-6">
                                    <b style="color: #000000;font-size: 0.85rem;">Ménages</b>
                                </div>
                                <div class="col-12 col-md-6">
                                    <b style="color: #000000;font-size: 0.85rem;">0</b>
                                </div>
                            </div>

                            <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                <div class="col">
                                    <h5 class="baraques_count" style="color: #629327;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Dossiers initiés</h5>
                                </div>
                            </div>
                            <div class="row" style="width: 100%;text-align: center;padding:8px">
                                <div class="col-12">
                                    <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                </div>
                            </div>

                            <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                <div class="col">
                                    <h5 class="baraques_count" style="color: #d86629;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Dossiers non inities</h5>
                                </div>
                            </div>
                            <div class="row" style="width: 100%;text-align: center;padding:8px">
                                <div class="col-12">
                                    <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                </div>
                            </div>

                        </div>
                    </div>



                </div>
            </div>
        </div>


        <div class="col-sm-2 col-12 mt-2">
            <div class="card card-stats" style="background: #e8f5e3;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                <div class="card-content">
                    <div class="row" style="height:320px">
                        <div class="col">
                            <div class="row" style="margin-top: 6px;width: 100%;  ">




                                <svg style="display: block; margin: auto;" fill="#c0665b" height="80px" width="80px" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 294.843 294.843" xml:space="preserve">
                                    <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                                    <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                                    <g id="SVGRepo_iconCarrier">
                                        <g>
                                            <path d="M6,40.77c3.313,0,6-2.686,6-6c0-9.256,7.53-16.786,16.786-16.786h53.675l42.243,46.147 c1.137,1.242,2.743,1.949,4.426,1.949h136.928c9.256,0,16.786,7.53,16.786,16.786c0,3.314,2.687,6,6,6s6-2.686,6-6 c0-15.873-12.913-28.786-28.786-28.786H131.771L89.529,7.933c-1.137-1.242-2.743-1.949-4.426-1.949H28.786 C12.913,5.984,0,18.897,0,34.77C0,38.083,2.687,40.77,6,40.77z"></path>
                                            <path d="M266.057,94.104H131.771L89.529,47.957c-1.137-1.242-2.743-1.949-4.426-1.949H28.786C12.913,46.008,0,58.921,0,74.793 v118.628c0,3.313,2.687,6,6,6s6-2.687,6-6V74.793c0-9.256,7.53-16.786,16.786-16.786h53.675l42.243,46.147 c1.137,1.242,2.743,1.949,4.426,1.949h136.928c9.256,0,16.786,7.53,16.786,16.786v137.184c0,9.255-7.53,16.786-16.786,16.786 H28.786c-9.256,0-16.786-7.53-16.786-16.786c0-3.313-2.687-6-6-6s-6,2.687-6,6c0,15.873,12.913,28.786,28.786,28.786h237.271 c15.873,0,28.786-12.913,28.786-28.786V122.89C294.843,107.017,281.93,94.104,266.057,94.104z"></path>
                                        </g>
                                    </g>
                                </svg>

                            </div>
                            <div class="row" style="width: 100%;text-align: center;padding:8px;background: #2929290f; margin-top: 8px; border-radius: 8px;">
                                <div class="col-12 col-md-6">
                                    <b style="color: #000000;font-size: 0.85rem;">Dossiers</b>
                                </div>
                                <div class="col-12 col-md-6">
                                    <b style="color: #000000;font-size: 0.85rem;">0</b>
                                </div>
                            </div>

                            <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                <div class="col">
                                    <h5 class="baraques_count" style="color: #629327;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Dossiers vérifiés</h5>
                                </div>
                            </div>
                            <div class="row" style="width: 100%;text-align: center;padding:8px">
                                <div class="col-12">
                                    <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                </div>
                            </div>

                            <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                <div class="col">
                                    <h5 class="baraques_count" style="color: #d86629;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Dossiers non vérifiés</h5>
                                </div>
                            </div>
                            <div class="row" style="width: 100%;text-align: center;padding:8px">
                                <div class="col-12">
                                    <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                </div>
                            </div>

                        </div>
                    </div>



                </div>
            </div>
        </div>


        <div class="col-sm-2 col-12 mt-2">
            <div class="card card-stats" style="background: #f8f8f8;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                <div class="card-content">
                    <div class="row" style="height:320px">
                        <div class="col">
                            <div class="row" style="margin-top: 6px;width: 100%;  ">

                                <svg style="display: block; margin: auto;" fill="#c0665b" height="80px" width="80px" id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 64.86 62.56">
                                    <defs>

                                        <clipPath id="clippath">
                                            <rect class="cls-3" x="6.42" width="49.05" height="50.53" />
                                        </clipPath>
                                    </defs>
                                    <g>
                                        <g id="SVGRepo_iconCarrier" data-name="SVGRepo iconCarrier">
                                            <g class="cls-4">
                                                <path class="cls-2" d="M19.94,39.92c8.62-4.94.11-.09.33-.31l1.18-2.97c3.19,2.9,7.24,4.49,11.54,4.49,9.62,0,17.45-8.06,17.45-17.97s-7.83-17.97-17.45-17.97S15.54,13.25,15.54,23.16c0,4.42,1.54,8.6,4.36,11.88l-.91,3.44c-.43.44-.61.44-.18.88.21.22.86.56,1.14.56h0ZM32.98,7.45c8.41,0,15.25,7.05,15.25,15.71s-6.84,15.71-15.25,15.71c-4.07,0-7.9-1.63-10.78-4.6-2.88-2.97-4.47-6.91-4.47-11.11,0-8.66,6.84-15.71,15.25-15.71Z" />
                                            </g>
                                        </g>
                                        <g id="SVGRepo_iconCarrier-2" data-name="SVGRepo iconCarrier-2">
                                            <path class="cls-2" d="M40.34,18.91l3.34,3.07c.4.38.29.67-.26.67h-2.51v8.02c0,.55-.46,1.04-1.01,1.04h-4.35v-5.62c0-.55-.49-1.04-1.04-1.04h-2.74c-.55,0-1.04.49-1.04,1.04v5.62h-4.35c-.55,0-1.04-.49-1.04-1.04v-8.02h-2.48c-.55,0-.66-.29-.26-.67l9.76-8.92c.4-.38,1.09-.38,1.53,0l2.22,2v-1.59c0-.55.49-1.04,1.04-1.04h2.16c.55,0,1.01.49,1.01,1.04v5.44h0Z" />
                                        </g>
                                        <path class="cls-2" d="M19.54,33.54l-3.06,4.2s-1.03,3.13.64,4.06,4.02,0,4.02,0l3.24-3.74-1.59-2.97-3.25-1.55Z" />
                                    </g>
                                    <g>
                                        <path class="cls-1" d="M0,52.11v-1.59h8.4v1.59H0ZM3.37,62.43v-10.93h1.67v10.93h-1.67Z" />
                                        <path class="cls-1" d="M11.61,62.56c-1.04,0-1.83-.22-2.35-.65-.52-.43-.78-1.09-.78-1.98s.24-1.48.72-1.9c.48-.42,1.19-.63,2.15-.63h2.42l.11,1.34h-2.52c-.43,0-.76.1-.97.29s-.33.49-.33.89c0,.43.14.75.43.96.29.21.72.31,1.3.31.63,0,1.11-.07,1.42-.21.32-.14.48-.35.48-.64l.17,1.2c-.15.23-.33.42-.55.56s-.47.26-.75.33c-.28.07-.6.11-.95.11ZM13.69,62.43v-5.39c0-.56-.15-.99-.45-1.3s-.72-.46-1.26-.46c-.33,0-.66.05-.99.15-.33.1-.62.25-.87.44l-1.22-.84c.32-.39.75-.69,1.27-.9.53-.22,1.11-.32,1.76-.32,1.06,0,1.89.28,2.47.83.58.55.88,1.33.88,2.33v5.46h-1.59Z" />
                                        <path class="cls-1" d="M17.82,62.43v-11.91h1.67v11.91h-1.67ZM22.98,62.43v-5.15c0-.6-.15-1.06-.46-1.39-.31-.33-.75-.49-1.31-.49s-.97.14-1.27.43c-.3.28-.45.69-.45,1.2l-.17-1.64c.26-.5.6-.89,1.03-1.17.42-.28.89-.41,1.4-.41.92,0,1.64.3,2.14.9.51.6.76,1.46.76,2.56v5.16h-1.67Z" />
                                        <path class="cls-1" d="M30.19,62.56c-.75,0-1.44-.11-2.05-.33-.61-.22-1.16-.55-1.65-.99l.99-1.22c.46.35.92.61,1.37.79.45.18.9.26,1.34.26.66,0,1.16-.1,1.49-.31.33-.21.5-.51.5-.92,0-.32-.11-.54-.33-.67-.22-.13-.51-.22-.87-.26-.36-.04-.74-.07-1.15-.1-.34-.03-.69-.07-1.02-.13-.34-.06-.65-.16-.93-.31-.28-.15-.5-.37-.67-.67s-.25-.69-.25-1.19c0-.9.28-1.57.83-2.02.55-.45,1.37-.67,2.46-.67.67,0,1.29.09,1.86.27.57.18,1.11.46,1.61.83l-1.01,1.22c-.43-.27-.84-.48-1.26-.61s-.81-.2-1.21-.2c-.57,0-.99.1-1.28.29-.28.19-.43.48-.43.87,0,.26.1.44.29.55s.46.18.78.22c.32.03.67.06,1.04.09.35.02.71.06,1.08.12.36.06.7.17,1,.33.31.16.55.41.74.73.19.32.28.76.28,1.32,0,.91-.3,1.59-.89,2.05-.59.45-1.48.68-2.67.68Z" />
                                        <path class="cls-1" d="M38.89,62.56c-.75,0-1.44-.11-2.05-.33-.61-.22-1.16-.55-1.65-.99l.99-1.22c.46.35.92.61,1.37.79.45.18.9.26,1.34.26.66,0,1.16-.1,1.49-.31.33-.21.5-.51.5-.92,0-.32-.11-.54-.33-.67-.22-.13-.51-.22-.87-.26-.36-.04-.74-.07-1.15-.1-.34-.03-.69-.07-1.02-.13-.34-.06-.65-.16-.93-.31-.28-.15-.5-.37-.67-.67s-.25-.69-.25-1.19c0-.9.28-1.57.83-2.02.55-.45,1.37-.67,2.46-.67.67,0,1.29.09,1.86.27.57.18,1.11.46,1.61.83l-1.01,1.22c-.43-.27-.84-.48-1.26-.61s-.81-.2-1.21-.2c-.57,0-.99.1-1.28.29-.28.19-.43.48-.43.87,0,.26.1.44.29.55s.46.18.78.22c.32.03.67.06,1.04.09.35.02.71.06,1.08.12.36.06.7.17,1,.33.31.16.55.41.74.73.19.32.28.76.28,1.32,0,.91-.3,1.59-.89,2.05-.59.45-1.48.68-2.67.68Z" />
                                        <path class="cls-1" d="M44.58,52.2v-1.67h1.67v1.67h-1.67ZM44.58,62.43v-8.5h1.67v8.5h-1.67Z" />
                                        <path class="cls-1" d="M48.79,62.43v-8.5h1.67v8.5h-1.67ZM53.95,62.43v-5.15c0-.6-.15-1.06-.46-1.39-.31-.33-.75-.49-1.31-.49s-.97.14-1.27.43c-.3.29-.45.7-.45,1.22l-.17-1.64c.26-.51.6-.91,1.03-1.19.42-.28.89-.42,1.4-.42.92,0,1.64.3,2.14.9.51.6.76,1.46.76,2.56v5.16h-1.67Z" />
                                        <path class="cls-1" d="M61.64,62.56c-1.18,0-2.1-.33-2.75-.99-.65-.66-.97-1.6-.97-2.82v-.96c0-1.27.31-2.25.94-2.94.63-.69,1.51-1.04,2.64-1.04,1.07,0,1.9.39,2.49,1.18s.88,1.89.88,3.31v.56h-5.73v-1.34h4.14c-.05-.69-.23-1.23-.54-1.61-.31-.39-.72-.58-1.24-.58-.63,0-1.12.21-1.47.62s-.52,1-.52,1.76v1.08c0,.7.19,1.24.56,1.62.37.38.9.56,1.58.56.34,0,.67-.07,1.01-.2.33-.14.63-.33.89-.57l1.1,1.1c-.42.4-.89.72-1.42.94-.52.22-1.05.33-1.58.33Z" />
                                    </g>
                                </svg>



                            </div>


                            <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                <div class="col">
                                    <h5 class="baraques_count" style="color: #629327;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Eligibles</h5>
                                </div>
                            </div>
                            <div class="row" style="width: 100%;text-align: center;padding:8px">
                                <div class="col-12">
                                    <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                </div>
                            </div>

                            <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                <div class="col">
                                    <h5 class="baraques_count" style="color:#f36c6c;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Non eligibles</h5>
                                </div>
                            </div>
                            <div class="row" style="width: 100%;text-align: center;padding:8px">
                                <div class="col-12">
                                    <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                </div>
                            </div>

                        </div>
                    </div>



                </div>
            </div>
        </div>




        <div class="col-sm-6 col-12 mt-2">
            <div class="card card-stats" style="background: #f8f8f8;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                <div class="card-content">
                    <div style="height:320px">
                        <h5 style="margin:6px;color:black">Evolution des initiations des dossiers</h5>
                    </div>
                </div>
            </div>
        </div>


    </div>

    <div class="row ">
        <div class="col-sm-3 col-12 mt-2">
            <div class="card card-stats" style="background: #e8f5e3;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                <div class="card-content">
                    <div class="row" style="height:320px">
                        <div class="col">
                            <div class="row" style="margin-top: 6px;width: 100%;  ">


                                <svg style="display: block; margin: auto;" height="80px" width="80px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                                    <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                                    <g id="SVGRepo_iconCarrier">
                                        <path d="M22 11.7979C22 9.16554 22 7.84935 21.2305 6.99383C21.1598 6.91514 21.0849 6.84024 21.0062 6.76946C20.1506 6 18.8345 6 16.2021 6H15.8284C14.6747 6 14.0979 6 13.5604 5.84678C13.2651 5.7626 12.9804 5.64471 12.7121 5.49543C12.2237 5.22367 11.8158 4.81578 11 4L10.4497 3.44975C10.1763 3.17633 10.0396 3.03961 9.89594 2.92051C9.27652 2.40704 8.51665 2.09229 7.71557 2.01738C7.52976 2 7.33642 2 6.94975 2C6.06722 2 5.62595 2 5.25839 2.06935C3.64031 2.37464 2.37464 3.64031 2.06935 5.25839C2 5.62595 2 6.06722 2 6.94975M21.9913 16C21.9554 18.4796 21.7715 19.8853 20.8284 20.8284C19.6569 22 17.7712 22 14 22H10C6.22876 22 4.34315 22 3.17157 20.8284C2 19.6569 2 17.7712 2 14V11" stroke="#bc7a7a" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M10 13.5L11.3333 15L14 12" stroke="#c0665b" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                                    </g>
                                </svg>
                            </div>
                            <div class="row" style="width: 100%;text-align: center;padding:8px;background: #2929290f; margin-top: 8px; border-radius: 8px;">
                                <div class="col-12 col-md-6">
                                    <b style="color: #000000;font-size: 0.85rem;">Dossiers complets</b>
                                </div>
                                <div class="col-12 col-md-6">
                                    <b style="color: #000000;font-size: 0.85rem;">0 | 0 %</b>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                        <div class="col">
                                            <h5 class="baraques_count" style="color: #629327;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Validés</h5>
                                        </div>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <div class="col-12">
                                            <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                        <div class="col">
                                            <h5 class="baraques_count" style="color: #f36c6c;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Rejetés</h5>
                                        </div>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <div class="col-12">
                                            <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                        <div class="col">
                                            <h5 class="baraques_count" style="color:#e2953c;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Ajournés</h5>
                                        </div>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <div class="col-12">
                                            <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                        <div class="col">
                                            <h5 class="baraques_count" style="color:#919191;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">En attente</h5>
                                        </div>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <div class="col-12">
                                            <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>



        <div class="col-sm-3 col-12 mt-2">
            <div class="card card-stats" style="background: #fef4de;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                <div class="card-content">
                    <div class="row" style="height:320px">
                        <div class="col">
                            <div class="row" style="margin-top: 6px;width: 100%;  ">



                                <svg style="display: block; margin: auto;" height="80px" width="80px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                                    <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                                    <g id="SVGRepo_iconCarrier">
                                        <path d="M14 14H10" stroke="#c0665b" stroke-width="1.5" stroke-linecap="round"></path>
                                        <path d="M22 11.7979C22 9.16554 22 7.84935 21.2305 6.99383C21.1598 6.91514 21.0849 6.84024 21.0062 6.76946C20.1506 6 18.8345 6 16.2021 6H15.8284C14.6747 6 14.0979 6 13.5604 5.84678C13.2651 5.7626 12.9804 5.64471 12.7121 5.49543C12.2237 5.22367 11.8158 4.81578 11 4L10.4497 3.44975C10.1763 3.17633 10.0396 3.03961 9.89594 2.92051C9.27652 2.40704 8.51665 2.09229 7.71557 2.01738C7.52976 2 7.33642 2 6.94975 2C6.06722 2 5.62595 2 5.25839 2.06935C3.64031 2.37464 2.37464 3.64031 2.06935 5.25839C2 5.62595 2 6.06722 2 6.94975M21.9913 16C21.9554 18.4796 21.7715 19.8853 20.8284 20.8284C19.6569 22 17.7712 22 14 22H10C6.22876 22 4.34315 22 3.17157 20.8284C2 19.6569 2 17.7712 2 14V11" stroke="#bc7a7a" stroke-width="1.5" stroke-linecap="round"></path>
                                    </g>
                                </svg>

                            </div>
                            <div class="row" style="width: 100%;text-align: center;padding:8px;background: #2929290f; margin-top: 8px; border-radius: 8px;">
                                <div class="col-12 col-md-6">
                                    <b style="color: #000000;font-size: 0.85rem;">Dossiers incomplets</b>
                                </div>
                                <div class="col-12 col-md-6">
                                    <b style="color: #000000;font-size: 0.85rem;">0 | 0 %</b>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                        <div class="col">
                                            <h5 class="baraques_count" style="color: #629327;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Att. Résidence</h5>
                                        </div>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <div class="col-12">
                                            <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                        <div class="col">
                                            <h5 class="baraques_count" style="color: #f36c6c;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Att. Démolition</h5>
                                        </div>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <div class="col-12">
                                            <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                        <div class="col">
                                            <h5 class="baraques_count" style="color:#e2953c;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Att. Non Imposition</h5>
                                        </div>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <div class="col-12">
                                            <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="col-sm-6 col-12 mt-2">
            <div class="card card-stats" style="background: #f8f8f8;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                <div class="card-content">
                    <div style="height:320px">
                        <h5 style="margin:6px;color:black"> Evolution des traitements des dossiers d’attribution</h5>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <div class="row mt-2">
        <b style="margin-bottom:10px;display: block;width:100%;font-size: 1rem; margin-top: 12px; border-bottom: 1px #c0665b dashed; text-align: left;color: #c0665b;padding-left: 12px;">Affectation</b>

        <div class="col-sm-3 col-12 mt-2">
            <div class="card card-stats" style="background: #f8f8f8;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                <div class="card-content">
                    <div class="row" style="height:380px">
                        <div class="col">

                            <div class="row">
                                <div class="col-md-12 col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                        <div class="col">
                                            <h5 class="baraques_count" style="color: #c36d61;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Autorisations de versement</h5>
                                        </div>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <div class="col-12">
                                            <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="row">
                                <div class="col-md-12 col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                        <div class="col">
                                            <h5 class="baraques_count" style="color: #629327;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Remise</h5>
                                        </div>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <div class="col-12">
                                            <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="row">
                                <div class="col-md-12 col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                        <div class="col">
                                            <h5 class="baraques_count" style="color: #e2953c;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">A Remettre</h5>
                                        </div>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <div class="col-12">
                                            <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="row">
                                <div class="col-md-12 col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                        <div class="col">
                                            <h5 class="baraques_count" style="color: #919191;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">En attente</h5>
                                        </div>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <div class="col-12">
                                            <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="col-sm-3 col-12 mt-2">
            <div class="row mt-2">
                <div class="col-12">
                    <div class="card card-stats" style="background: #e8f5e3;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                        <div class="card-content">
                            <div class="row">
                                <div class="col">
                                    <div class="row">
                                        <div class="col-md-12 col-12">
                                            <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                                <div class="col">
                                                    <h5 class="baraques_count" style="color: #c36d61;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Versements réalisés</h5>
                                                </div>
                                            </div>
                                            <div class="row" style="width: 100%;text-align: center;padding:8px">
                                                <div class="col-12">
                                                    <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mt-2">
                <div class="col-12">
                    <div class="card card-stats" style="background: #fbdfdf;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                        <div class="card-content">
                            <div class="row">
                                <div class="col">
                                    <div class="row">
                                        <div class="col-md-12 col-12">
                                            <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                                <div class="col">
                                                    <h5 class="baraques_count" style="color: #c36d61;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Versements nons réalisés</h5>
                                                </div>
                                            </div>
                                            <div class="row" style="width: 100%;text-align: center;padding:8px">
                                                <div class="col-12">
                                                    <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mt-2">
                <div class="col-12">
                    <div class="card card-stats" style="background: #dde2f4;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                        <div class="card-content">
                            <div class="row">
                                <div class="col">
                                    <div class="row">
                                        <div class="col-md-12 col-12">
                                            <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                                <div class="col">
                                                    <h5 class="baraques_count" style="color: #c36d61;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Avec engagement</h5>
                                                </div>
                                            </div>
                                            <div class="row" style="width: 100%;text-align: center;padding:8px">
                                                <div class="col-12">
                                                    <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mt-2">
                <div class="col-12">
                    <div class="card card-stats" style="background: #fef4de;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                        <div class="card-content">
                            <div class="row">
                                <div class="col">
                                    <div class="row">
                                        <div class="col-md-12 col-12">
                                            <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                                <div class="col">
                                                    <h5 class="baraques_count" style="color: #c36d61;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Sans engagement</h5>
                                                </div>
                                            </div>
                                            <div class="row" style="width: 100%;text-align: center;padding:8px">
                                                <div class="col-12">
                                                    <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>


                        </div>
                    </div>
                </div>
            </div>


        </div>



        <div class="col-sm-3 col-12 mt-2">
            <div class="card card-stats" style="background: #f8f8f8;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                <div class="card-content">
                    <div class="row" style="height:380px">
                        <div class="col">

                            <div class="row" style="margin-top: 6px;width: 100%;  ">

                                <svg style="display: block; margin: auto;" height="80px" width="80px" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" width="62.11" height="72.35" viewBox="0 0 62.11 72.35">

                                    <g>
                                        <rect fill="#ffffff" stroke="#ffffff" x="23.45" y="20.73" width="17.42" height="23.08" rx="8.71" ry="8.71" transform="translate(5.5 -4.67) rotate(9.08)" />
                                        <path fill="#ffffff" stroke="#c0665b" d="M22.93,42.79c-.9-.44-1.46-1.43-1.29-2.47l3.03-18.98c.2-1.27,1.4-2.14,2.67-1.94l13.39,2.14c1.27.2,2.14,1.4,1.94,2.67l-3.03,18.98c-.1.62-.43,1.16-.94,1.52-.5.37-1.12.51-1.74.41l-13.39-2.14c-.23-.04-.45-.11-.65-.2ZM41.03,22.48c-.13-.06-.27-.11-.42-.13l-13.39-2.14c-.83-.13-1.62.44-1.75,1.27l-3.03,18.98c-.13.83.44,1.62,1.27,1.75l13.39,2.14c.4.06.81-.03,1.14-.27.33-.24.55-.59.61-1l3.03-18.98c.11-.68-.25-1.33-.84-1.62Z" />
                                    </g>
                                    <g id="SVGRepo_iconCarrier" data-name="SVGRepo iconCarrier">
                                        <path fill="#ffffff" stroke="#c0665b" d="M40.61,16.91c.14.85.33,1.7.57,2.53.07.24.14.48.22.72.12.38.06.94-.07,1.54v.05c-3.48-.62-7.63-1.37-10.13-1.82-.68-.12-1.35.22-1.65.84.66,2.3,1.87,4.52,2.74,6.78.39,1.01.66,2.3-.21,3.01-.38.3-.87.42-1.35.34-.86-.12-1.53-.67-2.12-1.26-1.45-1.44-2.32-2.79-3.24-4.19-.27,0-.49,0-.6,0-1.3-.06-3.48-.16-4.16-.42-.84-.33-1.66-.87-1.9-1.74s.23-1.92,1.09-2.17l.06-.02-.28-.06c-.85-.2-2.04-1.19-2.3-1.6-.28-.41-.32-.94-.09-1.39.05-.09.11-.17.19-.24-.5-.32-.96-.68-1.38-1.09-1.51-1.22-2.41-4.36-3.88-7.26-.33-1.16,5.34-9.51,6.86-8.95,0,0,.25.07.29.09,7.34,3.74,11.96,3.92,18.71,8.61.78.54,1.36,1.34,1.62,2.25.56,1.95.7,3.65,1.01,5.45Z" />
                                        <path fill="#ffffff" stroke="#c0665b" d="M16.97,17.56c-.38.46-.5,1.08-.31,1.65.13.38.35.72.66.99.29.28.61.53.95.75.38.26.8.46,1.25.58.26.05.51-.13.56-.39.04-.26-.13-.51-.39-.56-.04,0-.09-.02-.13-.04.11.06.02,0,0,0-.08-.03-.16-.07-.24-.1-.17-.08-.33-.17-.49-.27.09.06-.01,0-.03-.02-.05-.03-.09-.06-.13-.09-.08-.05-.15-.11-.23-.17-.13-.1-.26-.21-.39-.32-.05-.05-.11-.1-.16-.15-.03-.03-.06-.06-.08-.09-.07-.07.07.09.01.01-.03-.04-.07-.08-.1-.13-.02-.03-.04-.06-.06-.09s-.01-.03,0,.01c-.01-.03-.03-.05-.04-.08-.02-.04-.03-.08-.05-.13,0-.03-.02-.06-.03-.09.01.05.01.05,0,0,0-.04-.01-.09-.02-.13,0-.03.01-.2,0-.09,0-.04.01-.09.02-.13,0-.03.01-.06.02-.08-.02.05-.02.05,0,0,.02-.04.04-.08.06-.12-.04.07.06-.07.07-.08.17-.2.15-.51-.05-.68-.2-.17-.51-.15-.68.05h0Z" />
                                        <path fill="#ffffff" stroke="#c0665b" d="M21.38,20.29c-.84.1-1.84.23-2.48.83-.64.63-.88,1.56-.61,2.42.29.91,1.14,1.53,1.99,1.88.68.29,1.45.33,2.18.39,1,.1,1.99.14,2.99.13.27-.02.46-.26.44-.53-.02-.27-.26-.46-.53-.44-.71.02-1.42-.03-2.19-.08-.71-.03-1.42-.11-2.11-.24-.05-.01-.1-.03-.16-.04-.12-.03.04.03-.06-.02-.19-.08-.37-.16-.55-.25-.32-.16-.6-.38-.82-.65-.4-.49-.43-1.19-.07-1.72.43-.6,1.41-.67,2.07-.75.61-.08.53-1.04-.09-.96Z" />
                                        <path fill="#ffffff" stroke="#c0665b" d="M33.55,14.65c-1.26.47-2.52.91-3.8,1.32-.25.09-.38.37-.28.62.09.25.37.37.62.28,1.28-.41,2.55-.85,3.8-1.32.25-.09.38-.37.29-.62-.09-.25-.37-.38-.62-.29Z" />
                                        <path fill="#ffffff" stroke="#c0665b" d="M31.09,16.2c.33.83.73,1.63,1.19,2.39.22.36.45.72.7,1.06.13.18.26.36.39.53.07.09.14.18.21.27.03.04.05.08.08.12.06.09-.02-.04.01.02.1.25.37.37.62.29.25-.09.38-.37.29-.62-.2-.37-.44-.72-.71-1.04-.26-.35-.5-.72-.73-1.09-.44-.73-.82-1.49-1.14-2.28-.23-.58-1.14-.25-.91.33h0Z" />
                                        <path fill="#ffffff" stroke="#c0665b" d="M41.81,21.78c.12-.56.21-1.16.06-1.73-.16-.6-.36-1.2-.51-1.81-.28-1.19-.43-2.41-.62-3.62-.09-.61-.2-1.21-.32-1.81-.11-.63-.27-1.24-.48-1.84-.19-.5-.47-.97-.83-1.37-.41-.43-.87-.81-1.37-1.12-1.88-1.26-3.86-2.35-5.94-3.25-1.84-.8-3.74-1.47-5.62-2.17-2.14-.78-4.24-1.67-6.28-2.67-.23-.12-.47-.23-.71-.31-.03,0-.06-.02-.09-.03h-.03c.14.04.13.03-.03-.02-.03,0-.06-.01-.1-.02-.2-.02-.41,0-.6.08-.41.18-.79.43-1.11.74-.97.91-1.85,1.91-2.61,3-.84,1.12-1.59,2.29-2.26,3.52-.23.41-.43.85-.59,1.3-.07.17-.11.36-.14.54-.04.36.12.61.28.94.53,1.09.99,2.21,1.48,3.32.39.96.88,1.87,1.46,2.73.24.34.53.65.85.92.48.39,1.11-.34.63-.74-.64-.52-1.07-1.28-1.44-2.02-.49-.97-.9-1.98-1.34-2.98-.24-.56-.49-1.11-.76-1.65-.01-.03-.19-.42-.2-.41,0,0,.03.16.02.05-.01-.09,0,0,0,.04,0-.03,0-.07.01-.11,0-.06.03-.13.04-.19.01-.04.06-.18,0-.02.02-.05.03-.1.05-.14.07-.2.16-.39.25-.59.54-1.08,1.16-2.12,1.86-3.11.75-1.1,1.58-2.15,2.49-3.12.1-.1.2-.2.3-.3.05-.05.1-.09.15-.14.02-.02.04-.04.06-.05-.08.08.01,0,.02-.02.17-.15.35-.29.53-.42.07-.05.14-.09.22-.13.08-.05-.11.05-.02,0,.02,0,.03-.02.04-.02.04-.02.09-.03.13-.05.02,0,.14-.03.04-.01s.01,0,.03,0c.04,0,.17,0-.02,0,.03,0,.15.02.04,0-.15-.02.12.04.16.05.06.02.12.04.17.07.28.14.56.28.84.42.53.26,1.07.51,1.62.75.98.44,1.98.84,2.98,1.23,1.82.7,3.67,1.33,5.48,2.06,1.91.75,3.76,1.66,5.53,2.71.49.29.97.6,1.44.91.47.28.9.61,1.28.99.75.82.97,1.92,1.18,2.98.23,1.14.37,2.31.56,3.46.19,1.22.47,2.43.84,3.61.15.47.05.95-.05,1.42-.13.61.82.78.95.17h0Z" />
                                        <path fill="#ffffff" stroke="#c0665b" d="M22.99,22.25c2.34,2.67,3.11,4.9,5.63,7.4.59.59,1.26,1.14,2.12,1.26.48.08.96-.05,1.35-.34.87-.72.6-2.01.21-3.01-1.32-3.44-3.42-6.79-3.21-10.47" />
                                        <path fill="#ffffff" stroke="#c0665b" d="M15.69,17.09c.96.94,2.17,1.57,3.29,2.31,1.28.84,2.45,1.83,3.48,2.96,1.88,2.09,3.14,4.65,5,6.75.94,1.07,2.08,2.32,3.63,2.3.72,0,1.38-.39,1.75-1,.34-.56.36-1.27.24-1.9-.15-.66-.37-1.3-.65-1.92-.26-.63-.54-1.26-.82-1.88-.58-1.25-1.09-2.53-1.52-3.83-.37-1.21-.66-2.57-.52-3.85.05-.46.3-.9.53-1.34.26-.48.55-.95.81-1.44.1-.18.18-.36.25-.55.11-.24,0-.52-.23-.64-.24-.11-.53-.01-.64.23-.17.43-.38.85-.63,1.24-.28.46-.53.94-.76,1.43-.48,1.11-.34,2.42-.12,3.58.49,2.65,1.78,5.03,2.8,7.5.35.86,1.16,2.53.12,3.22-.49.32-1.13.18-1.61-.07-.6-.31-1.08-.83-1.54-1.32-1.87-1.98-3.09-4.46-4.84-6.54-1.08-1.29-2.32-2.44-3.7-3.4-1.23-.85-2.61-1.52-3.68-2.58-.44-.44-1.07.3-.63.74h0Z" />
                                    </g>
                                    <path fill="#ffffff" stroke="#c0665b" class="cls-4" d="M6.85,33.91h48.35s18.27,25.4-6.91,37.94H14.68s-25.76-8.58-7.83-37.94Z" />
                                </svg>
                            </div>


                            <div class="row">
                                <div class="col-md-12 col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;margin-bottom:12px">
                                        <div class="col">
                                            <h5 class="baraques_count" style="color:#c36d61;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Tirage au sort</h5>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12 col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                        <div class="col">
                                            <h5 class="baraques_count" style="color: #629327;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Effectués</h5>
                                        </div>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <div class="col-12">
                                            <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12 col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                        <div class="col">
                                            <h5 class="baraques_count" style="color: #e2953c;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">En attente</h5>
                                        </div>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <div class="col-12">
                                            <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>



        <div class="col-sm-3 col-12 mt-2">

            <div class="row">
                <div class="col-12">
                    <div class="card card-stats" style="background: #f8f8f8;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                        <div class="card-content">
                            <div class="row">
                                <div class="col">

                                    <div class="row" style="margin-top: 6px;width: 100%;">

                                        <svg height="80px" width="80px" style="display: block; margin: auto;" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                                            <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                                            <g id="SVGRepo_iconCarrier">
                                                <path d="M5 3V2.25C4.58579 2.25 4.25 2.58579 4.25 3H5ZM19 21V21.75C19.4142 21.75 19.75 21.4142 19.75 21H19ZM5 21H4.25C4.25 21.4142 4.58579 21.75 5 21.75V21ZM14 3L14.5303 2.46967C14.3897 2.32902 14.1989 2.25 14 2.25V3ZM19 8H19.75C19.75 7.80109 19.671 7.61032 19.5303 7.46967L19 8ZM15.5305 12.5303C15.8233 12.2374 15.8233 11.7626 15.5305 11.4697C15.2376 11.1768 14.7627 11.1768 14.4698 11.4697L15.5305 12.5303ZM10.8001 16.2L10.2698 16.7304C10.5627 17.0233 11.0375 17.0233 11.3304 16.7304L10.8001 16.2ZM9.53036 13.8697C9.23747 13.5768 8.76259 13.5768 8.4697 13.8697C8.17681 14.1626 8.17682 14.6375 8.46971 14.9304L9.53036 13.8697ZM4.25 5C4.25 5.41421 4.58579 5.75 5 5.75C5.41421 5.75 5.75 5.41421 5.75 5H4.25ZM5.75 9C5.75 8.58579 5.41421 8.25 5 8.25C4.58579 8.25 4.25 8.58579 4.25 9H5.75ZM18.25 12C18.25 12.4142 18.5858 12.75 19 12.75C19.4142 12.75 19.75 12.4142 19.75 12H18.25ZM19.75 16C19.75 15.5858 19.4142 15.25 19 15.25C18.5858 15.25 18.25 15.5858 18.25 16H19.75ZM19 20.25H5V21.75H19V20.25ZM5 3.75H14V2.25H5V3.75ZM13.4697 3.53033L18.4697 8.53033L19.5303 7.46967L14.5303 2.46967L13.4697 3.53033ZM12.25 3V7H13.75V3H12.25ZM15 9.75H19V8.25H15V9.75ZM12.25 7C12.25 8.51878 13.4812 9.75 15 9.75V8.25C14.3096 8.25 13.75 7.69036 13.75 7H12.25ZM14.4698 11.4697L10.2698 15.6697L11.3304 16.7304L15.5305 12.5303L14.4698 11.4697ZM8.46971 14.9304L10.2698 16.7304L11.3304 15.6697L9.53036 13.8697L8.46971 14.9304ZM5.75 5V3H4.25V5H5.75ZM5.75 21V9H4.25V21H5.75ZM18.25 8V12H19.75V8H18.25ZM18.25 16V21H19.75V16H18.25Z" fill="#c0665b"></path>
                                            </g>
                                        </svg>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-12 col-12">
                                            <div class="row" style="width: 100%;text-align: center;padding:8px;margin-bottom:12px">
                                                <div class="col">
                                                    <h5 class="baraques_count" style="color:#c36d61;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Attributions accusés</h5>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-12 col-12">

                                            <div class="row" style="width: 100%;text-align: center;padding:8px">
                                                <div class="col-12">
                                                    <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                                </div>
                                            </div>
                                        </div>
                                    </div>


                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mt-2">
                <div class="col-12">
                    <div class="card card-stats" style="background: #f8f8f8;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                        <div class="card-content">
                            <div class="row">
                                <div class="col">

                                    <div class="row" style="margin-top: 6px;width: 100%;">
                                        <svg style="display: block; margin: auto;" height="80px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                                            <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                                            <g id="SVGRepo_iconCarrier">
                                                <path d="M5 3V2.25C4.58579 2.25 4.25 2.58579 4.25 3H5ZM19 21V21.75C19.4142 21.75 19.75 21.4142 19.75 21H19ZM5 21H4.25C4.25 21.4142 4.58579 21.75 5 21.75V21ZM14 3L14.5303 2.46967C14.3897 2.32902 14.1989 2.25 14 2.25V3ZM19 8H19.75C19.75 7.80109 19.671 7.61032 19.5303 7.46967L19 8ZM15.0303 12.0303C15.3232 11.7374 15.3232 11.2626 15.0303 10.9697C14.7374 10.6768 14.2626 10.6768 13.9697 10.9697L15.0303 12.0303ZM8.96967 15.9697C8.67678 16.2626 8.67678 16.7374 8.96967 17.0303C9.26256 17.3232 9.73744 17.3232 10.0303 17.0303L8.96967 15.9697ZM10.0303 10.9697C9.73744 10.6768 9.26256 10.6768 8.96967 10.9697C8.67678 11.2626 8.67678 11.7374 8.96967 12.0303L10.0303 10.9697ZM13.9697 17.0303C14.2626 17.3232 14.7374 17.3232 15.0303 17.0303C15.3232 16.7374 15.3232 16.2626 15.0303 15.9697L13.9697 17.0303ZM4.25 5C4.25 5.41421 4.58579 5.75 5 5.75C5.41421 5.75 5.75 5.41421 5.75 5H4.25ZM5.75 9C5.75 8.58579 5.41421 8.25 5 8.25C4.58579 8.25 4.25 8.58579 4.25 9H5.75ZM18.25 12C18.25 12.4142 18.5858 12.75 19 12.75C19.4142 12.75 19.75 12.4142 19.75 12H18.25ZM19.75 16C19.75 15.5858 19.4142 15.25 19 15.25C18.5858 15.25 18.25 15.5858 18.25 16H19.75ZM19 20.25H5V21.75H19V20.25ZM5 3.75H14V2.25H5V3.75ZM13.4697 3.53033L18.4697 8.53033L19.5303 7.46967L14.5303 2.46967L13.4697 3.53033ZM12.25 3V7H13.75V3H12.25ZM15 9.75H19V8.25H15V9.75ZM12.25 7C12.25 8.51878 13.4812 9.75 15 9.75V8.25C14.3096 8.25 13.75 7.69036 13.75 7H12.25ZM13.9697 10.9697L8.96967 15.9697L10.0303 17.0303L15.0303 12.0303L13.9697 10.9697ZM8.96967 12.0303L13.9697 17.0303L15.0303 15.9697L10.0303 10.9697L8.96967 12.0303ZM5.75 5V3H4.25V5H5.75ZM5.75 21V9H4.25V21H5.75ZM18.25 8V12H19.75V8H18.25ZM18.25 16V21H19.75V16H18.25Z" fill="#c0665b"></path>
                                            </g>
                                        </svg>
                                    </div>



                                    <div class="row">
                                        <div class="col-md-12 col-12">
                                            <div class="row" style="width: 100%;text-align: center;padding:8px;margin-bottom:12px">
                                                <div class="col">
                                                    <h5 class="baraques_count" style="color:#c36d61;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Attributions non accuses</h5>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-md-12 col-12">

                                            <div class="row" style="width: 100%;text-align: center;padding:8px">
                                                <div class="col-12">
                                                    <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>


    </div>


    <div class="row mt-2">
        <b style="margin-bottom:10px;display: block;width:100%;font-size: 1rem; margin-top: 12px; border-bottom: 1px #c0665b dashed; text-align: left;color: #c0665b;padding-left: 12px;">Finalisation et remise des clés</b>



        <div class="col-sm-6 col-12 mt-2">
            <div class="card card-stats" style="background: #e8f5e3;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                <div class="card-content">
                    <div class="row">
                        <div class="col">

                            <div class="row" style="width: 100%;text-align: center;padding:8px;background: #2929290f; margin-top: 8px; border-radius: 8px;">
                                <div class="col-12 col-md-6">
                                    <b style="color: #000000;font-size: 0.85rem;">Compromis de vente</b>
                                </div>
                                <div class="col-12 col-md-6">
                                    <b style="color: #000000;font-size: 0.85rem;">0 | 0 %</b>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                        <div class="col">
                                            <h5 class="baraques_count" style="color: #629327;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Remis</h5>
                                        </div>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <div class="col-12">
                                            <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                        <div class="col">
                                            <h5 class="baraques_count" style="color: #f36c6c;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">En attente</h5>
                                        </div>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <div class="col-12">
                                            <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="col-sm-6 col-12 mt-2">
            <div class="card card-stats" style="background: #e8f5e3;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                <div class="card-content">
                    <div class="row">
                        <div class="col">

                            <div class="row" style="width: 100%;text-align: center;padding:8px;background: #2929290f; margin-top: 8px; border-radius: 8px;">
                                <div class="col-12 col-md-6">
                                    <b style="color: #000000;font-size: 0.85rem;">Remise des clés</b>
                                </div>
                                <div class="col-12 col-md-6">
                                    <b style="color: #000000;font-size: 0.85rem;">0 | 0 %</b>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                        <div class="col">
                                            <h5 class="baraques_count" style="color: #629327;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Remis</h5>
                                        </div>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <div class="col-12">
                                            <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                        <div class="col">
                                            <h5 class="baraques_count" style="color: #f36c6c;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">En attente</h5>
                                        </div>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <div class="col-12">
                                            <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-2">
        <b style="margin-bottom:10px;display: block;width:100%;font-size: 1rem; margin-top: 12px; border-bottom: 1px #c0665b dashed; text-align: left;color: #c0665b;padding-left: 12px;">Projets de destination / stock</b>


        <div class="col-sm-3 col-12 mt-2">
            <div class="card card-stats" style="background: #e8f5e3;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                <div class="card-content">
                    <div class="row">
                        <div class="col">



                            <div class="row" style="margin-top: 6px;width: 100%;">
                                <svg fill="#c0665b" height="80px" width="80px" style="display: block; margin: auto;" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512 512" xml:space="preserve">
                                    <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                                    <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                                    <g id="SVGRepo_iconCarrier">
                                        <g>
                                            <g>
                                                <path d="M501.945,57.442c-14.13-14.13-40.454-13.257-74.122,2.455c-1.331,0.621-2.678,1.291-4.023,1.952l-28.358-7.51 c-25.169-6.667-51.816,5.443-63.344,28.796l-7.709,15.619c-11.629,23.554-34.132,39.561-60.197,42.819 c-4.752,0.594-8.124,4.929-7.531,9.682c0.549,4.389,4.285,7.599,8.596,7.599c0.36,0,0.722-0.023,1.087-0.068 c31.868-3.983,59.381-23.554,73.599-52.353l7.71-15.62c7.888-15.979,26.116-24.269,43.347-19.706l10.966,2.904 c-23.721,14.679-48.462,34.554-71.754,57.846c-34.18,34.18-61.535,72.305-75.052,104.603c-0.012,0.028-0.017,0.057-0.028,0.084 c-0.02,0.047-0.043,0.091-0.061,0.139l-8.964,23.203c-3.737,9.672-10.879,17.597-20.112,22.316l-19.533,9.983 c-2.651,1.354-4.421,3.974-4.691,6.938l-4.907,53.973c-0.234,2.564,0.685,5.099,2.505,6.918c1.634,1.634,3.843,2.541,6.133,2.541 c0.261,0,0.524-0.012,0.786-0.036l53.973-4.907c2.964-0.269,5.584-2.04,6.939-4.691l9.983-19.532 c4.719-9.232,12.644-16.375,22.317-20.112l23.203-8.964c0.038-0.015,0.074-0.035,0.112-0.05c0.036-0.015,0.074-0.024,0.11-0.039 c32.3-13.518,70.426-40.874,104.603-75.052c8.086-8.086,15.873-16.465,23.143-24.904c3.126-3.629,2.719-9.106-0.91-12.232 c-3.629-3.125-9.105-2.721-12.233,0.91c-6.99,8.114-14.481,16.175-22.266,23.959c-30.76,30.762-64.592,55.619-93.742,68.994 l-48.033-48.033c13.373-29.15,38.231-62.979,68.994-93.742c26.416-26.416,54.603-48.169,80.649-62.393l54.534,54.533 c-5.742,10.485-12.811,21.5-21.086,32.784c-2.832,3.863-1.998,9.291,1.864,12.124c3.864,2.833,9.29,2,12.124-1.864 c18.27-24.912,31.188-48.942,37.357-69.493C516.776,80.322,509.558,65.055,501.945,57.442z M304.021,292.935l-10.773,4.162 c-13.658,5.277-24.849,15.362-31.512,28.399l-7.806,15.275l-25.352,2.305l7.102-7.102c0.838,0.142,1.686,0.226,2.535,0.226 c3.85,0,7.7-1.465,10.63-4.396c5.862-5.862,5.862-15.4,0-21.262c-2.84-2.84-6.615-4.404-10.63-4.404 c-4.015,0-7.791,1.565-10.631,4.404c-3.577,3.577-4.959,8.521-4.17,13.166l-7.102,7.103l2.305-25.352l15.275-7.806 c13.036-6.664,23.123-17.855,28.398-31.512l4.162-10.773L304.021,292.935z M491.306,104.828 c-1.435,4.781-3.296,9.796-5.548,14.999l-46.193-46.192c23.699-10.274,42.254-11.786,50.111-3.927 C495.715,75.745,496.293,88.218,491.306,104.828z"></path>
                                            </g>
                                        </g>
                                        <g>
                                            <g>
                                                <path d="M320.511,82.561l-10.954-35.55c-1.121-3.638-4.483-6.12-8.289-6.12H8.674c-2.752,0-5.343,1.307-6.978,3.522 c-1.635,2.215-2.122,5.075-1.311,7.706L37.477,172.5c1.148,3.727,4.58,6.121,8.286,6.121c0.847,0.001,1.708-0.124,2.558-0.385 c4.577-1.411,7.146-6.265,5.735-10.843L20.423,58.239h274.441l9.069,29.431c1.41,4.579,6.262,7.145,10.843,5.735 C319.355,91.994,321.923,87.14,320.511,82.561z"></path>
                                            </g>
                                        </g>
                                        <g>
                                            <g>
                                                <path d="M314.996,453.761H142.293l-79.675-258.58c-1.411-4.577-6.266-7.145-10.843-5.735c-4.577,1.411-7.146,6.265-5.735,10.843 l81.56,264.699c1.121,3.638,4.483,6.12,8.289,6.12h179.107c4.791,0,8.674-3.883,8.674-8.674S319.787,453.761,314.996,453.761z"></path>
                                            </g>
                                        </g>
                                        <g>
                                            <g>
                                                <path d="M436.772,459.881l-51.368-166.703c-1.411-4.577-6.26-7.146-10.843-5.735c-4.577,1.411-7.146,6.265-5.734,10.843 l47.908,155.475h-72.826c-4.791,0-8.674,3.883-8.674,8.674s3.882,8.674,8.674,8.674h84.575c2.754,0,5.343-1.307,6.978-3.522 C437.097,465.371,437.582,462.512,436.772,459.881z"></path>
                                            </g>
                                        </g>
                                        <g>
                                            <g>
                                                <path d="M86.009,106.812H75.705c-4.79,0-8.674,3.883-8.674,8.674s3.884,8.674,8.674,8.674h10.304c4.79,0,8.674-3.883,8.674-8.674 S90.8,106.812,86.009,106.812z"></path>
                                            </g>
                                        </g>
                                        <g>
                                            <g>
                                                <path d="M274.865,106.812H114.922c-4.79,0-8.674,3.883-8.674,8.674s3.884,8.674,8.674,8.674h159.944 c4.791,0,8.674-3.883,8.674-8.674S279.657,106.812,274.865,106.812z"></path>
                                            </g>
                                        </g>
                                        <g>
                                            <g>
                                                <path d="M144.991,147.555H88.253c-4.79,0-8.674,3.883-8.674,8.674s3.883,8.674,8.674,8.674h56.738c4.79,0,8.674-3.883,8.674-8.674 S149.781,147.555,144.991,147.555z"></path>
                                            </g>
                                        </g>
                                        <g>
                                            <g>
                                                <path d="M236.354,147.555h-62.451c-4.79,0-8.674,3.883-8.674,8.674s3.883,8.674,8.674,8.674h62.451 c4.79,0,8.674-3.883,8.674-8.674S241.144,147.555,236.354,147.555z"></path>
                                            </g>
                                        </g>
                                        <g>
                                            <g>
                                                <path d="M250.232,188.287H100.812c-4.79,0-8.674,3.884-8.674,8.674c0,4.79,3.883,8.674,8.674,8.674h149.419 c4.79,0,8.674-3.884,8.674-8.674C258.906,192.171,255.022,188.287,250.232,188.287z"></path>
                                            </g>
                                        </g>
                                        <g>
                                            <g>
                                                <path d="M176.216,229.031H113.36c-4.79,0-8.674,3.884-8.674,8.674c0,4.79,3.884,8.674,8.674,8.674h62.856 c4.79,0,8.674-3.884,8.674-8.674C184.89,232.914,181.006,229.031,176.216,229.031z"></path>
                                            </g>
                                        </g>
                                        <g>
                                            <g>
                                                <path d="M189.985,362.169c-3.32-3.452-8.81-3.562-12.264-0.241l-9.253,8.898l-9.619-8.55c-3.582-3.183-9.063-2.86-12.245,0.721 c-3.184,3.579-2.861,9.061,0.718,12.244l15.613,13.878c1.647,1.464,3.705,2.192,5.762,2.192c2.17,0,4.337-0.811,6.013-2.422 l15.034-14.456C193.198,371.112,193.306,365.621,189.985,362.169z"></path>
                                            </g>
                                        </g>
                                    </g>
                                </svg>

                            </div>
                            <div class="row" style="width: 100%;text-align: center;padding:8px;background: #2929290f; margin-top: 8px; border-radius: 8px;">
                                <div class="col-12 col-md-6">
                                    <b style="color: #000000;font-size: 0.85rem;">Conventions</b>
                                </div>
                                <div class="col-12 col-md-6">
                                    <b style="color: #000000;font-size: 0.85rem;">0</b>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                        <div class="col">
                                            <h5 class="baraques_count" style="line-height: 1;color: #629327;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Autorisations</h5>
                                        </div>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <div class="col-12">
                                            <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                        <div class="col">
                                            <h5 class="baraques_count" style="line-height: 1;color: #f36c6c;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Ouvertures de chantier</h5>
                                        </div>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <div class="col-12">
                                            <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>



        <div class="col-sm-3 col-12 mt-2">
            <div class="row mt-2">
                <div class="col-12">
                    <div class="card card-stats" style="background: #e8f5e3;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                        <div class="card-content">
                            <div class="row">
                                <div class="col">
                                    <div class="row">
                                        <div class="col-md-12 col-12">
                                            <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                                <div class="col">
                                                    <h5 class="baraques_count" style="color: #c36d61;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Réceptions provisoires</h5>
                                                </div>
                                            </div>
                                            <div class="row" style="width: 100%;text-align: center;padding:8px">
                                                <div class="col-12">
                                                    <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mt-2">
                <div class="col-12">
                    <div class="card card-stats" style="background: #fbdfdf;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                        <div class="card-content">
                            <div class="row">
                                <div class="col">
                                    <div class="row">
                                        <div class="col-md-12 col-12">
                                            <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                                <div class="col">
                                                    <h5 class="baraques_count" style="color: #c36d61;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Eclatement des titres</h5>
                                                </div>
                                            </div>
                                            <div class="row" style="width: 100%;text-align: center;padding:8px">
                                                <div class="col-12">
                                                    <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mt-2">
                <div class="col-12">
                    <div class="card card-stats" style="background: #dde2f4;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                        <div class="card-content">
                            <div class="row">
                                <div class="col">
                                    <div class="row">
                                        <div class="col-md-12 col-12">
                                            <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                                <div class="col">
                                                    <h5 class="baraques_count" style="color: #c36d61;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Permis d'habiters</h5>
                                                </div>
                                            </div>
                                            <div class="row" style="width: 100%;text-align: center;padding:8px">
                                                <div class="col-12">
                                                    <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        </div>



        <div class="col-sm-6 col-12 mt-2">
            <div class="card card-stats" style="background: #f8f8f8;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                <div class="card-content">
                    <div style="height:270px">
                        <h5 style="margin:6px;color:black"> Etat d'avancement</h5>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt-2">
        <div class="col-sm-6 col-12 mt-2">
            <div class="card card-stats" style="background: #e8f5e3;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                <div class="card-content">
                    <div class="row">
                        <div class="col">

                            <div class="row" style="margin-top: 6px;width: 100%;">

                                <svg style="display: block; margin: auto;" fill="#c0665b" height="80px" width="80px" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 290.625 290.625" xml:space="preserve">
                                    <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                                    <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                                    <g id="SVGRepo_iconCarrier">
                                        <g>
                                            <g>
                                                <g>
                                                    <path d="M276.563,281.25V60.938h-16.645l-37.5-42.188h-25.542V0H14.062v281.25H4.687v9.375h103.125h18.75h37.5h9.375h37.5h9.375 h37.5h18.75h9.375v-9.375H276.563z M218.213,28.125l29.16,32.813h-50.498V46.875H187.5v14.063h-50.498l29.17-32.813H218.213z M135.938,42.188v-9.375h13.519l-8.334,9.375H135.938z M107.812,281.25H56.25v-70.313h51.563V281.25z M107.812,154.688h-18.75 v-9.375h18.75V154.688z M107.812,117.188h-18.75v-9.375h18.75V117.188z M107.812,79.688h-18.75v-9.375h18.75V79.688z M79.687,60.938v28.125h28.125v9.375H79.687v28.125h28.125v9.375H79.687v28.125h28.125v18.75h-75v9.375h75v9.375h-75v9.375 h14.063v70.313H23.437V9.375H187.5v9.375h-25.542l-4.167,4.688h-31.228v28.125h6.23l-8.334,9.375h-7.27h-9.375H79.687z M154.688,281.25h-18.75v-28.125c0-5.17,4.205-9.375,9.375-9.375c5.17,0,9.375,4.205,9.375,9.375V281.25z M201.563,281.25h-18.75 v-28.125c0-5.17,4.205-9.375,9.375-9.375c5.17,0,9.375,4.205,9.375,9.375V281.25z M248.438,281.25h-18.75v-28.125 c0-5.17,4.205-9.375,9.375-9.375c5.17,0,9.375,4.205,9.375,9.375V281.25z M267.188,281.25h-9.375v-28.125 c0-10.341-8.409-18.75-18.75-18.75s-18.75,8.409-18.75,18.75v28.125h-9.375v-28.125c0-10.341-8.409-18.75-18.75-18.75 s-18.75,8.409-18.75,18.75v28.125h-9.375v-28.125c0-10.341-8.409-18.75-18.75-18.75s-18.75,8.409-18.75,18.75v28.125h-9.375 V164.063v-28.125v-9.375V98.438v-9.375v-18.75h150V281.25z"></path>
                                                    <path d="M164.063,192.188h-37.5v28.125h37.5V192.188z M154.688,210.938h-18.75v-9.375h18.75V210.938z"></path>
                                                    <path d="M210.938,192.188h-37.5v28.125h37.5V192.188z M201.563,210.938h-18.75v-9.375h18.75V210.938z"></path>
                                                    <path d="M257.813,192.188h-37.5v28.125h37.5V192.188z M248.438,210.938h-18.75v-9.375h18.75V210.938z"></path>
                                                    <path d="M164.063,154.688h-37.5v28.125h37.5V154.688z M154.688,173.438h-18.75v-9.375h18.75V173.438z"></path>
                                                    <path d="M210.938,154.688h-37.5v28.125h37.5V154.688z M201.563,173.438h-18.75v-9.375h18.75V173.438z"></path>
                                                    <path d="M257.813,154.688h-37.5v28.125h37.5V154.688z M248.438,173.438h-18.75v-9.375h18.75V173.438z"></path>
                                                    <path d="M164.063,117.188h-37.5v28.125h37.5V117.188z M154.688,135.938h-18.75v-9.375h18.75V135.938z"></path>
                                                    <path d="M210.938,117.188h-37.5v28.125h37.5V117.188z M201.563,135.938h-18.75v-9.375h18.75V135.938z"></path>
                                                    <path d="M257.813,117.188h-37.5v28.125h37.5V117.188z M248.438,135.938h-18.75v-9.375h18.75V135.938z"></path>
                                                    <path d="M164.063,79.688h-37.5v28.125h37.5V79.688z M154.688,98.438h-18.75v-9.375h18.75V98.438z"></path>
                                                    <path d="M210.938,79.688h-37.5v28.125h37.5V79.688z M201.563,98.438h-18.75v-9.375h18.75V98.438z"></path>
                                                    <path d="M257.813,79.688h-37.5v28.125h37.5V79.688z M248.438,98.438h-18.75v-9.375h18.75V98.438z"></path>
                                                    <path d="M32.812,164.063h37.5v-28.125h-37.5V164.063z M42.187,145.313h18.75v9.375h-18.75V145.313z"></path>
                                                    <path d="M32.812,126.563h37.5V98.438h-37.5V126.563z M42.187,107.813h18.75v9.375h-18.75V107.813z"></path>
                                                    <path d="M32.812,89.063h37.5V60.938h-37.5V89.063z M42.187,70.313h18.75v9.375h-18.75V70.313z"></path>
                                                    <path d="M32.812,51.563h37.5V23.438h-37.5V51.563z M42.187,32.813h18.75v9.375h-18.75V32.813z"></path>
                                                    <path d="M79.687,51.563h37.5V23.438h-37.5V51.563z M89.062,32.813h18.75v9.375h-18.75V32.813z"></path>
                                                </g>
                                            </g>
                                        </g>
                                    </g>
                                </svg>
                            </div>

                            <div class="row" style="width: 100%;text-align: center;padding:8px;background: #2929290f; margin-top: 8px; border-radius: 8px;">
                                <div class="col-12 col-md-6">
                                    <b style="color: #000000;font-size: 0.85rem;">Stock</b>
                                </div>
                                <div class="col-12 col-md-6">
                                    <b style="color: #000000;font-size: 0.85rem;">0</b>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                        <div class="col">
                                            <h5 class="baraques_count" style="color: #629327;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Assignés</h5>
                                        </div>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <div class="col-12">
                                            <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                        <div class="col">
                                            <h5 class="baraques_count" style="color: #f36c6c;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Non asignes</h5>
                                        </div>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <div class="col-12">
                                            <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>



        <div class="col-sm-6 col-12 mt-2">
            <div class="card card-stats" style="background: #e8f5e3;border: 1px solid #bababa ; border-radius: 6px; box-shadow: 0px 0px 10px 2px rgb(0 0 0 / 15%) !important;">
                <div class="card-content">
                    <div class="row">
                        <div class="col">

                            <div class="row" style="margin-top: 6px;width: 100%;">


                                <svg style="display: block; margin: auto;" fill="#c0665b" height="80px" width="80px" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 433.511 433.511" xml:space="preserve">
                                    <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                                    <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                                    <g id="SVGRepo_iconCarrier">
                                        <g>
                                            <g>
                                                <path d="M411.192,122.541c7.328-22.894-7.238-53.834-35.826-74.315c-36.5-26.148-94.756-34.427-154.953,13.794l-33.956-33.956 c-2.929-2.928-7.677-2.928-10.607,0L2.196,201.713C0.79,203.121,0,205.027,0,207.018c0,1.99,0.79,3.896,2.196,5.304l73.795,73.795 c1.407,1.406,3.314,2.196,5.304,2.196c1.99,0,3.896-0.79,5.304-2.196l173.65-173.652c2.929-2.93,2.929-7.678,0-10.607 l-29.142-29.141c53.308-41.798,103.942-34.92,135.521-12.297c19.78,14.171,31.926,34.296,31.521,50.158 c-15.089-11.295-33.331-17.409-52.518-17.409c-23.473,0-45.541,9.142-62.14,25.739c-13.595,13.595-22.193,30.818-24.868,49.809 c-2.323,16.493,0.154,33.564,6.984,48.666l-131.05,131.049c-1.406,1.407-2.196,3.314-2.196,5.305v46.407 c0,4.143,3.357,7.5,7.5,7.5h46.406c1.989,0,3.896-0.79,5.304-2.195l138.008-138.004c5.293,0.979,10.681,1.473,16.068,1.474 c0.002,0-0.001,0,0.002,0c23.467,0,45.53-9.139,62.122-25.729c16.599-16.6,25.738-38.666,25.737-62.139 C433.513,159.245,425.615,138.662,411.192,122.541z M244.339,107.16L81.295,270.205l-63.188-63.188L181.153,43.973l27.858,27.858 c-2.471,2.271-4.942,4.629-7.414,7.101c-2.929,2.93-2.929,7.678,0,10.607c2.93,2.928,7.678,2.928,10.607,0 c2.478-2.478,4.953-4.832,7.425-7.089L244.339,107.16z M397.169,232.578c-13.759,13.76-32.055,21.337-51.518,21.337 c-5.648-0.001-11.298-0.655-16.785-1.947c-2.527-0.595-5.186,0.161-7.021,1.997l-138.68,138.677h-35.8V356.84l28.565-28.564 l8.862,8.859c1.465,1.464,3.384,2.196,5.303,2.196c1.92,0,3.839-0.731,5.304-2.197c2.929-2.93,2.929-7.678-0.001-10.605 l-8.861-8.859l19.068-19.067l14.354,14.355c1.465,1.465,3.384,2.197,5.304,2.197c1.919,0,3.839-0.732,5.304-2.196 c2.93-2.929,2.93-7.678,0-10.605l-14.354-14.357l17.653-17.653l8.859,8.859c1.465,1.464,3.385,2.196,5.305,2.196 c1.918,0,3.838-0.732,5.304-2.196c2.929-2.93,2.929-7.678,0-10.607l-8.859-8.858l35.539-35.539 c2.335-2.335,2.867-5.923,1.313-8.836c-15.213-28.492-10.077-62.99,12.776-85.844c13.766-13.766,32.066-21.347,51.532-21.347 s37.767,7.581,51.531,21.347c13.766,13.765,21.348,32.066,21.348,51.533C418.515,200.513,410.934,218.815,397.169,232.578z"></path>
                                                <path d="M357.564,135.673c-4.42-4.422-11.592-4.424-16.014,0c-4.422,4.422-4.422,11.592,0,16.016l33.441,33.441 c4.424,4.422,11.594,4.422,16.016,0c4.422-4.424,4.424-11.592,0-16.016L357.564,135.673z"></path>
                                            </g>
                                        </g>
                                    </g>
                                </svg>
                            </div>

                            <div class="row" style="width: 100%;text-align: center;padding:8px;background: #2929290f; margin-top: 8px; border-radius: 8px;">
                                <div class="col-12 col-md-6">
                                    <b style="color: #000000;font-size: 0.85rem;">Appartments</b>
                                </div>
                                <div class="col-12 col-md-6">
                                    <b style="color: #000000;font-size: 0.85rem;">0</b>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                        <div class="col">
                                            <h5 class="baraques_count" style="color: #629327;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Affectés</h5>
                                        </div>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <div class="col-12">
                                            <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6 col-12">
                                    <div class="row" style="width: 100%;text-align: center;padding:8px;border-bottom:1px gray dashed">
                                        <div class="col">
                                            <h5 class="baraques_count" style="color: #f36c6c;text-align: center;width: 100%;font-size:1.1rem;margin-bottom: 0px !important;">Non affectés</h5>
                                        </div>
                                    </div>
                                    <div class="row" style="width: 100%;text-align: center;padding:8px">
                                        <div class="col-12">
                                            <b style="color: #000000;font-size: 1rem;">0</b> | <b style="color: #000000;font-size: 1rem;">0 %</b>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>




@include('dashboard/modals')
@endsection

@push('added_scripts')

<script>

</script>

<script src="{{asset('js/dashboard/index.js').'?t='.time()}}"></script>


@endpush