<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AlomranAssist - Accueil</title>
    <link rel="stylesheet" href="styles.css">
    <link rel="stylesheet" href="https://site-assets.fontawesome.com/releases/v6.4.0/css/all.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <link rel="icon" href="{{asset('images/favicon.png')}}">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <link href="/vendor_components/sweetalert/sweetalert.css" rel="stylesheet" type="text/css">
    <script src="/vendor_components/sweetalert/sweetalert2@11.js"></script>
    <style>
        .big-button {
            background-color: #115555;
            /* Button color */
            color: white;
            /* Text color */
            font-size: 20px;
            /* Text size */
            padding: 15px 30px;
            /* Padding to make the button bigger */
            border: none;
            border-radius: 10px;
            /* Rounded corners */
            cursor: pointer;
            transition: background-color 0.3s, transform 0.2s;
            /* Smooth transition for hover effects */
        }

        .big-button:hover {
            background-color: #0d4444;
            /* Darker shade on hover */
            transform: scale(1.05);
            /* Slightly increase size on hover */
        }

        .select2-container {
            flex: 1 1 auto !important;
        }

        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            color: #333;
            margin: 0;
            padding: 0;
            background-image: url(/images/index/bg.jpg);
            background-repeat: no-repeat;
            background-size: cover;
            font-family: 'Montserrat', sans-serif;
        }

        header {
            color: #fff;
            height: 80px;
            text-align: center;
            position: fixed;
            width: 100%;
            background: rgb(255 255 255 / 44%);
            -webkit-backdrop-filter: blur(10px);
            backdrop-filter: blur(10px);
            z-index: 99;
            border: 1px #979797 solid;
            box-shadow: 0 4px 10px rgb(0 0 0 / 4%);
        }

        .container {

            max-width: 1200px;
            margin: auto;
            padding: 20px;
            padding-top: 88px !important;
        }

        h1,
        h2 {
            color: #ffffff;
        }

        p {
            line-height: 1.6;
        }

        .features {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            margin-top: 20px;
        }

        .feature-item {
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            flex: 1 1 calc(33% - 20px);
            padding: 20px;
        }

        .feature-item h3 {
            margin-top: 0;
        }

        .video-container {
            margin-top: 20px;
            text-align: center;
        }

        .video-container iframe {
            width: 100%;
            height: 500px;
            border: none;
            border-radius: 8px;
        }

        @media (max-width: 768px) {
            .features {
                flex-direction: column;
            }
        }

        footer {
            background-color: #115555;
            color: #fff;
            text-align: center;
            padding: 10px 0;
            margin-top: 20px;
        }


        /* Animation for fade-in effect */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes scaleUp {
            from {
                transform: scale(0.9);
                opacity: 0;
            }

            to {
                transform: scale(1);
                opacity: 1;
            }
        }

        /* Apply animation to each feature item */
        .feature-item {
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            flex: 1 1 calc(33% - 20px);
            padding: 20px;
            animation: fadeInUp 0.8s ease forwards;
            opacity: 0;
            /* Start hidden for fade-in effect */
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .feature-item:hover {
            transform: translateY(-10px) scale(1.05);
            /* Add scaling effect */
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
        }

        /* Staggered animation delay for each item */
        .feature-item:nth-child(1) {
            animation-delay: 0.1s;
        }

        .feature-item:nth-child(2) {
            animation-delay: 0.2s;
        }

        .feature-item:nth-child(3) {
            animation-delay: 0.3s;
        }

        .feature-item:nth-child(4) {
            animation-delay: 0.4s;
        }

        .feature-item:nth-child(5) {
            animation-delay: 0.5s;
        }

        .feature-item:nth-child(6) {
            animation-delay: 0.6s;
        }

        .feature-item:nth-child(7) {
            animation-delay: 0.7s;
        }

        .feature-item:nth-child(8) {
            animation-delay: 0.8s;
        }

        .feature-item:nth-child(9) {
            animation-delay: 0.9s;
        }

        /* Animation for video container */
        .video-container {
            animation: scaleUp 0.8s ease forwards;
            opacity: 0;
            /* Start hidden for fade-in effect */
            animation-delay: 1s;
        }

        .intro-slider-section {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 20px;
            background-color: #f9f9f9;
            color: #115555;
            border-radius: 10px;
            box-shadow: 0 4px 10px rgb(0 0 0 / 4%);
            border: 1px #d9d9d9 solid;
        }

        .intro-text {
            flex: 1;
            margin-right: 20px;
        }

        .intro-text h1 {
            font-size: 2em;
            margin-bottom: 15px;
            color: #0d4848;
            text-align: center;
        }

        .intro-text p {
            font-size: 1.1em;
            color: #115555;
        }

        .slider {
            flex: 1;
            overflow: hidden;
            border-radius: 8px;
        }

        .slides {
            display: flex;
            transition: transform 0.5s ease;
        }

        .slides img {
            width: 100%;
            border-radius: 8px;
            flex: 1 0 100%;
        }


        .dots {
            display: flex;
            justify-content: center;
            margin-top: 10px;
        }

        .dots button {
            background-color: #ddd;
            border: none;
            border-radius: 50%;
            width: 12px;
            height: 12px;
            margin: 0 5px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        .dots button.active {
            background-color: #115555;
            /* Color for the active dot */
        }

        .logo {
            width: 50%;
            display: block;
            margin: auto;
            height: 68px;
            padding-bottom: 16px;
            border-bottom: 1px #606060 dashed;
        }

        @keyframes slideInFromTop {
            from {
                opacity: 0;
                transform: translateY(-50px);
                /* Starts slightly above the visible area */
            }

            to {
                opacity: 1;
                transform: translateY(0);
                /* Ends at its normal position */
            }
        }

        .intro-slider-section {

            animation: slideInFromTop 1s ease forwards;
            animation-delay: 0.5s;
            opacity: 0;
            /* Initially hidden for the animation */
        }
    </style>
</head>

<body>
    <header>
        <img style="height: calc(100% - 16px); display: block; left: 8px; position: absolute; margin: 8px;" src="/images/alomrane-groupe.svg?v=2">
        <div style="position: absolute; right: 20px; top: 50%; transform: translateY(-50%);">

            <select style="width:160px"  class="switch_lang select2nc_t" data-live-search="true">

                <option data-image="https://flagsapi.com/FR/flat/32.png" value="fr" {{$local=='fr'?'selected':''}}>Français</option>
                <option data-image="https://flagsapi.com/US/flat/32.png" value="en" {{$local=='en'?'selected':''}}>English</option>
            </select>
            <button class="btn btn-sm btn-success mr-2" id="authentification_btn"><i class="fa-solid fa-unlock mr-1"></i>Authentication</button>
            <button id="demande_inscription_btn" class="btn btn-sm btn-light" data-toggle="modal"><i class="fa-solid fa-envelope mr-1"></i>Registration request</button>


        </div>
    </header>
    <div class="container">

        <div class="row intro-slider-section">
            <div class="col-12 col-sm-6">
                <div class="intro-text">
                    <img class="logo" src="/images/logo/logo_app.svg?v=2">
                    <h1>&nbsp&nbspWelcome to the platform <b style="text-transform: uppercase;color: #3d9b9b;">AlomranAssist</b></h1>
                    <p style="    border-bottom: 1px #c6c6c6 solid;color: #4c8117;"><i style="margin-right: 8px;margin-left: 20px;" class="fa-regular fa-thumbs-up mr-2 ml-4"></i><b style="font-weight: 500 !important;">Achieve your real estate projects, wherever you are!</b></p>
                    <p style="color:#4c4c4c">
                        &nbsp&nbsp&nbspAlomraneAssist was designed to simplify and optimize the management of your real estate projects, especially for Moroccans around the world. Our mission is to provide you with comprehensive, transparent, and secure support throughout the entire life cycle of your project
                    </p>
                </div>
            </div>
            <div class="col-12 col-sm-6">

                <div class="slider">
                    <div class="slides">
                        <img src="/images/index/image1.jpg" alt="Image 1">
                        <img src="/images/index/image2.jpg" alt="Image 2">
                        <img src="/images/index/image3.jpg" alt="Image 3">
                        <img src="/images/index/image4.jpg" alt="Image 4">
                    </div>
                    <div class="dots">
                        <!-- Dots will be dynamically generated -->
                    </div>
                </div>
            </div>
        </div>

        <section>
            <h2 style="color: #4b4b4b;text-align: center;margin-top: 53px;background: #ffffff;border-radius: 8px;padding: 16px;">
                <img style="height: 80px; margin: auto; display: block;" src="/images/index/solution.png">
                </span style="margin:top:8px">A complete and innovative solution</span>
            </h2>
            <div class="features">
                <div class="feature-item">
                    <h5 style="color: #115555;text-decoration: underline;"><i class="fas fa-tachometer-alt"></i> Global dashboard</h3>
                        <p>&nbsp&nbspAccess a real-time overview of your project's progress</p>
                </div>
                <div class="feature-item">
                    <h5 style="color: #115555;text-decoration: underline;"><i class="fas fa-play-circle"></i> Preparation for startup</h3>
                        <p>&nbsp&nbspGet a detailed description of your projects with the technical support of our experts.</p>
                </div>
                <div class="feature-item">
                    <h5 style="color: #115555;text-decoration: underline;"><i class="fas fa-users-cog"></i> Selection of study providers</h3>
                        <p>&nbsp&nbspAccess a comprehensive directory of architects, engineering firms, surveyors, and qualified laboratories</p>
                </div>
                <div class="feature-item">
                    <h5 style="color: #115555;text-decoration: underline;"><i class="fas fa-briefcase"></i> Selection of companies responsible for the work</h3>
                        <p>&nbsp&nbspMake informed decisions with quotes and detailed information on each service provider.</p>
                </div>
                <div class="feature-item">
                    <h5 style="color: #115555;text-decoration: underline;"><i class="fas fa-chart-line"></i> Detailed study tracking</h3>
                        <p>&nbsp&nbspStay informed about the progress of studies at every stage..</p>
                </div>
                <div class="feature-item">
                    <h5 style="color: #115555;text-decoration: underline;"><i class="fas fa-hard-hat"></i> Work progress tracking</h3>
                        <p>&nbsp&nbspTrack the progress of construction work precisely at every phase</p>
                </div>
                <div class="feature-item">
                    <h5 style="color: #115555;text-decoration: underline;"><i class="fas fa-cube"></i> "3D visualisation</h3>
                        <p>&nbsp&nbspVirtually explore your project's plans with immersive 3D modeling.</p>
                </div>
                <div class="feature-item">
                    <h5 style="color: #115555;text-decoration: underline;"><i class="fas fa-video"></i> 360° camera for field monitoring</h3>
                        <p>&nbsp&nbspTrack the actual progress of your construction site using immersive technology similar to Street View.</p>
                </div>
                <div class="feature-item">
                    <h5 style="color: #115555;text-decoration: underline;"><i class="fas fa-video"></i> Video conference space</h3>
                        <p>&nbsp&nbspFacilitate communication with your project stakeholders through a dedicated space for online meetings.</p>
                </div>
            </div>
        </section>

    </div>
    <footer>
        <p>&copy; 2024 AlomranAssist. All rights reserved.</p>
    </footer>


    <div id="add_prestataire_check_type_modal" class="modal fade" role="dialog">
        <div class="modal-dialog modal-lg modal-center" role="document">
            <div class="modal-content">
                <div class="modal-header">

                </div>
                <div class="modal-body" style="    margin: auto;">
                    <span>
                        <button id="add_prestataire_check_type_modal_client_btn" class="big-button"><i style="font-size: 4rem;" class="fa-solid fa-user-tie"></i><span style="font-size: 1.5rem; width: 100%; display: block; margin: auto;">I am a client</span></button>
                        <button id="add_prestataire_check_type_modal_prestataire_btn" class="big-button ml-3"><i style="font-size: 4rem;" class="fa-solid fa-user-tie"></i><span style="font-size: 1.5rem; width: 100%; display: block; margin: auto;">I am a service provider</span></button>
                    </span>
                </div>


            </div>
        </div>
    </div>
    <div id="add_prestataire_modal" class="modal fade" role="dialog">
        <div class="modal-dialog modal-lg modal-center" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Registration request</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <form id="store_user_form">
                    @csrf
                    <input hidden name="id" class="form-control">
                    <div class=" modal-body">

                        <div class="row is_prestataire_div" style="display:none">
                            <div class="col-12">
                                <div class="input-group input-group-sm mb-3">
                                    <div class="input-group-prepend">
                                        <span style="padding: .0rem .5rem !important;min-width: 200px;" class="input-group-text">Type</span>
                                    </div>
                                    <select id="add_prestataire_modal_rol_id" required name="role_id" class="select2nc ">
                                        @foreach($role_prestataires as $role)
                                        <option value="{{$role->id}}">{{__($role->full_name)}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row is_client_div">
                            <div class="col-12">
                                <div class="input-group input-group-sm mb-3">
                                    <div class="input-group-prepend">
                                        <span style="padding: .0rem .5rem !important;min-width: 200px;" class="input-group-text">Type of the client</span>
                                    </div>
                                    <select id="add_prestataire_modal_type_client" required name="type_client" class="select2nc">
                                        <option selected value="Personne physique">Personne physique</option>
                                        <option value="Personne morale">Personne morale</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <div class="input-group input-group-sm mb-3">
                                    <div class="input-group-prepend">
                                        <span style="padding: .0rem .5rem !important;min-width: 200px;" class="input-group-text">Last name</span>
                                    </div>
                                    <input required name="nom" class="form-control" placeholder="Nom">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <div class="input-group input-group-sm mb-3">
                                    <div class="input-group-prepend">
                                        <span style="padding: .0rem .5rem !important;min-width: 200px;" class="input-group-text">First name</span>
                                    </div>
                                    <input required name="prenom" class="form-control" placeholder="Prenom">
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-12">
                                <div class="input-group input-group-sm mb-3">
                                    <div class="input-group-prepend">
                                        <span style="padding: .0rem .5rem !important;min-width: 200px;" class="input-group-text">adress</span>
                                    </div>
                                    <input required name="adresse" class="form-control" placeholder="Adresse">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <div class="input-group input-group-sm mb-3">
                                    <div class="input-group-prepend">
                                        <span style="padding: .0rem .5rem !important;min-width: 200px;" class="input-group-text">E-mail</span>
                                    </div>
                                    <input required name="email" class="form-control" placeholder="Email">
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-12">
                                <div class="input-group input-group-sm mb-3">
                                    <div class="input-group-prepend">
                                        <span style="padding: .0rem .5rem !important;min-width: 200px;" class="input-group-text">Phone number</span>
                                    </div>
                                    <input name="tel" class="form-control" placeholder="Téléphone">
                                </div>
                            </div>
                        </div>

                        <div class="row organisme_ste_div" style="display:none">
                            <div class="col-12">
                                <div class="input-group input-group-sm mb-3">
                                    <div class="input-group-prepend">
                                        <span style="padding: .0rem .5rem !important;min-width: 200px;" class="input-group-text">Company</span>
                                    </div>
                                    <input name="organisme_ste" class="form-control" placeholder="Organisme/Société">
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="input-group input-group-sm mb-3">
                                    <div class="input-group-prepend">
                                        <span style="padding: .0rem .5rem !important;min-width: 200px;" class="input-group-text">Business Identifier</span>
                                    </div>
                                    <input name="identifiant_ste" class="form-control" placeholder="Identifiant de l'Entreprise">
                                </div>
                            </div>
                        </div>



                    </div>

                    <div class="modal-footer" style="width:100%">
                        <div class="row" style=" width: 100%;">
                            <div class="col-6">
                            </div>
                            <div class="col-6">
                                <button style="float: right;margin-left: 8px;" type="button" class="btn btn-sm btn-danger " data-dismiss="modal"><i class="fa-solid fa-xmark"></i>&nbspClose</button>
                                <button style="float: right;" type="submit" class="btn btn-success btn-sm"><i class="fa-solid fa-envelope mr-1"></i>&nbspAsk for registration</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</body>

<script>
    let currentSlide = 0;
    const slides = document.querySelectorAll('.slides img');
    const dotsContainer = document.querySelector('.dots');

    // Create dots based on the number of slides
    slides.forEach((_, index) => {
        const dot = document.createElement('button');
        dot.addEventListener('click', () => {
            goToSlide(index);
        });
        dotsContainer.appendChild(dot);
    });

    const dots = document.querySelectorAll('.dots button');

    function updateDots() {
        dots.forEach((dot, index) => {
            dot.classList.toggle('active', index === currentSlide);
        });
    }

    function goToSlide(index) {
        currentSlide = index;
        document.querySelector('.slides').style.transform = `translateX(-${currentSlide * 100}%)`;
        updateDots();
    }

    function showNextSlide() {
        currentSlide = (currentSlide + 1) % slides.length;
        goToSlide(currentSlide);
    }

    // Initialize the first active dot
    updateDots();

    // Automatically change slides every 3 seconds
    setInterval(showNextSlide, 3000);


    $("#authentification_btn").click(function() {
        location.href = "/login";
    });

    $(document).ready(function() {
        $(".select2").select2();
        $(".select2nc").select2({
            minimumResultsForSearch: -1
        });
    });


    $("#add_prestataire_modal_type_client").change(function() {
        if ($(this).val() == "Personne morale") {
            $(".organisme_ste_div").css('display', 'block');
        } else {
            $(".organisme_ste_div").css('display', 'none');
        }
    });


    $("#demande_inscription_btn").click(function() {
        $("#add_prestataire_check_type_modal").modal("show");
    });

    $("#add_prestataire_check_type_modal_client_btn").click(function() {

        $(".is_prestataire_div").css('display', 'none');
        $(".is_client_div").css('display', 'flex');

        $("#add_prestataire_check_type_modal").modal("hide");
        $("#add_prestataire_modal").modal("show");
    });

    $("#add_prestataire_check_type_modal_prestataire_btn").click(function() {
        $(".is_prestataire_div").css('display', 'flex');
        $(".is_client_div").css('display', 'none');

        $("#add_prestataire_check_type_modal").modal("hide");
        $("#add_prestataire_modal").modal("show");
    });

    $("#store_user_form").submit(function(event) {

        event.preventDefault();
        var formData = new FormData(this);
        formData.append('demande', 1);
        $.ajax({
            url: "/user/store",
            type: "POST",
            dataType: "json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success == 1) {
                    $("#add_prestataire_modal").modal('hide');
                    Swal.fire({
                        icon: "success",
                        title: "AlomranAssist",
                        text: "Votre demande a été enregistrée avec succès. Vous recevrez un email prochainement pour poursuivre la création de votre compte.",

                    });
                } else {
                    Swal.fire({
                        icon: "error",
                        title: "AlomranAssist",
                        text: "Cet email est déjà présent dans notre base de données.",

                    });

                }


            },
            error: function(xhr, status, error) {
                console.log(xhr.responseText);
            },
        });


        
    });

    function formatOption(option) {
                if (!option.id) {
                    return option.text; // Return the text for non-selected options
                }

                var imageUrl = $(option.element).data('image'); // Get the image URL from the data attribute
                var $option = $(
                    `<div>
                        <img src="${imageUrl}" style="width: 20px; height: 20px; margin-right: 10px;" />
                        ${option.text}
                        </div>`
                );

                return $option;
            }
        $(document).ready(function() {

            $('.switch_lang').select2({
                templateResult: formatOption,
                templateSelection: formatOption,
                minimumResultsForSearch: Infinity
            });
         
           

        });

        
        $(".switch_lang").change(function() {
            location.href = "https://alomraneassist.ma/language/" + $(this).val()
        })
</script>

</html>