@if($menage->check_step_in_log('BON_TIRAGE_AU_SORT') || $test)
<div class="card card-refresh mt-2">
    <div class="refresh-container">
        <div class="loader-pendulums"></div>
    </div>
    <div class="card-header card-header-action">
        <h5 style="margin: 2px !important;color: #c0665b;font-size: 15px;"><i class="fa-solid fa-money-bills mr-1"></i>Financement</h5>
        <div class="d-flex align-items-center card-action-wrap">
            <a class="inline-block mr-15" data-toggle="collapse" href="#collapse_90" aria-expanded="true">
                <i class="zmdi zmdi-chevron-down"></i>
            </a>
        </div>
    </div>
    <div id="collapse_90" class="collapse show">
        <div class="card-body">

            <div class="row mt-3">
                <div class="col-8 ">
                    <div class="input-group input-group-sm">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="min-width: 180px;">Banque :</span>
                            </div>
                            <select disabled id="banque_inpt" class="form-control select2 select2nc prestataire_select">
                                <option value="" selected>Non sélectionnée</option>
                                @foreach($banques as $banque)
                                <option {{$banque->id==$menage->banque_id?'selected':''}} value="{{$banque->id}}">{{$banque->organisme_ste}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-4">
                    <button type="button" id="edit_banque_btn" class="btn btn-success"><i class="fa-solid fa-pencil mr-1"></i>&nbsp;Modifier</button>
                </div>
            </div>

            <div class="row">
                @if(Auth::user()->has_role('banque,bet'))
                <button type="button" class="btn btn-light" id="add_financement_btn"> <i class="fa-solid fa-pencil"></i>&nbsp;Modifier </button>
                <br>
                @endif
                <table class="table dataTable rtable datatables table-striped no-footer display nowrap mt-2">
                    <thead>
                        <th>Source</th>
                        <th>Montant</th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                    </thead>
                    <tbody>
                        <tr>
                            <td><i class="fa-solid fa-check"></i>&nbspFond propre</td>
                            @if(!is_null($menage->dossier_financement))
                            <td style="font-weight: 500; color: #d87250;" id="fond_propre_table_data">{{ number_format( $menage->dossier_financement->fond_propre,2,'.',' ')}} Dhs</td>
                            @else
                            <td style="font-weight: 500; color: #d87250;" id="fond_propre_table_data">-</td>
                            @endif

                            <td>{{$recu_versement_fond_propre['name']}}</td>
                            <td>
                                @if(!is_null($recu_versement_fond_propre['document']))
                                <span>{{$recu_versement_fond_propre['document']->formated_date_document()}} </span>
                                @else
                                <span type_document="{{$recu_versement_fond_propre['type_document']}}" style="color:gray">Aucun fichier importé</span>
                                @endif
                            </td>
                            <td>
                                @if(Auth::user()->has_role($recu_versement_fond_propre['w_roles']) && $recu_versement_fond_propre['active']==1)
                                <button id="upload_recu_versement_fond_propre_btn" type_document="{{$recu_versement_fond_propre['type_document']}}" file_type="{{$recu_versement_fond_propre['file_type']}}" type="button" {{ $menage->dossier_financement?->fond_propre == null ? 'disabled' : ''}} class="btn btn-light upload_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                                @endif
                            </td>
                            <td>
                                @if(is_null($recu_versement_fond_propre['document']))
                                <button type_document="{{$recu_versement_fond_propre['type_document']}}" file_id="" disabled type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download "></i>&nbsp;Télécharger</button>
                                @else
                                <button type_document="{{$recu_versement_fond_propre['type_document']}}" file_id="{{$recu_versement_fond_propre['document']->id}}" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td><i class="fa-solid fa-check"></i>&nbspCredit</td>

                            @if(!is_null($menage->dossier_financement))
                            <td style="font-weight: 500; color: #d87250;" id="credit_table_data">{{ number_format( $menage->dossier_financement->credit,2,'.',' ')}} Dhs</td>
                            @else
                            <td style="font-weight: 500; color: #d87250;" id="credit_table_data">-</td>
                            @endif
                            <td></td>
                            <td></td>
                            <td></td>
                            <td></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="row mt-3">
                <div class="col-md-3 col-12">
                    <div style="background: #f8f8f8; padding: 8px; border: 1px silver dashed; border-radius: 8px;">
                        <div>
                            <h5 class="mt-2 upload_doc_no_file_label" style="color:black;display: block; margin: auto;text-align: center;">Dossier de crédit</h5>

                            <svg height="80px" width="100%" version="1.1" id="_x32_" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512 512" xml:space="preserve" fill="#000000">
                                <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                                <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                                <g id="SVGRepo_iconCarrier">
                                    <style type="text/css">
                                        .financement_ico_default {
                                            fill: #c2c2c2;
                                        }

                                        .financement_ico_active {
                                            fill: #d87250
                                        }
                                    </style>
                                    <g>
                                        <path class="{{$menage->dossier_credit == 1?'financement_ico_active':'financement_ico_default'}}" d="M507.011,116.239c-5.006-5.425-12.726-7.421-19.738-5.101L133.065,228.115 c-10.252,3.412-18.56,11.046-22.774,20.992l-57.61,135.794l-2.636-190.3L385.018,82.307l-0.7-50.829 c-0.05-3.608-1.826-6.969-4.777-9.058c-2.95-2.09-6.704-2.618-10.124-1.467L183.161,83.714c-4.051,1.374-8.529,0.342-11.566-2.687 l-35.253-35.066c-3.02-2.994-7.481-4.052-11.516-2.704L7.729,82.137c-4.666,1.544-7.796,5.937-7.728,10.858l5.357,387.533 c0.052,3.583,1.808,6.934,4.743,9.024c2.925,2.082,6.678,2.653,10.099,1.518l390.356-128.979c3.071-1.032,5.561-3.318,6.833-6.304 l93.119-219.454C513.391,129.528,512.026,121.671,507.011,116.239z"></path>
                                    </g>
                                </g>
                            </svg>

                            @if($menage->date_operation_dossier_credit)
                            <input type="hidden" name="date_dossier_credit_inpt" id="date_dossier_credit_inpt" value="{{\Carbon\Carbon::createFromFormat('Y-m-d', $menage->date_operation_dossier_credit)->format('d/m/Y')}}">
                            @else
                            <input type="hidden" name="date_dossier_credit_inpt" id="date_dossier_credit_inpt" value="">
                            @endif
                            <b class="mt-2 upload_doc_no_file_label" id="dossier_credit_depose" style="border-top: 1px #cbcbcb dashed; padding-top: 8px;color:#68a334;display: {{$menage->dossier_credit == 1 ? 'block' : 'none'}}; margin: auto;text-align: center;margin-top: 10px !important;font-size : 14px;margin-bottom: 9px;">
                                <i class="fa-solid fa-check mr-1"></i>Dossier déposé
                            </b>
                            @if(Auth::user()->has_role('banque,bet'))
                            <button type="button" class="btn btn-light" id="dossier_credit_btn" class="mt- upload_doc_no_file_label" style="color:68a334;display:  {{$menage->dossier_credit == 0 ? 'block' : 'none'}}; margin: auto;text-align: center;margin-top: px !important"> <i class="fa-solid fa-pencil"></i>&nbsp;Décision </button>
                            @else
                            <button type="button" class="btn btn-light" class="mt- upload_doc_no_file_label" style="color:68a334;display:  {{$menage->dossier_credit == 0 ? 'block' : 'none'}}; margin: auto;text-align: center;margin-top: px !important" disabled> <i class="fa-solid fa-pencil"></i>&nbsp;Décision </button>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="col-md-3 col-12">
                    <div class="row">
                        <div class="col-12 mt-3">
                            <b style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Date de l'opération</b>
                            <b class="mt-1 download_depot_date" id="none_date_operation_dossier_credit_div" style="color:gray;display: {{$menage->date_operation_dossier_credit == null ? 'block' : 'none'}}; margin: auto;text-align: center;">Aucune opération actuellement</b>
                            <b class="mt-1 download_depot_date" id="date_operation_dossier_credit_div" style="color:gray;display: {{$menage->date_operation_dossier_credit != null ? 'block' : 'none'}}; margin: auto;text-align: center;">{{ \Carbon\Carbon::parse($menage->date_operation_dossier_credit)->format('d/m/Y')}} </b>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 col-12">
                    <div style="background: #f8f8f8; padding: 8px; border: 1px silver dashed; border-radius: 8px;">
                        <div>
                            <h5 class="mt-2 upload_doc_no_file_label" style="color:black;display: block; margin: auto;text-align: center;">Octroi de crédit </h5>

                            <svg fill="#bdbdbd" height="80px" width="100%" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 490.766 490.766" xml:space="preserve" stroke="#bdbdbd">
                                <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                                <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                                <g id="SVGRepo_iconCarrier">

                                    <g>
                                        <path class="{{$menage->octroi_credit == 1?'financement_ico_active':'financement_ico_default'}}" d="M472.554,319.199c-9.4-0.7-28.8,9.8-34.1,12.5c-18.9,9.5-45.2,24.4-62.5,36.3c-1.2,0.8-2.8,1.9-4,2.7 c-7.8,5-16,8.3-25.1,10.3c-50.2,10.7-123.3,11.8-123.3,11.8l-4.3,0.2c-3.2,0.2-6.1-2.1-6.5-5.2c-0.5-3.4,2-6.6,5.6-6.9l108.7-10.3 c12-1.3,21.5-12.5,20.2-25.1s-12.9-21.8-24.9-20.5l-96.7-1.2c-6.6-0.1-17.1-1.7-23.4-3.6c-62.3-18.2-97.5-1.2-116.2,6.8 c-4.2-6.9-12.1-11.4-20.9-10.8l-41.7,2.8c-13.9,0.9-24.3,12.5-23.4,25.9l6.7,92.6c1,13.4,13,23.5,26.9,22.5l41.7-2.8 c8.8-0.6,16-6,19.1-13.4l183.2,7.9c20.4,2.2,39.5-0.3,57.5-9.7l5.2-2.7l138.5-81c6.8-4,11.6-10.9,11.9-18.5 C491.054,330.499,485.754,320.199,472.554,319.199z M48.954,438.099c-7.8,0-14.2-6.1-14.2-13.7s6.4-13.7,14.2-13.7 s14.2,6.1,14.2,13.7S56.754,438.099,48.954,438.099z M369.554,351.099c0.2-2.5,0.2-5.1-0.1-7.7c-0.3-3.3-1.1-6.4-2.1-9.4 c0.1-0.2,0.2-0.4,0.2-0.6c14.6-8,43.2-21.8,58.8-27.9c7.8-3.1,15.5-2.9,22.6,1.9c-5.6,2-10.8,4.5-15.7,6.9 c-16.4,8.2-45.3,23.9-59.4,33.8C372.454,349.099,370.954,350.099,369.554,351.099z M348.354,310.299c9.6-5.1,31-12,40.7-15.8 c7.7-3.1,15.3-2.9,22.4,1.8c-11.3,5-33,12.6-43.3,18.3l-7,3.8c-0.7,0.4-1.3,0.8-1.9,1.3 C356.054,315.899,352.454,312.799,348.354,310.299z M387.154,222.599c5.8,0,10.5,4.7,10.5,10.5s-4.7,10.5-10.5,10.5h-261.8 c-5.8,0-10.5-4.7-10.5-10.5s4.7-10.5,10.5-10.5H387.154z M114.954,270.999c0-5.8,4.7-10.5,10.5-10.5h261.7 c5.8,0,10.5,4.7,10.5,10.5s-4.7,10.5-10.5,10.5h-261.8C119.654,281.499,114.954,276.799,114.954,270.999z M349.254,118.299 c0,8.2-6.7,14.9-14.9,14.9c-8.2,0-14.9-6.7-14.9-14.9s6.7-14.9,14.9-14.9C342.654,103.399,349.254,110.099,349.254,118.299z M192.954,118.299c0,8.2-6.7,14.9-14.9,14.9s-14.9-6.7-14.9-14.9s6.7-14.9,14.9-14.9 C186.354,103.399,192.954,110.099,192.954,118.299z M397.754,55.199c0-13.5-11-24.5-24.5-24.5h-234c-13.5,0-24.5,11-24.5,24.5 v126.2c0,13.5,11,24.5,24.5,24.5h234c13.5,0,24.5-11,24.5-24.5V55.199z M376.854,157.899c-2-0.5-4-0.8-6.1-0.8 c-13.7,0-24.8,11.1-24.8,24.8c0,1,0.1,2.1,0.2,3.1h-181.7c0.3-1.5,0.4-3,0.4-4.6c0-13.7-11.1-24.8-24.8-24.8 c-1.5,0-2.9,0.1-4.4,0.4v-75.4c1.4,0.3,2.9,0.4,4.4,0.4c13.7,0,24.8-11.1,24.8-24.8c0-1.6-0.2-3.1-0.4-4.6h182.2 c-0.5,1.9-0.8,4-0.8,6.1c0,13.7,11.1,24.8,24.8,24.8c2.1,0,4.2-0.3,6.1-0.8v76.2H376.854z M256.254,64.599 c-29.6,0-53.7,24.1-53.7,53.7s24.1,53.7,53.7,53.7s53.7-24.1,53.7-53.7S285.854,64.599,256.254,64.599z M259.754,130.299 l-10.5,10.4l-10.4-10.5l-10-10.1l10.5-10.4l10,10.1l24-23.9l10.4,10.5L259.754,130.299z"></path>
                                    </g>
                                </g>
                            </svg>

                            @if($menage->date_operation_octroi_credit)
                            <input type="hidden" name="date_octroi_credit_inpt" id="date_octroi_credit_inpt" value="{{\Carbon\Carbon::createFromFormat('Y-m-d', $menage->date_operation_octroi_credit)->format('d/m/Y')}}">
                            @else
                            <input type="hidden" name="date_octroi_credit_inpt" id="date_octroi_credit_inpt" value="">
                            @endif
                            <b class="mt-2 upload_doc_no_file_label" id="octroi_credit_accorde" style="border-top: 1px #cbcbcb dashed; padding-top: 8px;color: #68a334;display: {{$menage->octroi_credit == 1 ? 'block' : 'none'}}; margin: auto;text-align: center;margin-top: 10px !important;font-size : 14px;margin-bottom: 9px;">
                                <i class="fa-solid fa-check mr-1"></i>Crédit accordé
                            </b>
                            @if(Auth::user()->has_role('banque,bet'))
                            <button type="button" class="btn btn-light" id="octroi_credit_btn" class="mt- upload_doc_no_file_label" style="color:68a334;display:  {{$menage->date_operation_octroi_credit == null ? 'block' : 'none'}}; margin: auto;text-align: center;margin-top: px !important"> <i class="fa-solid fa-pencil"></i>&nbsp;Décision </button>
                            @else
                            <button type="button" class="btn btn-light" class="mt- upload_doc_no_file_label" style="color:68a334;display:  {{$menage->date_operation_octroi_credit == null ? 'block' : 'none'}}; margin: auto;text-align: center;margin-top: px !important" disabled> <i class="fa-solid fa-pencil"></i>&nbsp;Décision </button>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="col-md-3 col-12">
                    <div class="row">
                        <div class="col-12 mt-3">
                            <b style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Date de l'opération</b>
                            <b class="mt-1 download_depot_date" id="none_date_operation_octroi_credit_div" style="color:gray;display: {{$menage->date_operation_octroi_credit == null ? 'block' : 'none'}}; margin: auto;text-align: center;">Aucune opération actuellement</b>
                            <b class="mt-1 download_depot_date" id="date_operation_octroi_credit_div" style="color:gray;display: {{$menage->date_operation_octroi_credit != null ? 'block' : 'none'}}; margin: auto;text-align: center;">{{ \Carbon\Carbon::parse($menage->date_operation_octroi_credit)->format('d/m/Y')}} </b>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row mt-3">
                <div class="col-md-3 col-12">
                    <div style="background: #f8f8f8; padding: 8px; border: 1px silver dashed; border-radius: 8px;">
                        <div>
                            <h5 class="mt-2 upload_doc_no_file_label" style="color:black;display: block; margin: auto;text-align: center;">Déblocage auprès du notaire</h5>

                            <svg height="80px" width="100%" fill="#000000" viewBox="0 0 14 14" role="img" focusable="false" aria-hidden="true" xmlns="http://www.w3.org/2000/svg">
                                <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                                <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                                <g id="SVGRepo_iconCarrier">
                                    <path class="{{$menage->deblocage_aupres_notaire == 1?'financement_ico_active':'financement_ico_default'}}" d="m 10.3,6.4 c -1.4925,0 -2.7,1.2075 -2.7,2.7 0,1.4925 1.2075,2.7 2.7,2.7 1.4925,0 2.7,-1.2075 2.7,-2.7 0,-1.4925 -1.2075,-2.7 -2.7,-2.7 z m 1.2,2.81812 C 11.5,9.31752 11.4175,9.4 11.318125,9.4 l -1.13625,0 C 10.0825,9.4 10,9.3175 10,9.21812 L 10,7.78187 C 10,7.6825 10.0825,7.6 10.181875,7.6 l 0.23625,0 C 10.5175,7.6 10.6,7.6825 10.6,7.78187 l 0,1.01813 0.718125,0 C 11.4175,8.8 11.5,8.8825 11.5,8.98187 l 0,0.23625 z M 7,9.1 C 7,8.57875 7.125625,8.08562 7.34125,7.64687 7.19125,7.61875 7.0375,7.6 6.88,7.6 l -0.313125,0 C 6.150625,7.79125 5.6875,7.9 5.2,7.9 4.7125,7.9 4.25125,7.79125 3.833125,7.6 L 3.52,7.6 C 2.12875,7.6 1,8.72875 1,10.12 l 0,0.78 c 0,0.49687 0.403125,0.9 0.9,0.9 l 6.508125,0 C 7.55875,11.20187 7,10.21562 7,9.1 Z M 5.2,7 C 6.525625,7 7.6,5.92562 7.6,4.6 7.6,3.27437 6.525625,2.2 5.2,2.2 3.874375,2.2 2.8,3.27437 2.8,4.6 2.8,5.92562 3.874375,7 5.2,7 Z"></path>
                                </g>
                            </svg>

                            @if($menage->date_operation_deblocage_aupres_notaire)
                            <input type="hidden" name="date_deblocage_aupres_notaire_inpt" id="date_deblocage_aupres_notaire_inpt" value="{{\Carbon\Carbon::createFromFormat('Y-m-d', $menage->date_operation_deblocage_aupres_notaire)->format('d/m/Y')}}">
                            @else
                            <input type="hidden" name="date_deblocage_aupres_notaire_inpt" id="date_deblocage_aupres_notaire_inpt" value="">
                            @endif
                            <b class="mt-2 upload_doc_no_file_label" id="deblocage_aupres_notaire_div" style="border-top: 1px #cbcbcb dashed; padding-top: 8px; color: #68a334;display: {{$menage->deblocage_aupres_notaire == 1 ? 'block' : 'none'}}; margin: auto;text-align: center;margin-top: 10px !important;font-size : 14px;margin-bottom: 9px;">
                            <i class="fa-solid fa-check mr-1"></i>Effectué
                            </b>
                            @if(Auth::user()->has_role('notaire'))
                            <button type="button" class="btn btn-light" id="deblocage_aupres_notaire_btn" class="mt- upload_doc_no_file_label" style="color:68a334;display:  {{$menage->deblocage_aupres_notaire == 0 ? 'block' : 'none'}}; margin: auto;text-align: center;margin-top: px !important"> <i class="fa-solid fa-pencil"></i>&nbsp;Décision </button>
                            @else
                            <button type="button" class="btn btn-light" class="mt- upload_doc_no_file_label" style="color:#68a334;display:  {{$menage->deblocage_aupres_notaire == 0 ? 'block' : 'none'}}; margin: auto;text-align: center;margin-top: px !important" disabled> <i class="fa-solid fa-pencil"></i>&nbsp;Décision </button>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="col-md-3 col-12">
                    <div class="row">
                        <div class="col-12 mt-3">
                            <b style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Date de l'opération</b>
                            <b class="mt-1 download_depot_date" id="none_date_operation_deblocage_aupres_notaire_div" style="color:gray;display: {{$menage->date_operation_deblocage_aupres_notaire == null ? 'block' : 'none'}}; margin: auto;text-align: center;">Aucune opération actuellement</b>
                            <b class="mt-1 download_depot_date" id="date_operation_deblocage_aupres_notaire_div" style="color:gray;display: {{$menage->date_operation_deblocage_aupres_notaire != null ? 'block' : 'none'}}; margin: auto;text-align: center;">{{ \Carbon\Carbon::parse($menage->date_operation_dossier_credit)->format('d/m/Y')}} </b>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 col-12">
                    <div style="background: #f8f8f8; padding: 8px; border: 1px silver dashed; border-radius: 8px;">
                        <div>
                            <h5 class="mt-2 upload_doc_no_file_label" style="color:black;display: block; margin: auto;text-align: center;">Déblocage dans les mains du notaire</h5>
                            <svg  style="padding: 10px;" height="80px" width="100%" xmlns="http://www.w3.org/2000/svg"   viewBox="0 0 690.21 548.57">
                                
                                <g id="Layer_1" data-name="Layer 1" focusable="false">
                                    <path class="{{$menage->deblocage_main_notaire == 1?'financement_ico_active':'financement_ico_default'}}" d="M342.86,394.29c0-29.79,7.18-57.96,19.5-83.04-8.57-1.61-17.36-2.68-26.36-2.68h-17.89c-23.79,10.93-50.25,17.14-78.11,17.14s-54.21-6.21-78.11-17.14h-17.89C64.5,308.57,0,373.07,0,452.57v44.57c0,28.39,23.04,51.43,51.43,51.43h371.89c-48.54-34.18-80.46-90.54-80.46-154.29ZM240,274.29c75.75,0,137.14-61.39,137.14-137.14S315.75,0,240,0,102.86,61.39,102.86,137.14s61.39,137.14,137.14,137.14Z" />
                                    <path class="{{$menage->deblocage_main_notaire == 1?'financement_ico_active':'financement_ico_default'}}" d="M533.68,235.5c-86.45,0-156.53,70.08-156.53,156.53s70.08,156.53,156.53,156.53,156.53-70.08,156.53-156.53-70.08-156.53-156.53-156.53ZM518.37,460.1h-23.09l-55.84-78.25,23.09-21.54,44.29,41.36,88.59-102.2,23.09,16.2-100.14,144.43Z" />
                                </g>
                            </svg> @if($menage->date_operation_deblocage_main_notaire)
                            <input type="hidden" name="date_deblocage_main_notaire_inpt" id="date_deblocage_main_notaire_inpt" value="{{\Carbon\Carbon::createFromFormat('Y-m-d', $menage->date_operation_deblocage_main_notaire)->format('d/m/Y')}}">
                            @else
                            <input type="hidden" name="date_deblocage_main_notaire_inpt" id="date_deblocage_main_notaire_inpt" value="">
                            @endif
                            <b class="mt-2 upload_doc_no_file_label" id="deblocage_main_notaire_div" style="border-top: 1px #cbcbcb dashed; padding-top: 8px; color: #68a334;display: {{$menage->deblocage_main_notaire == 1 ? 'block' : 'none'}}; margin: auto;text-align: center;margin-top: 10px !important;font-size : 14px;margin-bottom: 9px;">
                            <i class="fa-solid fa-check mr-1"></i>Effectué
                            </b>
                            @if(Auth::user()->has_role('notaire'))
                            <button type="button" class="btn btn-light" id="deblocage_main_notaire_btn" class="mt- upload_doc_no_file_label" style="color:68a334; display: {{$menage->deblocage_main_notaire == 0 ? 'block' : 'none'}}; margin: auto;text-align: center;margin-top: px !important"> <i class="fa-solid fa-pencil"></i>&nbsp;Décision </button>
                            @else
                            <button type="button" class="btn btn-light" class="mt- upload_doc_no_file_label" style="color:68a334; display: {{$menage->deblocage_main_notaire == 0 ? 'block' : 'none'}}; margin: auto;text-align: center;margin-top: px !important" disabled> <i class="fa-solid fa-pencil"></i>&nbsp;Décision </button>
                            @endif
                        </div>
                    </div>
                </div>
                <div class="col-md-3 col-12">
                    <div class="row">
                        <div class="col-12 mt-3">
                            <b style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Date de l'opération</b>
                            <b class="mt-1 download_depot_date" id="none_date_operation_deblocage_main_notaire_div" style="color:gray;display: {{$menage->date_operation_deblocage_main_notaire == null ? 'block' : 'none'}}; margin: auto;text-align: center;">Aucune opération actuellement</b>
                            <b class="mt-1 download_depot_date" id="date_operation_deblocage_main_notaire_div" style="color:gray;display: {{$menage->date_operation_deblocage_main_notaire != null ? 'block' : 'none'}}; margin: auto;text-align: center;">{{ \Carbon\Carbon::parse($menage->date_operation_deblocage_main_notaire)->format('d/m/Y')}} </b>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@else
<div class="card card-refresh mt-2">
    <div class="card-header card-header-action" style="background: white;background-image: linear-gradient(45deg, #fcfcfc 40%, #e3e3e3 40%, #e3e3e3 50%, #fcfcfc 50%, #fcfcfc 90%, #e3e3e3 90%, #e3e3e3 100%);    background-size: 7.07px 7.07px;">
        <h5 style="margin: 2px !important;color:rgb(89, 89, 89);font-size: 15px;"><i class="fa-solid fa-money-bills mr-1"></i>Financement</h5>
    </div>
</div>
@endif