@extends('layouts.app')
@section('added_css')
<link rel="stylesheet" href="{{asset('css/datatable/datatables.min.css')}}" />
<link rel="stylesheet" type="text/css" href="{{asset('chart.js/dist/Chart.min.css')}}">
<script src="{{asset('chart.js/dist/Chart.js')}}"></script>
<style>
    .m-footer {
        color: #ff1308 !important;
        font-weight: 600;
    }

    .small-box>.inner {
        padding: 0.75rem;
    }

    .small-box {
        margin-bottom: 10px;
    }

    .text-styling {
        font-size: 14px;
        color: #000;
    }

    .text-center {
        font-size: 14px;
        color: #000;
    }

    .table>thead>tr>th {
        background: #e8e8e8;
        color: #000000 !important;
        font-weight: 400;
        padding-left: 8px;
        border-bottom: 1px #cbcbcb solid !important;
        text-transform: uppercase;
        font-weight: 500;
        font-size: 0.70rem;
    }

    .m-thead {
        font-family: Lato;
        font-weight: 700 !important;
        font-size: 15px !important;
    }

    .m-thead-mobile {
        font-family: Lato;
        font-weight: 600 !important;
        font-size: 13px !important;
    }

    .costume-img-2 {
        max-width: unset !important;
        width: auto;
        margin: 2px 4px !important;
        /* height: 260px; */
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        /* display: inline-block; */
        float: none;
        border-radius: 4px;
        transition: transform 0.2s, 0.35s ease-in-out !important;
        cursor: pointer;
    }

    .photo_side_bar {
        background: #fdfdfd;
        width: 40%;
        position: fixed;
        right: -55%;
        height: 100%;
        z-index: 9999999999;
        box-shadow: 0px 10px 30px 0px rgb(0 0 0 / 30%);
        transition: all 0.35s;
        opacity: 0;
        top: 45px;
    }

    .photo_side_bar.active {
        right: 0px;
        opacity: 1;
    }

    [type=radio]:checked+label,
    [type=radio]:not(:checked)+label {
        font-weight: 300;
        position: relative;
        padding-left: 35px;
        cursor: pointer;
        display: inline-block;
        height: 25px;
        line-height: 25px;
        -webkit-transition: .28s ease;
        -o-transition: .28s ease;
        transition: .28s ease;
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none;
        font-size: 14px;
        font-weight: 400;
    }

    .document_preview_modal {
        width: 60%;
        height: 90%;
        background: #f2f2f2;
        position: fixed;
        z-index: 999999999999;
        left: -20%;
        top: 80%;
        pointer-events: none;
        opacity: 0;
        border-radius: 8px;
        border: 1px gray solid;
        box-shadow: 1px 3px 16px 8px rgb(0 0 0 / 13%) !important;
        transform: scale(0.15);
        transition: all 0.35s ease-in-out !important;
    }

    .document_preview_modal.active {
        transform: scale(1);
        pointer-events: all;
        opacity: 1;
        left: 20%;
        top: 20px;

    }

    .document_preview_modal_close>i {
        font-size: 20px;
        position: absolute;
        right: 12px;
        top: 12px;
        transition: all 0.2s, 0.15s ease-in-out !important;
    }

    .document_preview_modal_close>i:hover {
        font-size: 20px;
        position: absolute;
        right: 12px;
        top: 12px;
        color: red;
        cursor: pointer;
    }

    .document_preview_modal>iframe {
        height: calc(100% - 60px);
        display: block;
        width: calc(100% - 40px);
        border: 1px #d5d5d5 solid;
        margin: 50px 20px 30px 20px;
        border-radius: 8px;
        box-shadow: 1px 3px 9px 0px rgb(0 0 0 / 13%) !important;
    }

    .document_preview_modal>span {
        position: absolute;
        top: 12px;
        left: 20px;
        font-weight: 500;
        font-size: 14px;
    }

    .document_preview_modal_loader {
        position: absolute;
        top: calc(50% - 50px);
        height: 100px;
        width: 100px;
        left: calc(50% - 50px);
        opacity: 0;
        transition: all 0.25s, 0.25s ease-in-out !important;
        pointer-events: none;
    }

    .document_preview_modal_loader.active {

        opacity: 1;

    }

    .document_preview_modal_doc {
        opacity: 0;
        pointer-events: none;
        transition: all 0.25s, 0.25s ease-in-out !important;
    }

    .document_preview_modal_doc.active {
        opacity: 1;
        pointer-events: all;

    }
</style>
@endsection
@section('content')

<div class="document_preview_modal">
    <div class="document_preview_modal_close">
        <i class="fa-solid fa-xmark"></i>
    </div>
    <span><i class="fa-solid fa-file-pdf"></i><span class="document_preview_modal_title">DOUCMENT</span></span>
    <iframe class="document_preview_modal_doc" scr=""></iframe>

    <div class="document_preview_modal_loader active">
        <img src="/images/loader/motion-blur-2.svg">
    </div>
</div>

<div style="padding-top: 16px;margin-left: 8px">
    <nav class="hk-breadcrumb" aria-label="breadcrumb">
        <ol class="breadcrumb breadcrumb-light bg-transparent">
            <li class="breadcrumb-item"><a href="{{route('menages')}}">Menages</a></li>
            <!-- <li class="breadcrumb-item"><a href="{{route('menages')}}">Baraque N° ---</a></li> -->
            <li class="breadcrumb-item " aria-current="page">Dossier N° {{$menage->ref}}</li>
        </ol>
    </nav>
    @if(Auth::user()->has_role('verif'))
    <ul class="nav nav-tabs" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link {{(request()->tab == "verification-tab")?'':'active'}}" id="donnees-tab" data-toggle="tab" data-target="#donnees" type="button" role="tab" aria-controls="donnees" aria-selected="true">Données</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link {{(request()->tab == "verification-tab")?'active':''}}" id="verification-tab" data-toggle="tab" data-target="#verification" type="button" role="tab" aria-controls="verification" aria-selected="false">Vérification</button>
        </li>
    </ul>
    @endif
    <div class="tab-content" id="myTabContent">
        <div class="tab-pane fade {{(request()->tab == "verification-tab")?'':'active show'}}" id="donnees" role="tabpanel" aria-labelledby="donnees-tab">
            <div class="row">
                <div class="col-9">
                    @include('menages/details_informations_generales')
                    @include('menages/details_mode_attribution')
                    @include('menages/details_dossier_etude')
                    @include('menages/details_avance_20000')
                    @include('menages/details_tirage_sort')
                    @include('menages/details_affectation')
                    @include('menages/details_compromis_vente')
                    @include('menages/details_cessions_partielles')
                    @include('menages/details_financement')
                    @include('menages/details_acquisition')
                </div>
                <div class="col-12 col-md-3 " style="padding-top: 8px;">
                    <div class="row" style="position: fixed; margin-right: 8px; margin-top: 0px;background: #f2f2f2; padding: 8px; border-radius: 6px; border: 1px #d2d2d2 solid;">
                        <i style="text-align: center; margin: auto; font-size:20px; color: #d07979;" class="fa-regular fa-folder-open"></i>
                        <b class="mt-2" style="font-size: 0.8rem;color: #2273ae;width:100%;text-align: center;">Dossier N° : {{$menage->ref}}</b>

                        <h6>Traitement</h6>
                        <div class="row ml-2 m-step {{$menage->check_step_in_log('RECENSEMENT_VALIDE')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Recensement validé</b>
                            </div>
                        </div>

                        <div class="row ml-2 m-step {{$menage->check_step_in_log('DOISSIER_ETUDE_COMPLET')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Dossier d’étude complet</b>
                            </div>
                        </div>
                        <div class="row ml-2 m-step {{$menage->check_step_in_log('DOISSIER_ETUDE_COMPLET_VALIDE')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Dossier d’étude complet et validé</b>
                            </div>
                        </div>
                        <div class="row ml-2 m-step {{$menage->check_step_in_log('ETUDE_VALIDEE')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Etude validée</b>
                            </div>
                        </div>

                        <div class="row mt-2" style="width: 100%;">
                            <div class="col-12 mb-2 m-step-af {{$menage->check_step_in_log('ETUDE_VALIDEE')?'success':'pending'}}">
                                <div class="row ml-2 m-step {{$menage->check_step_in_log('ETUDE_VALIDEE')?'success':'pending'}}" style="text-align: center; width: 100%; display: block;">
                                    <div>
                                        <i class="pending-icon fa-regular fa-clock"></i>
                                        <i class="success-icon fa-solid fa-check"></i>
                                        <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                        <b class="ml-1">Validation de l’étude par la commission </b>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row ml-2 m-step {{$menage->check_step_in_log('PROJET_DESTINATION_AFFECTED')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Projet de destination désigné</b>
                            </div>
                        </div>

                        <div class="row ml-2 m-step {{$menage->check_step_in_log('AUTORISATION_VERSEMENT')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Autorisation de versement</b>
                            </div>
                        </div>
                        <div class="row ml-2 m-step {{$menage->check_step_in_log('RECU_VERSEMENT_20000')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Versement de l’avance de 20 000 DH</b>
                            </div>
                        </div>
                        <div class="row mt-2" style="width: 100%;">
                            <div class="col-12 mb-2 m-step-af {{$menage->check_step_in_log('RECU_VERSEMENT_20000')?'success':'pending'}}">
                                <div class="row ml-2 m-step {{$menage->check_step_in_log('RECU_VERSEMENT_20000')?'success':'pending'}}" style="text-align: center; width: 100%; display: block;">
                                    <div>
                                        <i class="pending-icon fa-regular fa-clock"></i>
                                        <i class="success-icon fa-solid fa-check"></i>
                                        <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                        <b class="ml-1">Versement de l’avance de 20 000 DH</b>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row ml-2 m-step {{$menage->check_step_in_log('BON_TIRAGE_AU_SORT')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Tirage au sort</b>
                            </div>
                        </div>

                        <div class="row ml-2 m-step {{$menage->check_step_in_log('ATTESTATION_ATTRIBUTION')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Attestation d’attribution</b>
                            </div>
                        </div>
                        <div class="row ml-2 m-step {{$menage->check_step_in_log('ACCUSE_RECEPTION_ATTRIBUTION_NOTAIRE')?'success':'pending'}}">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Attestation d’attribution avec accusé de réception</b>
                            </div>
                        </div>


                        @if(Auth::user()->has_role('bet,notaire,banque,admin'))
                        <button id="save_dossier" style="width: 100%;  " type="button" class="btn btn-save mt-2">
                            <span style="display: none;" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                            <i class="fa-solid fa-floppy-disk mr-2"></i>Enregistrer
                        </button>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        <div class="tab-pane fade {{(request()->tab == "verification-tab")?'active show':''}}" id="verification" role="tabpanel" aria-labelledby="verification-tab">
            @include('menages/verification')
        </div>
    </div>
</div>
@if(Auth::user()->has_role('verif'))
@include('menages/modals_verification')
@endif
@include('menages/modals')
@endsection
@push('added_scripts')
<script>
    var menage = @json($menage);
    var current_chef_menage_id = menage.chefs_menage[0].id;

    var situation_scolarite_data = @json($situations_solaire);
</script>
<script src="{{asset('js/menages/show.js').'?t='.time()}}"></script>
<script src="{{asset('js/menages/details_infos_generales.js').'?t='.time()}}"></script>
<script src="{{asset('js/menages/situation_scolaire.js').'?t='.time()}}"></script>
@if(Auth::user()->has_role('verif'))
<script src="{{asset('js/menages/verification.js').'?t='.time()}}"></script>
@endif
<script src="{{asset('js/menages/projet_destination.js').'?t='.time()}}"></script>
<script>
    $(document).ready(function() {
        // for (var i = 0; i < menage.dossier_financement.associes.length; i++) {
        //     console.log(menage.dossier_financement.associes[i]);
        //     associes_add(menage.dossier_financement.associes[i]);
        // }
    });

    $("body").on("click", '.document_preview_img', function() {
        $(".document_preview_modal_loader").addClass("active");
        $(".document_preview_modal_doc").removeClass("active");
        var document = $(this).attr('document');
        var title = $(this).attr('title');
        $(".document_preview_modal").addClass("active");
        $(".document_preview_modal_title").text(title);

        setTimeout(function() {

            $('.document_preview_modal_doc')[0].contentWindow.location.replace(document);
            $(".document_preview_modal_loader").removeClass("active");
            $(".document_preview_modal_doc").addClass("active");
        }, 1500);

    });

    $(".document_preview_modal_close").click(function() {
        $(".document_preview_modal").removeClass("active");
    });
</script>
@endpush