@extends('layouts.app')
@section('added_css')
<link rel="stylesheet" href="{{asset('css/datatable/datatables.min.css')}}" />
<link rel="stylesheet" type="text/css" href="{{asset('chart.js/dist/Chart.min.css')}}">
<script src="{{asset('chart.js/dist/Chart.js')}}"></script>
<style>
    .m-footer {
        color: #ff1308 !important;
        font-weight: 600;
    }
    .small-box>.inner {
        padding: 0.75rem;
    }
    .small-box {
        margin-bottom: 10px;
    }
    .text-styling {
        font-size: 14px;
        color: #000;
    }
    .text-center {
        font-size: 14px;
        color: #000;
    }
    .table>thead>tr>th {
        background: #e8e8e8;
        color: #000000 !important;
        font-weight: 400;
        padding-left: 8px;
        border-bottom: 1px #cbcbcb solid !important;
        text-transform: uppercase;
        font-weight: 500;
        font-size: 0.70rem;
    }
    .m-thead {
        font-family: Lato;
        font-weight: 700 !important;
        font-size: 15px !important;
    }
    .m-thead-mobile {
        font-family: Lato;
        font-weight: 600 !important;
        font-size: 13px !important;
    }
</style>
@endsection
@section('content')
<div style="padding-top: 16px;margin-left: 8px">
    <div style="margin-top:8px;padding-left: 10px;padding-right: 10px;">
        <div class="box" style="margin-bottom: 0.5em;border: none;">
            <div class="filters" style="margin-bottom: 4px;">
                <div class="row">
                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Province :</span>
                            </div>
                            <select id="provinces_filter" class="form-control select2 m-tout dt_filter" column="menages.province_id" table="">
                                <option value="all" selected>Indifferent</option>
                                @foreach($provinces as $province)
                                <option value="{{$province->id}}">{{$province->nom}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Commune :</span>
                            </div>
                            <select id="provinces_filter" class="form-control select2 m-tout dt_filter" column="menages.province_id" table="">
                                <option value="all" selected>Indifferent</option>
                             
                            </select>
                        </div>
                    </div>


                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Promoteur :</span>
                            </div>
                            <select id="provinces_filter" class="form-control select2 m-tout dt_filter" column="menages.province_id" table="">
                                <option value="all" selected>Indifferent</option>
                             
                            </select>
                        </div>
                    </div>

                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Etat d'avancement :</span>
                            </div>
                            <select id="provinces_filter" class="form-control select2 m-tout dt_filter" column="menages.province_id" table="">
                                <option value="all" selected>Indifferent</option>
                                <option value="Autorisation">Autorisation</option>
                                <option value="Démarrage des travaux">Démarrage des travaux</option>
                                <option value="Attestation d'avancement de 50%">Attestation d'avancement de 50%</option>
                                <option value="PV d'achèvement">PV d'achèvement</option>
                            </select>
                        </div>
                    </div>
                </div>
                <hr>
            </div>
        </div>
        
        <table class="table table-striped datatables dataTable no-footer display nowrap" id="projets_table">
            <thead>
                <th>Projet</th>
                <th>Province</th>
                <th>Promoteur</th>
                <th>Nbr immeubles</th>
                <th>Nbr appartement</th>
                <th>Appartements affectés</th>
                <th>Taux d'affectation</th>
            </thead>
            <tbody>
            </tbody>    
        </table>
    </div>
</div>
@include('projets.modals')
@endsection
<script>
    var provinces = @json($provinces);
    var arrondissements = @json($arrondissements);
</script>
@push('added_scripts')
<script src="{{asset('js/projets/index.js').'?t='.time()}}"></script>
@endpush