@extends('layouts.app')

@section('added_css')

<style>
    .m-footer {

        color: #ff1308 !important;

        font-weight: 600;

    }



    .small-box>.inner {

        padding: 0.75rem;

    }



    .small-box {

        margin-bottom: 10px;

    }





    .text-styling {

        font-size: 14px;

        color: #000;



    }



    .text-center {

        font-size: 14px;

        color: #000;

    }







    .table>thead>tr>th {

        background: #e8e8e8;

        color: #000000 !important;

        font-weight: 400;

        padding-left: 8px;

        border-bottom: 1px #cbcbcb solid !important;

        text-transform: uppercase;

        font-weight: 500;

        font-size: 0.70rem;

    }





    .m-thead {

        font-family: Lato;

        font-weight: 700 !important;

        font-size: 15px !important;

    }





    .m-thead-mobile {

        font-family: Lato;

        font-weight: 600 !important;

        font-size: 13px !important;



    }


    .badge {
        font-weight: 500;
        background: #f5f5f5;
        color: #555;
        border: none;
        padding: 4px 10px;
        border-radius: 4px;
        font-size: 0.75rem;
    }

    .badge-danger {
        background: #fee;
        color: #c53030;
    }

    .badge-warning {
        background: #fffbeb;
        color: #d97706;
    }

    .badge-info {
        background: #eff6ff;
        color: #2563eb;
    }
</style>

@endsection



@section('content')

<div style="padding-top: 16px;margin-left: 8px">

    <div style="margin-top:8px;padding-left: 10px;padding-right: 10px;">
        <div class="box" style="margin-bottom: 0.5em;border: none;">
            <div class="filters" style="margin-bottom: 4px;">
                <div class="row">
                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Province :</span>
                            </div>

                            <select id="provinces_filter" class="form-control select2 m-tout dt_filter"
                                column="province_id" table="">
                                <option value="all" selected>Indifferent</option>
                                @foreach($provinces as $province)
                                <option value="{{$province->id}}">{{$province->nom}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Arrondissement :</span>
                            </div>
                            <select id="arrondissements_filter" class="form-control select2 m-tout dt_filter"
                                column="arrondissement_id" table="">
                                <option value="all" selected>Indifferent</option>
                                @foreach($arrondissements as $arrondissement)
                                <option value="{{$arrondissement->id}}">{{$arrondissement->nom}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Annexe administrative :</span>
                            </div>
                            <select id="annexes_administratives_filter" class="form-control select2 m-tout dt_filter"
                                column="annexe_administrative_id" table="">
                                <option value="all" selected>Indifferent</option>
                                @foreach($annexes_administratives as $annexe_administrative)
                                <option value="{{$annexe_administrative->id}}">{{$annexe_administrative->nom}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="input-group input-group-sm col-lg-3">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 160px;">Quartier :</span>
                            </div>
                            <select id="quartiers_filter" class="form-control select2 m-tout dt_filter"
                                column="quartier_id" table="">
                                <option value="all" selected>Indifferent</option>
                                @foreach($quartiers as $quartier)
                                <option value="{{$quartier->id}}">{{$quartier->nom}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>          

                <hr>
            </div>
        </div>

        <div class="table-responsive">
            <div class="row">
                <div class="col-lg-3">
                    <button class="mr-3 btn dossiers_table_export_excel"><i class="fa fa-file-excel-o"></i> Exporter
                        Excel</button>
                    <span>Nombre batisses : <b style="color:#63a013" id="dt_ratissages_count">0</b></span>
                </div>

                <div class="input-group input-group-sm col-3">
                </div>
                <div class="input-group input-group-sm col-3">
                </div>
                <div class="input-group input-group-sm col-3">
                    <div class="input-group">
                        <div class="input-group-prepend">
                            <span class="input-group-text" style="width: 160px;">ID :</span>
                        </div>
                        <input placeholder="ID" class="form-control dt_filter" column="numero" table="">
                    </div>
                </div>

                <div class="input-group input-group-sm col-3">
                
                </div>
            </div>

            <table class="table table-striped datatables dataTable no-footer display nowrap" id="ratissages_table"
                style="min-width: 1200px;margin-top: 10px !important;">
                <thead>
                    <th>ID</th>                    
                    <th>MÉNAGES</th>               
                    <th>ARRONDISSEMENT</th>               
                    <th>ANNEXE ADMINISTRATIVE</th>               
                    <th>Rue</th>   
                    <th>Adresse</th>            
                    <th>Date</th>               
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
    </div>
</div>


@endsection
<script>
    var provinces = @json($provinces);
    var arrondissements = @json($arrondissements);
    var annexes_administratives = @json($annexes_administratives);
    var quartiers = @json($quartiers);
</script>
@push('added_scripts')
<script src="{{asset('js/ratissages/index.js').'?t='.time()}}"></script>
@endpush