@extends('layouts.app')
@section('added_css')
@endsection
@section('content')

<style>
    .btn_active {
        background: #c0665b !important;
        color: white !important;
        pointer-events: none;
    }
</style>

<div style="padding-top: 16px;margin-left: 8px;">

    <div style="margin-top:8px;padding-left: 10px;padding-right: 10px;">



        <div class="row">
            <div class="input-group input-group-sm col-lg-3">
                <div class="input-group mb-1">
                    <div class="input-group-prepend">
                        <span class="input-group-text" style="width: 160px;">Province :</span>
                    </div>
                    <select id="provinces_filter" class="form-control select2 m-tout dt_filter" column="province_id" table="">
                        <option value="all" selected>Indifferent</option>
                        @foreach($provinces as $province)
                        <option value="{{$province->id}}">{{$province->nom}}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="input-group input-group-sm col-lg-3">
                <div class="input-group mb-1">
                    <div class="input-group-prepend">
                        <span class="input-group-text" style="width: 160px;">Commune :</span>
                    </div>
                    <select id="communes_filter" class="form-control select2 m-tout dt_filter" column="commune_id" table="">
                        <option value="all" selected>Indifferent</option>

                        @foreach($communes as $commune)
                        <option value="{{$commune->id}}">{{$commune->nom}}</option>
                        @endforeach

                    </select>
                </div>
            </div>

            <div class="input-group input-group-sm col-lg-3">
                <div class="input-group mb-1">
                    <div class="input-group-prepend">
                        <span class="input-group-text" style="width: 160px;">Douar :</span>
                    </div>
                    <select id="douars_filter" class="form-control select2 m-tout dt_filter" column="id_douar" table="">
                        <option value="all" selected>Indifferent</option>
                        @foreach($douars as $douar)
                        <option value="{{$douar->id}}">{{$douar->nom}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>

        <div class="row mt-2" style="font-family: Roboto;padding: 8px; border-top: 1px #e5e5e5 solid; ">
            <div class="col">
                <button style="display: block;margin: auto;width:100%" id="filter_recenses_par_cin_btn" type="button" class="btn btn_active filter_btn"><i class="fa-solid fa-check"></i>&nbsp;Recensés trouvés par CIN</button>
            </div>
            <div class="col">
                <button style="display: block;margin: auto;width:100%" id="filter_recenses_par_nom_btn" type="button" class="btn filter_btn"><i class="fa-solid fa-check"></i>&nbsp;Recensés trouvés par nom</button>
            </div>
            <div class="col">
                <button style="display: block;margin: auto;width:100%" id="filter_non_recenses_trouves_btn" type="button" class="btn filter_btn"><i class="fa-solid fa-check"></i>&nbsp;Non recensés et trouvés</button>
            </div>
            <div class="col">
                <button style="display: block;margin: auto;width:100%" id="filter_recenses_non_trouves_localises_btn" type="button" class="btn filter_btn"><i class="fa-solid fa-check"></i>&nbsp;Recensés non trouvés et localisé</button>
            </div>
            <div class="col">
                <button style="display: block;margin: auto;width:100%" id="filter_recenses_non_trouves_non_localises_btn" type="button" class="btn filter_btn"><i class="fa-solid fa-check"></i>&nbsp;Recensés non trouvés et non localisé</button>
            </div>
        </div>

        <div class="table-responsive">

            <div class="row">
                <div class="col-lg-3">

                    <button class="mr-3 btn menages_table_export_excel"><i class="fa fa-file-excel-o"></i> Exporter Excel</button>
                    <span>Nombres : <b style="color:#63a013" id="dt_dossiers_count">0</b></span>
                </div>


            </div>

            <table class="table table-striped datatables dataTable no-footer display nowrap" id="menages_table" style="min-width: 1200px;">
                <thead>
                    <th>CIN</th>
                    <th>Nom</th>
                    <th>Prénom</th>
                    <th>CIN conjoint</th>
                    <th>Nom conjoint</th>
                    <th>Prénom conjoint</th>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
    </div>
</div>


<script>
    var provinces = @json($provinces);
  
    var communes = @json($communes);
    var douars = @json($douars);
</script>
@endsection
@push('added_scripts')

<script src="{{asset('js/recoupement/index.js').'?t='.time()}}"></script>


@endpush