<?php

use App\Http\Controllers\DashboardController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\PagesController;
use App\Http\Controllers\InvitationController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\LoginSecurityController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AppTerrainController;
use App\Http\Controllers\VerificationController;
use App\Http\Controllers\RecoupementController;
use App\Http\Controllers\GeoportailController;
use App\Http\Controllers\BaraquesContorller;
use App\Http\Controllers\MenagesController;
use App\Http\Controllers\ProjetsController;
use App\Http\Controllers\CentreDonneesController;
use App\Http\Controllers\GestionComptesController;
use App\Http\Controllers\QRCodeController;
use App\Http\Controllers\TravauxCommissionsController;
use App\Http\Controllers\DocumentGeneratorController;
use App\Http\Controllers\RatissagesController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/testdb', [PagesController::class, 'testdb']);

Route::get('/qr_code/generate_img', [QRCodeController::class, 'generate_qrcode_image']);
Route::get('/qr_code/show/{id}', [QRCodeController::class, 'show']);

//invitation
Route::get('/invitation/{user_id}/{token}', [InvitationController::class, 'show']);
Route::post('/invitation-save-pwd/', [InvitationController::class, 'invitation_save_pwd']);
Route::post('/send-forgotpwd-mail', [UserController::class, 'send_forgotpwd_mail']);
Route::get('/reset-pwd/{user_id}/{token}', [UserController::class, 'reset_pwd']);
Route::post('/reset-save-pwd', [UserController::class, 'reset_save_pwd']);

Auth::routes();
Route::get('/', [PagesController::class, 'index']);

Route::get('/index', [PagesController::class, 'index_new']);


Route::group(['prefix' => '2fa'], function () {


    Route::get('/', [LoginSecurityController::class, 'show2faForm'])->name("show2faForm");;
    Route::post('/generateSecret', [LoginSecurityController::class, 'generate2faSecret'])->name("generate2faSecret");
    Route::post('/enable2fa', [LoginSecurityController::class, 'enable2fa'])->name("enable2fa");
    Route::post('/disable2fa', [LoginSecurityController::class, 'disable2fa'])->name("disable2fa");


    // 2fa middleware
    Route::post('/2faVerify', function () {
        return redirect(URL()->previous());
    })->name('2faVerify')->middleware('2fa');
});

Route::post('/user/store', [UserController::class, 'store'])->name('user.store');

Route::post('/user/store_proposition', [UserController::class, 'store_proposition']);



Route::get('language/{locale}', function ($locale) {
    app()->setLocale($locale);
    session()->put('locale', $locale);
    return redirect()->back();
});
Route::post('/app_terrain/upload_tab', [AppTerrainController::class, 'upload_tab']);
Route::post('/app_terrain/sync_photo_tab', [AppTerrainController::class, 'sync_photo_tab']);


Route::get('/travaux_commissions/get_pv_etude', [TravauxCommissionsController::class, 'get_pv_etude']);
Route::get('/travaux_commissions/PV_ETUDE_generated', [TravauxCommissionsController::class, 'PV_ETUDE_generated']);

Route::get('/travaux_commissions/get_pv_tas', [TravauxCommissionsController::class, 'get_pv_tas']);
Route::get('/travaux_commissions/PV_TAS_STOCK_generated', [TravauxCommissionsController::class, 'PV_TAS_STOCK_generated']);
Route::get('/travaux_commissions/PV_TAS_generated', [TravauxCommissionsController::class, 'PV_TAS_generated']);
Route::get('/travaux_commissions/PV_TAS_BONS_generated', [TravauxCommissionsController::class, 'PV_TAS_BONS_generated']);


Route::get('/menage/get_menage', [MenagesController::class, 'get_menage']);



Route::group(
    ['middleware' => ['auth', '2fa']],
    function () {

        Route::get('/phpinfo', function () {
            phpinfo();
        });


        //DASHBOARD       
        Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
        Route::get('/dashboard/getStats', [DashboardController::class, 'getStats']);

        Route::get('/dashboard/depot_dossiers_attribution_chart', [DashboardController::class, 'depot_dossiers_attribution_chart']);
        Route::get('/dashboard/evolution_des_avances_chart', [DashboardController::class, 'evolution_des_avances_chart']);



        //USER   

        Route::get('/logoutn', function () {
            Auth::logout();
            return redirect('/'); // Redirect to the login page or any desired page
        })->name('logoutn');
        Route::post('/user/delete', [UserController::class, 'delete'])->name('user.delete');
        Route::get('/user/{id}', [UserController::class, 'get']);
        Route::get('/send-invitation-mail/{user_id}', [UserController::class, 'send_invitation_mail']);
        Route::get('/gestion_comptes', [UserController::class, 'gestion_compte_index'])->name('gestion_comptes');
        Route::get('/users/datatble', [UserController::class, 'datatable']);


        //APP TERRAIN
        Route::get('/app_terrain', [AppTerrainController::class, 'index'])->name('app_terrain');
        Route::post('/app_terrain/upload', [AppTerrainController::class, 'upload']);
        Route::post('/app_terrain/delete', [AppTerrainController::class, 'delete']);

        Route::post('/app_terrain/store', [AppTerrainController::class, 'store']);
        Route::get('/app_terrain/geometriesCount', [AppTerrainController::class, 'geometriesCount']);
        Route::get('/app_terrain/loadGeometries', [AppTerrainController::class, 'loadGeometries']);
        Route::get('/app_terrain/gerDouarsDatatable', [AppTerrainController::class, 'gerDouarsDatatable']);
        Route::get('/app_terrain/basemap_tile/{id}/{z}/{x}/{y}', [AppTerrainController::class, 'basemap_tile']);

        Route::get('/app_terrain/show_media/{document_id}', [AppTerrainController::class, 'show_media']);


        Route::get('/app_terrain/getBaraque', [AppTerrainController::class, 'getBaraque']);

        Route::post('/app_terrain/edit_geometry', [AppTerrainController::class, 'edit_geometry']);

        //PROFILE
        Route::get('/profile', [ProfileController::class, 'index'])->name('profile.index');
        Route::post('/profile/update', [ProfileController::class, 'update']);
        Route::post('/profile/updatePassword', [ProfileController::class, 'updatePassword']);



        //VERIFICATION
        Route::get('/verification', [VerificationController::class, 'index'])->name('verification');
        Route::get('/verification/next', [VerificationController::class, 'get_next']);
        Route::get('/verification/show/{id}', [VerificationController::class, 'show']);
        Route::post('/verification/affectation_photos', [VerificationController::class, 'affectation_photos']);
        Route::post('/verification/delete_selected_photo', [VerificationController::class, 'delete_selected_photo']);

        Route::post('/verification/validate_menage', [VerificationController::class, 'validate_menage']);
        Route::post('/verification/reject_menage', [VerificationController::class, 'reject_menage']);
        Route::post('/verification/complete_validation', [VerificationController::class, 'complete_validation']);
        Route::post('/verification/complete_affectation', [VerificationController::class, 'complete_affectation']);

        Route::post('/verification/validate_commerce', [VerificationController::class, 'validate_commerce']);
        Route::post('/verification/reject_commerce', [VerificationController::class, 'reject_commerce']);

        Route::get('/verification/get_baraques_refuses', [VerificationController::class, 'get_baraques_refuses']);
        Route::get('/verification/get_baraques_en_attente', [VerificationController::class, 'get_baraques_en_attente']);
        Route::get('/verification/get_baraques_en_attente_v2', [VerificationController::class, 'get_baraques_en_attente_v2']);

        Route::get('/fix_geometry', [VerificationController::class, 'fix_geometry']);


        Route::get('/verification/downloadPhotos', [VerificationController::class, 'downloadPhotos']);

        Route::get('/verification/updateVerified', [VerificationController::class, 'updateVerified']);

        Route::get('/verification/exportData', [VerificationController::class, 'exportData']);


        Route::post('/verification/delete_baraque', [VerificationController::class, 'delete_baraque']);
        Route::post('/verification/delete_menage', [VerificationController::class, 'delete_menage']);

        Route::get('/verification/search_by_name', [VerificationController::class, 'search_by_name']);


        //VERIFICATION 2
        Route::get('/verification2', [VerificationController::class, 'index_v2'])->name('verification2');
        Route::get('/verification2/next', [VerificationController::class, 'v2_get_next']);
        Route::get('/verification2/show/{id}', [VerificationController::class, 'v2_show']);

        Route::post('/verification2/complete_validation', [VerificationController::class, 'complete_validation2']);
        Route::post('/verification2/validate_menage', [VerificationController::class, 'validate_menage_2']);
        Route::post('/verification2/validate_commerce', [VerificationController::class, 'validate_commerce_2']);
        //GEOPORTAIL
        Route::get('/geoportail', [GeoportailController::class, 'index'])->name('geoportail');
        Route::get('/geoportail/baraques_datatable', [GeoportailController::class, 'baraques_datatable']);
        Route::get('/geoportail/map_get_baraques', [GeoportailController::class, 'map_get_baraques']);
        Route::get('/geoportail/baraque/data/{id}', [GeoportailController::class, 'baraque_data']);

         //RATISSAGES
        Route::get('/ratissages', [RatissagesController::class, 'index'])->name('ratissages');
        Route::get('/ratissages/ratissages_datatable', [RatissagesController::class, 'ratissages_datatable']);
        Route::get('/ratissages/show/{id}', [RatissagesController::class, 'show']);
        Route::post('/ratissages/store', [RatissagesController::class, 'store']);
        Route::get('/ratissages/file/{id}', [RatissagesController::class, 'file']);
        Route::post('/ratissages/file/upload', [RatissagesController::class, 'upload']);
        Route::post('ratissages/menage/file/upload', [RatissagesController::class, 'uploadMenageDocument'])->name('ratissages.menage.upload');
        Route::get('ratissages/menage/file/{id}', [RatissagesController::class, 'downloadMenageDocument'])->name('ratissages.menage.download');


        //BARAQUES

        Route::get('/baraques', [BaraquesContorller::class, 'index'])->name('baraques');
        Route::get('/baraques/baraques_datatable', [BaraquesContorller::class, 'baraques_datatable']);
        Route::get('/baraques/show/{id}', [BaraquesContorller::class, 'show']);
        Route::get('/baraques/update_zone_pa_ref', [BaraquesContorller::class, 'update_zone_pa_ref']); //temp

        Route::get('/baraques/pa_datatable', [BaraquesContorller::class, 'pa_datatable']);
        Route::get('/baraques/titres_datatable', [BaraquesContorller::class, 'titres_datatable']);


        //MENAGES
        Route::get('/menages', [MenagesController::class, 'index'])->name('menages');
        Route::get('/menages/menages_datatable', [MenagesController::class, 'menages_datatable']);
        Route::get('/menages/show/{id}', [MenagesController::class, 'show']);
        Route::post('/dossiers/store', [MenagesController::class, 'store']);
        Route::get('/menages/file/{id}', [MenagesController::class, 'file']);
        Route::post('/menages/file/upload', [MenagesController::class, 'upload']);
        Route::get('/menages/file_data/{id}', [MenagesController::class, 'file_data']);
        Route::post('/menages/validate_document', [MenagesController::class, 'validate_document']);
        Route::post('/menages/rejeter_document', [MenagesController::class, 'rejeter_document']);

        Route::post('/menages/chef_menage/edit', [MenagesController::class, 'edit_chef_menage']);
        Route::post('/menages/chef_menage/validate', [MenagesController::class, 'validate_chef_menage']);


        Route::post('/menages/notaire_etude/edit', [MenagesController::class, 'edit_notaire_etude']);


        //MENAGES-PROJET DESTINATION
        Route::post('/menages/affcetation_projet', [MenagesController::class, 'affcetation_projet']);

        // PROJETS
        Route::get('/projets', [ProjetsController::class, 'index'])->name('projets');
        Route::get('/projets/projets_datatable', [ProjetsController::class, 'projets_datatable']);
        Route::post('/projet/store', [ProjetsController::class, 'store']);
        Route::get('/projets/show/{id}', [ProjetsController::class, 'show']);
        Route::get('/projets/get-projets/{id?}', [ProjetsController::class, 'get_projets'])->name('projets.get_projets');
        Route::get('/projets/file/{id}', [ProjetsController::class, 'file']);
        Route::post('/projets/file/upload', [ProjetsController::class, 'upload']);
        Route::get('/projets/file_data/{id}', [ProjetsController::class, 'file_data']);
        Route::get('/projets/douars_affectes_datatable', [ProjetsController::class, 'douars_affectes_datatable']);
        Route::post('/projet/assigner_douar', [ProjetsController::class, 'assigner_douar']);



        //CENTRE DE DONNEES
        Route::get('/centre_donnees', [CentreDonneesController::class, 'index'])->name('centre_donnees');


        // GESTION DE COMPTES
        Route::get('/gestion-comptes', [GestionComptesController::class, 'index'])->name('gestion-comptes');
        Route::get('/gestion-comptes/comptes_datatable', [GestionComptesController::class, 'comptes_datatable']);


        Route::get('/centre_donnees/projets/datatable', [CentreDonneesController::class, 'projets_datatable']);
        Route::get('/centre_donnees/projets/get', [CentreDonneesController::class, 'get_projet']);

        Route::get('/centre_donnees/stock/datatable', [CentreDonneesController::class, 'stock_datatable']);

        Route::get('/centre_donnees/mappe/datatable', [CentreDonneesController::class, 'mappe_datatable']);
        Route::get('/centre_donnees/mappe/getall', [CentreDonneesController::class, 'mappe_getall']);

        Route::get('/centre_donnees/pa/datatable', [CentreDonneesController::class, 'pa_datatable']);
        Route::get('/centre_donnees/pa/getall', [CentreDonneesController::class, 'pa_getall']);


        //GENERATE DOCUMENTS
        Route::get('/document/generate_AUTORISATION_VERSEMENT', [DocumentGeneratorController::class, 'generate_AUTORISATION_VERSEMENT']);
        Route::get('/document/generate_ATTESTATION_ATTRIBUTION', [DocumentGeneratorController::class, 'generate_ATTESTATION_ATTRIBUTION']);

        //QR CODE
        Route::get('/qr_code/generate', [QRCodeController::class, 'generate_qrcode']);
        Route::get('/qr_code/generate_document', [QRCodeController::class, 'generate_document']);


        //RECOUPEMENT       
        Route::get('/recoupement', [RecoupementController::class, 'index'])->name('recoupement');
        Route::get('/recoupement/menages_datatable', [RecoupementController::class, 'menages_datatable']);
        Route::get('/recoupement/fix_menages_active', [RecoupementController::class, 'fix_menages_active']);
        Route::get('/recoupement/process', [RecoupementController::class, 'process']);

        Route::get('/recoupement/recensement_datatable', [RecoupementController::class, 'recensement_datatable']);

        Route::get('/test_tahssine', [VerificationController::class, 'test_tahssine']);

        //TRAVAUX COMMISSIONS
        Route::get('/travaux_commissions', [TravauxCommissionsController::class, 'index'])->name('travaux_commissions');
        Route::get('/travaux_commissions/membres_datatable', [TravauxCommissionsController::class, 'membres_datatable']);
        Route::post('/travaux_commissions/store_membre', [TravauxCommissionsController::class, 'store_membre']);
        Route::post('/travaux_commissions/check_cin', [TravauxCommissionsController::class, 'check_cin']);
        Route::post('/travaux_commissions/pv_etude_store', [TravauxCommissionsController::class, 'pv_etude_store']);
        Route::get('/travaux_commissions/etudes_pv_datatable', [TravauxCommissionsController::class, 'etudes_pv_datatable']);

        //TRAVAUX COMMISSIONS-TAS
        Route::get('/travaux_commissions/pv_tas_datatable', [TravauxCommissionsController::class, 'pv_tas_datatable']);
        Route::post('/travaux_commissions/pv_tas_get_immeubles', [TravauxCommissionsController::class, 'pv_tas_get_immeubles']);
        Route::post('/travaux_commissions/pv_tas_get_stock_from_immeuble', [TravauxCommissionsController::class, 'pv_tas_get_stock_from_immeuble']);
        Route::post('/travaux_commissions/pv_tas_get_stock_from_projet', [TravauxCommissionsController::class, 'pv_tas_get_stock_from_projet']);
        Route::post('/travaux_commissions/pv_tas_get_stock_stats', [TravauxCommissionsController::class, 'pv_tas_get_stock_stats']);
        Route::post('/travaux_commissions/pv_tas_store', [TravauxCommissionsController::class, 'pv_tas_store']);


        Route::get('/travaux_commissions/downloadPVEtudeGenerated/{id}', [TravauxCommissionsController::class, 'downloadPVEtudeGenerated']);
        Route::post('/travaux_commissions/upload_signed_pv_etude', [TravauxCommissionsController::class, 'upload_signed_pv_etude']);

        Route::get('/travaux_commissions/pv_tas_generation_stats', [TravauxCommissionsController::class, 'pv_tas_generation_stats']);

        Route::get('/travaux_commissions/download_pv_tas_stock_Generated/{id}', [TravauxCommissionsController::class, 'download_pv_tas_stock_Generated']);
        Route::get('/travaux_commissions/download_pv_tas_Generated/{id}', [TravauxCommissionsController::class, 'download_pv_tas_Generated']);
        Route::get('/travaux_commissions/download_pv_tas_bons_Generated/{id}', [TravauxCommissionsController::class, 'download_pv_tas_bons_Generated']);

        Route::get('/travaux_commissions/pv_etude_generation_stats', [TravauxCommissionsController::class, 'pv_etude_generation_stats']);

        Route::post('/travaux_commissions/upload_signed_pv_tas', [TravauxCommissionsController::class, 'upload_signed_pv_tas']);

        Route::post('/travaux_commissions/pv_tas_get_douars', [TravauxCommissionsController::class, 'pv_tas_get_douars']);
    }
);
