
<?php $__env->startSection('added_css'); ?>
<?php $__env->startSection('content'); ?>
<style>
    [type=checkbox]:checked,
    [type=checkbox]:not(:checked) {
        opacity: 1;
        display: inline-block;
        accent-color: #1ca31c;
        zoom: 1.5;
    }

    .form-check-label {
        margin-bottom: 0;
        font-weight: 500 !important;
    }

    .btns-container {
        width: 90px;
        height: auto;
        position: fixed;
        transition: all 0.3s;
        z-index: 9999;
        opacity: 1;
    }

    .btns-container.left {
        top: 8px;
        left: 8px;
    }

    .btns-container.right {
        top: 8px;
        right: 8px;
    }


    .btns-container.bottom-center {
        bottom: 8px;
        left: calc(50% - 111px);
        width: 100%;
        height: 90px;
    }

    .btns-container.disabled {
        opacity: 0;
        pointer-events: none;
    }

    .map-btn {
        width: 74px;
        height: 74px;
        background: #ffffff;
        border: 2px #ce6110 solid;
        border-radius: 40%;
        margin: 8px;
        transition: all 0.3s;
        float: left;
    }

    .map-btn.disabled {
        filter: grayscale(1);
        pointer-events: none;
        opacity: 0.5;
    }

    .map-btn:hover {
        background: #f1efef;
        cursor: pointer;
    }

    .map-btn svg {
        width: 100%;
        height: 40px;
        display: block;
        margin: auto;
        padding: 4px;
        margin-top: 4px;
    }

    .map-btn span {
        font-weight: 500;
        font-size: 10px;
        text-align: center;
        display: block;
        color: #ce6110;
    }

    .modal-header {
        padding: 20px;
        background: #f0f0f0;
        border-style: solid;
        border-width: 0px 0px 1px 0px;
        border-color: #cdcdcd !important;
    }


    .btn-big {
        background-color: #fcfcfc !important;
        border-color: #00000029 !important;
        color: #0b52ad !important;
        box-shadow: 0px 1px 10px 3px rgb(0 0 0 / 11%) !important;
        font-size: 15px !important;
        padding: 8px !important;
    }

    .h7 {
        line-height: 20px;
        color: #0a6fbf;
        font-size: 17px;
        font-weight: 500;
        padding: 16px;
        border-bottom: 1px #b3b3b3 dashed;
        display: block;
        margin-bottom: 16px;
    }

    .h8 {
        line-height: 16px;
        color: #5c5c5c;
        font-size: 17px;
        font-weight: 500;
        padding: 9px;
        display: block;
        margin-bottom: 16px;
    }

    .input-group>.input-group-prepend>.btn,
    .input-group>.input-group-prepend>.input-group-text,
    .input-group>.input-group-append:not(:last-child)>.btn,
    .input-group>.input-group-append:not(:last-child)>.input-group-text,
    .input-group>.input-group-append:last-child>.btn:not(:last-child):not(.dropdown-toggle),
    .input-group>.input-group-append:last-child>.input-group-text:not(:last-child) {
        color: gray !important;
        font-size: 15px !important;
    }

    .form-control {
        font-size: 15px !important;
    }

    .modal-title {
        margin-bottom: 0 !important;
        margin-top: 0 !important;
        color: #272727 !important;
        font-size: 18px !important;
    }

    .leaflet-popup-content {
        max-width: 200px;
        width: 200px;

    }

    .btn {
        background-color: #195cb1 !important;
        border-color: #00000000 !important;
        color: #ffffff;
        padding: 8px 16px;
        box-shadow: 0px 0px 8px 0px rgb(0 0 0 / 5%) !important;
    }

    .btn-danger {
        background-color: #ff3e3e !important;

    }

    .btn:hover {
        opacity: 0.75 !important;
        color: white !important;
        background: #195cb1 !important;
    }

    .nav-tabs .nav-link.active {
        background-color: #195cb1;
        color: #ffffff !important;
        text-decoration: none !important;
        font-weight: 400 !important;
        font-size: 14px !important;
        height: 30px;
        bottom: 0px !important;
    }

    .select2-container .select2-selection--single .select2-selection__rendered {

        font-size: 14px !important;
    }

    .costume-img {
        transition: 0.3s;
    }

    .sync_info_div {
        display: none;
        color: #616161;
        z-index: 9999999999;
        position: absolute;
        font-weight: 500;
        font-size: 14px;
        bottom: 16px;
        left: 16px;
        background: #ffffff;
        padding: 8px;
        border-radius: 16px;
    }

    .sync_info_div.active {
        display: block;
    }
</style>

<div id="map" style="height: 100vh; width: 100vw;">

    <div class="sync_info_div">
        <span>Synchronisation : <b class="sync_info_sync_count">0</b> / <b class="sync_info_total">0</b></span>
    </div>
    <div id="drawing_tools_div" class="btns-container disabled bottom-center ">
        <div class="drawing_close map-btn">

            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 220 199.45">
                <defs>
                    <style>
                        .cls-1 {
                            fill: #1b6eb2;
                        }

                        .cls-1,
                        .cls-2 {
                            stroke-width: 0px;
                        }

                        .cls-2 {
                            fill: #6fb319;
                        }
                    </style>
                </defs>
                <rect class="cls-2" x="58.48" y="1.86" width="12.09" height="123.51" transform="translate(63.88 -26.99) rotate(45)" />
                <rect class="cls-2" x="149.14" y="74.39" width="12.09" height="123.51" transform="translate(141.72 -69.85) rotate(45)" />
                <rect class="cls-2" x="101.97" y="41.24" width="102.75" height="11.85" transform="translate(59.1 -82.67) rotate(36.93)" />
                <rect class="cls-2" x="11.28" y="141.65" width="102.75" height="11.85" transform="translate(101.24 -8.04) rotate(36.93)" />
                <circle class="cls-1" cx="111.81" cy="16.32" r="16.32" />
                <circle class="cls-1" cx="16.32" cy="111.81" r="16.32" />
                <circle class="cls-1" cx="203.68" cy="85.22" r="16.32" />
                <circle class="cls-1" cx="110.6" cy="183.13" r="16.32" />
            </svg>
            <span>Clore</span>
        </div>

        <div class="drawing_delete_last_vertex map-btn">

            <svg fill="#1b6eb2" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg">
                <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                <g id="SVGRepo_iconCarrier">
                    <path d="M8.06.56A8.05 8.05 0 0 0 1.24 4.2V1.55H0V5a1.16 1.16 0 0 0 1.15 1.14h3.44V4.9H2.27a6.79 6.79 0 0 1 5.79-3.1 6.48 6.48 0 0 1 6.7 6.2 6.48 6.48 0 0 1-6.7 6.2A6.48 6.48 0 0 1 1.36 8H.12a7.71 7.71 0 0 0 7.94 7.44A7.71 7.71 0 0 0 16 8 7.71 7.71 0 0 0 8.06.56z"></path>
                </g>
            </svg>
            <span>Annuler point</span>
        </div>

        <div class="drawing_cancel map-btn">

            <svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 128 128" enable-background="new 0 0 128 128" xml:space="preserve" fill="#000000">
                <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                <g id="SVGRepo_iconCarrier">
                    <g>
                        <g>
                            <path fill="#1b6eb2" d="M64,0C28.656,0,0,28.656,0,64s28.656,64,64,64s64-28.656,64-64S99.344,0,64,0z M64,120 C33.125,120,8,94.875,8,64S33.125,8,64,8s56,25.125,56,56S94.875,120,64,120z"></path>
                        </g>
                    </g>
                    <g>
                        <g>
                            <path fill="#F44336" d="M75.313,64l16.969-16.969c3.125-3.125,3.125-8.195,0-11.313c-3.117-3.125-8.188-3.125-11.313,0L64,52.688 L47.031,35.719c-3.125-3.125-8.195-3.125-11.313,0c-3.125,3.117-3.125,8.188,0,11.313L52.688,64L35.719,80.969 c-3.125,3.125-3.125,8.195,0,11.313c3.117,3.125,8.188,3.125,11.313,0L64,75.313l16.969,16.969c3.125,3.125,8.195,3.125,11.313,0 c3.125-3.117,3.125-8.188,0-11.313L75.313,64z"></path>
                        </g>
                    </g>
                </g>
            </svg>
            <span>Annuler</span>
        </div>


    </div>


    <div class="btns-container left">
        <div class="add_baraque map-btn">

            <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                <g id="SVGRepo_iconCarrier">
                    <path d="M10 14H12M12 14H14M12 14V16M12 14V12" stroke="#2c6ade" stroke-width="1.5" stroke-linecap="round"></path>
                    <path d="M22 11.7979C22 9.16554 22 7.84935 21.2305 6.99383C21.1598 6.91514 21.0849 6.84024 21.0062 6.76946C20.1506 6 18.8345 6 16.2021 6H15.8284C14.6747 6 14.0979 6 13.5604 5.84678C13.2651 5.7626 12.9804 5.64471 12.7121 5.49543C12.2237 5.22367 11.8158 4.81578 11 4L10.4497 3.44975C10.1763 3.17633 10.0396 3.03961 9.89594 2.92051C9.27652 2.40704 8.51665 2.09229 7.71557 2.01738C7.52976 2 7.33642 2 6.94975 2C6.06722 2 5.62595 2 5.25839 2.06935C3.64031 2.37464 2.37464 3.64031 2.06935 5.25839C2 5.62595 2 6.06722 2 6.94975M21.9913 16C21.9554 18.4796 21.7715 19.8853 20.8284 20.8284C19.6569 22 17.7712 22 14 22H10C6.22876 22 4.34315 22 3.17157 20.8284C2 19.6569 2 17.7712 2 14V11" stroke="#2c6ade" stroke-width="1.5" stroke-linecap="round"></path>
                </g>
            </svg>
            <span>Ajouter</span>
        </div>

        <div class="douars_map map-btn">

            <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" fill="#2c6ade">
                <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                <g id="SVGRepo_iconCarrier">
                    <path d="M21.981 15.677V2.02H2.021v19.96h19.96v-6.264l.019-.024zm-.981-.08c-.171.03-.36.045-.45.059a2.283 2.283 0 0 1-.366.04c-.295 0-.69-.347-.952-.577a1.218 1.218 0 0 1-.197-.36c-.135-.313-.361-.839-.962-.839a1.464 1.464 0 0 0-.981.383.578.578 0 0 1-.41.185.711.711 0 0 1-.22-.08 1.405 1.405 0 0 0-.61-.165.987.987 0 0 0-1.079.869v.695c0 .09-.046.15-.216.32a1.345 1.345 0 0 0-.485.975 1.06 1.06 0 0 0 .33.675c.033.038.079.093.101.097a1.71 1.71 0 0 1-.41.147c-.41.113-1.096.302-1.096 1.054a1.122 1.122 0 0 0 .294.675l.08.107c-.044.114-.128.303-.217.505-.096.221-.194.45-.27.638h-2.477v-.024a2.118 2.118 0 0 1 .17-.755l.048-.14a2.708 2.708 0 0 0 .173-.922c0-.805-.81-.994-1.294-1.107l-.429-.1c-.16-.319-.081-.448.33-.859a1.78 1.78 0 0 0 .68-1.25 1.107 1.107 0 0 0-.88-1.172 1.502 1.502 0 0 0-.79.127.878.878 0 0 1-.36.084.258.258 0 0 1-.144-.036.9.9 0 0 1 .158-.44 1.755 1.755 0 0 0 .27-.88 2.126 2.126 0 0 0-.086-.563 1.236 1.236 0 0 1-.056-.329.4.4 0 0 1 .356-.428c.145 0 .228.109.452.509a1.33 1.33 0 0 0 1.26.666c.956 0 1.567-1.076 1.567-1.816 0-.105.074-.215.144-.215.078 0 .146.045.292.156a1.356 1.356 0 0 0 .85.342 1.408 1.408 0 0 0 1.234-.921 1.372 1.372 0 0 1 .446-.56 2.01 2.01 0 0 0 .748-2.418c.046-.075.15-.184.141-.2a1.091 1.091 0 0 0 .943-.297 1.224 1.224 0 0 0 .156-1.09.946.946 0 0 1-.027-.264.925.925 0 0 1 .26-.278 1.34 1.34 0 0 0 .59-1.029 1.374 1.374 0 0 0-.22-.706.54.54 0 0 1-.103-.255c0-.051.101-.373.921-.818L18.231 3H21zM3 3h13.709a1.277 1.277 0 0 0-.347.83 1.375 1.375 0 0 0 .221.71.538.538 0 0 1 .102.251c0 .085-.064.153-.266.326a1.578 1.578 0 0 0-.536.687 1.085 1.085 0 0 0-.054.343 2.152 2.152 0 0 0 .05.388c.018.098.054.28.09.28a.496.496 0 0 1-.218.011 1.15 1.15 0 0 0-.84.438.972.972 0 0 0-.27.868c.151.742.151 1.188-.282 1.421a2.138 2.138 0 0 0-.812.92c-.214.38-.283.451-.429.451-.079 0-.146-.045-.293-.156a1.35 1.35 0 0 0-.849-.342 1.106 1.106 0 0 0-1.068 1.139c0 .298-.278.892-.644.892-.346 0-.414-.124-.465-.216a1.45 1.45 0 0 0-1.246-.96 1.32 1.32 0 0 0-1.28 1.353 2.126 2.126 0 0 0 .086.563 1.234 1.234 0 0 1 .056.328.9.9 0 0 1-.158.44 1.754 1.754 0 0 0-.27.881 1.02 1.02 0 0 0 1.068.96 1.788 1.788 0 0 0 .695-.146.808.808 0 0 1 .323-.084h.007a.496.496 0 0 1 .08.267c0 .176-.154.343-.407.596a1.52 1.52 0 0 0-.505 1.928 1.413 1.413 0 0 0 1.045.585c.184.042.525.121.58.207a1.807 1.807 0 0 1-.121.621l-.046.13a2.985 2.985 0 0 0-.223 1.066V21H3zm10.885 18l.117-.268c.274-.63.31-.716.31-.89a1.084 1.084 0 0 0-.288-.655c-.038-.05-.087-.13-.108-.117a1.41 1.41 0 0 1 .422-.158c.384-.106 1.098-.302 1.098-1.057a1.068 1.068 0 0 0-.332-.68c-.044-.05-.107-.121-.108-.073 0-.092.046-.152.217-.323a1.34 1.34 0 0 0 .484-.972v-.609a.46.46 0 0 1 .377.049 1.384 1.384 0 0 0 .608.165 1.467 1.467 0 0 0 .982-.382.71.71 0 0 1 .369-.202 1.303 1.303 0 0 1 .153.296 1.816 1.816 0 0 0 .437.689 2.562 2.562 0 0 0 1.561.808 3.36 3.36 0 0 0 .51-.052 2.764 2.764 0 0 1 .306-.034V21zM10.5 5.5a1 1 0 1 1 1 1 1 1 0 0 1-1-1zm-4 4a1 1 0 1 1 1-1 1 1 0 0 1-1 1zm12 9a1 1 0 1 1-1-1 1 1 0 0 1 1 1z"></path>
                    <path fill="none" d="M0 0h24v24H0z"></path>
                </g>
            </svg>

            <span>Douar</span>

        </div>

        <div class="sync_btn map-btn">

            <svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                <g id="SVGRepo_iconCarrier">
                    <path d="M7 10V9C7 6.23858 9.23858 4 12 4C14.7614 4 17 6.23858 17 9V10C19.2091 10 21 11.7909 21 14C21 15.4806 20.1956 16.8084 19 17.5M7 10C4.79086 10 3 11.7909 3 14C3 15.4806 3.8044 16.8084 5 17.5M7 10C7.43285 10 7.84965 10.0688 8.24006 10.1959M12 12V21M12 12L15 15M12 12L9 15" stroke="#2c6ade" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                </g>
            </svg>

            <span>Synchroniser</span>

        </div>

    </div>

    <div class="btns-container right">
        <div class="donnees_btn map-btn">

            <svg viewBox="0 0 1024 1024" class="icon" version="1.1" xmlns="http://www.w3.org/2000/svg" fill="#2c6ade">
                <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                <g id="SVGRepo_iconCarrier">
                    <path d="M978.578286 900.461714l-108.617143-108.617143c30.134857-39.570286 48.274286-88.795429 48.274286-142.189714a235.739429 235.739429 0 0 0-235.52-235.373714 235.739429 235.739429 0 0 0-235.373715 235.373714 235.739429 235.739429 0 0 0 235.446857 235.52c53.467429 0 102.692571-18.139429 142.189715-48.274286l108.617143 108.544a31.524571 31.524571 0 0 0 44.836571 0 31.744 31.744 0 0 0 0.146286-44.982857zM510.902857 649.654857a172.105143 172.105143 0 0 1 171.885714-171.885714 171.885714 171.885714 0 0 1 0 343.771428 172.178286 172.178286 0 0 1-171.885714-171.885714z m270.262857-378.514286c0 17.554286-14.262857 31.744-31.817143 31.744H431.396571a31.744 31.744 0 0 1 0-63.488h317.952c17.554286 0 31.817143 14.189714 31.817143 31.744z m-609.426285 620.032h211.968a31.890286 31.890286 0 0 1 0 63.634286H171.739429c-58.368 0-106.057143-47.542857-106.057143-106.057143V283.062857c0-14.262857 5.12-28.086857 14.262857-39.058286L240.420571 53.101714a57.417143 57.417143 0 0 1 43.885715-20.48h517.997714c58.441143 0 106.057143 47.542857 106.057143 106.057143V366.445714a31.744 31.744 0 0 1-63.634286 0V138.605714a42.422857 42.422857 0 0 0-42.276571-42.349714H336.018286V280.137143a50.688 50.688 0 0 1-50.980572 50.176H129.389714v518.509714c0 23.332571 19.017143 42.349714 42.349715 42.349714zM272.457143 113.810286l-128.512 152.868571h128.512v-152.868571z m79.506286 476.16a31.744 31.744 0 0 0 0-63.634286H240.64a31.744 31.744 0 0 0 0 63.634286h111.323429z m0 146.066285a31.744 31.744 0 0 0 0-63.561142H240.64a31.744 31.744 0 0 0 0 63.561142h111.323429z m31.744-353.206857H240.64a31.744 31.744 0 0 0 0 63.561143h143.067429a31.744 31.744 0 0 0 0-63.561143z" fill="#2c6ade"></path>
                </g>
            </svg>
            <span>Données</span>
        </div>


        <div class="position_btn map-btn">
            <svg viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" class="iconify iconify--gis" preserveAspectRatio="xMidYMid meet" fill="#000000">
                <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                <g id="SVGRepo_iconCarrier">
                    <path d="M49.798 23.592c-7.834.001-15.596 3.368-14.78 10.096l2 14.624c.351 2.573 2.09 6.688 4.687 6.688h.185l2.127 24.531c.092 1.104.892 2 2 2h8c1.108 0 1.908-.896 2-2L58.144 55h.186c2.597 0 4.335-4.115 4.687-6.688l2-14.624c.524-6.734-7.384-10.098-15.219-10.096z" fill="#2c6ade"></path>
                    <path d="M50.024 50.908l-.048.126c.016-.038.027-.077.043-.115l.005-.011z" fill="#2c6ade"></path>
                    <circle cx="50" cy="10.5" r="10.5" fill="#2c6ade"></circle>
                    <path d="M60.922 69.092c-.085.972-.175 1.942-.26 2.914C69.614 73.27 76.25 76.138 77 79.686c1.117 5.276-16.142 7.65-27.26 7.539c-11.118-.112-28.059-2.263-26.578-7.54c.972-3.463 7.512-6.274 16.23-7.583c-.087-.975-.186-1.95-.27-2.924c-11.206 1.236-20.542 4.279-24.272 8.246H2.229L0 82.047h13.166c1.023 5.44 12.427 10.136 28.734 11.322L41.342 100h16.14l-.162-6.63c16.39-1.187 28.117-5.883 29.514-11.323H100l-1.91-4.623H85.469c-3.543-4.067-13.048-7.16-24.547-8.332z" fill="#2c6ade"></path>
                </g>


            </svg>

            <b style="color: #6fb319; display: block;   bottom: 4px; width: 100%; text-align: center; font-family: 'Nunito'; font-weight: 500;"><b
                    id="gps_current_accuracy" style="font-weight: 700;">?</b>&nbspm</b>

        </div>


        <div class="logout_btn map-btn">

            <svg fill="#ff3e3e" viewBox="0 0 96 96" xmlns="http://www.w3.org/2000/svg">
                <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                <g id="SVGRepo_iconCarrier">
                    <title></title>
                    <g>
                        <path d="M48,36a5.9966,5.9966,0,0,0,6-6V6A6,6,0,0,0,42,6V30A5.9966,5.9966,0,0,0,48,36Z"></path>
                        <path d="M76.0078,22.9746a6,6,0,0,0-8.0156,8.93A29.39,29.39,0,0,1,78,54a30,30,0,0,1-60,0A29.39,29.39,0,0,1,28.0078,31.9043a6,6,0,0,0-8.0156-8.93,42.0009,42.0009,0,1,0,56.0156,0Z"></path>
                    </g>
                </g>
            </svg>
            <span>Déconnexion</span>
        </div>
    </div>
</div>

<?php echo $__env->make('app_terrain/modals', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('added_scripts'); ?>
<script src="<?php echo e(asset('js/app_terrain/messages.js').'?t='.time()); ?>"></script>
<script>
    var map = undefined;
    var drawing_mode = false;
    var baraque_modal = undefined;
    var menage_modal = undefined;
    var photo_modal = undefined;
    var douars_map_modal = undefined;
    var sync_modal = undefined;

    var douars_map_modal_table = undefined;
    var edit_geometry_mode = false;
    var edit_geometry_mode_id = undefined;

    var current_layer = undefined;

    var current_baraque = {
        id: null,
        numero: null,
        menages: [],
        commerces: [],
        geometry: "[]",
        lat: 0,
        lng: 0,
        rdc_obs: "",
        e1_obs: "",
        e2_obs: "",
    }

    var selected_layer = undefined;

    var current_niveau = "RDC";

    var plle_other_euipes_style = {
        fillColor: '#ffffff',
        weight: 3,
        opacity: 1,
        color: '#6fb319',
        fillOpacity: 0.25
    }

    var plle_style = {
        fillColor: '#2c6ade',
        weight: 3,
        opacity: 1,
        color: '#ef6300',
        fillOpacity: 0.25
    }

    var inactive_plle_style = {
        fillColor: '##19191',
        weight: 3,
        opacity: 1,
        color: '#919191',
        fillOpacity: 0.25
    }

    var selected_plle_style = {
        fillColor: '#ef6300',
        weight: 3,
        opacity: 1,
        color: '#ef6300',
        fillOpacity: 0.35
    }

    var current_menage = undefined;
    var current_commerce = undefined;

    var pixiOverlay = undefined;

    $(document).ready(function() {

        initMap('map');


        baraque_modal = new bootstrap.Modal(document.getElementById('baraque_modal'), {
            backdrop: 'static',
            keyboard: false
        });


        menage_modal = new bootstrap.Modal(document.getElementById('menage_modal'), {
            backdrop: 'static',
            keyboard: false
        });

        commerce_modal = new bootstrap.Modal(document.getElementById('commerce_modal'), {
            backdrop: 'static',
            keyboard: false
        });

        douars_map_modal = new bootstrap.Modal(document.getElementById('douars_map_modal'), {
            backdrop: 'static',
            keyboard: false
        });

        sync_modal = new bootstrap.Modal(document.getElementById('sync_modal'), {
            backdrop: 'static',
            keyboard: false
        });
        photo_modal = new bootstrap.Modal(document.getElementById('photo_modal'), {
            backdrop: 'static',
            keyboard: false
        });

        douars_map_modal_table = $('#douars_map_modal_table').DataTable({
            responsive: false,
            autoWidth: false,
            bPaginate: true,
            pageLength: 25,
            lengthChange: false,
            bFilter: false,
            bInfo: false,
            ordering: false,
            processing: true,
            serverSide: TextTrackCue,
            searching: true,
            scrollX: false,
            ajax: assetBaseUrl + 'app_terrain/gerDouarsDatatable',
            dom: "lBfrtip",
            buttons: [{
                "extend": 'excel',
                "text": '',
                "titleAttr": 'excel',
                'title': 'Dossiers-' + current_date.replaceAll("/", "-"),
                "action": newexportaction
            }, ],
            columnDefs: [{
                className: 'text-center',
                targets: [0, 1]
            }],
            columns: [{
                    data: 'douar',
                },
                {
                    data: 'actions',
                },

            ],
            language: {
                url: assetBaseUrl + "languages/datatable_fr.json",
            },

        }).on("xhr.dt", function(e, settings, json, xhr) {


        });

        $(".select2").select2();
        $(".select2nc").select2({
            minimumResultsForSearch: -1
        });

    });

    function initMap(div_id, lot_id) {
        var lot_data = undefined;
        var googlehybrid = L.tileLayer('https://www.google.com/maps/vt?lyrs=y@189&gl=ma&x={x}&y={y}&z={z}', {
            maxZoom: 22,
            attribution: "google-baselayer",
            opacity: 1
        });

        map = new L.Map(div_id, {
            zoomControl: false,
            center: new L.LatLng(auth_user.last_view_lat, auth_user.last_view_lng),
            zoom: auth_user.last_view_zoom,
            editable: true,
            drawControl: true,
            preferCanvas: false,
            attributionControl: false,

        });



        googlehybrid.addTo(map);




        map.on("pm:create", (e) => {

            drawing_mode = false;
            e.layer.options.pmIgnore = false;
            L.PM.reInitLayer(e.layer);
            $(".add_baraque").removeClass("disabled");
            $("#drawing_tools_div").addClass("disabled");

            if (edit_geometry_mode == false) {
                current_baraque = {
                    id: null,
                    numero: null,
                    menages: [],
                    commerces: [],
                    geometry: "[]",
                    lat: 0,
                    lng: 0,
                    rdc_obs: "",
                    e1_obs: "",
                    e2_obs: "",
                    baraque_vide: 0,
                    PHOTO_BARAQUE_VIDE: []
                };

                $("#baraque_modal_numero").val("");
                $("#baraque_modal_is_baraque_vide").prop("checked", current_baraque.baraque_vide == 1);
                $("#baraque_modal_is_baraque_vide").change();
                drawMenages();
                drawCommerces();
                baraque_modal.show();
                current_layer = e.layer;

                current_baraque.PHOTO_BARAQUE_VIDE.forEach(photo => {
                    insertPhoto(photo);
                });

                if (typeof CSharp !== 'undefined') {
                    try {
                        CSharp.stopSync();
                    } catch {

                    }

                }

            } else {
                baraques_ids = baraques_ids.filter(item => item !== edit_geometry_mode_id);

                var new_geojson = JSON.stringify(e.layer.toGeoJSON());
                e.layer.remove();
                selected_layer.remove();
                var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
                $.ajax({
                    url: assetBaseUrl + 'app_terrain/edit_geometry',
                    type: 'POST',
                    data: {
                        _token: csrfToken,
                        id: edit_geometry_mode_id,
                        geometry: new_geojson
                    },
                    success: function(response) {
                        loadGeometries(true);
                    },
                    error: function(xhr, status, error) {


                    }
                });
            }

        });

        map.on('pm:vertexremoved', (e) => {
            const layer = e.layer;
            console.log('s');
            // Check if the layer is a polygon and has no vertices left
            if (layer.pm && layer.pm.getShape() === 'Polygon' && layer.getLatLngs()[0].length === 0) {
                console.log('All vertices in the polygon have been removed');
                // Trigger any additional action you need here
            }
        });
    }




    var baraques_ids = [];
    var last_timestamp = 0;

    function loadGeometries(one_time = false, first_time = false) {


        if (first_time == true) {
            showLoading("chargement de la géometrie");
        }

        $.ajax({
            url: assetBaseUrl + 'app_terrain/loadGeometries',
            type: 'GET',
            data: {
                last_timestamp: last_timestamp
            },
            success: function(response) {

                last_timestamp = response.last_timestamp;
                response.baraques.forEach(baraque => {

                    if (!baraques_ids.includes(baraque.id)) {

                        try {
                            var geojson = JSON.parse(baraque.geometry);

                            try {
                                geojson.properties.equipe_id = baraque.equipe_id;
                                geojson.properties.numero = baraque.numero;
                                geojson.properties.prefix = baraque.equipe.prefix;
                                geojson.properties.id = baraque.id;
                            } catch (err) {
                                //console.log(baraque.id);
                            }


                            var layer = L.geoJSON(geojson);



                            if (baraque.equipe_id == auth_user.equipe_id) {
                                layer.setStyle(plle_style);
                            } else {
                                layer.setStyle(plle_other_euipes_style);
                            }


                            layer.on('click', function(e) {
                                if (drawing_mode)
                                    return;

                                var popup = L.popup()
                                    .setContent(`
                                                <h5 style="font-size:14px;"><i class="fa-solid fa-circle-info mr-1"></i> Baraque</h5>
                                                <div class="row  mb-3"> 
                                                    <div class="col-12 mt-2"> 
                                                        <span style="color: gray;">Numéro : <b style="color: #2c6ade;">${e.layer.feature.properties.numero}</b></span>                                    
                                                    </div>
                                                    <div class="col-12 mt-2"> 
                                                        <span style="color: gray;">Equipe : <b style="color: #2c6ade;">${e.layer.feature.properties.prefix}</b></span>                                    
                                                    </div>

                                                    <div class="col-12 mt-2"> 
                                                        <button ${e.layer.feature.properties.equipe_id==auth_user.equipe_id?'':'disabled'} style="width:100%;" class="btn edit_baraque" id="${e.layer.feature.properties.id}"><i class="fa-solid fa-pencil mr-1"></i>Modifier</button>
                                                    </div>
                                                    <div class="col-12 mt-2"> 
                                                        <button ${e.layer.feature.properties.equipe_id==auth_user.equipe_id?'':'disabled'} style="width:100%;" class="btn edit_baraque_geometry" id="${e.layer.feature.properties.id}"><i class="fa-solid fa-pencil mr-1"></i>Modifier la géometrie</button>
                                                    </div>
                                                    <div class="col-12 mt-2"> 
                                                        <button ${e.layer.feature.properties.equipe_id==auth_user.equipe_id?'':'disabled'}  style="width:100%;" class="btn  btn-danger delete_baraque" id="${e.layer.feature.properties.id}"><i class="fa-solid fa-trash-can mr-1"></i>Supprimer</button>
                                                    </div>

                                                    
                                                </div>
                                    `).setLatLng(e.layer.getCenter()).openOn(map);

                                if (selected_layer != undefined) {

                                    if (selected_layer.feature.properties.equipe_id == auth_user.equipe_id) {
                                        selected_layer.setStyle(plle_style);
                                    } else {
                                        selected_layer.setStyle(plle_other_euipes_style);
                                    }
                                }
                                selected_layer = e.layer;
                                selected_layer.setStyle(selected_plle_style);
                            });

                            layer.addTo(map);


                            baraques_ids.push(baraque.id);
                        } catch {
                            console.log(baraque.id);
                        }

                    }

                });

                if (first_time == true) {
                    closeLoading();
                }
                if (one_time == false) {
                    setTimeout(function() {
                        loadGeometries();
                    }, 5000);
                }


            },
            error: function(xhr, status, error) {


            }
        });
    }

    $(document).ready(function() {

        load_other_data();

        var active_douars = JSON.parse(auth_user.last_view_active_douars);

        active_douars.forEach(douar => {

            loadBaseLayer(douar.id);
        });
        loadGeometries(false, true);

        const interval = setInterval(function() {
            if (typeof CSharp !== 'undefined') {
                CSharp.GetLocation();
            }

        }, 2000);

        const interval_sync = setInterval(function() {
            if (typeof CSharp !== 'undefined') {


                try {
                    CSharp.SyncV2();
                } catch {

                }
            }

        }, 2000);


        // const interval2 = setInterval(function() {
        //     if (typeof CSharp !== 'undefined') {
        //         CSharp.refreshFilesStatus();
        //     }

        // }, 500);

    });

    function load_other_data() {

        var geojsonLayer = new L.GeoJSON.AJAX("/mapping/voies bouskoura1.geojson");
        geojsonLayer.addTo(map);





    }



    $(".add_baraque").click(function(event) {

        event.stopPropagation();


        edit_geometry_mode = false;
        edit_geometry_mode_id = undefined;

        $("#drawing_tools_div").removeClass("disabled");
        $("#rdc-tab").click();

        drawing_mode = true;

        $(".add_baraque").addClass("disabled");

        map.pm.enableDraw("Polygon", {
            snappable: true,
            snapDistance: 20,
            tooltips: false,
        });
    });

    $(".add_menage").click(function(event) {
        current_menage = null;

        $("#menage_modal_cin").val("");
        $("#menage_modal_marie").prop("checked", 0);
        $("#menage_modal_cin_conjoint").val("");

        $("#menage_modal_donnees_non_fournie_par_chef_menage").prop("checked", 0);
        $("#menage_modal_cin_non_disponible").prop("checked", 0);
        $("#menage_modal_cin_non_disponible_raision").val("Personne mineure");
        $("#menage_modal_acte_mariage_photo_non_disponible").prop("checked", 0);
        $("#menage_modal_conjoint_cin_non_disponible").prop("checked", 0);
        $("#menage_modal_acte_deces_photo_non_disponible").prop("checked", 0);
        $("#menage_modal_acte_divorce_photo_non_disponible").prop("checked", 0);

        $("#menage_modal_nom").val("");
        $("#menage_modal_prenom").val("");
        $(".phototheque[type_document='PHOTO_MENAGE_CIN']").empty();
        $(".phototheque[type_document='PHOTO_ACT_MARIAGE']").empty();
        $(".phototheque[type_document='PHOTO_ACT_DECES']").empty();
        $(".phototheque[type_document='PHOTO_ACT_DIVORCE']").empty();
        $(".phototheque[type_document='PHOTO_CIN_CONJOINT']").empty();
        $(".phototheque[type_document='PHOTO_BARAQUE']").empty();

        initLightGallery();
        menage_modal.show();
    });

    $(".add_commerce").click(function(event) {
        current_commerce = null;

        $("#commerce_modal_cin").val("");
        $("#commerce_modal_type_acivite").val("Agence de tourisme");


        $(".phototheque[type_document='PHOTO_COMMERCE_CIN']").empty();
        $(".phototheque[type_document='PHOTO_COMMERCE']").empty();

        initLightGallery();

        commerce_modal.show();
    });



    $(".upload_photo_link").click(function() {
        var type_document = $(this).attr("type_document");


        $('#menage_modal_fileInput').attr('type_document', type_document);

        CSharp.TakePhoto(type_document, auth_user.id);

    });

    $('#menage_modal_fileInput').on('change', function() {
        var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");

        const file = this.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                $('#photoPreview').attr('src', e.target.result).show();
            };
            reader.readAsDataURL(file);
            var type_document = $(this).attr("type_document");
            const formData = new FormData();
            formData.append('file', file);
            formData.append('_token', csrfToken);
            formData.append('type_document', type_document);

            $.ajax({
                url: assetBaseUrl + 'app_terrain/upload',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {

                    var url = assetBaseUrl + "files/baraques_documents/" + response.document.id + "/" + response.document.filename;

                    $(".phototheque[type_document='" + response.document.type_document + "']").append(
                        `<a  id="photos_${response.document.type_document}" class="costume-img" href="${url}" style="margin: 0px;">
                    <img  data-src="${url}" style="border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="/app_terrain/show_media/${response.document.id}" class="gallery-img costume-img hk-gallery">
                    </br>                       
                    <input filename="${response.document.filename}" id="${response.document.id}" type_document="${response.document.type_document}" class="select_photo_cb" style="margin: auto;display: block;position: relative;" type="checkbox">
                </a>`);

                    $('#menage_modal_fileInput').val("");

                    initLightGallery();
                },
                error: function(xhr, status, error) {


                }
            });
        }
    });

    $("#baraque_modal_is_baraque_vide").change(function() {
        if ($("#baraque_modal_is_baraque_vide").prop("checked")) {
            $(".baraques_vide_data_div").css('display', 'block');
        } else {
            $(".baraques_vide_data_div").css('display', 'none');
        }
    });

    function storeBaraque() {


        var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");

        current_baraque.numero = $("#baraque_modal_numero").val();

        current_baraque.baraque_vide = $("#baraque_modal_is_baraque_vide").prop("checked") ? 1 : 0;

        if (current_layer != undefined) {
            current_baraque.geometry = JSON.stringify(current_layer.toGeoJSON());
            current_baraque.lat = current_layer.getCenter().lat;
            current_baraque.lng = current_layer.getCenter().lng;

        }
        current_baraque.PHOTO_BARAQUE_VIDE = [];
        $(".select_photo_cb[type_document='PHOTO_BARAQUE_VIDE']").each(function() {


            var id = $(this).attr("id");
            var type_document = $(this).attr("type_document");
            var filename = $(this).attr("filename");

            current_baraque.PHOTO_BARAQUE_VIDE.push({
                id: id,
                type_document: type_document,
                filename: filename
            });
        });

        $.ajax({
            url: assetBaseUrl + 'app_terrain/store',
            type: 'POST',
            data: {
                _token: csrfToken,

                baraque: JSON.stringify(current_baraque),
                last_view_lat: map.getCenter().lat,
                last_view_lng: map.getCenter().lng,
                last_view_zoom: map.getZoom(),

                documents_to_delete: JSON.stringify(documents_to_delete)
            },
            success: function(response) {


                if (response.success == 1) {
                    baraque_modal.hide();
                    if (current_layer != undefined) {
                    current_layer.remove();
                    current_layer = undefined;
                }
                loadGeometries(true);
                if (typeof CSharp !== 'undefined') {

                    try {
                        CSharp.resumeSync();
                    } catch {

                    }

                }
                $("#baraque_modal_save").removeAttr("disabled");
                    return true;
                } else {

                    gl_alert('error', 'VSB-Maroc', parseErrorMessage(response.error));
                    $("#baraque_modal_save").removeAttr("disabled");
                    return false;

                }

                
              
            },
            error: function(xhr, status, error) {
                alert(xhr.responseText);
                $("#baraque_modal_save").removeAttr("disabled");
            }
        });
    }


    $("#commerce_modal_save").click(function() {


        var PHOTO_COMMERCE_CIN = [];
        var PHOTO_COMMERCE = [];

        $(".select_photo_cb[type_document='PHOTO_COMMERCE_CIN']").each(function() {
            var id = $(this).attr("id");
            var type_document = $(this).attr("type_document");
            var filename = $(this).attr("filename");

            PHOTO_COMMERCE_CIN.push({
                id: id,
                type_document: type_document,
                filename: filename
            });
        });

        $(".select_photo_cb[type_document='PHOTO_COMMERCE']").each(function() {

            var id = $(this).attr("id");
            var type_document = $(this).attr("type_document");
            var filename = $(this).attr("filename");

            PHOTO_COMMERCE.push({
                id: id,
                type_document: type_document,
                filename: filename
            });
        });


        if (current_commerce == undefined) {
            var menage_data = {
                id: Date.now(),
                cin: $("#commerce_modal_cin").val(),
                type_activite: $("#commerce_modal_type_activite").val(),
                niveau: current_niveau,
                PHOTO_COMMERCE_CIN: PHOTO_COMMERCE_CIN,
                PHOTO_COMMERCE: PHOTO_COMMERCE,
                _new: true
            };

            current_baraque.commerces.push(menage_data);
        } else {
            current_commerce.cin = $("#commerce_modal_cin").val();
            current_commerce.type_activite = $("#commerce_modal_type_activite").val();
            current_commerce.PHOTO_COMMERCE_CIN = PHOTO_COMMERCE_CIN;
            current_commerce.PHOTO_COMMERCE = PHOTO_COMMERCE;
        }

        commerce_modal.hide();
        drawCommerces();

    });

    $("#menage_modal_save").click(function() {


        var PHOTO_MENAGE_CIN = [];
        var PHOTO_ACT_MARIAGE = [];
        var PHOTO_ACT_DECES = [];
        var PHOTO_ACT_DIVORCE = [];
        var PHOTO_CIN_CONJOINT = [];
        var PHOTO_BARAQUE = [];

        $(".select_photo_cb[type_document='PHOTO_MENAGE_CIN']").each(function() {
            var id = $(this).attr("id");
            var type_document = $(this).attr("type_document");
            var filename = $(this).attr("filename");

            PHOTO_MENAGE_CIN.push({
                id: id,
                type_document: type_document,
                filename: filename
            });
        });

        $(".select_photo_cb[type_document='PHOTO_ACT_MARIAGE']").each(function() {


            var id = $(this).attr("id");
            var type_document = $(this).attr("type_document");
            var filename = $(this).attr("filename");

            PHOTO_ACT_MARIAGE.push({
                id: id,
                type_document: type_document,
                filename: filename
            });
        });

        $(".select_photo_cb[type_document='PHOTO_ACT_DIVORCE']").each(function() {


            var id = $(this).attr("id");
            var type_document = $(this).attr("type_document");
            var filename = $(this).attr("filename");

            PHOTO_ACT_DIVORCE.push({
                id: id,
                type_document: type_document,
                filename: filename
            });
        });

        $(".select_photo_cb[type_document='PHOTO_ACT_DECES']").each(function() {


            var id = $(this).attr("id");
            var type_document = $(this).attr("type_document");
            var filename = $(this).attr("filename");

            PHOTO_ACT_MARIAGE.push({
                id: id,
                type_document: type_document,
                filename: filename
            });
        });

        $(".select_photo_cb[type_document='PHOTO_CIN_CONJOINT']").each(function() {


            var id = $(this).attr("id");
            var type_document = $(this).attr("type_document");
            var filename = $(this).attr("filename");

            PHOTO_CIN_CONJOINT.push({
                id: id,
                type_document: type_document,
                filename: filename
            });
        });


        $(".select_photo_cb[type_document='PHOTO_BARAQUE']").each(function() {
            var id = $(this).attr("id");
            var type_document = $(this).attr("type_document");
            var filename = $(this).attr("filename");

            PHOTO_BARAQUE.push({
                id: id,
                type_document: type_document,
                filename: filename
            });
        });


        if (current_menage == undefined) {
            var menage_data = {
                id: Date.now(),
                chef_menage_cin: $("#menage_modal_cin").val(),
                situation: $("#menage_modal_situation").val(),
                conjoint_cin: $("#menage_modal_cin_conjoint").val(),
                niveau: current_niveau,
                sexe: $("#menage_modal_sexe_homme").prop("checked") ? "homme" : "femme",
                donnees_non_fournie_par_chef_menage: $("#menage_modal_donnees_non_fournie_par_chef_menage").prop("checked") ? 1 : 0,
                chef_menage_cin_non_disponible: $("#menage_modal_cin_non_disponible").prop("checked") ? 1 : 0,
                chef_menage_cin_non_disponible_raision: $("#menage_modal_cin_non_disponible_raision").val(),
                acte_mariage_photo_non_disponible: $("#menage_modal_acte_mariage_photo_non_disponible").prop("checked") ? 1 : 0,
                conjoint_cin_non_disponible: $("#menage_modal_conjoint_cin_non_disponible").prop("checked") ? 1 : 0,
                acte_deces_photo_non_disponible: $("#menage_modal_acte_deces_photo_non_disponible").prop("checked") ? 1 : 0,
                acte_divorce_photo_non_disponible: $("#menage_modal_acte_divorce_photo_non_disponible").prop("checked") ? 1 : 0,
                chef_menage_nom: $("#menage_modal_nom").val(),
                chef_menage_prenom: $("#menage_modal_prenom").val(),
                PHOTO_MENAGE_CIN: PHOTO_MENAGE_CIN,
                PHOTO_ACT_MARIAGE: PHOTO_ACT_MARIAGE,
                PHOTO_ACT_DECES: PHOTO_ACT_DECES,
                PHOTO_ACT_DIVORCE: PHOTO_ACT_DIVORCE,
                PHOTO_CIN_CONJOINT: PHOTO_CIN_CONJOINT,
                PHOTO_BARAQUE: PHOTO_BARAQUE,
                _new: true
            };

            current_baraque.menages.push(menage_data);
        } else {
            current_menage.chef_menage_cin = $("#menage_modal_cin").val();
            current_menage.situation = $("#menage_modal_situation").val();
            current_menage.conjoint_cin = $("#menage_modal_cin_conjoint").val();
            current_menage.sexe = $("#menage_modal_sexe_homme").prop("checked") ? "homme" : "femme";


            current_menage.donnees_non_fournie_par_chef_menage = $("#menage_modal_donnees_non_fournie_par_chef_menage").prop("checked") ? 1 : 0;
            current_menage.chef_menage_cin_non_disponible = $("#menage_modal_cin_non_disponible").prop("checked") ? 1 : 0;
            current_menage.chef_menage_cin_non_disponible_raision = $("#menage_modal_cin_non_disponible_raision").val();
            current_menage.acte_mariage_photo_non_disponible = $("#menage_modal_acte_mariage_photo_non_disponible").prop("checked") ? 1 : 0;
            current_menage.conjoint_cin_non_disponible = $("#menage_modal_conjoint_cin_non_disponible").prop("checked") ? 1 : 0;
            current_menage.acte_deces_photo_non_disponible = $("#menage_modal_acte_deces_photo_non_disponible").prop("checked") ? 1 : 0;
            current_menage.acte_divorce_photo_non_disponible = $("#menage_modal_acte_divorce_photo_non_disponible").prop("checked") ? 1 : 0;
            current_menage.chef_menage_nom = $("#menage_modal_nom").val();
            current_menage.chef_menage_prenom = $("#menage_modal_prenom").val();

            current_menage.PHOTO_MENAGE_CIN = PHOTO_MENAGE_CIN;
            current_menage.PHOTO_ACT_MARIAGE = PHOTO_ACT_MARIAGE;
            current_menage.PHOTO_ACT_DECES = PHOTO_ACT_DECES;
            current_menage.PHOTO_ACT_DIVORCE = PHOTO_ACT_DIVORCE;
            current_menage.PHOTO_CIN_CONJOINT = PHOTO_CIN_CONJOINT;
            current_menage.PHOTO_BARAQUE = PHOTO_BARAQUE;


        }

        menage_modal.hide();

        drawMenages();

    });

    function drawMenages() {

        $(".baraque_modal_menages_div").empty();

        var empty = true;
        current_baraque.menages.forEach(menage => {
            if (menage.niveau == current_niveau) {
                empty = false;
                var html = `<div id="${menage.id}" class="row menage_div" style="margin: 8px; border: 1px #c1c1c1 solid; border-radius: 8px; background: #f8fbfe;">
                        <div class="col" style="max-width: 60px;">
                            <svg style="width: 50px; height: 50px; border: 1px #0f729d solid; margin: 8px; border-radius: 50%; background: #195cb1; padding: 14px;" fill="#ffffff"  id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path  fill="#ffffff" d="M8.00444,2a2.18,2.18,0,0,1,2.18372,2.1821V5.27284c.64721,0,.37815.9309,0,1.45453a4.27536,4.27536,0,0,1-.33525.36378c-.09377.25171-.1949.504-.31012.74166l.20838,1.076h.437l2.74909,1.52741A2.14771,2.14771,0,0,1,14,12.2907V14H2V12.32745A2.16272,2.16272,0,0,1,3.06275,10.4583l2.758-1.54945h.437l.21083-1.06869c-.11645-.24008-.21819-.49485-.31257-.749a4.27536,4.27536,0,0,1-.33525-.36378c-.37815-.52363-.64721-1.45453,0-1.45453V4.1821A2.18,2.18,0,0,1,8.00444,2"></path> </g></svg>
                        </div>
                        <div class="col">
                            <div class="row" style="padding: 8px;">
                                <div style="padding-left:8px" class="col-12 col-md-6">
                                    <span style="display:block;font-size:16px;color:#f97e0f"><span style="color:gray">CIN</span> : ${menage.chef_menage_cin}</span>  
                                     <span style="display:block;font-size:16px;color:#f97e0f"><span style="color:gray">Situation</span> : ${menage.situation}</span>                     
                                </div>
                                          
                            </div>

                            
                        </div>

                        
                    </div>`;
                $(".baraque_modal_menages_div").append(html);

            }

        });

        if (empty) {
            var html = `<span style="font-size: 18px; margin: auto; display: block; text-align: center; line-height: 100px;">Aucun ménage n'a été ajouté.</span>`;
            $(".baraque_modal_menages_div").append(html);
        }

    }


    function drawCommerces() {

        $(".baraque_modal_commerces_div").empty();

        var empty = true;
        current_baraque.commerces.forEach(commerce => {
            if (commerce.niveau == current_niveau) {
                empty = false;
                var html = `<div id="${commerce.id}" class="row commerce_div" style="margin: 8px; border: 1px #c1c1c1 solid; border-radius: 8px; background: #f8fbfe;">
                <div class="col" style="max-width: 110px;">
                    <svg style="width: 70px; height: 70px; border: 1px #0f729d solid; margin: 8px; border-radius: 50%; background: #195cb1; padding: 14px;" fill="#ffffff"  viewBox="0 -64 640 640" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><path d="M320 384H128V224H64v256c0 17.7 14.3 32 32 32h256c17.7 0 32-14.3 32-32V224h-64v160zm314.6-241.8l-85.3-128c-6-8.9-16-14.2-26.7-14.2H117.4c-10.7 0-20.7 5.3-26.6 14.2l-85.3 128c-14.2 21.3 1 49.8 26.6 49.8H608c25.5 0 40.7-28.5 26.6-49.8zM512 496c0 8.8 7.2 16 16 16h32c8.8 0 16-7.2 16-16V224h-64v272z"></path></g></svg>
                </div>
                <div class="col">
                    <div class="row" style="padding: 8px;">
                        <div style="padding-left:8px" class="col-12 col-md-6">
                            <span style="font-size:16px;color:#f97e0f"><span style="color:gray">CIN</span> : ${commerce.cin}</span>                   
                        </div>
                              <div style="padding-left:8px" class="col-12 col-md-6">
                            <span style="font-size:16px;color:#f97e0f"><span style="color:gray">Type d'activité</span> : ${commerce.type_activite}</span>                   
                        </div>                
                    </div>

                    <div class="row" style="padding: 8px;">
                        
                                            
                    </div>
                </div>
            </div>`;
                $(".baraque_modal_commerces_div").append(html);

            }

        });

        if (empty) {
            var html = `<span style="font-size: 18px; margin: auto; display: block; text-align: center; line-height: 100px;">Aucun ménage n'a été ajouté.</span>`;
            $(".baraque_modal_commerces_div").append(html);
        }

    }

    $("#baraque_modal_close").click(function() {

        if (current_layer != undefined) {
            current_layer.remove();
            current_layer = undefined;
        }
        baraque_modal.hide();

        if (typeof CSharp !== 'undefined') {

            try {
                CSharp.resumeSync();
            } catch {

            }

        }
    });

    $("#baraque_modal_save").click(function() {

        $("#baraque_modal_save").attr("disabled", "disabled");
        storeBaraque();




    });

    $("body").on("click", ".menage_div", function() {
        var id = $(this).attr('id');

        current_baraque.menages.forEach(menage => {
            if (menage.id == id) {
                current_menage = menage;
                $("#menage_modal_cin").val(menage.chef_menage_cin);
                $("#menage_modal_marie").prop("checked", menage.chef_menage_marie == 1);
                $("#menage_modal_situation").val(menage.situation);
                $("#menage_modal_cin_conjoint").val(menage.conjoint_cin);

                $("#menage_modal_sexe_homme").prop("checked", menage.sexe == "homme");
                $("#menage_modal_sexe_femme").prop("checked", menage.sexe != "homme");

                $("#menage_modal_situation").change();

                $("#menage_modal_prenom").val(menage.chef_menage_prenom);
                $("#menage_modal_nom").val(menage.chef_menage_nom);

                $("#menage_modal_donnees_non_fournie_par_chef_menage").prop("checked", current_menage.donnees_non_fournie_par_chef_menage == 1);
                $("#menage_modal_cin_non_disponible").prop("checked", current_menage.chef_menage_cin_non_disponible == 1);
                $("#menage_modal_cin_non_disponible_raision").val(current_menage.chef_menage_cin_non_disponible_raision);
                $("#menage_modal_acte_mariage_photo_non_disponible").prop("checked", current_menage.acte_mariage_photo_non_disponible == 1);
                $("#menage_modal_conjoint_cin_non_disponible").prop("checked", current_menage.conjoint_cin_non_disponible == 1);
                $("#menage_modal_acte_deces_photo_non_disponible").prop("checked", current_menage.acte_deces_photo_non_disponible == 1);
                $("#menage_modal_acte_divorce_photo_non_disponible").prop("checked", current_menage.acte_divorce_photo_non_disponible == 1);

                $("#menage_modal_cin_non_disponible").change();

                $(".phototheque[type_document='PHOTO_MENAGE_CIN']").empty();
                $(".phototheque[type_document='PHOTO_ACT_MARIAGE']").empty();
                $(".phototheque[type_document='PHOTO_ACT_DECES']").empty();
                $(".phototheque[type_document='PHOTO_ACT_DIVORCE']").empty();
                $(".phototheque[type_document='PHOTO_CIN_CONJOINT']").empty();
                $(".phototheque[type_document='PHOTO_BARAQUE']").empty();

                menage.PHOTO_MENAGE_CIN.forEach(photo => {
                    insertPhoto(photo);
                });

                menage.PHOTO_ACT_MARIAGE.forEach(photo => {
                    insertPhoto(photo);
                });

                menage.PHOTO_ACT_DECES.forEach(photo => {
                    insertPhoto(photo);
                });

                menage.PHOTO_ACT_DIVORCE.forEach(photo => {
                    insertPhoto(photo);
                });

                menage.PHOTO_CIN_CONJOINT.forEach(photo => {
                    insertPhoto(photo);
                });

                menage.PHOTO_BARAQUE.forEach(photo => {
                    insertPhoto(photo);
                });



                if (menage.verrification_etat == "Validé") {
                    $("#menage_modal_save").css("display", "block");
                } else {
                    $("#menage_modal_save").css("display", "block");
                }
                menage_modal.show();

                initLightGallery();
            }
        });
    });

    $("body").on("click", ".commerce_div", function() {
        var id = $(this).attr('id');

        current_baraque.commerces.forEach(commerce => {
            if (commerce.id == id) {
                current_commerce = commerce;
                $("#commerce_modal_cin").val(commerce.cin);
                $("#commerce_modal_type_activite").val(commerce.type_activite).change();
                $("#menage_modal_marie").change();

                $(".phototheque[type_document='PHOTO_COMMERCE_CIN']").empty();
                $(".phototheque[type_document='PHOTO_COMMERCE']").empty();


                commerce.PHOTO_COMMERCE_CIN.forEach(photo => {
                    insertPhoto(photo);
                });

                commerce.PHOTO_COMMERCE.forEach(photo => {
                    insertPhoto(photo);
                });

                commerce_modal.show();

                initLightGallery();
            }
        });
    });

    $("body").on("click", ".delete_baraque", function() {
        map.closePopup();
        var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
        var id = $(this).attr('id');

        Swal.fire({
            title: "Êtes-vous sûr de vouloir supprimer la baraque ?",
            showDenyButton: true,
            showCancelButton: false,
            confirmButtonText: "Oui",
            denyButtonText: `Non`
        }).then((result) => {

            if (result.isConfirmed) {

                $.ajax({
                    url: assetBaseUrl + 'app_terrain/delete',
                    type: 'POST',
                    data: {
                        _token: csrfToken,
                        id: id
                    },
                    success: function(response) {
                        selected_layer.remove();
                        map.closePopup();

                    },
                    error: function(xhr, status, error) {


                    }
                });



            } else if (result.isDenied) {

            }
            assetBaseUrl
        });
    });


    $("#menage_modal_situation").change(function() {

        var situation = $("#menage_modal_situation").val();

        $(".situation_marie_div").css('display', 'none');
        $(".situation_veuf_div").css('display', 'none');
        $(".situation_divorce_div").css('display', 'none');

        if (situation == "Marié") {
            $(".situation_marie_div").css('display', 'block');
        }
        if (situation == "Célibataire") {

        }
        if (situation == "Divorcé") {
            $(".situation_divorce_div").css('display', 'block');
        }
        if (situation == "Veuf") {
            $(".situation_veuf_div").css('display', 'block');
        }
        if (situation == "Abandonné") {

        }
        if (situation == "Mère célibataire ") {

        }

    })

    // $("#menage_modal_non_marie").change(function() {

    //     if ($("#menage_modal_non_marie").prop("checked")) {
    //         $(".conjoint_div").css('display', 'none');
    //     } else {
    //         $(".conjoint_div").css('display', 'block');
    //     }
    // })

    function insertPhoto(photo) {
        var url = assetBaseUrl + "files/baraques_documents/" + photo.id + "/" + photo.filename;

        $(".phototheque[type_document='" + photo.type_document + "']").append(
            `
    <div  class="costume-img" style="position: relative;">

      <span class="local-file-badge" id="${photo.id}" style="display:none;position: absolute; margin: 8px 0px 0px 12px; background: #ededed; border-radius: 6px; padding: 4px 8px; font-weight: 500; border: 1px #222222 solid;">Local</span>

    <a id="photos_${photo.type_document}" class="costume-img" href="javascript:;" style="margin: 0px;">

        <img onerror="this.src='/images/waiting_sync.png'" data-src="${url}" style="border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="${url}" class="gallery-img costume-img hk-gallery">
        </br>                       
        <input filename="${photo.filename}" id="${photo.id}" type_document="${photo.type_document}" class="select_photo_cb" style="margin: auto;display: block;position: relative;" type="checkbox">
    </a></div>`);

        initLightGallery();
    }



    var basemaps = [];


    function generateRandInt() {
        return Date.now();
    }

    function loadBaseLayer(id) {

        basemaps.forEach(basemap => {
            if (basemap.id == id) {
                return;
            }
        });
        var basemap = L.tileLayer(assetBaseUrl + 'app_terrain/basemap_tile/' + id + '/{z}/{x}/{y}?t={rand}', {
            maxZoom: 22,
            rand: generateRandInt,
        });
        basemap.id = id;
        basemap.addTo(map);
        basemaps.push(basemap);
    }

    function destroyBaseLayer(id) {
        basemaps.forEach(basemap => {
            if (basemap.id == id) {
                basemap.remove();
            }
        });
    }

    $("body").on("change", ".active_douar_cb", function() {

        var active = $(this).prop('checked');
        var id = $(this).attr('id');

        if (active) {
            loadBaseLayer(id);
        } else {
            destroyBaseLayer(id);
        }
    });

    $(".douars_map").click(function() {
        douars_map_modal.show();
    });



    var gps_circle = undefined;
    var gps_center_circle = undefined;

    function update_gps_position(lat, lng, accuracy) {
        if (gps_circle == undefined) {
            gps_circle = L.circle([lat, lng], {
                radius: accuracy,
                color: '#1ACE70',
                fillColor: '#88C241',
                fillOpacity: 0.2,

            }).addTo(map);

            gps_center_circle = L.circle([lat, lng], {
                radius: 2,
                color: '#FF2D32',
                fillColor: '#FF2D32',
                fillOpacity: 0.65,
            }).addTo(map);

            $("#gps_current_accuracy").text(accuracy.toString());
        } else {
            gps_circle.setLatLng([lat, lng]);
            gps_center_circle.setLatLng([lat, lng]);
            gps_circle.setRadius(accuracy);


        }

        $(".position_btn").removeClass("disabled");
        $(".position_btn").removeClass("no_click");
    }

    $(".position_btn").click(function() {
        map.flyTo(gps_center_circle._latlng, 20, {
            animate: true,
            duration: 2
        });

    });

    $("body").on("click", ".edit_baraque", function() {
        var id = $(this).attr('id');
        map.closePopup();
        $("#baraque_modal_save").removeAttr("disabled");
        $.ajax({
            url: assetBaseUrl + 'app_terrain/getBaraque?id=' + id,
            type: 'GET',
            success: function(response) {
                current_baraque = {
                    id: response.id,
                    numero: response.numero,
                    menages: response.menages,
                    commerces: response.commerces,
                    geometry: response.geometry,
                    lat: response.lat,
                    lng: response.lng,
                    rdc_obs: response.rdc_obs,
                    e1_obs: response.e1_obs,
                    e2_obs: response.e2_obs,
                    baraque_vide: response.baraque_vide,
                    PHOTO_BARAQUE_VIDE: response.PHOTO_BARAQUE_VIDE
                };

                $("#baraque_modal_numero").val(response.numero);
                $("#baraque_modal_is_baraque_vide").prop("checked", current_baraque.baraque_vide == 1);
                $("#baraque_modal_is_baraque_vide").change();
                drawMenages();
                drawCommerces();
                $("#rdc-tab").click();
                $("#baraque_modal_obs").val(response.rdc_obs);
                $(".phototheque[type_document='PHOTO_BARAQUE_VIDE']").empty();
                current_baraque.PHOTO_BARAQUE_VIDE.forEach(photo => {
                    insertPhoto(photo);
                });
                baraque_modal.show();
            },
            error: function(xhr, status, error) {


            }
        });



    });

    $("#baraque_modal_obs").change(function() {
        if (current_niveau == "RDC") {
            current_baraque.rdc_obs = $("#baraque_modal_obs").val();
        }
        if (current_niveau == "1E") {
            current_baraque.e1_obs = $("#baraque_modal_obs").val();
        }
        if (current_niveau == "2E") {
            current_baraque.e2_obs = $("#baraque_modal_obs").val();
        }
    });

    $("#baraque_modal_obs").keyup(function() {
        if (current_niveau == "RDC") {
            current_baraque.rdc_obs = $("#baraque_modal_obs").val();
        }
        if (current_niveau == "1E") {
            current_baraque.e1_obs = $("#baraque_modal_obs").val();
        }
        if (current_niveau == "2E") {
            current_baraque.e2_obs = $("#baraque_modal_obs").val();
        }
    });


    $("body").on("click", ".edit_baraque_geometry", function() {

        map.closePopup();
        var id = $(this).attr('id');

        edit_geometry_mode = true;
        edit_geometry_mode_id = selected_layer.feature.properties.id;


        $("#drawing_tools_div").removeClass("disabled");
        $("#rdc-tab").click();

        drawing_mode = true;

        $(".add_baraque").addClass("disabled");

        map.pm.enableDraw("Polygon", {
            snappable: true,
            snapDistance: 20,
            tooltips: false,
        });





    });

    $("#rdc-tab").click(function() {
        current_niveau = "RDC";
        $(".niveau_title").text("Rez-de-chaussée");
        drawMenages();
        drawCommerces();

        $("#baraque_modal_obs").val(current_baraque.rdc_obs);
    });
    $("#etage-1-tab").click(function() {
        current_niveau = "1E";
        $(".niveau_title").text("Premier étage");
        drawMenages();
        drawCommerces();

        $("#baraque_modal_obs").val(current_baraque.e1_obs);
    });
    $("#etage-2-tab").click(function() {
        current_niveau = "2E";
        $(".niveau_title").text("Deuxième étage");
        drawMenages();
        drawCommerces();

        $("#baraque_modal_obs").val(current_baraque.e2_obs);
    });

    $(".logout_btn").click(function(event) {
        event.stopPropagation();
        location.href = assetBaseUrl + "logoutn";
    });

    $(".drawing_close").click(function(event) {
        event.stopPropagation();
        map.pm.Draw.Polygon._finishShape();
    });
    $(".drawing_cancel").click(function(event) {
        event.stopPropagation();
        map.pm.disableDraw();
        $(".add_baraque").removeClass("disabled");
        $("#drawing_tools_div").addClass("disabled");
        drawing_mode = false;
    });


    $(".drawing_delete_last_vertex").click(function(event) {
        event.stopPropagation();

        var current_drawing_vertex_count = map.pm.Draw.Polygon._layer.getLatLngs().length;

        map.pm.Draw.Polygon._removeLastVertex();



        if (current_drawing_vertex_count == 1 && map.pm.Draw.Polygon._layer.getLatLngs().length == 1) {
            map.pm.disableDraw();
            $(".add_baraque").removeClass("disabled");
            $("#drawing_tools_div").addClass("disabled");
            drawing_mode = false;
        }

    });

    var lightGallery_list = [];

    function initLightGallery() {
        return;
        lightGallery_list.forEach(lg => {
            lg.destroy();
        });
        lightGallery_list = [];

        $(".phototheque").each(function() {
            var lg = lightGallery(document.getElementById($(this).attr('id')), {
                plugins: [lgZoom, lgThumbnail, lgFullscreen, lgRotate],
                selector: ".gallery-img",
                thumbnail: true,
                animateThumb: true,
                zoomFromOrigin: true,
                allowMediaOverlap: false,
                toggleThumb: true,
                exThumbImage: "data-src",
                fullScreen: true,
                mousewheel: true
            });

            lightGallery_list.push(lg);
        });
    }

    $(".sync_btn").click(function() {
        CSharp.prepareSync();
    });

    $("#sync_modal_sync_btn").click(function() {
        CSharp.Sync();
    });

    var documents_to_delete = [];
    $("body").on('change', '.select_photo_cb', function() {
        var type_document = $(this).attr('type_document');

        if ($(".select_photo_cb[type_document='" + type_document + "']:checked").length > 0) {
            $(".delete_photo_link[type_document='" + type_document + "']").removeAttr('disabled');
        } else {
            $(".delete_photo_link[type_document='" + type_document + "']").attr('disabled', 'disabled');

        }
    });



    $('body').on('click', '.delete_photo_link', function() {
        var type_document = $(this).attr('type_document');

        Swal.fire({
            title: 'Confirmation',
            text: "ÃŠtes-vous certain(e) de vouloir supprimer les photos ?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#88C241',
            cancelButtonColor: '#F83F37',
            confirmButtonText: 'Oui',
            cancelButtonText: 'Non'
        }).then((result) => {
            if (result.isConfirmed) {
                $(".select_photo_cb[type_document='" + type_document + "']:checked").each(function() {
                    $(this).parent().remove();
                    documents_to_delete.push($(this).attr('id'));
                });
                $(".delete_photo_link[type_document='" + type_document + "']").attr('disabled', 'disabled');
            }
        });


    });

    $('body').on('click', '.gallery-img', function() {
        var url = $(this).attr('data-src');
        show_photo(url);
    });

    function show_photo(url) {
        $("#photo_modal_img").attr('src', url);
        photo_modal.show();
    }

    $("#photo_modal_close").click(function() {
        photo_modal.hide();
    })

    $("#menage_modal_cin_non_disponible").change(function() {
        if ($(this).prop("checked")) {
            $("#menage_modal_cin_non_disponible_raision").removeAttr('disabled');
        } else {
            $("#menage_modal_cin_non_disponible_raision").attr('disabled', 'disabled');
        }
    })
</script>

<!-- <script src="<?php echo e(asset('js/client/projet/section_choisir_mon_equipe.js').'?t='.time()); ?>"></script> -->

<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app_terrain', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vsbmaroc/public_html/resources/views/app_terrain/index.blade.php ENDPATH**/ ?>