<?php
$profile_pic = Auth::user()->avatar();

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="_token" content="<?php echo e(csrf_token()); ?>" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
    <link rel="icon" href="<?php echo e(asset('images/favicon.png')); ?>">
    <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
    <title><?php echo e(config('app.name')); ?></title>
    <?php echo $__env->make('inc.css_links', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


</head>

<body class="hold-transition skin-blue layout-top-nav has-drawer" >

    <div class="wrapper">

        <header class="main-header" style=" border-bottom: 1px #a0aaab solid;">
            <div class="inside-header">
                <!-- Logo -->
                <a style="padding: 0 0px !important;width:   136px;" href="<?php echo e(route('dashboard')); ?>" class="logo">
                    <b class="logo-mini" style="height: 100%;padding: 2px;">
                        <span class="light-logo" style="display: flex;height: 100%;"><img src="<?php echo e(asset('images/logo/logo_app.svg').'?v=2'); ?>" alt="logo" style="height: 100%;  "></span>
                    </b>
                </a>
                <!-- Header Navbar -->
                <nav class="navbar navbar-static-top">
                    <!-- Sidebar toggle button-->
                    <a id="navbar_toggle_btn" style="padding:20px 8px !important;text-decoration: none;" style="text-decoration: none !important;" href="#" class="sidebar-toggle d-block d-lg-none" data-toggle="push-menu" role="button">
                        <span class="sr-only">Toggle navigation</span>
                    </a>
                    <ul class="navbar-nav mr-auto mt-md-0">
                    </ul>

                    <div class="navbar-custom-menu" style="padding-top: 4px;">
                        <ul class="nav navbar-nav">
                            <li class="nav-item dropdown dropdown-notifications" style="margin-right: 6px;">
                                <a style="border: 1px #c0665b  solid; line-height: 32px; border-radius: 50%; width: 34px; height: 34px; padding: 0px 8px;" class="nav-link dropdown-toggle no-caret" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                                    <?php if(auth()->user()->notifications_count()==0): ?>
                                    <i style="margin-right: 0px;color:#c0665b; font-size: 1.15rem;line-height: unset;" class="fa-solid fa-bell"></i>
                                    <?php else: ?>
                                    <i style="margin-right: 0px;color:#fb5151;font-size: 1.15rem;line-height: unset;" class="fa-solid fa-bell fa-shake"></i>
                                    <span style="display: flex; right: 20px; border-radius: 50%; font-size: 0.55rem; width: 18px; height: 18px; background-image: unset; top: 22px; position: absolute;" class="badge badge-danger">
                                        <p style="display: block; margin: auto;"><?php echo e(auth()->user()->notifications_count()); ?></p>
                                    </span>
                                    <?php endif; ?>

                                </a>

                                <div class="dropdown-menu dropdown-menu-right" data-bs-auto-close="outside" data-dropdown-in="fadeIn" data-dropdown-out="fadeOut" style="margin-right: 8px; margin-top: 8px; border-radius: 8px;width: 320px;border: 1px #d6d6d6 solid;box-shadow: 0px 0px 8px 2px rgb(0 0 0 / 15%) !important;">
                                    <h6 style="text-align: center;" class="dropdown-header show_all_notification_a"><?php echo e(auth()->user()->notifications_count()); ?> Notifications -&nbsp<a href="javascript:void(0);" class="">Afficher tout</a></h6>
                                    <div class="slimScrollDiv" style="position: relative; overflow: hidden; width: auto; height: 260px;">
                                        <div class="notifications-nicescroll-bar" style="padding: 6px;overflow-y: auto;width: auto; height: 260px; outline: none;" tabindex="-50">
                                            <?php $__currentLoopData = auth()->user()->notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a style="text-decoration: none;padding: 0px;" href="javascript:void(0);" class="dropdown-item">
                                                <div class="media" style="padding: 4px;">
                                                    <div class="media-img-wrap" style="margin: 0rem 0.2rem;">
                                                        <div style="border-radius: 50%; background: #2fa2e4; color: white;" class="avatar avatar-sm">
                                                            <i style="margin-right: 0px;" class="fa-solid fa-bell "></i>
                                                        </div>
                                                    </div>
                                                    <div class="media-body" style="margin: 0px 6px;">
                                                        <div>
                                                            <div class="notifications-text"><a href="<?php echo e($notification->target); ?>" class="text-dark" style="font-weight: 500;white-space: wrap;"><?php echo e($notification->content); ?></a></div>
                                                            <div class="notifications-time"><?php echo e(\Carbon\Carbon::createFromFormat('Y-m-d H:i:s',$notification->created_at)->format('d/m/Y H:i')); ?></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </a>
                                            <div class="dropdown-divider"></div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



                                            <?php if(auth()->user()->notifications_count()==0): ?>
                                            <span style="display: block; margin: auto; text-align: center;">Pas de notifications.</span>
                                            <?php else: ?>
                                            <a style="width: 100%; display: block; text-align: center;" href="javascript:void(0);" class="show_all_notification_a">Afficher toutes les notifications</a></h6>
                                            <?php endif; ?>

                                        </div>
                                        <div class="slimScrollBar" style="background: rgb(214, 217, 218); width: 6px; position: absolute; top: 0px; opacity: 0.8; display: none; border-radius: 0px; z-index: 99; right: 1px; outline: none; height: 284.334px;" tabindex="-50"></div>
                                        <div class="slimScrollRail" style="width: 6px; height: 100%; position: absolute; top: 0px; display: none; border-radius: 7px; background: rgb(51, 51, 51); opacity: 0.2; z-index: 90; right: 1px;"></div>
                                    </div>
                                </div>

                            </li>
                            <!-- User Account -->
                            <li class="dropdown user user-menu" style="margin-right: 12px;">
                                <a href="#" style="background: transparent;display: inline-flex;width: 100%;padding: 0px 0px !important;" class="dropdown-toggle" data-toggle="dropdown">

                                    <img src="<?php echo e($profile_pic); ?>" class="user-image rounded-circle" style="float: left; border: #c0665b solid; border-width: 1px;margin-right: 6px; margin-left: 6px;" alt="User Image">
                                    <div style="float:left;line-height: 1rem; ">
                                        <b style="font-size: 0.75rem;color: #c0665b;display: block;"><?php echo e(ucfirst(auth()->user()->nom)); ?> <?php echo e(ucfirst(auth()->user()->prenom)); ?> </b>
                                        <b style="font-size: 0.65rem;color: #676767;display: block;"><?php echo e(ucfirst(auth()->user()->role->full_name)); ?> </b>



                                    </div>

                                </a>
                                <ul class="dropdown-menu " style="width: 240px; border: 1px #689797 solid; border-radius: 6px; margin-top: 0px; margin-right: 0px; box-shadow: 0px 0px 8px 2px rgb(0 0 0 / 9%) !important;">

                                    <!-- User image -->
                                    <li class="user-header" style="display: contents;">

                                        <img src="<?php echo e($profile_pic); ?>" class="user-image rounded-circle" style="border: #c0665b solid; border-width: 2px; width: 100px; height: auto; display: block; margin: auto; margin-bottom: 6px;    box-shadow: 0px 0px 7px 1px rgb(0 0 0 / 28%) !important;" alt="User Image">

                                        <div class="row">
                                            <h5 style="margin-bottom: 8px !important;font-size: 1rem;width: 100%; text-align: center !important;">
                                                <?php echo e(ucfirst(auth()->user()->nom)); ?>

                                                <?php echo e(ucfirst(auth()->user()->prenom)); ?>

                                            </h5>
                                        </div>
                                        <div class="row">
                                            <b style="margin-bottom: 8px !important;font-size: 0.76rem; color: #2584c9; text-align: center; width: 100%;"><?php echo e(ucfirst(auth()->user()->role->full_name)); ?> </b>
                                        </div>

                                    </li>
                                    <!-- Menu Body -->
                                    <li class="user-body">
                                        <div class="row no-gutters">
                                            <div role="separator" class="divider col-12"></div>
                                            <div class="col-12 text-left">
                                                <button class="btn mt-1 mb-1" style="width: 100%;" class="dropdown-item" onclick="window.location.href='/profile'">
                                                    <i class="fa fa-user"></i> Mon profil
                                                </button>

                                                <button class="btn btn-danger mt-1 mb-1" style="width: 100%;" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                                                    <i class="fa fa-sign-out"></i> <?php echo e(__('Déconnexion')); ?>

                                                </button>

                                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                                                    <?php echo csrf_field(); ?>
                                                </form>
                                            </div>
                                        </div>
                                        <!-- /.row -->
                                    </li>
                                </ul>
                            </li>

                        </ul>
                    </div>
                </nav>
            </div>
        </header>


        <!-- Main Navbar -->
        <div class="main-nav" style="font-size: 85%; margin-top: 0px !important; z-index: 99999999; background: unset; margin-left: 150px; width: calc(100% - 350px) !important; border-left: 1px gray solid; height: 45px;">
            <nav class="navbar navbar-expand-lg" style="margin-top: 8px;">
                <div class="collapse navbar-collapse" id="navbarNavDropdown" style="top: 60px;">
                    <?php echo $__env->make('inc.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </nav>
        </div>

        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">

            <!-- Main content -->
            <section class="content m-content " style="overflow-y: hidden;overflow-x: hidden ">

                <?php echo $__env->yieldContent('content'); ?>

            </section>
            <!-- /.content -->
        </div>

        <!-- Add the sidebar's background. This div must be placed immediately after the control sidebar -->
        <div class="control-sidebar-bg"></div>

    </div>
    <!-- ./wrapper -->
    <?php echo $__env->make('inc.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('layouts/modals', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>

</html><?php /**PATH /home/jobbidmng/public_html/avroyal/resources/views/layouts/app.blade.php ENDPATH**/ ?>