<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AlomranAssist - Accueil</title>
    <link rel="stylesheet" href="styles.css">
    <link rel="stylesheet" href="https://site-assets.fontawesome.com/releases/v6.4.0/css/all.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">

    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

    <link href="/vendor_components/sweetalert/sweetalert.css" rel="stylesheet" type="text/css">
    <script src="/vendor_components/sweetalert/sweetalert2@11.js"></script>
    <style>
        .select2-container {
            flex: 1 1 auto !important;
        }

        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            color: #333;
            margin: 0;
            padding: 0;
            background-image: url(/images/index/bg.jpg);
            background-repeat: no-repeat;
            background-size: cover;
            font-family: 'Montserrat', sans-serif;
        }

        header {
            color: #fff;
            height: 80px;
            text-align: center;
            position: fixed;
            width: 100%;
            background: rgb(255 255 255 / 44%);
            -webkit-backdrop-filter: blur(10px);
            backdrop-filter: blur(10px);
            z-index: 99;
            border: 1px #979797 solid;
            box-shadow: 0 4px 10px rgb(0 0 0 / 4%);
        }

        .container {

            max-width: 1200px;
            margin: auto;
            padding: 20px;
            padding-top: 88px !important;
        }

        h1,
        h2 {
            color: #ffffff;
        }

        p {
            line-height: 1.6;
        }

        .features {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            margin-top: 20px;
        }

        .feature-item {
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            flex: 1 1 calc(33% - 20px);
            padding: 20px;
        }

        .feature-item h3 {
            margin-top: 0;
        }

        .video-container {
            margin-top: 20px;
            text-align: center;
        }

        .video-container iframe {
            width: 100%;
            height: 500px;
            border: none;
            border-radius: 8px;
        }

        @media (max-width: 768px) {
            .features {
                flex-direction: column;
            }
        }

        footer {
            background-color: #115555;
            color: #fff;
            text-align: center;
            padding: 10px 0;
            margin-top: 20px;
        }


        /* Animation for fade-in effect */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        @keyframes scaleUp {
            from {
                transform: scale(0.9);
                opacity: 0;
            }

            to {
                transform: scale(1);
                opacity: 1;
            }
        }

        /* Apply animation to each feature item */
        .feature-item {
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            flex: 1 1 calc(33% - 20px);
            padding: 20px;
            animation: fadeInUp 0.8s ease forwards;
            opacity: 0;
            /* Start hidden for fade-in effect */
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .feature-item:hover {
            transform: translateY(-10px) scale(1.05);
            /* Add scaling effect */
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
        }

        /* Staggered animation delay for each item */
        .feature-item:nth-child(1) {
            animation-delay: 0.1s;
        }

        .feature-item:nth-child(2) {
            animation-delay: 0.2s;
        }

        .feature-item:nth-child(3) {
            animation-delay: 0.3s;
        }

        .feature-item:nth-child(4) {
            animation-delay: 0.4s;
        }

        .feature-item:nth-child(5) {
            animation-delay: 0.5s;
        }

        .feature-item:nth-child(6) {
            animation-delay: 0.6s;
        }

        .feature-item:nth-child(7) {
            animation-delay: 0.7s;
        }

        .feature-item:nth-child(8) {
            animation-delay: 0.8s;
        }

        .feature-item:nth-child(9) {
            animation-delay: 0.9s;
        }

        /* Animation for video container */
        .video-container {
            animation: scaleUp 0.8s ease forwards;
            opacity: 0;
            /* Start hidden for fade-in effect */
            animation-delay: 1s;
        }

        .intro-slider-section {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 20px;
            background-color: #f9f9f9;
            color: #115555;
            border-radius: 10px;
            box-shadow: 0 4px 10px rgb(0 0 0 / 4%);
            border: 1px #d9d9d9 solid;
        }

        .intro-text {
            flex: 1;
            margin-right: 20px;
        }

        .intro-text h1 {
            font-size: 2em;
            margin-bottom: 15px;
            color: #0d4848;
            text-align: center;
        }

        .intro-text p {
            font-size: 1.1em;
            color: #115555;
        }

        .slider {
            flex: 1;
            overflow: hidden;
            border-radius: 8px;
        }

        .slides {
            display: flex;
            transition: transform 0.5s ease;
        }

        .slides img {
            width: 100%;
            border-radius: 8px;
            flex: 1 0 100%;
        }


        .dots {
            display: flex;
            justify-content: center;
            margin-top: 10px;
        }

        .dots button {
            background-color: #ddd;
            border: none;
            border-radius: 50%;
            width: 12px;
            height: 12px;
            margin: 0 5px;
            cursor: pointer;
            transition: background-color 0.3s ease;
        }

        .dots button.active {
            background-color: #115555;
            /* Color for the active dot */
        }

        .logo {
            width: 50%;
            display: block;
            margin: auto;
            height: 68px;
            padding-bottom: 16px;
            border-bottom: 1px #606060 dashed;
        }

        @keyframes slideInFromTop {
            from {
                opacity: 0;
                transform: translateY(-50px);
                /* Starts slightly above the visible area */
            }

            to {
                opacity: 1;
                transform: translateY(0);
                /* Ends at its normal position */
            }
        }

        .intro-slider-section {

            animation: slideInFromTop 1s ease forwards;
            animation-delay: 0.5s;
            opacity: 0;
            /* Initially hidden for the animation */
        }
    </style>
</head>

<body>
    <header>
        <img style="height: calc(100% - 16px); display: block; left: 8px; position: absolute; margin: 8px;" src="/images/alomrane-groupe.svg?v=2">
        <div style="position: absolute; right: 20px; top: 50%; transform: translateY(-50%);">
            <button class="btn btn-sm btn-success mr-2" id="authentification_btn"><i class="fa-solid fa-unlock mr-1"></i>Authentification</button>
            <button class="btn btn-sm btn-light" data-toggle="modal" data-target="#add_prestataire_modal"><i class="fa-solid fa-envelope mr-1"></i>Demande d'inscription</button>
        </div>
    </header>
    <div class="container">

        <div class="row intro-slider-section">
            <div class="col-12 col-sm-6">
                <div class="intro-text">
                    <img class="logo" src="/images/logo/logo_app.svg?v=2">
                    <h1>&nbsp&nbspBienvenue sur la plateforme <b style="text-transform: uppercase;color: #3d9b9b;">AlomranAssist</b></h1>
                    <p style="    border-bottom: 1px #c6c6c6 solid;color: #4c8117;"><i style="margin-right: 8px;margin-left: 20px;" class="fa-regular fa-thumbs-up mr-2 ml-4"></i><b style="font-weight: 500 !important;">Réussissez vos projets immobiliers, où que vous soyez !</b></p>
                    <p style="color:#4c4c4c">
                        &nbsp&nbsp&nbspTamkineInvest a été conçue pour simplifier
                        et optimiser la gestion de vos projets immobiliers, en particulier pour les Marocains du monde.
                        Notre mission est de vous offrir un accompagnement complet, transparent et sécurisé tout au long
                        du cycle de vie de votre projet.
                    </p>
                </div>
            </div>
            <div class="col-12 col-sm-6">

                <div class="slider">
                    <div class="slides">
                        <img src="/images/index/image1.jpg" alt="Image 1">
                        <img src="/images/index/image2.jpg" alt="Image 2">
                        <img src="/images/index/image3.jpg" alt="Image 3">
                        <img src="/images/index/image4.jpg" alt="Image 4">
                    </div>
                    <div class="dots">
                        <!-- Dots will be dynamically generated -->
                    </div>
                </div>
            </div>
        </div>

        <section>
            <h2 style="color: #4b4b4b;text-align: center;margin-top: 53px;background: #ffffff;border-radius: 8px;padding: 16px;">
                <img style="height: 80px; margin: auto; display: block;" src="/images/index/solution.png">
                </span style="margin:top:8px">Une solution complète et innovante</span>
            </h2>
            <div class="features">
                <div class="feature-item">
                    <h5 style="color: #115555;text-decoration: underline;"><i class="fas fa-tachometer-alt"></i> Tableau de bord global</h3>
                        <p>&nbsp&nbspAccédez à une vue d'ensemble en temps réel de l'état d'avancement de votre projet.</p>
                </div>
                <div class="feature-item">
                    <h5 style="color: #115555;text-decoration: underline;"><i class="fas fa-play-circle"></i> Préparation du démarrage</h3>
                        <p>&nbsp&nbspObtenez une description détaillée de vos projets avec l’assistance technique de nos experts.</p>
                </div>
                <div class="feature-item">
                    <h5 style="color: #115555;text-decoration: underline;"><i class="fas fa-users-cog"></i> Sélection des prestataires d'études</h3>
                        <p>&nbsp&nbspAccédez à un référentiel complet d'architectes, de bureaux d'études, de topographes et de laboratoires qualifiés.</p>
                </div>
                <div class="feature-item">
                    <h5 style="color: #115555;text-decoration: underline;"><i class="fas fa-briefcase"></i> Choix des entreprises responsables des travaux</h3>
                        <p>&nbsp&nbspPrenez des décisions éclairées grâce aux devis et aux informations détaillées sur chaque prestataire.</p>
                </div>
                <div class="feature-item">
                    <h5 style="color: #115555;text-decoration: underline;"><i class="fas fa-chart-line"></i> Suivi détaillé des études</h3>
                        <p>&nbsp&nbspRestez informé de l’évolution des études à chaque étape.</p>
                </div>
                <div class="feature-item">
                    <h5 style="color: #115555;text-decoration: underline;"><i class="fas fa-hard-hat"></i> Suivi des travaux</h3>
                        <p>&nbsp&nbspSuivez précisément l’avancement des travaux de construction à chaque phase.</p>
                </div>
                <div class="feature-item">
                    <h5 style="color: #115555;text-decoration: underline;"><i class="fas fa-cube"></i> Visualisation 3D</h3>
                        <p>&nbsp&nbspExplorez virtuellement les plans de votre projet grâce à des modélisations 3D immersives.</p>
                </div>
                <div class="feature-item">
                    <h5 style="color: #115555;text-decoration: underline;"><i class="fas fa-video"></i> Caméra 360° pour un suivi terrain</h3>
                        <p>&nbsp&nbspSuivez l’avancement réel de votre chantier grâce à une technologie immersive similaire à Street-view.</p>
                </div>
                <div class="feature-item">
                    <h5 style="color: #115555;text-decoration: underline;"><i class="fas fa-video"></i> Espace de visioconférence</h3>
                        <p>&nbsp&nbspFacilitez les échanges avec les parties prenantes de votre projet grâce à un espace dédié pour des réunions en ligne.</p>
                </div>
            </div>
        </section>

    </div>
    <footer>
        <p>&copy; 2024 AlomranAssist. Tous droits réservés.</p>
    </footer>


    <div id="add_prestataire_modal" class="modal fade" role="dialog">
        <div class="modal-dialog modal-lg modal-center" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Demande d'inscription</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>

                <form id="store_user_form">
                    <?php echo csrf_field(); ?>
                    <input hidden name="id" class="form-control">
                    <div class=" modal-body">


                        <div class="row">
                            <div class="col-12">
                                <div class="input-group input-group-sm mb-3">
                                    <div class="input-group-prepend">
                                        <span style="padding: .0rem .5rem !important;min-width: 200px;" class="input-group-text">Type du client</span>
                                    </div>
                                    <select id="add_prestataire_modal_type_client" required name="type_client" class="select2nc">
                                        <option selected value="Personne physique">Personne physique</option>
                                        <option value="Personne morale">Personne morale</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <div class="input-group input-group-sm mb-3">
                                    <div class="input-group-prepend">
                                        <span style="padding: .0rem .5rem !important;min-width: 200px;" class="input-group-text">Nom</span>
                                    </div>
                                    <input required name="nom" class="form-control" placeholder="Nom">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <div class="input-group input-group-sm mb-3">
                                    <div class="input-group-prepend">
                                        <span style="padding: .0rem .5rem !important;min-width: 200px;" class="input-group-text">Prenom</span>
                                    </div>
                                    <input required name="prenom" class="form-control" placeholder="Prenom">
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-12">
                                <div class="input-group input-group-sm mb-3">
                                    <div class="input-group-prepend">
                                        <span style="padding: .0rem .5rem !important;min-width: 200px;" class="input-group-text">Adresse</span>
                                    </div>
                                    <input required name="adresse" class="form-control" placeholder="Adresse">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <div class="input-group input-group-sm mb-3">
                                    <div class="input-group-prepend">
                                        <span style="padding: .0rem .5rem !important;min-width: 200px;" class="input-group-text">Email</span>
                                    </div>
                                    <input required name="email" class="form-control" placeholder="Email">
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-12">
                                <div class="input-group input-group-sm mb-3">
                                    <div class="input-group-prepend">
                                        <span style="padding: .0rem .5rem !important;min-width: 200px;" class="input-group-text">Téléphone</span>
                                    </div>
                                    <input name="tel" class="form-control" placeholder="Téléphone">
                                </div>
                            </div>
                        </div>

                        <div class="row organisme_ste_div" style="display:none">
                            <div class="col-12">
                                <div class="input-group input-group-sm mb-3">
                                    <div class="input-group-prepend">
                                        <span style="padding: .0rem .5rem !important;min-width: 200px;" class="input-group-text">Organisme/Société</span>
                                    </div>
                                    <input name="organisme_ste" class="form-control" placeholder="Organisme/Société">
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="input-group input-group-sm mb-3">
                                    <div class="input-group-prepend">
                                        <span style="padding: .0rem .5rem !important;min-width: 200px;" class="input-group-text">Identifiant de l'Entreprise</span>
                                    </div>
                                    <input name="identifiant_ste" class="form-control" placeholder="Identifiant de l'Entreprise">
                                </div>
                            </div>
                        </div>



                    </div>

                    <div class="modal-footer" style="width:100%">
                        <div class="row" style=" width: 100%;">
                            <div class="col-6">
                            </div>
                            <div class="col-6">
                                <button style="float: right;margin-left: 8px;" type="button" class="btn btn-sm btn-danger " data-dismiss="modal"><i class="fa-solid fa-xmark"></i>&nbspFermer</button>
                                <button style="float: right;" type="submit" class="btn btn-success btn-sm"><i class="fa-solid fa-envelope mr-1"></i>&nbspDemander</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</body>

<script>
    let currentSlide = 0;
    const slides = document.querySelectorAll('.slides img');
    const dotsContainer = document.querySelector('.dots');

    // Create dots based on the number of slides
    slides.forEach((_, index) => {
        const dot = document.createElement('button');
        dot.addEventListener('click', () => {
            goToSlide(index);
        });
        dotsContainer.appendChild(dot);
    });

    const dots = document.querySelectorAll('.dots button');

    function updateDots() {
        dots.forEach((dot, index) => {
            dot.classList.toggle('active', index === currentSlide);
        });
    }

    function goToSlide(index) {
        currentSlide = index;
        document.querySelector('.slides').style.transform = `translateX(-${currentSlide * 100}%)`;
        updateDots();
    }

    function showNextSlide() {
        currentSlide = (currentSlide + 1) % slides.length;
        goToSlide(currentSlide);
    }

    // Initialize the first active dot
    updateDots();

    // Automatically change slides every 3 seconds
    setInterval(showNextSlide, 3000);


    $("#authentification_btn").click(function() {
        location.href = "/login";
    });

    $(document).ready(function() {
        $(".select2").select2();
        $(".select2nc").select2({
            minimumResultsForSearch: -1
        });
    });


    $("#add_prestataire_modal_type_client").change(function() {
        if ($(this).val() == "Personne morale") {
            $(".organisme_ste_div").css('display', 'block');
        } else {
            $(".organisme_ste_div").css('display', 'none');
        }
    });



    $("#store_user_form").submit(function(event) {

        event.preventDefault();
        var formData = new FormData(this);
        $.ajax({
            url: "/user/store",
            type: "POST",
            dataType: "json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success == 1) {
                    $("#add_prestataire_modal").modal('hide');
                    Swal.fire({
                        icon: "success",
                        title: "AlomranAssist",
                        text: "Votre demande a été enregistrée avec succès. Vous recevrez un email prochainement pour poursuivre la création de votre compte.",

                    });
                } else {
                    Swal.fire({
                        icon: "error",
                        title: "AlomranAssist",
                        text: "Cet email est déjà présent dans notre base de données.",

                    });

                }


            },
            error: function(xhr, status, error) {
                console.log(xhr.responseText);
            },
        });
    });
</script>

</html><?php /**PATH /home/u447310764/domains/indigo-ram-434224.hostingersite.com/public_html/resources/views/index/index.blade.php ENDPATH**/ ?>