<style>
    /* ----------------------------------------------------------------------------------------------------------*/
    /* NavCubePlugin */
    /* ----------------------------------------------------------------------------------------------------------*/

    #myNavCubeCanvas {
        position: absolute;
        width: 250px;
        height: 250px;
        bottom: 50px;
        right: 10px;
        z-index: 200000;
    }

    /* ----------------------------------------------------------------------------------------------------------*/
    /* TreeViewPlugin */
    /* ----------------------------------------------------------------------------------------------------------*/

    #treeViewContainer {
        pointer-events: all;

        overflow-y: auto;
        overflow-x: hidden;
        background-color: rgba(255, 255, 255, 0.2);
        color: black;
        top: 80px;
        z-index: 200000;
        float: left;
        left: 0;
        padding-left: 10px;
        font-family: 'Roboto', sans-serif;
        font-size: 15px;
        user-select: none;
        -ms-user-select: none;
        -moz-user-select: none;
        -webkit-user-select: none;

    }

    #treeViewContainer ul {
        list-style: none;
        padding-left: 1.75em;
        pointer-events: none;
    }

    #treeViewContainer ul li {
        position: relative;
        width: 500px;
        pointer-events: none;
        padding-top: 3px;
        padding-bottom: 3px;
        vertical-align: middle;
    }

    #treeViewContainer ul li a {
        background-color: #eee;
        border-radius: 50%;
        color: #000;
        display: inline-block;
        height: 1.5em;
        left: -1.5em;
        position: absolute;
        text-align: center;
        text-decoration: none;
        width: 1.5em;
        pointer-events: all;
    }

    #treeViewContainer ul li a.plus {
        background-color: #ded;
        pointer-events: all;
    }

    #treeViewContainer ul li a.minus {
        background-color: #eee;
        pointer-events: all;
    }

    #treeViewContainer ul li a:active {
        top: 1px;
        pointer-events: all;
    }

    #treeViewContainer ul li span:hover {
        color: white;
        cursor: pointer;
        background: black;
        padding-left: 2px;
        pointer-events: all;
    }

    #treeViewContainer ul li span {
        display: inline-block;
        width: calc(100% - 50px);
        padding-left: 2px;
        pointer-events: all;
        height: 23px;
    }

    #treeViewContainer .highlighted-node {
        /* Appearance of node highlighted with TreeViewPlugin#showNode() */
        border: black solid 1px;
        background: yellow;
        color: black;
        padding-left: 1px;
        padding-right: 5px;
        pointer-events: all;
    }
</style>
<div class="row">
    <div class="col-12 col-sm-4">

        <div class="card">
            <div class="card-body">
                <h6 class="card-title"><i class="fa-solid fa-folder-tree mr-1"></i>L'arborescence </h6>

                <div id="treeViewContainer" style="width: 100%;padding: 8px; height:700px"></div>
            </div>
        </div>
    </div>
    <div class="col-12 col-sm-8">

        <div class="card">
            <div class="card-body">
                <h6 class="card-title"><i class="fa-brands fa-unity mr-1"></i>Visionneuse</h6>
                <canvas id="viewer_canvas" style="width: 100%;height:700px"></canvas>


            </div>
        </div>

    </div>
</div>

</body>
<script id="source" type="module">
    import {
        XKTLoaderPlugin,
        WebIFCLoaderPlugin,
        TreeViewPlugin,
        DistanceMeasurementsPlugin,
        Viewer,
        DistanceMeasurementsMouseControl,
        PointerLens
    } from "https://cdn.jsdelivr.net/npm/@xeokit/xeokit-sdk/dist/xeokit-sdk.es.min.js";


    import * as WebIFC from "https://cdn.jsdelivr.net/npm/web-ifc@0.0.51/web-ifc-api.js";

    const viewer = new Viewer({
        canvasId: "viewer_canvas",
        transparent: true
    });
    const canvas = document.getElementById('viewer_canvas');
    canvas.addEventListener('wheel', (event) => {
        event.preventDefault(); // Prevent default scroll behavior
    });
    // 2
    viewer.camera.eye = [-2.56, 8.38, 8.27];
    viewer.camera.look = [13.44, 3.31, -14.83];
    viewer.camera.up = [0.10, 0.98, -0.14];


    const treeView = new TreeViewPlugin(viewer, {
        containerElement: document.getElementById("treeViewContainer")
    });

    const distanceMeasurements = new DistanceMeasurementsPlugin(viewer);

    const distanceMeasurementsControl = new DistanceMeasurementsMouseControl(distanceMeasurements, {
       
    })



    distanceMeasurementsControl.snapToVertex = true;
    distanceMeasurementsControl.snapToEdge = true;

    ///distanceMeasurementsControl.activate();


    const IfcAPI = new WebIFC.IfcAPI();


    IfcAPI.SetWasmPath("https://cdn.jsdelivr.net/npm/web-ifc@0.0.51/");


    IfcAPI.Init().then(() => {


        const ifcLoader = new WebIFCLoaderPlugin(viewer, {
            WebIFC,
            IfcAPI
        });

        // 2
        let model = ifcLoader.load({ // Returns an Entity that represents the model
            id: "myModel",
            src: "/files/bim/20211122Wellness center Sama.ifc",
            excludeTypes: ["IfcSpace"],
            edges: true
        });

        model.on("loaded", () => {

            const metaModel = viewer.metaScene.metaModels["myModel"]; // MetaModel with ID "myModel"

            // Find the model Entity by ID
            const model = viewer.scene.models["myModel"];

            // Get the Object IDs in the model
            const objectIds = viewer.metaScene.getObjectIDsInSubtree(model.id); // Gets IDs of objects in the model subtree

            // Get the AABB (Axis-Aligned Bounding Box) of the entire model
            const aabb = viewer.scene.getAABB(objectIds);

            // Zoom to the extent of the model using the AABB
            viewer.cameraFlight.flyTo(aabb); // Automatically zoom to fit the model within the view


        });
    });
</script><?php /**PATH /home/u207500317/domains/seagreen-ostrich-285320.hostingersite.com/public_html/resources/views/projets/3dview_tab.blade.php ENDPATH**/ ?>