

<?php $__env->startSection('added_css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/datatable/datatables.min.css')); ?>" />
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('chart.js/dist/Chart.min.css')); ?>">
<script src='https://unpkg.com/maplibre-gl@latest/dist/maplibre-gl.js'></script>
<link href='https://unpkg.com/maplibre-gl@latest/dist/maplibre-gl.css' rel='stylesheet' />
<script src="<?php echo e(asset('js/geoportail/mapblibre_animated_popup.js')); ?>"></script>


<style>
    /* ----------------------------------------------------------------------------------------------------------*/
    /* NavCubePlugin */
    /* ----------------------------------------------------------------------------------------------------------*/

    #myNavCubeCanvas {
        position: absolute;
        width: 250px;
        height: 250px;
        bottom: 50px;
        right: 10px;
        z-index: 200000;
    }

    /* ----------------------------------------------------------------------------------------------------------*/
    /* TreeViewPlugin */
    /* ----------------------------------------------------------------------------------------------------------*/

    .lg-outer.lg-visible {

        margin-top: 120px;
        height: 100%;
    }

    .lg-backdrop.in {
        margin-top: 120px;
        height: 100%;
    }

    #treeViewContainer {
        pointer-events: all;

        overflow-y: auto;
        overflow-x: hidden;
        background-color: rgba(255, 255, 255, 0.2);
        color: black;
        top: 80px;
        z-index: 200000;
        float: left;
        left: 0;
        padding-left: 10px;
        font-family: 'Roboto', sans-serif;
        font-size: 15px;
        user-select: none;
        -ms-user-select: none;
        -moz-user-select: none;
        -webkit-user-select: none;

    }

    #treeViewContainer ul {
        list-style: none;
        padding-left: 1.75em;
        pointer-events: none;
    }

    #treeViewContainer ul li {
        position: relative;
        width: 500px;
        pointer-events: none;
        padding-top: 3px;
        padding-bottom: 3px;
        vertical-align: middle;
    }

    #treeViewContainer ul li a {
        background-color: #eee;
        border-radius: 50%;
        color: #000;
        display: inline-block;
        height: 1.5em;
        left: -1.5em;
        position: absolute;
        text-align: center;
        text-decoration: none;
        width: 1.5em;
        pointer-events: all;
    }

    #treeViewContainer ul li a.plus {
        background-color: #ded;
        pointer-events: all;
    }

    #treeViewContainer ul li a.minus {
        background-color: #eee;
        pointer-events: all;
    }

    #treeViewContainer ul li a:active {
        top: 1px;
        pointer-events: all;
    }

    #treeViewContainer ul li span:hover {
        color: white;
        cursor: pointer;
        background: black;
        padding-left: 2px;
        pointer-events: all;
    }

    #treeViewContainer ul li span {
        display: inline-block;
        width: calc(100% - 50px);
        padding-left: 2px;
        pointer-events: all;
        height: 23px;
    }

    #treeViewContainer .highlighted-node {
        /* Appearance of node highlighted with TreeViewPlugin#showNode() */
        border: black solid 1px;
        background: yellow;
        color: black;
        padding-left: 1px;
        padding-right: 5px;
        pointer-events: all;
    }

    .side-panel-toggle {
        height: 26px;
        width: 26px;
        background: #f0f0f0;
        right: 6px;
        top: 4px;
        position: absolute;
        display: flex;
        border-radius: 50%;
        border: 1px #cccccc solid;
        color: cadetblue;
        transition: transform 0.2s, 0.35s ease-in-out !important;
    }

    .side_panel {

        top: 44px;
        border: 2px #115555 solid;
    }

    .side_panel.folded {
        width: 44px !important;
        overflow: hidden;
    }

    body,
    html {
        height: 100%;
        margin: 0;
    }

    .full-height {
        height: 100%;
        display: flex;
        flex-direction: column;
    }

    .row-full {
        flex-grow: 1;
    }

    .btn-big-vis {
        padding: 6px;
        background-color: #ffffff !important;
        color: #0a76c7 !important;
    }

    .btn-big-vis:hover {

        background-color: #cccccc !important;

    }

    .costume-img {
        float: left !important;
    }
</style>

<div class="row mt-2">
    <div class="col-12">
        <button id="maquettes_3d" style="height: 70px;width: 98px;" class="btn mr-2 btn-big-vis  ">
            <svg height="40px" width="40px" version="1.1" id="_x32_" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512 512" xml:space="preserve" fill="#ffffff" stroke="#ffffff">
                <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                <g id="SVGRepo_iconCarrier">
                    <style type="text/css">
                        .st0 {
                            fill: #0a76c7;
                        }
                    </style>
                    <g>
                        <path class="st0" d="M320.707,0L37.037,69.971v417.625L320.447,512l154.516-26.258V62.568L320.707,0z M290.346,471.742 l-92.584-7.974v-79.426l-55.086-0.677v75.36l-68.109-5.866V99.367l215.779-53.224V471.742z"></path>
                        <polygon class="st0" points="271.25,76.933 226.537,86.32 226.537,138.956 271.25,131.246 "></polygon>
                        <polygon class="st0" points="118.574,112.033 87.416,118.622 87.416,164.818 118.574,159.469 "></polygon>
                        <polygon class="st0" points="190.012,95.942 150.426,104.23 150.426,153.027 190.012,146.202 "></polygon>
                        <polygon class="st0" points="118.576,203.184 87.416,207.448 87.416,253.722 118.576,250.622 "></polygon>
                        <polygon class="st0" points="190.012,192.792 150.426,198.154 150.426,246.952 190.012,243.052 "></polygon>
                        <polygon class="st0" points="271.25,181.04 226.537,187.097 226.537,238.911 271.25,234.506 "></polygon>
                        <polygon class="st0" points="271.25,286.135 226.537,288.889 226.537,340.702 271.25,339.6 "></polygon>
                        <polygon class="st0" points="190.012,291.476 150.426,293.914 150.426,342.712 190.012,341.737 "></polygon>
                        <polygon class="st0" points="118.574,296.198 87.416,298.136 87.416,344.409 118.574,343.634 "></polygon>
                    </g>
                </g>
            </svg>
            <b style="display:block"><?php echo e(__("Maquettes 3D")); ?></b></button>
        <button id="vue_360" style="height: 70px;width: 98px;" class="btn mr-2 btn-big-vis ">

            <svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" height="40px" width="40px" viewBox="0 0 75.37 40.73">
                <defs>
                    <style>
                        .cls-1 {
                            fill: #2b3844;
                        }

                        .cls-1,
                        .cls-2 {
                            stroke-width: 0px;
                        }

                        .cls-2 {
                            fill: #4a92ce;
                        }
                    </style>
                </defs>
                <path class="cls-1" d="M49.85,40.73c-4.96-2.71-9.76-5.32-14.69-8.01,4.82-2.94,9.53-5.81,14.48-8.83,0,1.58,0,2.9,0,4.22,0,.5.03.87.71.79,5.18-.64,10.25-1.68,14.77-4.48,1.21-.75,2.31-1.67,3.01-2.95.75-1.38.63-2.32-.47-3.54-.91-1.01-2.02-1.78-3.25-2.31-.82-.35-.86-.71-.49-1.45.72-1.45,1.33-2.95,1.99-4.43.15-.35.2-.84.81-.55,3.42,1.67,6.51,3.73,7.97,7.46,1.46,3.74.49,7.1-2.01,10.06-2.73,3.24-6.39,5.05-10.3,6.42-3.69,1.29-7.49,2.11-11.38,2.41-.9.07-1.25.39-1.17,1.34.1,1.21.02,2.43.02,3.83Z" />
                <path class="cls-1" d="M0,20.06c.15-4.33,2.62-7.18,6.06-9.38,2.4-1.53,2.41-1.5,3.57,1.11.46,1.04.92,2.07,1.4,3.1.21.45.15.7-.34.94-1.06.52-2.05,1.14-2.87,2.03-1.39,1.51-1.44,2.84-.11,4.42,1.51,1.79,3.55,2.81,5.66,3.67,4.26,1.73,8.77,2.27,13.29,2.74,1.25.13,2.51.23,3.77.25.82.01.92.35.84,1.05-.18,1.65-.31,3.31-.42,4.97-.03.49-.05.85-.73.8-6.99-.6-14.01-1.09-20.53-4.08-3.41-1.56-6.48-3.56-8.38-6.95C.42,23.28-.01,21.73,0,20.06Z" />
                <path class="cls-2" d="M44.21,9.75c-.02-1.59.16-3.16.73-4.66,1.15-3,3.19-4.47,6.15-4.41,2.74.05,4.86,1.63,5.73,4.62.95,3.26.97,6.57-.36,9.78-1.05,2.52-3.01,3.79-5.7,3.8-2.61,0-4.45-1.29-5.54-3.66-.79-1.74-1.03-3.57-1.01-5.46ZM48.38,9.73c-.04,1.51,0,3,.58,4.43.36.88.91,1.59,1.95,1.56.98-.03,1.54-.72,1.8-1.58.85-2.86.89-5.75.03-8.62-.26-.88-.78-1.65-1.85-1.67-1.13-.02-1.61.79-1.97,1.7-.54,1.35-.59,2.76-.54,4.19Z" />
                <path class="cls-2" d="M33.48,7.97c1.03-.65,1.91-1.11,2.95-1.19,3.17-.24,5.62,1.57,6.07,4.52.53,3.44-1.53,6.68-4.7,7.36-4.74,1.03-8.53-1.95-8.68-6.8-.05-1.72.12-3.39.75-5.02,1.88-4.83,6.19-6.1,10.11-6.16.46,0,.61.2.66.65.29,2.33.17,2.49-2.17,2.71-2.52.23-4.31,1.56-5,3.91ZM33.25,12.31c.01,2.1,1.08,3.46,2.74,3.48,1.42.02,2.42-1.24,2.42-3.04,0-1.8-1.05-3.04-2.59-3.03-1.53,0-2.58,1.06-2.57,2.59Z" />
                <path class="cls-2" d="M23.29,9.12c.19.13.3.24.45.3,1.7.65,2.77,1.82,2.95,3.67.2,2.03-.69,3.62-2.4,4.59-3.04,1.71-6.21,1.51-9.39.28-.78-.3-.47-.8-.36-1.28.47-2.06.47-2.05,2.44-1.43,1.34.42,2.71.57,4.05,0,.86-.36,1.34-1.02,1.34-1.99,0-.95-.46-1.62-1.31-2.01-.9-.42-1.87-.59-2.85-.52-.8.06-1.13-.22-1.02-1.02.04-.28.04-.57,0-.85-.11-.83.17-1.2,1.06-1.1.77.09,1.55,0,2.28-.28.85-.33,1.47-.89,1.33-1.93-.13-.96-.8-1.38-1.68-1.48-1.18-.13-2.37-.1-3.45.48-.8.43-1.2.3-1.43-.65-.53-2.15-.53-2.22,1.71-2.79,1.83-.47,3.68-.63,5.54-.15,1.88.49,3.24,1.59,3.54,3.58.27,1.83-.55,3.22-2.15,4.15-.21.12-.4.26-.65.43Z" />
                <path class="cls-2" d="M59.11,4.07C59.1,1.76,60.81.04,63.17,0c2.25-.04,4.2,1.83,4.17,4.01-.03,2.22-1.89,3.98-4.21,3.98-2.35,0-4.02-1.62-4.03-3.92ZM65.04,4c0-1.2-.82-2.1-1.89-2.08-1.07.02-1.86.94-1.84,2.15.02,1.17.77,1.97,1.84,1.99,1.13.01,1.89-.81,1.89-2.05Z" />
            </svg>
            <b style="display:block"><?php echo e(__("Visite 360")); ?></b></button>


        <button id="photos" style="height: 70px;width: 98px;" class="btn mr-2 btn-big-vis  ">

            <svg height="40px" width="40px" fill="#0a76c7" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 31.06 32.001" xml:space="preserve">
                <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                <g id="SVGRepo_iconCarrier">
                    <g id="photos">
                        <path d="M29.341,11.405L13.213,7.383c-1.21-0.301-2.447,0.441-2.748,1.652L6.443,25.163c-0.303,1.211,0.44,2.445,1.65,2.748 l16.127,4.023c1.21,0.301,2.447-0.443,2.748-1.652l4.023-16.127C31.293,12.944,30.551,11.708,29.341,11.405z M28.609,14.338 l-2.926,11.731c-0.1,0.402-0.513,0.65-0.915,0.549l-14.662-3.656c-0.403-0.1-0.651-0.512-0.551-0.916l2.926-11.729 c0.1-0.404,0.513-0.65,0.916-0.551l14.661,3.658C28.462,13.522,28.71,13.936,28.609,14.338z"></path>
                        <circle cx="15.926" cy="13.832" r="2.052"></circle>
                        <path d="M22.253,16.813c-0.136-0.418-0.505-0.51-0.82-0.205l-2.943,2.842c-0.315,0.303-0.759,0.244-0.985-0.133l-0.471-0.781 c-0.227-0.377-0.719-0.5-1.095-0.273l-4.782,2.852c-0.377,0.225-0.329,0.469,0.096,0.576l3.099,0.771 c0.426,0.107,1.122,0.281,1.549,0.389l3.661,0.912c0.426,0.105,1.123,0.279,1.549,0.385l3.098,0.773 c0.426,0.107,0.657-0.121,0.521-0.539L22.253,16.813z"></path>
                        <path d="M2.971,7.978l14.098-5.439c0.388-0.149,0.828,0.045,0.977,0.432l1.506,3.933l2.686,0.67l-2.348-6.122 c-0.449-1.163-1.768-1.748-2.931-1.299L1.45,6.133C0.287,6.583-0.298,7.902,0.151,9.065L5.156,22.06l0.954-3.827L2.537,8.954 C2.389,8.565,2.583,8.126,2.971,7.978z"></path>
                    </g>
                    <g id="Layer_1"> </g>
                </g>
            </svg>
            <b style="display:block"><?php echo e(__("Photos")); ?></b>
        </button>

        <button id="documents" style="height: 70px;width: 98px;" class="btn mr-2 btn-big-vis  ">
            <svg height="40px" width="40px" fill="#0a76c7" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 31.119 31.119" xml:space="preserve">
                <g id="SVGRepo_bgCarrier" stroke-width="0"></g>
                <g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g>
                <g id="SVGRepo_iconCarrier">
                    <g>
                        <g>
                            <path d="M26.065,14.984c-0.1-0.666-0.671-1.146-1.343-1.146H13.836l-1.977-2.34c-0.419-0.492-1.034-0.802-1.681-0.802H3.105 c-0.504,0-0.983,0.236-1.309,0.622c-0.325,0.387-0.464,0.917-0.379,1.414l0.188,1.106H1.481c-0.396,0-0.771,0.161-1.027,0.461 c-0.26,0.301-0.373,0.693-0.312,1.084l2.196,14.248c0.133,0.857,0.871,1.488,1.738,1.488h22.797c0.396,0,0.771-0.174,1.027-0.471 c0.257-0.3,0.373-0.689,0.314-1.08L26.065,14.984z"></path>
                            <path d="M20.645,4.351H12.13c-0.587,0-1.063,0.53-1.063,1.118s0.477,1.118,1.063,1.118h8.515c0.589,0,1.064-0.53,1.064-1.118 S21.232,4.351,20.645,4.351z"></path>
                            <path d="M30.677,12.186c-0.245-0.285-0.604-0.464-0.981-0.464h-2.416l0.55,5.095l1.313,8.901l1.838-12.492 C31.032,12.854,30.924,12.472,30.677,12.186z"></path>
                            <path d="M9.024,2.055h14.864v10.091h2.056V1.307C25.943,0.591,25.345,0,24.629,0H8.191C7.405,0,6.789,0.647,6.789,1.433v7.812 h2.235V2.055z"></path>
                            <path d="M20.645,8.46H12.13c-0.511,0-0.937,0.404-1.04,0.899c0.729,0.186,1.392,0.583,1.891,1.168l0.155,0.168h7.509 c0.589,0,1.064-0.53,1.064-1.118C21.709,8.989,21.232,8.46,20.645,8.46z"></path>
                        </g>
                    </g>
                </g>
            </svg>
            <b style="display:block"><?php echo e(__("Documents")); ?></b></button>

    </div>

</div>


<div class="row mt-2" style="display:none">
    <div class="col-6">
        <div class="card">
            <div class="card-body">

                <h6 class="card-title"><i class="fa-brands fa-unity mr-1"></i><?php echo e(__("Maquettes 3D")); ?></h6>

                <div class="phototheque hk-gallery mt-1" type_document="" style="width: 100%;border-radius:6px;border:1px #949494 solid;height:140px;overflow-x: auto;white-space: nowrap;padding:4px">
                    <?php $__currentLoopData = $maquettes3d_file_groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $__currentLoopData = $group['files']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a class="costume-img" style="margin: 0px;">
                        <img class="ifc_a" ifc_path="<?php echo e($photo->documentUrl()); ?>" style="border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="<?php echo e(asset('images/ifc_file_default_thumbnail.png')); ?>" class="gallery-img costume-img hk-gallery">

                    </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>



            </div>
        </div>
    </div>


    <div class="col-6  ">
        <div class="card">
            <div class="card-body">
                <h6 class="card-title"><i class="fa-solid fa-street-view mr-1"></i><?php echo e(__("Visite 360")); ?></h6>
                <div class="phototheque hk-gallery mt-1" type_document="" style="width: 100%;border-radius:6px;border:1px #949494 solid;height:140px;overflow-x: auto;white-space: nowrap;padding:4px">
                    <a class="costume-img " style="margin: 0px;">
                        <img class="visite_360_a" ifc_path="https://my.matterport.com/show/?m=5JLjtzxSeVM" style="    border-radius: 8px;border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="<?php echo e(asset('images/visite_360_icon.png')); ?>" class="gallery-img costume-img hk-gallery">
                        </br>
                        <b style="padding-top:4px; text-align: center;text-overflow: clip;overflow: hidden;white-space: nowrap;display: block;"><?php echo e(__("Visite")); ?> n° 1</b>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row row-full vue_3d_div">
    <div class="col-12  mt-2 ">

        <div class="card">
            <div class="card-body">
                <h6 class="card-title"><i class="fa-regular fa-eye mr-1"></i><?php echo e(__("Maquettes 3D")); ?></h6>
                <canvas id="viewer_canvas" style="width: 100%;height:550px">



                </canvas>


                <div id="viewer_canvas_mg" style="width: 100%;height:550px;display:none">
                    <img id="viewer_canvas_img" src="" style="width: 100%;padding-left: 135px;height: 100%;object-fit: contain;">

                    <video id="viewer_canvas_vid" style="display:block;width: 100%;padding-left: 135px;height: 100%" controls>

                        <source id="viewer_canvas_vid_src" src="" type="video/mp4">
                    </video>
                </div>
                <div id="photos_fondation_phototheque" class="phototheque hk-gallery mt-1" style="border-radius: 8px; padding: 8px;margin-bottom: 8px; width: 160px; border: 1px #46997c solid; height: calc(276px - 0.85rem); overflow-y: auto; white-space: nowrap; padding: 4px; overflow-x: hidden; background: unset; border: unset; box-shadow: unset !important; z-index: 99999999; position: absolute; top: 46px; height: 480px; left: 16px; background: #f9f9f9;">


                    <a class="costume-img " style="margin: 0px;">
                        <img class="photo_a" image_path="<?php echo e(asset('images/simulation18_10/rendu1.jpeg')); ?>" style="border-radius: 8px;border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="<?php echo e(asset('images/simulation18_10/rendu1.jpeg')); ?>" class="gallery-img costume-img hk-gallery">

                        <b style="padding-top:4px;text-align: center;text-overflow: clip;overflow: hidden;white-space: nowrap;display: block;">Rendu 1</b>
                    </a>

                    <a class="costume-img " style="margin: 0px;">
                        <img class="photo_a" image_path="<?php echo e(asset('images/simulation18_10/rendu2.jpeg')); ?>" style="border-radius: 8px;border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="<?php echo e(asset('images/simulation18_10/rendu2.jpeg')); ?>" class="gallery-img costume-img hk-gallery">

                        <b style="padding-top:4px;text-align: center;text-overflow: clip;overflow: hidden;white-space: nowrap;display: block;">Rendu 2</b>
                    </a>

                    <a class="costume-img " style="margin: 0px;">
                        <img class="photo_a" image_path="<?php echo e(asset('images/simulation18_10/rendu3.jpeg')); ?>" style="border-radius: 8px;border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="<?php echo e(asset('images/simulation18_10/rendu3.jpeg')); ?>" class="gallery-img costume-img hk-gallery">

                        <b style="padding-top:4px;text-align: center;text-overflow: clip;overflow: hidden;white-space: nowrap;display: block;">Rendu 2</b>
                    </a>


                    <a class="costume-img " style="margin: 0px;">
                        <img class="photo_a" image_path="<?php echo e(asset('images/simulation18_10/rendu4.jpeg')); ?>" style="border-radius: 8px;border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="<?php echo e(asset('images/simulation18_10/rendu4.jpeg')); ?>" class="gallery-img costume-img hk-gallery">

                        <b style="padding-top:4px;text-align: center;text-overflow: clip;overflow: hidden;white-space: nowrap;display: block;">Rendu 2</b>
                    </a>

                    <a class="costume-img " style="margin: 0px;">
                        <img class="photo_a" image_path="<?php echo e(asset('images/simulation18_10/rendu5.jpeg')); ?>" style="border-radius: 8px;border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="<?php echo e(asset('images/simulation18_10/rendu5.jpeg')); ?>" class="gallery-img costume-img hk-gallery">

                        <b style="padding-top:4px;text-align: center;text-overflow: clip;overflow: hidden;white-space: nowrap;display: block;">Rendu 2</b>
                    </a>

                    <a class="costume-img " style="margin: 0px;">
                        <img class="photo_a" image_path="<?php echo e(asset('images/simulation18_10/rendu6.jpeg')); ?>" style="border-radius: 8px;border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="<?php echo e(asset('images/simulation18_10/rendu6.jpeg')); ?>" class="gallery-img costume-img hk-gallery">

                        <b style="padding-top:4px;text-align: center;text-overflow: clip;overflow: hidden;white-space: nowrap;display: block;">Rendu 2</b>
                    </a>

                    <a class="costume-img " style="margin: 0px;">
                        <img class="video_a" video_path="<?php echo e(asset('images/simulation18_10/vid1.mp4')); ?>" style="border-radius: 8px;border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="<?php echo e(asset('images/simulation18_10/vid1_tb.png')); ?>" class="gallery-img costume-img hk-gallery">

                        <b style="padding-top:4px;text-align: center;text-overflow: clip;overflow: hidden;white-space: nowrap;display: block;">Video 1</b>
                    </a>

                    <a class="costume-img " style="margin: 0px;">
                        <img class="video_a" video_path="<?php echo e(asset('images/simulation18_10/vid2.mp4')); ?>" style="border-radius: 8px;border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="<?php echo e(asset('images/simulation18_10/vid2_tb.png')); ?>" class="gallery-img costume-img hk-gallery">

                        <b style="padding-top:4px;text-align: center;text-overflow: clip;overflow: hidden;white-space: nowrap;display: block;">Video 2</b>
                    </a>
                </div>

                <div class="side_panel" style="display:none !important; width: 30%;max-width:400px; height:600px;  z-index: 99; display: block; position: absolute;padding:0.8rem">
                    <div class="side-panel-toggle">
                        <i class="side-panel-toggle-icon fa-solid fa-chevron-left"></i>
                    </div>
                    <div class="tab-content">
                        <h6><i class="fa-solid fa-folder-tree mr-1"></i>L'arborescence</h6>
                        <div id="treeViewContainer" style="width: 100%;padding: 8px; height:100%"></div>
                    </div>
                    <div class="tab-content-hidden hidden">
                        <b style="font-size: 1rem;writing-mode: vertical-rl;margin-top: 30px;">L'arborescence</b>
                    </div>
                </div>
            </div>
        </div>




    </div>
</div>



<div class="row row-full documents_div" style="display: none;">
    <div class="col-12  mt-2 ">

        <div class="card">
            <div class="card-body">
                <h6 class="card-title"><i class="fa-regular fa-eye mr-1"></i><?php echo e(__("Documents")); ?></h6>


                <div id="viewer_canvas_mg" style="width: 100%;height:550px;">
                    <iframe id="viewer_canvas_pdf" src="" style="    padding-left: 238px;width: 100%;height:100%;">
                    </iframe>
                </div>


                <div class="phototheque hk-gallery mt-1" style="border-radius: 8px; padding: 8px;margin-bottom: 8px; width: 220px; border: 1px #46997c solid; height: calc(296px - 0.85rem); overflow-y: auto; white-space: nowrap; padding: 4px; overflow-x: hidden; background: unset; border: unset; box-shadow: unset !important; z-index: 99999999; position: absolute; top: 46px; height: 480px; left: 16px; background: #f9f9f9;">





                    <?php $__currentLoopData = $documents_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <?php if(is_null($document['document'])): ?>
                    <button disabled style="text-align: left;margin-top: 8px;float: left;width:100%" class="btn"><i class="fa-regular fa-file-pdf mr-1"></i><?php echo e($document['name']); ?></button>

                    <?php else: ?>
                    <button pdf_path="<?php echo e($document['document']->documentUrl()); ?>" style="text-align: left;margin-top: 8px;float: left;width:100%" class="pdf_a btn"><i class="fa-regular fa-file-pdf mr-1"></i><?php echo e($document['name']); ?></button>


                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
                <div class="phototheque hk-gallery mt-1" style="border-radius: 8px; padding: 8px;margin-bottom: 8px; width: 220px; border: 1px #46997c solid; height: calc(276px - 0.85rem); overflow-y: auto; white-space: nowrap; padding: 4px; overflow-x: hidden; background: unset; border: unset; box-shadow: unset !important; z-index: 99999999; position: absolute; top: 46px; height: 480px; left: 16px; background: #f9f9f9;">





                    <?php $__currentLoopData = $documents_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <?php if(is_null($document['document'])): ?>
                    <button disabled style="text-align: left;margin-top: 8px;float: left;width:100%" class="btn"><i class="fa-regular fa-file-pdf mr-1"></i><?php echo e($document['name']); ?></button>

                    <?php else: ?>
                    <button pdf_path="<?php echo e($document['document']->documentUrl()); ?>" style="text-align: left;margin-top: 8px;float: left;width:100%" class="pdf_a btn"><i class="fa-regular fa-file-pdf mr-1"></i><?php echo e($document['name']); ?></button>


                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>
        </div>




    </div>
</div>

<div class="row row-full vue_360_div" style="display:none">
    <div class="col-12  mt-1">

        <div class="card">
            <div class="card-body">
                <h6 class="card-title"><i class="fa-regular fa-eye mr-1"></i><?php echo e(__("Visite 360")); ?></h6>
                <iframe style="width: 100%;height:550px" src='https://my.matterport.com/show/?m=5JLjtzxSeVM' frameborder='0' allowfullscreen allow='xr-spatial-tracking'></iframe>
            </div>
        </div>

    </div>
</div>




<div class="row row-full photos_div" style="display:none">
    <div class="col-12  mt-1">

        <div class="card">
            <div class="card-body">
                <h6 class="card-title"><i class="fa-regular fa-eye mr-1"></i>Photos</h6>
                <iframe style="width: 100%;height:550px" src='/projets/photos_frame/<?php echo e($projet->id); ?>' frameborder='0' allowfullscreen allow='xr-spatial-tracking'></iframe>
            </div>
        </div>

    </div>
</div>



<?php $__env->stopSection(); ?>
<?php $__env->startPush('added_scripts'); ?>
<script src="<?php echo e(asset('js/geoportail/filters.js').'?t='.time()); ?>"></script>
<script src="<?php echo e(asset('js/geoportail/map.js').'?t='.time()); ?>"></script>
<script src="<?php echo e(asset('js/geoportail/tab_porjets.js').'?t='.time()); ?>"></script>

<script id="source" type="module">
    import {
        XKTLoaderPlugin,
        WebIFCLoaderPlugin,
        TreeViewPlugin,
        DistanceMeasurementsPlugin,
        Viewer,
        DistanceMeasurementsMouseControl,
        PointerLens
    } from "https://cdn.jsdelivr.net/npm/@xeokit/xeokit-sdk/dist/xeokit-sdk.es.min.js";


    import * as WebIFC from "https://cdn.jsdelivr.net/npm/web-ifc@0.0.51/web-ifc-api.js";

    const viewer = new Viewer({
        canvasId: "viewer_canvas",
        transparent: true
    });
    const canvas = document.getElementById('viewer_canvas');
    canvas.addEventListener('wheel', (event) => {
        event.preventDefault(); // Prevent default scroll behavior
    });
    // 2
    viewer.camera.eye = [-2.56, 8.38, 8.27];
    viewer.camera.look = [13.44, 3.31, -14.83];
    viewer.camera.up = [0.10, 0.98, -0.14];


    const treeView = new TreeViewPlugin(viewer, {
        containerElement: document.getElementById("treeViewContainer")
    });

    const distanceMeasurements = new DistanceMeasurementsPlugin(viewer);

    const distanceMeasurementsControl = new DistanceMeasurementsMouseControl(distanceMeasurements, {

    })



    distanceMeasurementsControl.snapToVertex = true;
    distanceMeasurementsControl.snapToEdge = true;

    ///distanceMeasurementsControl.activate();


    const IfcAPI = new WebIFC.IfcAPI();


    IfcAPI.SetWasmPath("https://cdn.jsdelivr.net/npm/web-ifc@0.0.51/");

    var model = undefined;


    function progressiveLoadModel(file_path) {

        showLoading('Chargement...', 'Le fichier est en cours de chargement, veuillez patienter');

        IfcAPI.Init().then(async () => {
            const ifcLoader = new WebIFCLoaderPlugin(viewer, {
                WebIFC,
                IfcAPI
            });

            // Load model incrementally
            model = ifcLoader.load({
                id: "myModel",
                src: file_path,
                excludeTypes: ["IfcSpace"],
                edges: false
            });

            // Add a timeout to handle large model processing
            setTimeout(() => {
                model.on("loaded", () => {
                    // Perform camera adjustments
                    const metaModel = viewer.metaScene.metaModels["myModel"];
                    const model = viewer.scene.models["myModel"];
                    const objectIds = viewer.metaScene.getObjectIDsInSubtree(model.id);
                    const aabb = viewer.scene.getAABB(objectIds);
                    viewer.cameraFlight.flyTo(aabb);
                    closeLoading();
                });
            }, 50); // 50ms delay between loading steps
        });
    }

    function destroyAllModels() {
        if (model != undefined) {
            model.destroy();

        }

    }
    $('body').on('click', '#maquettes_3d', function() {
        $(".vue_360_div").css("display", "none");
        $(".photos_div").css("display", "none");
        $(".vue_3d_div").css("display", "flex");
        $(".documents_div").css("display", "none");

        // var ifc_path = $(this).attr('ifc_path');
        // destroyAllModels();
        // progressiveLoadModel(ifc_path);
    });

    $('body').on('click', '#documents', function() {
        $(".vue_360_div").css("display", "none");
        $(".photos_div").css("display", "none");
        $(".vue_3d_div").css("display", "none");
        $(".documents_div").css("display", "flex");

        // var ifc_path = $(this).attr('ifc_path');
        // destroyAllModels();
        // progressiveLoadModel(ifc_path);
    });


    $('body').on('click', '.ifc_a', function() {

        var ifc_path = $(this).attr('ifc_path');
        destroyAllModels();
        progressiveLoadModel(ifc_path);

        $("#viewer_canvas_mg").css('display', 'none');
        $("#viewer_canvas").css('display', 'block');
    });

    $('body').on('click', '.photo_a', function() {

        var image_path = $(this).attr('image_path');
        destroyAllModels();



        $("#viewer_canvas_vid").css('display', 'none');
        $("#viewer_canvas_img").css('display', 'block');

        $("#viewer_canvas_img").attr('src', image_path);
        $("#viewer_canvas_mg").css('display', 'block');
        $("#viewer_canvas").css('display', 'none');

        const viewer_canvas_vid = document.getElementById('viewer_canvas_vid');
        viewer_canvas_vid.pause();
    });

    $('body').on('click', '.video_a', function() {

        var video_path = $(this).attr('video_path');
        destroyAllModels();

        $("#viewer_canvas_vid").css('display', 'block');
        $("#viewer_canvas_img").css('display', 'none');


        const viewer_canvas_vid = document.getElementById('viewer_canvas_vid');
        const source = document.getElementById('viewer_canvas_vid_src');
        source.src = video_path;

        viewer_canvas_vid.load();
        viewer_canvas_vid.play();


        $("#viewer_canvas_mg").css('display', 'block');
        $("#viewer_canvas").css('display', 'none');
    });


    $('body').on('click', '.pdf_a', function() {

        var pdf_path = $(this).attr('pdf_path');
        $("#viewer_canvas_pdf").attr('src', pdf_path);
    });
    $('body').on('click', '#vue_360', function() {
        $(".vue_360_div").css("display", "flex");
        $(".vue_3d_div").css("display", "none");
        $(".photos_div").css("display", "none");
        $(".documents_div").css("display", "none");
    });


    $('body').on('click', '#photos', function() {
        $(".vue_360_div").css("display", "none");
        $(".vue_3d_div").css("display", "none");
        $(".photos_div").css("display", "flex");
        $(".documents_div").css("display", "none");

    });
</script>
<script>
    $(document).ready(function() {
        $(".select2").select2();
        $(".select2nc").select2({
            minimumResultsForSearch: -1
        });
        let hasCentered = false;

        map.on('idle', () => {

            if (!hasCentered) {
                map.setCenter([-8.107054934176404, 31.75133673006178]);
                map.setZoom(16);
                hasCentered = true;
            }


        });


    });
</script>


<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app_no_nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u447310764/domains/alomraneassist.ma/public_html/resources/views/projets/3dview_tab_frame.blade.php ENDPATH**/ ?>