
<?php $__env->startSection('added_css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<style>
    .costume-img {
        width: 126px;
        margin: 2px 4px !important;
        height: 126px;
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        display: inline-block;
        float: none;
        border-radius: 4px;
        transition: transform 0.2s, 0.35s ease-in-out !important;
        cursor: pointer;
    }
</style>

<nav class="hk-breadcrumb" aria-label="breadcrumb">

    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo e(route('etude_marche')); ?>">Etudes de marché</a></li>
        <li class="breadcrumb-item"><b>Etude N° <?php echo e($etude_marche->numero); ?></b>

    </ol>
</nav>

<div class="row mt-2">
    <div class="col-12 col-sm-9">
        <ul class="nav nav-tabs " role="tablist">
            <li class="nav-item">
                <a class="nav-link active" id="description-tab" data-toggle="tab" href="#description" role="tab" aria-controls="description" aria-selected="true"><i class="fa-solid fa-calendar-check mr-1"></i>Description et visite des lieux</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="evaluation-tab" data-toggle="tab" href="#evaluation" role="tab" aria-controls="evaluation" aria-selected="false"><i class="fa-solid fa-hand-holding-dollar mr-1"></i>Evaluation</a>
            </li>

        </ul>
        <div class="tab-content" style="padding:8px">
            <div class="tab-pane fade show active" id="description" role="tabpanel" aria-labelledby="description-tab">

                <div class="row">
                    <div class="col-12 col-sm-7">
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h6 class="card-title"><i class="fa-regular fa-circle-question mr-1"></i>Description physique</h6>

                                        <div class="row">
                                            <div class="col-12 col-sm-6">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" style="width: 160px;">Ville</span>
                                                    </div>
                                                    <input readonly class="form-control" value="<?php echo e($etude_marche->projet->lot->lotissement->ville->nom); ?>">
                                                </div>
                                            </div>

                                            <div class="col-12 col-sm-6">
                                                <div class="input-group input-group-sm mb-2">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" style="width: 160px;">Surface</span>
                                                    </div>
                                                    <input readonly class="form-control" value="<?php echo e($etude_marche->projet->lot->surface); ?>">
                                                    <div class="input-group-append">
                                                        <span class="input-group-text">m²</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-12 col-sm-6">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" style="width: 160px;">Nombre de niveaux</span>
                                                    </div>
                                                    <input readonly class="form-control" value="R+<?php echo e($etude_marche->projet->lot->nombre_niveaux); ?>">
                                                </div>
                                            </div>

                                            <div class="col-12 col-sm-6">
                                                <div class="input-group input-group-sm mb-2">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" style="width: 160px;">Sous-sol:</span>
                                                    </div>
                                                    <input readonly class="form-control" value="<?php echo e($etude_marche->projet->lot->sous_sol?'Oui':'Non'); ?>">

                                                </div>
                                            </div>
                                        </div>

                                        <h5 class="pl-4" style="text-decoration: underline;">Description</h5>
                                        <div class="row">
                                            <div class="col-12">
                                                <textarea class="form-control" id="description_physique" rows="5" style="width: 100%;"><?php echo e($etude_marche->description_physique); ?></textarea>
                                            </div>
                                        </div>


                                        <div class="row mt-2">
                                            <div class="col-6">
                                            <?php if($etude_marche->etat=="en_cours" && Auth::user()->has_role('chef_projet')): ?>
                                                <div class="row">
                                                    <div class="col-12">
                                                        <button id="etude_marche_atouts_table_add_btn" class="mr-3 btn btn-success "><i class="fa-solid fa-circle-plus mr-1"></i>Ajouter</button>
                                                        <button id="etude_marche_atouts_table_delete_btn" disabled class="mr-3 btn btn-danger "><i class="fa-regular fa-trash-can mr-1"></i>Supprimer</button>
                                                    </div>
                                                </div>
                                                <?php endif; ?>
                                                <table class="table table-striped datatables dataTable no-footer display nowrap" id="etude_marche_atouts_table">
                                                    <thead>
                                                        <th>Atouts</th>
                                                    </thead>
                                                    <tbody>
                                                        <?php $__currentLoopData = $etude_marche->atouts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $atout): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td><span style="color: #3b8512;"><input type="checkbox" style="vertical-align: sub;" class="etude_marche_atouts_table_cb" data="<?php echo e($atout->content); ?>" id="<?php echo e($atout->id); ?>"><b class="ml-1"><i class="fa-regular fa-thumbs-up mr-1"></i><?php echo e($atout->content); ?></b></span></td>
                                                        </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                            <div class="col-6">
                                                <?php if($etude_marche->etat=="en_cours" && Auth::user()->has_role('chef_projet')): ?>
                                                <div class="row">
                                                    <div class="col-12">
                                                        <button id="etude_marche_faiblesses_table_add_btn" class="mr-3 btn btn-success "><i class="fa-solid fa-circle-plus mr-1"></i>Ajouter</button>
                                                        <button id="etude_marche_faiblesses_table_delete_btn" disabled class="mr-3 btn btn-danger "><i class="fa-regular fa-trash-can mr-1"></i>Supprimer</button>
                                                    </div>
                                                </div>
                                                <?php endif; ?>
                                                <table class="table table-striped datatables dataTable no-footer display nowrap" id="etude_marche_faiblesses_table">
                                                    <thead>
                                                        <th>Faiblesses</th>
                                                    </thead>
                                                    <tbody>
                                                        <?php $__currentLoopData = $etude_marche->faiblesses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faiblesse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td><span style="color: #fb5151;"><input type="checkbox" style="vertical-align: sub;" class="etude_marche_faiblesses_table_cb" data="<?php echo e($faiblesse->content); ?>" id="<?php echo e($faiblesse->id); ?>"><b class="ml-1"><i class="fa-regular fa-thumbs-down mr-1"></i><?php echo e($faiblesse->content); ?></b></span></td>
                                                        </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>


                    </div>

                    <div class="col-12 col-sm-5">
                        <div class="row mb-4">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h6 class="card-title"><i class="fa-solid fa-map-location-dot mr-1"></i>Image satellitaire</h6>
                                        <div id="image_sat_div" style="min-height: 400px; background: rgb(242, 242, 242); height: 100%; width: 100%; border-radius: 4px; border: 1px solid rgb(198, 198, 198); position: relative;">

                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>


                <div class="card">
                    <div class="card-body">
                        <h6 class="card-title"><i class="fa-regular fa-images mr-1"></i>Photos</h6>
                        <div class="row">
                            <?php $__currentLoopData = $photos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photos_group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($etude_marche->etat=="en_cours" && Auth::user()->has_role('chef_projet')): ?>
                            <?php if(Auth::user()->has_role('chef_projet')): ?>
                            <div class="col-6">
                                <button type_document="<?php echo e($photos_group['type_document']); ?>" type="button" class="btn btn-light upload_photo_link"> <i class="fa-solid fa-plus"></i>&nbsp;Ajouter</button>
                                <button type_document="<?php echo e($photos_group['type_document']); ?>" type="button" disabled class="btn btn-danger delete_photo_link"> <i class="fa-solid fa-trash"></i>&nbsp;Supprimer</button>
                            </div>
                            <?php endif; ?>
                            <?php endif; ?>
                            <div id="photos_<?php echo e($photos_group['type_document']); ?>" class="phototheque hk-gallery mt-1" type_document="<?php echo e($photos_group['type_document']); ?>" style="width: 100%;border-radius:6px;border:1px #949494 solid;height:160px;overflow-x: auto;white-space: nowrap;padding:4px">
                                <?php $__currentLoopData = $photos_group['photos']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a class="costume-img" href="<?php echo e($photo->documentUrl()); ?>" style="margin: 0px;">
                                    <img data-src="<?php echo e($photo->documentUrl()); ?>" style="border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="<?php echo e($photo->documentUrl()); ?>" class="gallery-img costume-img hk-gallery">
                                    </br>
                                    <input item_id="<?php echo e($photo->id); ?>" type_document="<?php echo e($photos_group['type_document']); ?>" class="select_photo_cb" style="margin: auto;display: block;position: relative;" type="checkbox">
                                </a>


                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>


            </div>

            <div class="tab-pane fade" id="evaluation" role="tabpanel" aria-labelledby="profile-evaluation">

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <h6 class="card-title"><i class="fa-solid fa-money-bill-wave mr-1"></i>Chiffre d'affaire estimatif <b id="postes_comparaison_global_cf" style="color: chocolate;float:right">0.00 MAD</b></h6>

                                <table class="table table-striped datatables dataTable no-footer display nowrap" id="chiffre_affaire_table">
                                    <thead>
                                        <th>Produit</th>
                                        <th>Surface vendable (Estimation) </th>
                                        <th>Prix unitaire calculé </th>
                                        <th>Prix unitaire adopté</th>
                                        <th>Chiffre d'affaire</th>

                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mt-2">

                    <div class="col-12 col-sm-6">
                        <div class="input-group input-group-sm ">
                            <div class="input-group mb-1">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" style="width: 160px;">Produit </span>
                                </div>
                                <select id="postes_comparaison_produits_select" class="form-control select2nc">
                                    <?php $__currentLoopData = $etude_marche->projet->produits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($produit->id); ?>"><?php echo e($produit->type); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    </div>

                </div>
                <hr>
                <div class="row mt-2">
                    <div class="col-12 col-sm-6">
                        <div class="card  disabled poste_comparaison_card">
                            <div class="card-body">
                                <h6 class="card-title"><i class="fa-solid fa-list-ul mr-1"></i></i>Détail des postes de comparaison</h6>

                                <div class="row mt-1">
                                    <div class="col-12 col-sm-6">
                                        <div class="input-group input-group-sm ">
                                            <div class="input-group mb-1">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text" style="width: 140px;">Rayon de recherche </span>
                                                </div>
                                                <input id="postes_comparaison_search_rayon" type="number" class="form-control" value="100">
                                                <div class="input-group-append">
                                                    <span class="input-group-text">m</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-12 col-sm-6">
                                        <div class="input-group input-group-sm ">
                                            <div class="input-group mb-1">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text" style="width: 80px;">Surface de :</span>
                                                </div>
                                                <input id="postes_comparaison_search_surface_min" type="number" class="form-control" value="0">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text" style="width: 20px;"> à :</span>
                                                </div>
                                                <input id="postes_comparaison_search_surface_max" type="number" class="form-control" value="0">
                                                <div class="input-group-append">
                                                    <span class="input-group-text">m</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row mt-1">
                                    <div class="col-12 col-sm-4">
                                        <input class="postes_comparaison_search_source" source="OFFRE" type="checkbox" checked value=""><span style="display: inline-block; font-size: 0.85rem; vertical-align: bottom;" class="ml-2">Offres</span>
                                    </div>

                                    <div class="col-12 col-sm-4">
                                        <input class="postes_comparaison_search_source" source="VENTE_ORMANE" type="checkbox" checked value=""><span style="display: inline-block; font-size: 0.85rem; vertical-align: bottom;" class="ml-2">Ventes Al Omrane</span>
                                    </div>

                                    <div class="col-12 col-sm-4">
                                        <input class="postes_comparaison_search_source" source="EXPERTISE" type="checkbox" checked value=""><span style="display: inline-block; font-size: 0.85rem; vertical-align: bottom;" class="ml-2">Biens expertisés</span>
                                    </div>

                                </div>

                                <hr>
                                <div class="row mt-1">
                                    <div class="col-12 col-sm-8">
                                        <span style="vertical-align: text-bottom;">Nombre de comparables : <b style="font-weight: 600;color: #115555;" id="postes_comparaison_search_count">0</b></span>
                                    </div>
                                    <?php if($etude_marche->etat=="en_cours" && Auth::user()->has_role('chef_projet')): ?>
                                    <?php if(Auth::user()->has_role('chef_projet')): ?>
                                    <div class="col-12 col-sm-4">
                                        <button style="width: 100%;" id="postes_comparaison_search_btn" class="btn"><i class="fa-solid fa-magnifying-glass-location mr-1"></i>Rechercher</button>
                                    </div>
                                    <?php endif; ?>
                                    <?php endif; ?>
                                </div>
                                <table class="table table-striped datatables dataTable no-footer display nowrap" id="postes_comparaison_table">
                                    <thead>
                                        <th>TF</th>
                                        <th>Source de donnée</th>
                                        <th>Date</th>
                                        <th>Surface</th>
                                        <th>Prix total</th>
                                        <th>Prix unitaire</th>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                                <?php if($etude_marche->etat=="en_cours" && Auth::user()->has_role('chef_projet')): ?>
                                <div class="row mt-1">
                                    <div class="col-12">
                                        <button disabled id="postes_comparaison_add_to_retenus_list_btn" class="btn"><i class="fa-solid fa-circle-plus mr-1"></i>Ajouter à la liste des comparables retenus</button>
                                    </div>
                                </div>
                                <?php endif; ?>

                            </div>
                        </div>

                        <div class="card disabled poste_comparaison_card mt-2">
                            <div class="card-body">
                                <h6 class="card-title"><i class="fa-solid fa-list-check mr-1"></i>Comparables retenus</h6>

                                <table class="table table-striped datatables dataTable no-footer display nowrap" id="comparables_retenues_table">
                                    <thead>
                                        <th>TF</th>
                                        <th>Source de donnée</th>
                                        <th>Date</th>
                                        <th>Surface</th>
                                        <th>Prix total</th>
                                        <th>Prix unitaire</th>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="col-12 col-sm-6">
                        <div class="card">
                            <div class="card-body">
                                <h6 class="card-title"><i class="fa-solid fa-location-dot mr-1"></i>Localisation des postes de comparaison</h6>

                                <div id="postes_comparaison_map_div" style="min-height: 400px; background: rgb(242, 242, 242); height: 100%; width: 100%; border-radius: 4px; border: 1px solid rgb(198, 198, 198); position: relative;">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>

    <div class="col-12 col-sm-3">
        <div class="row" style="background: #f9f9f9; padding: 8px; border-radius: 6px; border: 1px #d2d2d2 solid;">
            <span class="mb-1" style="text-align: center;width: 100%;">
                <i style="font-size: 0.9rem; color: #115555;" class="fa-solid fa-magnifying-glass-chart"></i>
                <b class="mt-2" style="font-size: 0.9rem;color: #115555; ">Etude : <?php echo e($etude_marche->numero); ?></b>
            </span>

            <span class="pt-1" style="border-top: 1px #cecece dashed;text-align: center;width: 100%;">
                <i style="font-size: 0.9rem; color: #115555;" class="fa-regular fa-folder-open"></i>
                <b class="mt-2" style="font-size: 0.9rem;color: #115555; ">Projet : <a style="color:#115555 !important;" href="/projets/show/<?php echo e($etude_marche->projet->id); ?>"><?php echo e($etude_marche->projet->numero); ?></a></b>
            </span>
        </div>

        <div class="row mt-1" style="background: #f9f9f9; padding: 8px; border-radius: 6px; border: 1px #d2d2d2 solid;">
            <div class="row">
                <div class="col-2">
                    <img src="<?php echo e($etude_marche->projet->mao->avatar()); ?>" class="user-image rounded-circle" style="border: #1e6f6c solid; border-width: 2px;width:100%">

                </div>
                <div class="col-4" style="display: block;margin: auto;">
                    <b style="font-size: 0.8rem;color: #115555; "><?php echo e($etude_marche->projet->mao->nom); ?> <?php echo e($etude_marche->projet->mao->prenom); ?></b>
                    <br>
                    <b style="font-size: 0.7rem; color: #7a7a7a; font-style: italic;">Client</b>
                </div>

                <div class="col-2">
                    <img src="<?php echo e($etude_marche->projet->chef_projet->avatar()); ?>" class="user-image rounded-circle" style="border: #1e6f6c solid; border-width: 2px;width:100%">

                </div>
                <div class="col-4" style="display: block;margin: auto;">
                    <b style="font-size: 0.8rem;color: #115555; "><?php echo e($etude_marche->projet->chef_projet->nom); ?> <?php echo e($etude_marche->projet->chef_projet->prenom); ?></b>
                    <br>
                    <b style="font-size: 0.7rem; color: #7a7a7a; font-style: italic;">Chef du projet</b>
                </div>
            </div>
        </div>


        <div class="row mt-1">
            <div class="card" style="width: 100%;background: #f9f9f9;">
                <div class="card-body">
                    <h6 class="card-title"><i class="fa-solid fa-file-lines mr-1"></i>Documents</h6>

                    <button style="width: 100%;" disabled class="btn mt-1"><i class="fa-solid fa-download mr-1"></i>Télécharger l'étude</button>
                    <button style="width: 100%;" disabled class="btn mt-1"><i class="fa-solid fa-download mr-1"></i>Cahier des charges</button>
                    <button style="width: 100%;" disabled class="btn mt-1"><i class="fa-solid fa-download mr-1"></i>Plan cadastral</button>
                    <button style="width: 100%;" disabled class="btn mt-1"><i class="fa-solid fa-download mr-1"></i>Certificat de propriété</button>

                </div>
            </div>
        </div>
        <?php if(Auth::user()->has_role('chef_projet')): ?>
        <?php if($etude_marche->etat=="en_cours" && Auth::user()->has_role('chef_projet')): ?>
        <div class="row mt-1">
            <div class="card" style="width: 100%;background: #f9f9f9;">
                <div class="card-body">
                    <h6 class="card-title"><i class="fa-solid fa-gear mr-1"></i>Actions</h6>
                   
                    <button id="save_etude_marche" style="width: 100%;" class="btn mt-1"><i class="fa-regular fa-floppy-disk mr-1"></i>Enregistrer les modifications</button>

                    <button id="valider_etude_marche" style="width: 100%;" class="btn mt-1"><i class="fa-solid fa-check mr-1"></i>Valider</button>
                    
                </div>
            </div>
        </div>
        <?php endif; ?>
        <?php endif; ?>
        <?php if($etude_marche->etat=="realisee"): ?>
        <div class="row mt-1">
            <div class="card" style="width: 100%;background: #f9f9f9;">
                <div class="card-body">
                    <span style="color:#4f8710">
                        <i class="fa-regular fa-circle-check mr-1"></i><b> Etude du marché réalisée le <?php echo e($etude_marche->validation_date); ?>.</b>
                    </span>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php echo $__env->make('etude_marche/modals', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('added_scripts'); ?>
<script>
    var projet_id = "<?php echo e($etude_marche->projet->id); ?>";
    var etude_marche_id = "<?php echo e($etude_marche->id); ?>";
    var lot_id = "<?php echo e($etude_marche->projet->lot->id); ?>";
    var lot_lat = parseFloat("<?php echo e($etude_marche->projet->lot->lat); ?>");
    var lot_lng = parseFloat("<?php echo e($etude_marche->projet->lot->lng); ?>");
</script>
<script src="<?php echo e(asset('js/etude_marche/show.js').'?t='.time()); ?>"></script>
<script src="<?php echo e(asset('js/etude_marche/image_sat.js').'?t='.time()); ?>"></script>
<script src="<?php echo e(asset('js/etude_marche/postes_comparaison_map.js').'?t='.time()); ?>"></script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u207500317/domains/tamkininvest.ma/public_html/resources/views/etude_marche/show.blade.php ENDPATH**/ ?>