<?php $__env->startSection('added_css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/datatable/datatables.min.css')); ?>" />
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('chart.js/dist/Chart.min.css')); ?>">
<script src="<?php echo e(asset('chart.js/dist/Chart.js')); ?>"></script>
<style>
    .m-footer {
        color: #ff1308 !important;
        font-weight: 600;
    }

    .small-box>.inner {
        padding: 0.75rem;
    }

    .small-box {
        margin-bottom: 10px;
    }


    .text-styling {
        font-size: 14px;
        color: #000;

    }

    .text-center {
        font-size: 14px;
        color: #000;
    }


    .table th,
    .table td {
        border-right: 1px solid #f4f4f4;
    }


    .table-striped tbody tr:nth-of-type(odd) {
        background-color: rgba(0, 0, 0, .05) !important;
    }

    th {
        background-color: unset !important;
    }


    .m-thead {
        font-family: Lato;
        font-weight: 700 !important;
        font-size: 15px !important;
    }


    .m-thead-mobile {
        font-family: Lato;
        font-weight: 600 !important;
        font-size: 13px !important;

    }

    .costume-img-2 {
        max-width: unset !important;
        width: auto;
        margin: 2px 4px !important;
        /* height: 260px; */
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        /* display: inline-block; */
        float: none;
        border-radius: 4px;
        transition: transform 0.2s, 0.35s ease-in-out !important;
        cursor: pointer;
    }

    .photo_side_bar {
        background: #fdfdfd;
        width: 40%;
        position: fixed;
        right: -55%;
        height: 100%;
        z-index: 9999999999;
        box-shadow: 0px 10px 30px 0px rgb(0 0 0 / 30%);
        transition: all 0.35s;
        opacity: 0;
        top: 45px;
    }

    .photo_side_bar.active {
        right: 0px;
        opacity: 1;
    }

    [type=radio]:checked+label,
    [type=radio]:not(:checked)+label {
        font-weight: 300;
        position: relative;
        padding-left: 35px;
        cursor: pointer;
        display: inline-block;
        height: 25px;
        line-height: 25px;
        -webkit-transition: .28s ease;
        -o-transition: .28s ease;
        transition: .28s ease;
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none;
        font-size: 14px;
        font-weight: 400;
    }
</style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div style="padding-top: 16px;margin-left: 8px">

    <div class="row">
        <div class="col-9">
            <nav class="hk-breadcrumb" aria-label="breadcrumb">
                <ol class="breadcrumb breadcrumb-light bg-transparent">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('baraques')); ?>">Baraques</a></li>
                    <li class="breadcrumb-item " aria-current="page">Baraque N°: BA<?php echo e($baraque->equipe->prefix.$baraque->numero); ?></li>
                </ol>
            </nav>
            <?php echo $__env->make('baraques/details_infos_generales', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->make('baraques/details_occupants', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->make('baraques/details_etat_avancement', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <div class="col-12 col-md-3 " style="padding-top: 8px;">
            <div class="row" style="background: #f2f2f2; padding: 8px; border-radius: 6px; border: 1px #d2d2d2 solid;">
                <i style="text-align: center; margin: auto; font-size:20px; color: #d07979;" class="fa-regular fa-folder-open"></i>
                <b class="mt-2" style="font-size: 0.8rem;color: #2273ae;width:100%;text-align: center;">Baraque
                    N° : <?php echo e($baraque->numero); ?></b>


                <h6>Traitement</h6>
                <div class="row ml-2 m-step success">
                    <div>
                        <i class="pending-icon fa-regular fa-clock"></i>
                        <i class="success-icon fa-solid fa-check"></i>
                        <i class="error-icon fa-solid fa-circle-exclamation"></i>
                        <b class="ml-1">Saisi de la baraque</b>
                    </div>
                </div>
            </div>

        </div>
    </div>

</div>
<?php echo $__env->make('verification/modals', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('added_scripts'); ?>
<script>
    var baraque = <?php echo json_encode($baraque, 15, 512) ?>;
</script>
<script src="<?php echo e(asset('js/baraques/show.js').'?t='.time()); ?>"></script>
<script src="<?php echo e(asset('js/baraques/details_infos_generales.js').'?t='.time()); ?>"></script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u490561298/domains/salmon-monkey-162176.hostingersite.com/public_html/resources/views/baraques/show.blade.php ENDPATH**/ ?>