<div id="import_from_geojson_modal" class="modal fade" role="dialog">
    <div class="modal-dialog dialog-center modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Import en masse</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>

            <form id="import_geojson_form">
                <?php echo csrf_field(); ?>

                <div class=" modal-body">

                    <div class="row">

                        <?php if(Auth::user()->has_role('IGT')): ?>
                        <div class="col-12 col-md-6">
                            <span style="display: block; text-align: center;">
                                <input id="import_from_geojson_modal_file_type_geojson" checked disabled type="checkbox" name="import_from_geojson_modal_file_type"><b style="font-size: 0.9rem; margin-left: 6px; vertical-align: text-top;">Fichier Geojson</b>

                            </span>
                        </div>
                        <?php endif; ?>


                        <div class="col-12 col-md-6">
                            <span style="display: none; text-align: center;">
                                <input <?php echo e(Auth::user()->has_role('Architecte,IGT')?'disabled':''); ?> id="import_from_geojson_modal_file_type_excel" type="checkbox" checked name="import_from_geojson_modal_file_type"><b style="font-size: 0.9rem; margin-left: 6px; vertical-align: text-top;">Fichier Excel</b>
                            </span>
                        </div>
                    </div>
                    <hr>
                    <div class="row" id="import_from_geojson_modal_file_type_excel_data" style="display: none;">
                        <div class="col-12 col-md-6">
                            <h6 style="font-size: 0.9rem;color: #2073a0;"><i class="fa-solid fa-location-dot"></i>&nbsp;Situation de la bâtisse</h6>
                            <div class="col-12">
                                <div class="input-group input-group-sm">
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" style="width: 160px;">Province :</span>
                                        </div>
                                        <select name="province_id" id="province" class="form-control select2 m-tout">
                                            <?php $__currentLoopData = $provinces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $province): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($province->id); ?>"><?php echo e($province->nom); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="input-group input-group-sm">
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" style="width: 160px;">Cercle :</span>
                                        </div>
                                        <select name="cercle_id" id="cercle" class="form-control select2 m-tout">
                                            <?php $__currentLoopData = $cercles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cercle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($cercle->id); ?>"><?php echo e($cercle->nom); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="input-group input-group-sm">
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" style="width: 160px;">Commune :</span>
                                        </div>
                                        <select name="commune_id" id="commune" class="form-control select2 m-tout">
                                            <?php $__currentLoopData = $communes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $commune): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($commune->id); ?>"><?php echo e($commune->nom); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="input-group input-group-sm">
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" style="width: 160px;">Douar :</span>
                                        </div>
                                        <select name="douar_id" id="douar" class="form-control select2 m-tout">
                                            <?php $__currentLoopData = $douars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $douar): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($douar->id); ?>"><?php echo e($douar->nom); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-12 col-md-6">
                            <h6 style="font-size: 0.9rem;color: #2073a0;"><i class="fa-solid fa-users"></i>&nbsp;Prestataires</h6>
                            <div class="row">
                                <div class="col-12">
                                    <div class="input-group input-group-sm mb-1">
                                        <div class="input-group-prepend">
                                            <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">Laboratoire</span>
                                        </div>
                                        <select role_name="Laboratoire" name="laboratoire_id" class="form-control select2 import_from_geojson_modal_prestataire_select">

                                        </select>
                                    </div>
                                </div>
                            </div>
                            <?php if(Auth::user()->role->name!="Architecte"): ?>
                            <div class="row">
                                <div class="col-12">
                                    <div class="input-group input-group-sm mb-1">
                                        <div class="input-group-prepend">
                                            <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">Architecte</span>
                                        </div>
                                        <select role_name="Architecte" name="architecte_id" class="form-control select2 import_from_geojson_modal_prestataire_select">

                                        </select>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if(Auth::user()->role->name!="IGT"): ?>
                            <div class="row">
                                <div class="col-12">
                                    <div class="input-group input-group-sm mb-1">
                                        <div class="input-group-prepend">
                                            <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">IGT :</span>
                                        </div>
                                        <select role_name="IGT" name="igt_id" class="form-control select2 import_from_geojson_modal_prestataire_select">

                                        </select>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>

                            <div class="row">
                                <div class="col-12">
                                    <div class="input-group input-group-sm mb-1">
                                        <div class="input-group-prepend">
                                            <span style="padding: .0rem .5rem !important;min-width: 130px;" class="input-group-text">BET :</span>
                                        </div>
                                        <select role_name="BET" name="bet_id" class="form-control select2 import_from_geojson_modal_prestataire_select">

                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row mb-2 mt-2">
                            <div class="col-12">
                                <p>Pour créer des demandes en masse, veuillez suivre les étapes ci-dessous :</p>
                                <p style="margin-left:8px">1. Préparez les fichiers Excel qui contient les nouvelles demandes, en les classant par douar et par prestataire désigné (chaque importation doit correspondre à un douar et à un prestataire, qu'il s'agisse d'un IGT ou d'un Architecte). Si vous avez plusieurs prestataires (IGT ou Architecte), veuillez diviser l'importation.</p>
                                <p style="margin-left:8px">2. La colonne "type" dans le fichier Excel doit indiquer le type de démolition de la manière suivante : "p" pour une démolition partielle et "t" pour une démolition totale.</p>
                                <p style="margin-left:8px">3. Cliquez sur la zone d'importation pour sélectionner le fichier Excel.</p>
                                <p style="margin-left:8px">4. Choisissez le douar et le prestataire chargé des demandes concernées.</p>
                                <p style="margin-left:8px">5. Une fois le fichier importé, si des demandes avec des CIN déjà saisies sont détectées dans la plateforme, Bâtir vous permettra de télécharger ces CINs. Pour garantir une organisation efficace du travail, veuillez réviser la liste en éliminant les CINs déjà entrés, puis réimportez le fichier à nouveau.</p>
                                <p><a download target="_blank" href="/files/models/modele_import.xlsx">Télécharger le fichier modèle</a> , <b style="color:red"> <i class="fa-solid fa-triangle-exclamation"></i> Les noms des colonnes doivent être strictement respectés.</b></p>

                            </div>
                        </div>
                    </div>

                    <div class="row" id="import_from_geojson_modal_file_type_geojson_data">
                        <div class="row mb-2 mt-2">
                            <div class="col-12">
                                <p>Le fichier GeoJSON permettra d'importer les limites des parcelles pour lesquelles les demandes ont déjà été enregistrées. Ainsi, avec la nouvelle version, pour importer ces limites de parcelles, suivez les étapes suivantes : :</p>
                                <p style="margin-left:8px">1. Préparez un fichier contenant les limites des parcelles, <b>sans les diviser par douar ou architecte</b></p>
                                <p style="margin-left:8px">2. Exportez le fichier GeoJSON avec la projection WGS84 et incluez uniquement les CINs, conformément au modèle de fichier fourni.</p>
                                <p style="margin-left:8px">3. Cliquez sur la zone d'importation pour choisir le fichier GeoJSON.</p>
                                <p style="margin-left:8px">4. Une fois le fichier importé, la plateforme vous fournira les informations suivantes après avoir analysé les CINs mentionnées dans le fichier : les parcelles importées avec succès, celles pour lesquelles les CINs n'ont pas encore été saisies, et celles attribuées à d'autres IGT.</p>
                                <p><a download target="_blank" href="/files/models/modele_import.geojson">Télécharger le fichier modèle</a> , <b style="color:red"> <i class="fa-solid fa-triangle-exclamation"></i> Les noms des colonnes doivent être strictement respectés.</b></p>

                            </div>
                        </div>
                    </div>
                    <div class="row mb-2 mt-2">
                        <div class="col-12">

                            <p class="mb-2">La taille maximale de fichier : <b style="font-weight: 500;">50 Mb</b></p>
                            <div class="row">
                                <div class="col-12" style="padding: 0px;">
                                    <input id="import_from_geojson_modal_file" data-max-file-size-preview="50M" data-allowed-file-extensions="geojson xlsx" type="file" name="file" />
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="modal-footer" style="width:100%">
                    <div class="row">
                        <div class="col-6">
                        </div>
                        <div class="col-6">
                            <button style="float: right;margin-left: 8px;" type="button" class="btn btn-danger " data-dismiss="modal"><i class="fa-solid fa-xmark"></i>&nbspFermer</button>
                            <button id="import_from_geojson_modal_save" style="float: right;" type="submit" class="btn"><i class="fa-solid fa-floppy-disk"></i>&nbspEnregistrer</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div><?php /**PATH /home/batirc6/public_html/resources/views/demandes/index_modals.blade.php ENDPATH**/ ?>