
<?php $__env->startSection('added_css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div style="padding-top: 16px;margin-left: 8px;">
    <nav class="hk-breadcrumb" aria-label="breadcrumb">
        <ol class="breadcrumb breadcrumb-light bg-transparent">
            <li class="breadcrumb-item"><a href="<?php echo e(route('demandes')); ?>">Demandes</a></li>
            <?php if($mode=='create'): ?>
            <li class="breadcrumb-item active" aria-current="page">Nouvelle enquête</li>
            <?php else: ?>
            <li class="breadcrumb-item active" aria-current="page">Demande N° <?php echo e($demande->numero); ?></li>
            <?php endif; ?>
        </ol>
    </nav>
    <div class="row">
        <div class="col-12 col-md-9 mb-3">
            <div style="margin-top:8px;padding-left: 10px;padding-right: 10px;">
                <h6><i class="fa-solid fa-location-dot"></i>&nbsp Situation de la bâtisse</h6>
                <div class="row">
                    <div class="col-12 col-md-6">

                        <div class="row">
                            <?php if($mode=='create'): ?>
                            <div class="col-12">
                                <div class="input-group input-group-sm">
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" style="width: 160px;">Province :</span>
                                        </div>
                                        <select id="province" class="form-control select2 m-tout">
                                            <?php $__currentLoopData = $provinces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $province): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($province->id); ?>"><?php echo e($province->nom); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="input-group input-group-sm">
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" style="width: 160px;">Cercle :</span>
                                        </div>
                                        <select id="cercle" class="form-control select2 m-tout">
                                            <?php $__currentLoopData = $cercles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cercle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($cercle->id); ?>"><?php echo e($cercle->nom); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="input-group input-group-sm">
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" style="width: 160px;">Commune :</span>
                                        </div>
                                        <select id="commune" class="form-control select2 m-tout">
                                            <?php $__currentLoopData = $communes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $commune): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($commune->id); ?>"><?php echo e($commune->nom); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>



                            <div class="col-12">
                                <div class="input-group input-group-sm">
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text" style="width: 160px;">Douar :</span>
                                        </div>
                                        <select id="douar" class="form-control select2 m-tout">
                                            <?php $__currentLoopData = $douars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $douar): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($douar->id); ?>"><?php echo e($douar->nom); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <?php else: ?>
                            <div class="input-group input-group-sm">
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="width: 140px;">Province :</span>
                                    </div>
                                    <input readonly class="form-control" value="<?php echo e($demande->province->nom); ?>">
                                </div>
                            </div>

                            <div class="input-group input-group-sm">
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="width: 140px;">Cercle :</span>
                                    </div>
                                    <input readonly class="form-control" value="<?php echo e($demande->cercle->nom); ?>">
                                </div>
                            </div>


                            <div class="input-group input-group-sm">
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="width: 140px;">Commune :</span>
                                    </div>
                                    <input readonly class="form-control" value="<?php echo e($demande->commune->nom); ?>">
                                </div>
                            </div>

                            <div class="input-group input-group-sm">
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="width: 140px;">Douar :</span>
                                    </div>
                                    <input readonly class="form-control" value="<?php echo e(strlen($demande->douar->nom)>0?$demande->douar->nom:$demande->douar->nom_ar); ?>">
                                </div>
                            </div>

                            <?php endif; ?>
                            <hr>

                            <div class="col-12 mt-2" style="font-size: 0.8rem">
                                <i id="etude_geotechnique_status_icon_1" style="color:#759B24;display:none" class="fa-regular fa-square-check"></i>
                                <i id="etude_geotechnique_status_icon_0" style="color:#F44141" class="fa-regular fa-circle-xmark"></i>
                                <span id="etude_geotechnique_status_label" style="color:#F44141">Etude géotechnique</span>
                            </div>

                            <div class="col-12 mt-2" style="font-size: 0.8rem">
                                <i id="stabilisation_sol_status_icon_1" style="color:#759B24;display:none" class="fa-regular fa-square-check"></i>
                                <i id="stabilisation_sol_status_icon_0" style="color:#F44141" class="fa-regular fa-circle-xmark"></i>
                                <span id="stabilisation_sol_status_label" style="color:#F44141">Stabilisation du sol</span>
                            </div>

                            <div class="col-12 mt-2" style="font-size: 0.8rem">
                                <i id="nivellement_sol_status_icon_1" style="color:#759B24;display:none" class="fa-regular fa-square-check"></i>
                                <i id="nivellement_sol_status_icon_0" style="color:#F44141" class="fa-regular fa-circle-xmark"></i>
                                <span id="nivellement_sol_status_label" style="color:#F44141">Nivellement du sol</span>
                            </div>

                            <div class="col-12 mt-2" style="font-size: 0.8rem">
                                <i id="deblaiement_status_icon_1" style="color:#759B24;display:none" class="fa-regular fa-square-check"></i>
                                <i id="deblaiement_status_icon_0" style="color:#F44141" class="fa-regular fa-circle-xmark"></i>
                                <span id="deblaiement_status_label" style="color:#F44141">Déblaiement</span>
                            </div>

                        </div>
                    </div>

                    <div class="col-12 col-md-6">
                        <?php if(!is_null($demande)): ?>
                        <div style="<?php echo e($demande->geojson!=null?'display:none':'display:block'); ?>;height: calc( 100% - 0px); width: calc( 100% - 20px); position: absolute; z-index: 99999; border-radius: 6px; background: rgba(255, 255, 255, .5); backdrop-filter: blur(10px); border: 1px #cacaca solid;">
                            <span style="font-family: 'Roboto'; font-weight: 500; font-size: 1.3rem; position: absolute; top: 50%; text-align: center; width: 100%;">Absence de données géométriques</span>
                        </div>
                        <?php else: ?>
                        <div style="height: calc( 100% - 0px); width: calc( 100% - 20px); position: absolute; z-index: 99999; border-radius: 6px; background: rgba(255, 255, 255, .5); backdrop-filter: blur(10px); border: 1px #cacaca solid;">
                            <span style="font-family: 'Roboto'; font-weight: 500; font-size: 1.3rem; position: absolute; top: 50%; text-align: center; width: 100%;">Absence de données géométriques</span>
                        </div>
                        <?php endif; ?>

                        <div id="map" style="min-height: 300px;background: #f2f2f2; height: 100%; width: 100%; border-radius: 6px; border: 1px #c6c6c6 solid;"></div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <h6><i class="fa-solid fa-users"></i>&nbsp Pétitionnaires</h6>
                        <div class="row">
                            <div class="col-6">
                                <?php if($mode=='create'): ?>
                                <button id="petitionnaires_add_btn" type="button" class="btn"> <i class="fa-solid fa-plus"></i>&nbspAjouter</button>
                                <button disabled id="petitionnaires_delete_btn" type="button" class="btn btn-danger"> <i class="fa-solid fa-trash"></i>&nbspSupprimer</button>
                                <?php else: ?>
                                <?php if(is_null($demande->dossier)): ?>
                                <button id="petitionnaires_add_btn" type="button" class="btn"> <i class="fa-solid fa-plus"></i>&nbspAjouter</button>
                                <button disabled id="petitionnaires_delete_btn" type="button" class="btn btn-danger"> <i class="fa-solid fa-trash"></i>&nbspSupprimer</button>
                                <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                        <table class="table table-hover datatables dataTable no-footer display nowrap" id="petitionnaires_table">
                            <thead>
                                <th>Nom</th>
                                <th>Prenom</th>
                                <th>CIN</th>
                                <th>Téléphone</th>
                                <th>Documents</th>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12">
                        <h6><i class="fa-solid fa-file"></i>&nbsp Documnts</h6>
                        <table style="border: 1px #d1d1d1 solid;" class="table rtable datatables table-striped no-footer display nowrap">
                            <thead>
                                <th>Document</th>
                                <th>Type du fichier</th>
                                <th>Date dépôt</th>

                                <th></th>
                                <th></th>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $igt_documents_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $igt_document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="<?php echo e($igt_document['active']==1?'':'disabled_tr'); ?>">
                                    <td><i class="fa-solid fa-file-pdf"></i>&nbsp<?php echo e($igt_document['name']); ?></td>
                                    <td>Fichier <?php echo e(strtoupper($igt_document['file_type'])); ?></td>
                                    <td>
                                        <?php if(is_null($igt_document['document'])): ?>
                                        <span type_document="<?php echo e($igt_document['type_document']); ?>" class="download_depot_date" style="color:gray">Aucun fichier importé</span>
                                        <?php else: ?>
                                        <span type_document="<?php echo e($igt_document['type_document']); ?>" class="download_depot_date" style="color:black"><?php echo e($igt_document['document']->formated_created_at()); ?></span>
                                        <?php endif; ?>
                                    </td>

                                    <td>
                                        <?php if(Auth::user()->has_role($igt_document['w_roles'])): ?>
                                        <button type_document="<?php echo e($igt_document['type_document']); ?>" file_type="<?php echo e($igt_document['file_type']); ?>" type="button" class="btn btn-light upload_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if(is_null($igt_document['document'])): ?>
                                        <button type_document="<?php echo e($igt_document['type_document']); ?>" file_id="" disabled type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download "></i>&nbsp;Télécharger</button>
                                        <?php else: ?>
                                        <button type_document="<?php echo e($igt_document['type_document']); ?>" file_id="<?php echo e($igt_document['document']->id); ?>" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-12 col-md-3">

            <div class="row" style="background: #f2f2f2; padding: 8px; border-radius: 6px; border: 1px #d2d2d2 solid;">


                <?php if($mode=='create'): ?>
                <h6>Nouvelle enquête</h6>
                <?php else: ?>
                <h6>Enquête N° <?php echo e($demande->numero); ?></h6>
                <?php endif; ?>

                <div class="col-12">
                    <div class="input-group input-group-sm">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 120px;">Date :</span>
                            </div>
                            <?php if($mode=='create'): ?>
                            <input readonly value="<?php echo e(Carbon\Carbon::now()->format('d/m/Y H:i')); ?>" class="form-control">
                            <?php else: ?>
                            <input readonly value="<?php echo e(Carbon\Carbon::createFromFormat('Y-m-d H:i:s',$demande->created_at)->format('d/m/Y H:i')); ?>" class="form-control">
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="col-12">
                    <div class="input-group input-group-sm">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 120px;">Créé par :</span>
                            </div>
                            <?php if($mode=='create'): ?>
                            <input value="<?php echo e(Auth::user()->nom.' '.Auth::user()->prenom); ?>" class="form-control">
                            <?php else: ?>
                            <input value="<?php echo e($demande->user->nom.' '.$demande->user->prenom); ?>" class="form-control">
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <div class="col-12">
                    <div class="input-group input-group-sm">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 120px;">Etat :</span>
                            </div>
                            <?php if($mode=='create'): ?>
                            <input value="Parcelle enquêtée" class="form-control">
                            <?php else: ?>
                            <?php if($demande->dossier==null): ?>
                            <input value="Parcelle enquêtée" class="form-control">
                            <?php else: ?>
                            <input value="-" class="form-control">
                            <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>





                <?php if($mode=='create' ): ?>
                <?php if(Auth::user()->has_role("IGT")): ?>

                <button id="save_eq_btn" style="width: 100%; background: #fcfcfc  !important; border: 1px #a1a1a1 solid !important;" type="button" class="btn mt-2">
                    <span style="display: none;" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                    Enregistrer
                </button>



                <?php endif; ?>
                <?php else: ?>
                <?php if(Auth::user()->has_role("IGT")): ?>
                <?php if($demande->user_id == Auth::user()->id): ?>
                <button id="save_eq_btn" style="width: 100%; background: #fcfcfc  !important; border: 1px #a1a1a1 solid !important;" type="button" class="btn mt-2">
                    <span style="display: none;" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                    Enregistrer
                </button>


                <?php endif; ?>
                <?php endif; ?>
                <?php endif; ?>


                <?php if($mode!='create' ): ?>
                <?php if(Auth::user()->has_role("IGT,Architecte")): ?>
                <button id="save_demande_btn" style="width: 100%; background: #fcfcfc  !important; border: 1px #a1a1a1 solid !important;" type="button" class="btn mt-2">
                    <span style="display: none;" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                    Créer demande
                </button>
                <?php endif; ?>
                <?php endif; ?>

            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('demandes.modals', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('added_scripts'); ?>
<script src="<?php echo e(asset('js/demandes/show.js').'?t='.time()); ?>"></script>
<script src="<?php echo e(asset('js/demandes/petitionnaire_modal.js').'?t='.time()); ?>"></script>

<script>
    var provinces = <?php echo json_encode($provinces, JSON_PRETTY_PRINT, 512) ?>;
    var cercles = <?php echo json_encode($cercles, JSON_PRETTY_PRINT, 512) ?>;
    var communes = <?php echo json_encode($communes, JSON_PRETTY_PRINT, 512) ?>;
    var douars = <?php echo json_encode($douars, JSON_PRETTY_PRINT, 512) ?>;

    <?php if($demande != null): ?>
    var demande = <?php echo json_encode($demande, JSON_PRETTY_PRINT, 512) ?>;
    <?php else: ?>
    var demande = {};
    <?php endif; ?>
    $(document).ready(function() {
        for (var i = 0; i < demande.petitionnaires.length; i++) {
            petitionnaires_add(demande.petitionnaires[i]);
        }
    });

    $(document).ready(function() {
        for (var i = 0; i < demande.documents.length; i++) {
            documents_table_add(demande.documents[i]);
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/batirc6/public_html/resources/views/demandes/show_eq.blade.php ENDPATH**/ ?>