
<?php $__env->startSection('added_css'); ?>
<link rel="stylesheet" href="https://unpkg.com/leaflet.fullscreen@latest/Control.FullScreen.css" />


<?php $__env->startSection('content'); ?>
<style>
    body {
        zoom: 100% !important;
    }

    .projet-info {
        position: absolute;
        left: 115px;
        top: 42px;
    }

    .visualistion {
        width: 50%;
        height: 132px;
        padding: 8px;
        position: absolute;
        top: 40px;

    }

    .visualistion_btn {
        width: 110px;
        height: 100px;
        padding: 6px;
        border: 1px #00060d solid;
        border-radius: 8px;
        background: #66a7e0;
    }

    .visualistion_btn:hover {

        background: #4493d9;
    }

    .visualistion_btn.disabled {
        filter: grayscale(1);
        border: 1px #777777 solid;
    }

    .card {
        border-radius: 12px;
        background: #f6f6f6;
    }

    h6 {
        font-size: 14px;
        font-weight: 500;
        border-bottom: 1px #dcdcdc solid;
        color: #1e5295;
        width: 100%;
        padding-bottom: 4px;
    }

    .profile-pic {
        height: 120px;
        width: 120px;
        border: #97999a solid;
        border-width: 2px;
        margin: auto;
        display: block;
        position: absolute;
        top: -53px;
        left: calc(50% - 60px);
    }

    .ds-container {
        width: 100%;
        position: relative;
        padding: 8px;
        transition: all;
        transition-duration: 0.25s;
    }

    .ds-container:hover {
        opacity: 0.75;
    }

    .ds-bottom-div {
        width: 100%;
        height: 164px;
        background-color: #115555;
        bottom: 0;
        z-index: 99;
        position: relative;
        border-radius: 8px;
        border: 1px #858585 solid;
        box-shadow: 0px 0px 8px 0px rgb(0 0 0 / 13%) !important;
    }

    .ds-top-div {
        width: 50%;
        height: 164px;
        background-color: #fefefe;
        top: 8px;
        clip-path: polygon(0 0, 100% 0, 80% 100%, 0 100%);
        z-index: 100;
        position: absolute;
        border-radius: 8px 0px 0px 8px;
        border: 1px #858585 solid;
        cursor: pointer;
    }

    .ds-top-border-div {
        width: calc(50% + 8px);
        height: 164px;
        background-color: #dedede;
        top: 8px;
        clip-path: polygon(0 0, 100% 0, 80% 100%, 0 100%);
        z-index: 100;
        position: absolute;
        border-radius: 8px 0px 0px 8px;
        border: 1px #858585 solid;

    }

    .ds-header {
        font-size: 0.8rem;
        font-weight: 500;
        color: #103451;
        width: 100%;
        display: block;
        background: #b3c8db;
        padding: 6px;
        border-radius: 8px 0px 0px 0px;
        height: 42px;
    }

    .ds-column {
        padding: 6px;
    }

    .ds-val {
        padding: 6px;
        font-weight: 500;
        color: #32862f;
    }
</style>
<div style="padding-top: 30px;margin-left: 40px;margin-right: 40px">

    <div class="row ">
        <div class="col-12 col-sm-3 mt-2">

            <?php echo $__env->make('client/global/profile-card', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="card mt-2 ">
                <div class="card-body">
                    <h6><i class="fa-regular fa-bell mr-1"></i><?php echo e(__('notifications')); ?> (<?php echo e((auth()->user()->notifications_count())); ?>)</h6>

                    <div>
                        <?php $__currentLoopData = auth()->user()->notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a style="text-decoration: none;padding: 0px;" href="javascript:void(0);" class="dropdown-item">
                            <div class="media" style="padding: 4px;">
                                <div class="media-img-wrap" style="margin: 0rem 0.2rem;">
                                    <div style="border-radius: 50%; background: #02a6ce; color: white;" class="avatar avatar-sm">
                                        <i style="margin-right: 0px;    margin-top: 8px; " class="fa-solid fa-bell "></i>
                                    </div>
                                </div>
                                <div class="media-body" style="margin: 0px 6px;">
                                    <div>
                                        <div class="notifications-text"><a href="<?php echo e($notification->target); ?>" class="text-dark" style="font-weight: 500;white-space: wrap;"><?php echo e(__($notification->content)); ?></a></div>
                                        <div class="notifications-time"><?php echo e(\Carbon\Carbon::createFromFormat('Y-m-d H:i:s',$notification->created_at)->format('d/m/Y H:i')); ?></div>
                                    </div>
                                </div>
                            </div>
                        </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                </div>
            </div>
        </div>
        <div class="col-12 col-sm-9 mt-2">
            <div class="card">
                <div class="card-body">
                    <h6><i class="fa-solid fa-helmet-safety mr-1"></i> <?php echo e(__('mes_projets')); ?> (<?php echo e(count($projets)); ?>)</h6>

                    <div>

                        <?php $__currentLoopData = $projets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $projet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="ds-container" id="<?php echo e($projet->id); ?>">
                            <div class="ds-bottom-div">
                                <div id="mapdiv-<?php echo e($projet->id); ?>" style="border-radius: 0px 8px 8px 0px;height: 100% !important; background: rgb(242, 242, 242); width: 60%; position: relative; float: right;">

                                </div>
                            </div>
                            <div class="ds-top-border-div">
                            </div>
                            <div class="ds-top-div" id="<?php echo e($projet->id); ?>">
                                <span class="ds-header"><span style="margin-left: 20px; float: left; margin-top: 4px; font-size: 1rem;"><?php echo e($projet->lot->type()); ?> N° <?php echo e($projet->lot->numero); ?></span> <button style="color: #ffffff;    float: right;    margin-right: 55px;    background: #2271c5 !important" class="btn"><?php echo e(__('acceder_a_mon_projet')); ?></button></span>

                                <div class="projet-info">
                                    <div class="row mt-2">
                                        <div class="col-12">
                                            <span class="ds-column"><?php echo e(__('ville')); ?> :</span><span class="ds-val "><?php echo e($projet->lot->lotissement->ville->nom); ?></span>
                                        </div>
                                    </div>

                                    <div class="row  mt-1">
                                        <div class="col-12">
                                            <span class="ds-column"><?php echo e(__('lotissement')); ?> :</span><span class="ds-val "><?php echo e($projet->lot->lotissement->nom); ?></span>
                                        </div>
                                    </div>


                                    <div class="row  mt-1">
                                        <div class="col-12">
                                            <span class="ds-column"><?php echo e(__('lot_numero')); ?> :</span><span class="ds-val "><?php echo e($projet->lot->numero); ?></span>
                                        </div>
                                    </div>

                                    <div class="row  mt-1">
                                        <div class="col-12">
                                            <span class="ds-column"><?php echo e(__('surface')); ?> :</span><span class="ds-val "><?php echo e($projet->lot->surface); ?> m²</span>
                                        </div>
                                    </div>

                                    <div class="row  mt-1">
                                        <div class="col-12">
                                            <span class="ds-column"><?php echo e(__('intitule')); ?> :</span><span class="ds-val "><?php echo e($projet->intitule); ?></span>
                                        </div>
                                    </div>
                                </div>


                                <div class="visualistion">

                                    <?php if(count($projet->maquettes_3d)>0): ?>
                                    <div id="<?php echo e($projet->id); ?>" class="visualistion_btn">
                                        <img style="width: 66px;margin: auto;display: block;" src="/images/building3d_icon.png">
                                        <b style="color: #ffffff;width: 100%;text-align: center;font-size: 0.75rem;display: block;margin-top: 4px;"><?php echo e(__('visualisation')); ?></b>
                                    </div>
                                    <?php else: ?>
                                    <div id="<?php echo e($projet->id); ?>" class="visualistion_btn disabled">
                                        <img style="width: 66px;margin: auto;display: block;" src="/images/building3d_icon.png">
                                        <b style="color: #ffffff;width: 100%;text-align: center;font-size: 0.75rem;display: block;margin-top: 4px;"><?php echo e(__('visualisation')); ?></b>
                                    </div>
                                    <?php endif; ?>




                                </div>
                                <!-- <div class="row  mt-1">
                                    <div class="col-12">
                                        <button disabled class="btn"><i class="fa-brands fa-unity mr-1"></i>Maquettes 3D</button>
                                        <button disabled class="btn"><i class="fa-regular fa-eye mr-1 ml-2"></i>Visite 3D</button>
                                    </div>

                                </div> -->


                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                </div>
            </div>

            <div class="row mt-4">
                <div class="col-12 ">
                    <iframe src="/geoportail_frame#client-index" style="margin-bottom :40px;width: 100%;height: 400px;border: 1px gray solid;border-radius: 12px;">
                    </iframe>
                </div>
            </div>
        </div>
    </div>



</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('added_scripts'); ?>

<script>
    var projets = <?php echo json_encode($projets, 15, 512) ?>;
</script>
<script src="https://unpkg.com/leaflet.fullscreen@latest/Control.FullScreen.js"></script>
<script>
    var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
    var plle_style = {
        fillColor: '#358eb0',
        weight: 3,
        opacity: 1,
        color: '#ffc000',
        fillOpacity: 0.60
    }




    function initMap(div_id, lot_id) {
        var lot_data = undefined;
        var googlehybrid = L.tileLayer('https://www.google.com/maps/vt?lyrs=y@189&gl=ma&x={x}&y={y}&z={z}', {
            maxZoom: 20,

        });

        var _map = new L.Map(div_id, {
            zoomControl: true,
            center: new L.LatLng(32.62087018318113, -6.262207031250001),
            zoom: 6,
            editable: true,
            drawControl: true,
            preferCanvas: true,
            attributionControl: false,

        });


        var fsControl = L.control.fullscreen({
            position: 'bottomright'
        });

        _map.addControl(fsControl);

        googlehybrid.addTo(_map);


        $.ajax({
            url: assetBaseUrl + 'lots/get',
            type: "POST",
            data: {
                _token: csrfToken,
                id: lot_id,
            },

            success: function(result) {
                lot_data = result.lot;

                var layers_group = new L.featureGroup();
                var geojson = L.geoJSON(JSON.parse(lot_data.geometry));
                geojson.setStyle(plle_style);
                geojson.addTo(_map);
                layers_group.addLayer(geojson);
                _map.fitBounds(layers_group.getBounds());



            }
        });



    }

    $(document).ready(function() {

        $('.switch_lang').select2({
            templateResult: formatOption,
            templateSelection: formatOption,
            minimumResultsForSearch: Infinity
        });
        projets.forEach(projet => {
            initMap('mapdiv-' + projet.id, projet.lot.id);
        });

        function formatOption(option) {
            if (!option.id) {
                return option.text; // Return the text for non-selected options
            }

            var imageUrl = $(option.element).data('image'); // Get the image URL from the data attribute
            var $option = $(
                `<div>
                <img src="${imageUrl}" style="width: 20px; height: 20px; margin-right: 10px;" />
                ${option.text}
            </div>`
            );

            return $option;
        }

    });

    $('body').on('click', '.ds-top-div', function() {
        var id = $(this).attr('id');
        location.href = assetBaseUrl + 'client/projet/' + id;
    })


    $(".visualistion_btn").click(function(event) {
        event.preventDefault();
        event.stopPropagation();
        var id = $(this).attr('id');

        $("#gl_frame_modal_title").text("Visualisation");
        $("#gl_frame_modal_frame").attr("src", "/projets/frame/viusalisation/" + id);

        $("#gl_frame_modal").modal('show');

        $('#gl_frame_modal .modal-content').css('height', '720px');

    })

    $(".switch_lang").change(function() {
        location.href = "https://alomraneassist.ma/language/" + $(this).val()
    })
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app_client', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u447310764/domains/alomraneassist.ma/public_html/resources/views/client/index/index.blade.php ENDPATH**/ ?>