<style>
    /* ----------------------------------------------------------------------------------------------------------*/
    /* NavCubePlugin */
    /* ----------------------------------------------------------------------------------------------------------*/

    #myNavCubeCanvas {
        position: absolute;
        width: 250px;
        height: 250px;
        bottom: 50px;
        right: 10px;
        z-index: 200000;
    }

    /* ----------------------------------------------------------------------------------------------------------*/
    /* TreeViewPlugin */
    /* ----------------------------------------------------------------------------------------------------------*/

    #treeViewContainer {
        pointer-events: all;

        overflow-y: auto;
        overflow-x: hidden;
        background-color: rgba(255, 255, 255, 0.2);
        color: black;
        top: 80px;
        z-index: 200000;
        float: left;
        left: 0;
        padding-left: 10px;
        font-family: 'Roboto', sans-serif;
        font-size: 15px;
        user-select: none;
        -ms-user-select: none;
        -moz-user-select: none;
        -webkit-user-select: none;

    }

    #treeViewContainer ul {
        list-style: none;
        padding-left: 1.75em;
        pointer-events: none;
    }

    #treeViewContainer ul li {
        position: relative;
        width: 500px;
        pointer-events: none;
        padding-top: 3px;
        padding-bottom: 3px;
        vertical-align: middle;
    }

    #treeViewContainer ul li a {
        background-color: #eee;
        border-radius: 50%;
        color: #000;
        display: inline-block;
        height: 1.5em;
        left: -1.5em;
        position: absolute;
        text-align: center;
        text-decoration: none;
        width: 1.5em;
        pointer-events: all;
    }

    #treeViewContainer ul li a.plus {
        background-color: #ded;
        pointer-events: all;
    }

    #treeViewContainer ul li a.minus {
        background-color: #eee;
        pointer-events: all;
    }

    #treeViewContainer ul li a:active {
        top: 1px;
        pointer-events: all;
    }

    #treeViewContainer ul li span:hover {
        color: white;
        cursor: pointer;
        background: black;
        padding-left: 2px;
        pointer-events: all;
    }

    #treeViewContainer ul li span {
        display: inline-block;
        width: calc(100% - 50px);
        padding-left: 2px;
        pointer-events: all;
        height: 23px;
    }

    #treeViewContainer .highlighted-node {
        /* Appearance of node highlighted with TreeViewPlugin#showNode() */
        border: black solid 1px;
        background: yellow;
        color: black;
        padding-left: 1px;
        padding-right: 5px;
        pointer-events: all;
    }

    .side-panel-toggle {
        height: 26px;
        width: 26px;
        background: #f0f0f0;
        right: 6px;
        top: 4px;
        position: absolute;
        display: flex;
        border-radius: 50%;
        border: 1px #cccccc solid;
        color: cadetblue;
        transition: transform 0.2s, 0.35s ease-in-out !important;
    }

    .side_panel {

        top: 44px;
        border: 2px #115555 solid;
    }

    .side_panel.folded {
        width: 44px !important;
        overflow: hidden;
    }
</style>
<div class="row">
    <div class="col-12  ">
        <div class="card">
            <div class="card-body">
                <h6 class="card-title"><i class="fa-solid fa-folder-tree mr-1"></i>Maquettes 3D</h6>
                <?php $__currentLoopData = $maquettes3d_file_groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                <?php if(Auth::user()->has_role('arch') && $projet->arch_id==Auth::user()->id): ?>
                <div class="col-12">
                    <button type_document="<?php echo e($group['type_document']); ?>" type="button" class="btn btn-light upload_ifc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Ajouter</button>
                    <button type_document="<?php echo e($group['type_document']); ?>" type="button" disabled class="btn btn-danger delete_photo_link"> <i class="fa-solid fa-trash"></i>&nbsp;Supprimer</button>
                </div>
                <?php endif; ?>
                <div class="phototheque hk-gallery mt-1" type_document="<?php echo e($group['type_document']); ?>" style="width: 100%;border-radius:6px;border:1px #949494 solid;height:140px;overflow-x: auto;white-space: nowrap;padding:4px">
                    <?php $__currentLoopData = $group['files']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a class="costume-img " style="margin: 0px;">
                        <img class="ifc_a" ifc_path="<?php echo e($file->documentUrl()); ?>" style="border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="<?php echo e(asset('images/ifc_file_default_thumbnail.png')); ?>" class="gallery-img costume-img hk-gallery">
                        </br>
                        <b style="text-overflow: clip;overflow: hidden;white-space: nowrap;display: block;"><?php echo e($file->filename); ?></b>
                        <input item_id="<?php echo e($file->id); ?>" type_document="<?php echo e($group['type_document']); ?>" class="select_photo_cb" style="margin: auto;display: block;position: relative;" type="checkbox">
                    </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </div>

    <div class="col-12  mt-1">

        <div class="card">
            <div class="card-body">
                <h6 class="card-title"><i class="fa-brands fa-unity mr-1"></i>Visionneuse</h6>
                <canvas id="viewer_canvas" style="width: 100%;height:600px">



                </canvas>

                <div class="side_panel" style="width: 30%;max-width:400px; height:600px;  z-index: 99; display: block; position: absolute;padding:0.8rem">
                    <div class="side-panel-toggle">
                        <i class="side-panel-toggle-icon fa-solid fa-chevron-left"></i>
                    </div>
                    <div class="tab-content">
                        <h6><i class="fa-solid fa-folder-tree mr-1"></i>L'arborescence</h6>
                        <div id="treeViewContainer" style="width: 100%;padding: 8px; height:100%"></div>
                    </div>
                    <div class="tab-content-hidden hidden">
                        <b style="font-size: 1rem;writing-mode: vertical-rl;margin-top: 30px;">L'arborescence</b>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

</body>
<script id="source" type="module">
    import {
        XKTLoaderPlugin,
        WebIFCLoaderPlugin,
        TreeViewPlugin,
        DistanceMeasurementsPlugin,
        Viewer,
        DistanceMeasurementsMouseControl,
        PointerLens
    } from "https://cdn.jsdelivr.net/npm/@xeokit/xeokit-sdk/dist/xeokit-sdk.es.min.js";


    import * as WebIFC from "https://cdn.jsdelivr.net/npm/web-ifc@0.0.51/web-ifc-api.js";

    const viewer = new Viewer({
        canvasId: "viewer_canvas",
        transparent: true
    });
    const canvas = document.getElementById('viewer_canvas');
    canvas.addEventListener('wheel', (event) => {
        event.preventDefault(); // Prevent default scroll behavior
    });
    // 2
    viewer.camera.eye = [-2.56, 8.38, 8.27];
    viewer.camera.look = [13.44, 3.31, -14.83];
    viewer.camera.up = [0.10, 0.98, -0.14];


    const treeView = new TreeViewPlugin(viewer, {
        containerElement: document.getElementById("treeViewContainer")
    });

    const distanceMeasurements = new DistanceMeasurementsPlugin(viewer);

    const distanceMeasurementsControl = new DistanceMeasurementsMouseControl(distanceMeasurements, {

    })



    distanceMeasurementsControl.snapToVertex = true;
    distanceMeasurementsControl.snapToEdge = true;

    ///distanceMeasurementsControl.activate();


    const IfcAPI = new WebIFC.IfcAPI();


    IfcAPI.SetWasmPath("https://cdn.jsdelivr.net/npm/web-ifc@0.0.51/");

    var model = undefined;


    function progressiveLoadModel(file_path) {

        showLoading('Chargement...', 'Le fichier est en cours de chargement, veuillez patienter');

        IfcAPI.Init().then(async () => {
            const ifcLoader = new WebIFCLoaderPlugin(viewer, {
                WebIFC,
                IfcAPI
            });

            // Load model incrementally
            model = ifcLoader.load({
                id: "myModel",
                src: file_path,
                excludeTypes: ["IfcSpace"],
                edges: false
            });

            // Add a timeout to handle large model processing
            setTimeout(() => {
                model.on("loaded", () => {
                    // Perform camera adjustments
                    const metaModel = viewer.metaScene.metaModels["myModel"];
                    const model = viewer.scene.models["myModel"];
                    const objectIds = viewer.metaScene.getObjectIDsInSubtree(model.id);
                    const aabb = viewer.scene.getAABB(objectIds);
                    viewer.cameraFlight.flyTo(aabb);
                    closeLoading();
                });
            }, 50); // 50ms delay between loading steps
        });
    }

    function destroyAllModels() {
        if (model != undefined) {
            model.destroy();

        }

    }
    $('body').on('click', '.ifc_a', function() {
        var ifc_path = $(this).attr('ifc_path');
        destroyAllModels();
        progressiveLoadModel(ifc_path);
    });
</script><?php /**PATH /home/u447310764/domains/alomraneassist.ma/public_html/resources/views/projets/3dview_tab.blade.php ENDPATH**/ ?>