
<?php $__env->startSection('added_css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div style="padding-top: 16px;margin-left: 8px;">
    <nav class="hk-breadcrumb" aria-label="breadcrumb">
        <ol class="breadcrumb breadcrumb-light bg-transparent">
            <li class="breadcrumb-item"><a href="<?php echo e(route('dossiers_rehab')); ?>">Dossiers de réhabilitation</a></li>
            <?php if($mode=='create'): ?>
            <li class="breadcrumb-item active" aria-current="page">Nouveau dossier</li>
            <?php else: ?>
            <li class="breadcrumb-item active" aria-current="page">Dossier N° <?php echo e($dossier_rehab->numero); ?></li>
            <?php endif; ?>
        </ol>
    </nav>
    <?php if(Auth::user()->has_role('Vérificateur,Administrateur')): ?>
    <ul class="nav nav-tabs" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="donnees-tab" data-toggle="tab" data-target="#donnees" type="button" role="tab" aria-controls="donnees" aria-selected="true">Données</button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="verification-tab" data-toggle="tab" data-target="#verification" type="button" role="tab" aria-controls="verification" aria-selected="false">Vérification</button>
        </li>
    </ul>
    <?php endif; ?>

    <div class="tab-content" id="myTabContent">
        <div class="tab-pane fade show active" id="donnees" role="tabpanel" aria-labelledby="donnees-tab">
            <div class="row">
                <div class="col-12 col-md-9 mb-3">
                    <div style="margin-top:8px;padding-left: 10px;padding-right: 10px;">

                        <div class="card card-refresh mt-2">
                            <div class="refresh-container">
                                <div class="loader-pendulums"></div>
                            </div>
                            <div class="card-header card-header-action">
                                <h5 style="margin: 2px !important;color: #2273ae;font-size: 15px;">Détails relatifs à la demande</h5>
                                <div class="d-flex align-items-center card-action-wrap">
                                    <a class="inline-block mr-15" data-toggle="collapse" href="#collapse_1" aria-expanded="true">
                                        <i class="zmdi zmdi-chevron-down"></i>
                                    </a>

                                </div>
                            </div>
                            <div id="collapse_1" class="collapse show">
                                <div class="card-body">
                                    <h6><i class="fa-solid fa-location-dot"></i>&nbsp Situation de la bâtisse</h6>
                                    <div class="row">
                                        <div class="col-12 col-md-6">
                                            <div class="row">

                                                <?php if($mode=='create'): ?>
                                                <div class="col-12">
                                                    <div class="input-group input-group-sm">
                                                        <div class="input-group mb-1">
                                                            <div class="input-group-prepend">
                                                                <span class="input-group-text" style="width: 160px;">Province :</span>
                                                            </div>
                                                            <select id="province" class="form-control select2 m-tout">
                                                                <?php $__currentLoopData = $provinces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $province): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($province->id); ?>"><?php echo e($province->nom); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-12">
                                                    <div class="input-group input-group-sm">
                                                        <div class="input-group mb-1">
                                                            <div class="input-group-prepend">
                                                                <span class="input-group-text" style="width: 160px;">Cercle :</span>
                                                            </div>
                                                            <select id="cercle" class="form-control select2 m-tout">
                                                                <?php $__currentLoopData = $cercles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cercle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($cercle->id); ?>"><?php echo e($cercle->nom); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-12">
                                                    <div class="input-group input-group-sm">
                                                        <div class="input-group mb-1">
                                                            <div class="input-group-prepend">
                                                                <span class="input-group-text" style="width: 160px;">Commune :</span>
                                                            </div>
                                                            <select id="commune" class="form-control select2 m-tout">
                                                                <?php $__currentLoopData = $communes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $commune): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($commune->id); ?>"><?php echo e($commune->nom); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>



                                                <div class="col-12">
                                                    <div class="input-group input-group-sm">
                                                        <div class="input-group mb-1">
                                                            <div class="input-group-prepend">
                                                                <span class="input-group-text" style="width: 160px;">Douar :</span>
                                                            </div>
                                                            <select id="douar" class="form-control select2 m-tout">
                                                                <?php $__currentLoopData = $douars; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $douar): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($douar->id); ?>"><?php echo e($douar->nom); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <?php else: ?>
                                                <div class="col-12">
                                                    <div class="input-group input-group-sm">
                                                        <div class="input-group mb-1">
                                                            <div class="input-group-prepend">
                                                                <span class="input-group-text" style="width: 140px;">Province :</span>
                                                            </div>
                                                            <input readonly class="form-control" value="<?php echo e($dossier_rehab->province->nom); ?>">
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-12">
                                                    <div class="input-group input-group-sm">
                                                        <div class="input-group mb-1">
                                                            <div class="input-group-prepend">
                                                                <span class="input-group-text" style="width: 140px;">Cercle :</span>
                                                            </div>
                                                            <input readonly class="form-control" value="<?php echo e($dossier_rehab->cercle->nom); ?>">
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-12">
                                                    <div class="input-group input-group-sm">
                                                        <div class="input-group mb-1">
                                                            <div class="input-group-prepend">
                                                                <span class="input-group-text" style="width: 140px;">Commune :</span>
                                                            </div>
                                                            <input readonly class="form-control" value="<?php echo e($dossier_rehab->commune->nom); ?>">
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="col-12">
                                                    <div class="input-group input-group-sm">
                                                        <div class="input-group mb-1">
                                                            <div class="input-group-prepend">
                                                                <span class="input-group-text" style="width: 140px;">Douar :</span>
                                                            </div>
                                                            <input readonly class="form-control" value="<?php echo e(strlen($dossier_rehab->douar->nom)>0?$dossier_rehab->douar->nom:$dossier_rehab->douar->nom_ar); ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                                <?php endif; ?>
                                                <div class="col-12">
                                                    <div class="input-group input-group-sm">
                                                        <div class="input-group mb-1">
                                                            <div class="input-group-prepend">
                                                                <span class="input-group-text" style="width: 160px;">Coordonnées :</span>
                                                            </div>
                                                            <select id="loc_type_coordonees" class="form-control select2 m-tout">
                                                                <option <?php echo e(is_null($dossier_rehab)?'selected':($dossier_rehab->type_coordonees=="lambert"?'selected':'')); ?> value="lambert">Lambert</option>
                                                                <option <?php echo e(is_null($dossier_rehab)?'':($dossier_rehab->type_coordonees=="geographiques"?'selected':'')); ?> value="geographiques">Géographiques</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div id="coordonnees_div_lambert" style="width: 100%;">
                                                    <div class="col-12">
                                                        <div class="input-group input-group-sm">
                                                            <div class="input-group mb-1">
                                                                <div class="input-group-prepend">
                                                                    <span class="input-group-text" style="width: 160px;">Zone :</span>
                                                                </div>
                                                                <select id="loc_zone" class="form-control select2 m-tout">
                                                                    <option selected value="1">Zone 1</option>
                                                                    <option value="2">Zone 2</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-12">
                                                        <div class="input-group input-group-sm">
                                                            <div class="input-group mb-1">
                                                                <div class="input-group-prepend">
                                                                    <span class="input-group-text" style="width: 160px;">X :</span>
                                                                </div>
                                                                <input id="loc_x" value="<?php echo e(is_null($dossier_rehab)?0:$dossier_rehab->x); ?>" class="form-control">
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-12">
                                                        <div class="input-group input-group-sm">
                                                            <div class="input-group mb-1">
                                                                <div class="input-group-prepend">
                                                                    <span class="input-group-text" style="width: 160px;">Y :</span>
                                                                </div>
                                                                <input id="loc_y" value="<?php echo e(is_null($dossier_rehab)?0:$dossier_rehab->y); ?>" class="form-control ">
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <div id="coordonnees_div_geographiques" style="width: 100%;display: none;">
                                                    <div class="col-12">
                                                        <div class="input-group input-group-sm">
                                                            <div class="input-group mb-1">
                                                                <div class="input-group-prepend">
                                                                    <span class="input-group-text" style="width: 160px;">Latitude :</span>
                                                                </div>
                                                                <input id="loc_lat" value="<?php echo e(is_null($dossier_rehab)?0:$dossier_rehab->lat); ?>" class="form-control">
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-12">
                                                        <div class="input-group input-group-sm">
                                                            <div class="input-group mb-1">
                                                                <div class="input-group-prepend">
                                                                    <span class="input-group-text" style="width: 160px;">Longitude :</span>
                                                                </div>
                                                                <input id="loc_lng" value="<?php echo e(is_null($dossier_rehab)?0:$dossier_rehab->lng); ?>" class="form-control">
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-6">

                                            <div id="map" style="min-height: 300px;background: #f2f2f2; height: 100%; width: 100%; border-radius: 6px; border: 1px #c6c6c6 solid;"></div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-12">
                                            <h6><i class="fa-solid fa-users"></i>&nbsp Pétitionnaires</h6>
                                            <div class="row">
                                                <div class="col-6">
                                                    <?php if($mode=='create'): ?>
                                                    <button id="petitionnaires_add_btn" type="button" class="btn"> <i class="fa-solid fa-plus"></i>&nbspAjouter</button>
                                                    <button disabled id="petitionnaires_delete_btn" type="button" class="btn btn-danger"> <i class="fa-solid fa-trash"></i>&nbspSupprimer</button>
                                                    <?php else: ?>
                                                    <?php if(is_null($dossier_rehab)): ?>
                                                    <button id="petitionnaires_add_btn" type="button" class="btn"> <i class="fa-solid fa-plus"></i>&nbspAjouter</button>
                                                    <button disabled id="petitionnaires_delete_btn" type="button" class="btn btn-danger"> <i class="fa-solid fa-trash"></i>&nbspSupprimer</button>
                                                    <?php endif; ?>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <table class="table table-hover datatables dataTable no-footer display nowrap" id="petitionnaires_table">
                                                <thead>
                                                    <th>Nom</th>
                                                    <th>Prenom</th>
                                                    <th>CIN</th>
                                                    <th>Téléphone</th>
                                                    <th>Documents</th>
                                                </thead>
                                                <tbody>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>



                        <?php if($mode!='create'): ?>

                        <?php if($dossier_rehab->created_from_reconstruction==1): ?>
                        <div class="card card-refresh mt-2">
                            <div class="refresh-container">
                                <div class="loader-pendulums"></div>
                            </div>
                            <div class="card-header card-header-action">
                                <h5 style="margin: 2px !important;color: #2273ae;font-size: 15px;">Documents de dossier de reconstruction</h5>
                                <div class="d-flex align-items-center card-action-wrap">
                                    <a class="inline-block mr-15" data-toggle="collapse" href="#collapse_2" aria-expanded="true">
                                        <i class="zmdi zmdi-chevron-down"></i>
                                    </a>

                                </div>
                            </div>
                            <div id="collapse_2" class="collapse show">
                                <div class="card-body">

                                    <table class="table rtable datatables table-striped no-footer display nowrap">
                                        <thead>
                                            <th>Document</th>
                                            <th>Type du fichier</th>
                                            <th>Date dépôt</th>
                                            <th></th>
                                            <th></th>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $dossiers_rehab_reconstruction_docs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dossiers_rehab_doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><i class="fa-solid fa-file-pdf"></i>&nbsp<?php echo e($dossiers_rehab_doc['name']); ?>

                                                    <?php if($dossiers_rehab_doc['document']!=null && $dossiers_rehab_doc['validation']==1): ?>
                                                    <span style="font-weight:bold;color:<?php echo e($dossiers_rehab_doc['document']->decision_color()); ?>"> - <?php echo e($dossiers_rehab_doc['document']->decision_full()); ?></span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>Fichier <?php echo e(strtoupper($dossiers_rehab_doc['file_type'])); ?></td>
                                                <td>
                                                    <?php if(is_null($dossiers_rehab_doc['document'])): ?>
                                                    <span type_document="<?php echo e($dossiers_rehab_doc['type_document']); ?>" class="download_depot_date" style="color:gray">Aucun fichier importé</span>
                                                    <?php else: ?>
                                                    <span type_document="<?php echo e($dossiers_rehab_doc['type_document']); ?>" class="download_depot_date" style="color:black"><?php echo e($dossiers_rehab_doc['document']->formated_created_at()); ?> - <span style="color:coral"><?php echo e($dossiers_rehab_doc['document']->user->organisme_ste); ?> <span></span>
                                                            <?php endif; ?>
                                                </td>

                                                <td>
                                                    <?php if(Auth::user()->has_role($dossiers_rehab_doc['w_roles']) && $dossiers_rehab_doc['active']==1): ?>
                                                    <button type_document="<?php echo e($dossiers_rehab_doc['type_document']); ?>" file_type="<?php echo e($dossiers_rehab_doc['file_type']); ?>" type="button" class="btn btn-light upload_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if(is_null($dossiers_rehab_doc['document'])): ?>
                                                    <button type_document="<?php echo e($dossiers_rehab_doc['type_document']); ?>" file_id="" disabled type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download "></i>&nbsp;Télécharger</button>
                                                    <?php else: ?>
                                                    <button type_document="<?php echo e($dossiers_rehab_doc['type_document']); ?>" file_id="<?php echo e($dossiers_rehab_doc['document']->id); ?>" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>


                                </div>
                            </div>

                        </div>
                        <?php endif; ?>
                        <div class="card card-refresh mt-2">
                            <div class="refresh-container">
                                <div class="loader-pendulums"></div>
                            </div>
                            <div class="card-header card-header-action">
                                <h5 style="margin: 2px !important;color: #2273ae;font-size: 15px;">Dossier de réhabilitation</h5>
                                <div class="d-flex align-items-center card-action-wrap">
                                    <a class="inline-block mr-15" data-toggle="collapse" href="#collapse_2" aria-expanded="true">
                                        <i class="zmdi zmdi-chevron-down"></i>
                                    </a>

                                </div>
                            </div>
                            <div id="collapse_2" class="collapse show">
                                <div class="card-body">

                                    <table class="table rtable datatables table-striped no-footer display nowrap">
                                        <thead>
                                            <th>Document</th>
                                            <th>Type du fichier</th>
                                            <th>Date dépôt</th>
                                            <th></th>
                                            <th></th>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $dossiers_rehab_docs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dossiers_rehab_doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><i class="fa-solid fa-file-pdf"></i>&nbsp<?php echo e($dossiers_rehab_doc['name']); ?>

                                                    <?php if($dossiers_rehab_doc['document']!=null && $dossiers_rehab_doc['validation']==1): ?>
                                                    <span style="font-weight:bold;color:<?php echo e($dossiers_rehab_doc['document']->decision_color()); ?>"> - <?php echo e($dossiers_rehab_doc['document']->decision_full()); ?></span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>Fichier <?php echo e(strtoupper($dossiers_rehab_doc['file_type'])); ?></td>
                                                <td>
                                                    <?php if(is_null($dossiers_rehab_doc['document'])): ?>
                                                    <span type_document="<?php echo e($dossiers_rehab_doc['type_document']); ?>" class="download_depot_date" style="color:gray">Aucun fichier importé</span>
                                                    <?php else: ?>
                                                    <span type_document="<?php echo e($dossiers_rehab_doc['type_document']); ?>" class="download_depot_date" style="color:black"><?php echo e($dossiers_rehab_doc['document']->formated_created_at()); ?> - <span style="color:coral"><?php echo e($dossiers_rehab_doc['document']->user->organisme_ste); ?> <span></span>
                                                            <?php endif; ?>
                                                </td>

                                                <td>
                                                    <?php if(Auth::user()->has_role($dossiers_rehab_doc['w_roles']) && $dossiers_rehab_doc['active']==1): ?>
                                                    <button type_document="<?php echo e($dossiers_rehab_doc['type_document']); ?>" file_type="<?php echo e($dossiers_rehab_doc['file_type']); ?>" type="button" class="btn btn-light upload_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if(is_null($dossiers_rehab_doc['document'])): ?>
                                                    <button type_document="<?php echo e($dossiers_rehab_doc['type_document']); ?>" file_id="" disabled type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download "></i>&nbsp;Télécharger</button>
                                                    <?php else: ?>
                                                    <button type_document="<?php echo e($dossiers_rehab_doc['type_document']); ?>" file_id="<?php echo e($dossiers_rehab_doc['document']->id); ?>" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>


                                </div>
                            </div>

                            <h6>Autorisation</h6>
                            <div class="row <?php echo e($autorisation_doc['active']==1?'':'disabled_tr'); ?>">
                                <div class="col-md-4 col-12">
                                    <div style="background: #f8f8f8; padding: 8px; border: 1px silver dashed; border-radius: 8px;">
                                        <div>
                                            <?php if(is_null($autorisation_doc['document'])): ?>
                                            <i type_document="<?php echo e($autorisation_doc['type_document']); ?>" style="font-size: 2rem; display: block; margin: auto; text-align: center;color: gray; border-bottom: 1px silver dashed; padding: 8px;" class="fa-solid fa-file-circle-xmark upload_doc_icon"></i>
                                            <?php else: ?>
                                            <i type_document="<?php echo e($autorisation_doc['type_document']); ?>" style="font-size: 2rem; display: block; margin: auto; text-align: center;color: #68a334; border-bottom: 1px silver dashed; padding: 8px;" class="fa-solid fa-file-circle-check upload_doc_icon"></i>
                                            <span style="width: 100%; display: block; text-align: center;"> Etat de la validation :
                                                <span style="font-weight:bold;color:<?php echo e($autorisation_doc['document']->decision_color()); ?>"> - <?php echo e($autorisation_doc['document']->decision_full()); ?></span>
                                            </span>
                                            <?php endif; ?>
                                            <?php if(is_null($autorisation_doc['document'])): ?>
                                            <b type_document="<?php echo e($autorisation_doc['type_document']); ?>" class="mt-2 upload_doc_no_file_label" style="color:gray;display: block; margin: auto;text-align: center;">Aucun fichier importé </b>
                                            <?php endif; ?>
                                            <div style="margin: auto; display: block;text-align: center;">
                                                <?php if(Auth::user()->has_role($autorisation_doc['w_roles'])): ?>
                                                <button type_document="<?php echo e($autorisation_doc['type_document']); ?>" file_type="<?php echo e($autorisation_doc['file_type']); ?>" type="button" class="btn btn-light upload_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                                                <?php endif; ?>
                                                <?php if(is_null($autorisation_doc['document'])): ?>
                                                <button disabled type_document="<?php echo e($autorisation_doc['type_document']); ?>" file_id="" type="button" class="btn btn-success download_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Télécharger</button>
                                                <?php else: ?>
                                                <button type_document="<?php echo e($autorisation_doc['type_document']); ?>" file_id="<?php echo e($autorisation_doc['document']->id); ?>" type="button" class="btn btn-success download_doc_link"> <i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                                                <?php endif; ?>
                                            </div>


                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-4 col-12">
                                    <div class="row">
                                        <div class="col-12">
                                            <b style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Date de l'autorisation</b>
                                            <?php if(is_null($autorisation_doc['document'])): ?>
                                            <b type_document="<?php echo e($autorisation_doc['type_document']); ?>" class="mt-1 download_doc_date" style="color:gray;display: block; margin: auto;text-align: center;">Aucun fichier importé </b>
                                            <?php else: ?>
                                            <b type_document="<?php echo e($autorisation_doc['type_document']); ?>" class="mt-1 download_doc_date" style="color:black;display: block; margin: auto;text-align: center;"><?php echo e($autorisation_doc['document']->formated_date_document()); ?></b>
                                            <?php endif; ?>
                                        </div>
                                        <div class="col-12 mt-3">
                                            <b style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Date de dépot</b>
                                            <?php if(is_null($autorisation_doc['document'])): ?>
                                            <b type_document="<?php echo e($autorisation_doc['type_document']); ?>" class="mt-1 download_depot_date" style="color:gray;display: block; margin: auto;text-align: center;">Aucun fichier importé </b>
                                            <?php else: ?>
                                            <b type_document="<?php echo e($autorisation_doc['type_document']); ?>" class="mt-1 download_depot_date" style="color:black;display: block; margin: auto;text-align: center;"><?php echo e($autorisation_doc['document']->formated_created_at()); ?></b>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <div class="card card-refresh mt-2">
                            <div class="refresh-container">
                                <div class="loader-pendulums"></div>
                            </div>
                            <div class="card-header card-header-action">
                                <h5 style="margin: 2px !important;color: #2273ae;font-size: 15px;">Avancement des travaux</h5>
                                <div class="d-flex align-items-center card-action-wrap">
                                    <a class="inline-block mr-15" data-toggle="collapse" href="#collapse_3" aria-expanded="true">
                                        <i class="zmdi zmdi-chevron-down"></i>
                                    </a>

                                </div>
                            </div>
                            <div id="collapse_3" class="collapse show">
                                <div class="card-body">

                                    <!--------------------------------------------------------------------25----------------------------------------------------------------- -->
                                    <h6 style="font-size: 0.85rem; font-weight: 500; color: #c72b2b;"><i class="fa-solid fa-check"></i>&nbspAvancement de 25%</h6>
                                    <table class="table rtable datatables table-striped no-footer display nowrap mb-0">
                                        <thead>
                                            <th>Document</th>
                                            <th>Type du fichier</th>
                                            <th>Date dépôt</th>

                                            <th></th>
                                            <th></th>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $dossiers_rehab_avancement_25_docs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c_doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><i class="fa-solid fa-file-pdf"></i>&nbsp<?php echo e($c_doc['name']); ?>

                                                    <?php if($c_doc['document']!=null && $c_doc['validation']==1): ?>
                                                    <span style="font-weight:bold;color:<?php echo e($c_doc['document']->decision_color()); ?>"> - <?php echo e($c_doc['document']->decision_full()); ?></span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>Fichier <?php echo e(strtoupper($c_doc['file_type'])); ?></td>
                                                <td>
                                                    <?php if(is_null($c_doc['document'])): ?>
                                                    <span type_document="<?php echo e($c_doc['type_document']); ?>" class="download_depot_date" style="color:gray">Aucun fichier importé</span>
                                                    <?php else: ?>
                                                    <span type_document="<?php echo e($c_doc['type_document']); ?>" class="download_depot_date" style="color:black"><?php echo e($c_doc['document']->formated_created_at()); ?> - <span style="color:coral"><?php echo e($c_doc['document']->user->organisme_ste); ?> <span></span>
                                                            <?php endif; ?>
                                                </td>

                                                <td>
                                                    <?php if(Auth::user()->has_role($c_doc['w_roles']) && $c_doc['active']==1): ?>
                                                    <button type_document="<?php echo e($c_doc['type_document']); ?>" file_type="<?php echo e($c_doc['file_type']); ?>" type="button" class="btn btn-light upload_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if(is_null($c_doc['document'])): ?>
                                                    <button type_document="<?php echo e($c_doc['type_document']); ?>" file_id="" disabled type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download "></i>&nbsp;Télécharger</button>
                                                    <?php else: ?>
                                                    <button type_document="<?php echo e($c_doc['type_document']); ?>" file_id="<?php echo e($c_doc['document']->id); ?>" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>

                                    <div class="row">
                                        <?php $__currentLoopData = $dossiers_rehab_avancement_25_photos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photos_group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <h6 style="font-size: 0.8rem; margin-left: 8px; color: #797979;"><?php echo e($photos_group['name']); ?></h6>
                                        <div class="col-6">
                                            <button type_document="<?php echo e($photos_group['type_document']); ?>" type="button" class="btn btn-light upload_photo_link"> <i class="fa-solid fa-plus"></i>&nbsp;Ajouter</button>
                                            <button type_document="<?php echo e($photos_group['type_document']); ?>" type="button" disabled class="btn btn-danger delete_photo_link"> <i class="fa-solid fa-trash"></i>&nbsp;Supprimer</button>
                                        </div>
                                        <div id="photos_<?php echo e($photos_group['type_document']); ?>" class="phototheque hk-gallery " type_document="<?php echo e($photos_group['type_document']); ?>" style="width: 100%;border-radius:6px;border:1px #949494 solid;height:120px;overflow-x: auto;white-space: nowrap;padding:4px">
                                            <?php $__currentLoopData = $photos_group['photos']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a class="costume-img" href="<?php echo e($photo->documentUrl()); ?>" style="margin: 0px;">
                                                <img data-src="<?php echo e($photo->documentUrl()); ?>" style="border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="<?php echo e($photo->documentUrl()); ?>" class="gallery-img costume-img hk-gallery">
                                                </br>
                                                <input item_id="<?php echo e($photo->id); ?>" type_document="<?php echo e($photos_group['type_document']); ?>" class="select_photo_cb" style="margin: auto;display: block;position: relative;" type="checkbox">
                                            </a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>



                                    <!--------------------------------------------------------------------50----------------------------------------------------------------- -->
                                    <h6 style="font-size: 0.85rem; font-weight: 500; color: #c72b2b;"><i class="fa-solid fa-check"></i>&nbspAvancement de 50%</h6>
                                    <table class="table rtable datatables table-striped no-footer display nowrap mb-0">
                                        <thead>
                                            <th>Document</th>
                                            <th>Type du fichier</th>
                                            <th>Date dépôt</th>
                                            <th></th>
                                            <th></th>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $dossiers_rehab_avancement_50_docs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c_doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><i class="fa-solid fa-file-pdf"></i>&nbsp<?php echo e($c_doc['name']); ?>

                                                    <?php if($c_doc['document']!=null && $c_doc['validation']==1): ?>
                                                    <span style="font-weight:bold;color:<?php echo e($c_doc['document']->decision_color()); ?>"> - <?php echo e($c_doc['document']->decision_full()); ?></span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>Fichier <?php echo e(strtoupper($c_doc['file_type'])); ?></td>
                                                <td>
                                                    <?php if(is_null($c_doc['document'])): ?>
                                                    <span type_document="<?php echo e($c_doc['type_document']); ?>" class="download_depot_date" style="color:gray">Aucun fichier importé</span>
                                                    <?php else: ?>
                                                    <span type_document="<?php echo e($c_doc['type_document']); ?>" class="download_depot_date" style="color:black"><?php echo e($c_doc['document']->formated_created_at()); ?> - <span style="color:coral"><?php echo e($c_doc['document']->user->organisme_ste); ?> <span></span>
                                                            <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if(Auth::user()->has_role($c_doc['w_roles']) && $c_doc['active']==1): ?>
                                                    <button type_document="<?php echo e($c_doc['type_document']); ?>" file_type="<?php echo e($c_doc['file_type']); ?>" type="button" class="btn btn-light upload_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if(is_null($c_doc['document'])): ?>
                                                    <button type_document="<?php echo e($c_doc['type_document']); ?>" file_id="" disabled type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download "></i>&nbsp;Télécharger</button>
                                                    <?php else: ?>
                                                    <button type_document="<?php echo e($c_doc['type_document']); ?>" file_id="<?php echo e($c_doc['document']->id); ?>" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>


                                    <div class="row">
                                        <?php $__currentLoopData = $dossiers_rehab_avancement_50_photos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photos_group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <h6 style="font-size: 0.8rem; margin-left: 8px; color: #797979;"><?php echo e($photos_group['name']); ?></h6>
                                        <div class="col-6">
                                            <button type_document="<?php echo e($photos_group['type_document']); ?>" type="button" class="btn btn-light upload_photo_link"> <i class="fa-solid fa-plus"></i>&nbsp;Ajouter</button>
                                            <button type_document="<?php echo e($photos_group['type_document']); ?>" type="button" disabled class="btn btn-danger delete_photo_link"> <i class="fa-solid fa-trash"></i>&nbsp;Supprimer</button>
                                        </div>
                                        <div id="photos_<?php echo e($photos_group['type_document']); ?>" class="phototheque hk-gallery" type_document="<?php echo e($photos_group['type_document']); ?>" style="width: 100%;border-radius:6px;border:1px #949494 solid;height:120px;overflow-x: auto;white-space: nowrap;padding:4px">
                                            <?php $__currentLoopData = $photos_group['photos']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a class="costume-img" href="<?php echo e($photo->documentUrl()); ?>" style="margin: 0px;">
                                                <img data-src="<?php echo e($photo->documentUrl()); ?>" style="border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="<?php echo e($photo->documentUrl()); ?>" class="gallery-img costume-img hk-gallery">
                                                </br>
                                                <input item_id="<?php echo e($photo->id); ?>" type_document="<?php echo e($photos_group['type_document']); ?>" class="select_photo_cb" style="margin: auto;display: block;position: relative;" type="checkbox">
                                            </a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>

                                    <!--------------------------------------------------------------------100----------------------------------------------------------------- -->
                                    <h6 style="font-size: 0.85rem; font-weight: 500; color: #c72b2b;"><i class="fa-solid fa-check"></i>&nbspAchèvement ces travaux</h6>
                                    <table class="table rtable datatables table-striped no-footer display nowrap mb-0">
                                        <thead>
                                            <th>Document</th>
                                            <th>Type du fichier</th>
                                            <th>Date dépôt</th>
                                            <th></th>
                                            <th></th>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $dossiers_rehab_avancement_100_docs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c_doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><i class="fa-solid fa-file-pdf"></i>&nbsp<?php echo e($c_doc['name']); ?>

                                                    <?php if($c_doc['document']!=null && $c_doc['validation']==1): ?>
                                                    <span style="font-weight:bold;color:<?php echo e($c_doc['document']->decision_color()); ?>"> - <?php echo e($c_doc['document']->decision_full()); ?></span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>Fichier <?php echo e(strtoupper($c_doc['file_type'])); ?></td>
                                                <td>
                                                    <?php if(is_null($c_doc['document'])): ?>
                                                    <span type_document="<?php echo e($c_doc['type_document']); ?>" class="download_depot_date" style="color:gray">Aucun fichier importé</span>
                                                    <?php else: ?>
                                                    <span type_document="<?php echo e($c_doc['type_document']); ?>" class="download_depot_date" style="color:black"><?php echo e($c_doc['document']->formated_created_at()); ?> - <span style="color:coral"><?php echo e($c_doc['document']->user->organisme_ste); ?> <span></span>
                                                            <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if(Auth::user()->has_role($c_doc['w_roles']) && $c_doc['active']==1): ?>
                                                    <button type_document="<?php echo e($c_doc['type_document']); ?>" file_type="<?php echo e($c_doc['file_type']); ?>" type="button" class="btn btn-light upload_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php if(is_null($c_doc['document'])): ?>
                                                    <button type_document="<?php echo e($c_doc['type_document']); ?>" file_id="" disabled type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download "></i>&nbsp;Télécharger</button>
                                                    <?php else: ?>
                                                    <button type_document="<?php echo e($c_doc['type_document']); ?>" file_id="<?php echo e($c_doc['document']->id); ?>" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>


                                    <div class="row">
                                        <?php $__currentLoopData = $dossiers_rehab_avancement_100_photos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photos_group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <h6 style="font-size: 0.8rem; margin-left: 8px; color: #797979;"><?php echo e($photos_group['name']); ?></h6>
                                        <div class="col-6">
                                            <button type_document="<?php echo e($photos_group['type_document']); ?>" type="button" class="btn btn-light upload_photo_link"> <i class="fa-solid fa-plus"></i>&nbsp;Ajouter</button>
                                            <button type_document="<?php echo e($photos_group['type_document']); ?>" type="button" disabled class="btn btn-danger delete_photo_link"> <i class="fa-solid fa-trash"></i>&nbsp;Supprimer</button>
                                        </div>
                                        <div id="photos_<?php echo e($photos_group['type_document']); ?>" class="phototheque hk-gallery" type_document="<?php echo e($photos_group['type_document']); ?>" style="width: 100%;border-radius:6px;border:1px #949494 solid;height:120px;overflow-x: auto;white-space: nowrap;padding:4px">
                                            <?php $__currentLoopData = $photos_group['photos']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a class="costume-img" href="<?php echo e($photo->documentUrl()); ?>" style="margin: 0px;">
                                                <img data-src="<?php echo e($photo->documentUrl()); ?>" style="border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="<?php echo e($photo->documentUrl()); ?>" class="gallery-img costume-img hk-gallery">
                                                </br>
                                                <input item_id="<?php echo e($photo->id); ?>" type_document="<?php echo e($photos_group['type_document']); ?>" class="select_photo_cb" style="margin: auto;display: block;position: relative;" type="checkbox">
                                            </a>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>



                    </div>
                </div>

                <div class="col-12 col-md-3">

                    <div class="row" style="background: #f2f2f2; padding: 8px; border-radius: 6px; border: 1px #d2d2d2 solid;">


                        <?php if($mode=='create'): ?>
                        <h6>Noveau dossier</h6>
                        <?php else: ?>
                        <h6>Dossier N° <?php echo e($dossier_rehab->numero); ?></h6>
                        <?php endif; ?>

                        <div class="col-12">
                            <div class="input-group input-group-sm">
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="width: 120px;">Date :</span>
                                    </div>
                                    <?php if($mode=='create'): ?>
                                    <input readonly value="<?php echo e(Carbon\Carbon::now()->format('d/m/Y H:i')); ?>" class="form-control">
                                    <?php else: ?>
                                    <input readonly value="<?php echo e(Carbon\Carbon::createFromFormat('Y-m-d H:i:s',$dossier_rehab->created_at)->format('d/m/Y H:i')); ?>" class="form-control">
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="input-group input-group-sm">
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="width: 120px;">Créé par :</span>
                                    </div>
                                    <?php if($mode=='create'): ?>
                                    <input readonly value="<?php echo e(Auth::user()->nom.' '.Auth::user()->prenom); ?>" class="form-control">
                                    <?php else: ?>
                                    <input readonly value="<?php echo e($dossier_rehab->user->nom.' '.$dossier_rehab->user->prenom); ?>" class="form-control">
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>



                        <h6>Prestataires</h6>

                        <?php if($mode=='create' ): ?>
                        <?php if(Auth::user()->has_role('Laboratoire')): ?>
                        <div class="col-12">
                            <div class="input-group input-group-sm">
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="width: 120px;">Laboratoire :</span>
                                    </div>
                                    <input id="<?php echo e(Auth::user()->id); ?>" role_name="Laboratoire" disabled class="form-control prestataire_fixed" value="<?php echo e(Auth::user()->organisme_ste); ?>">

                                </div>
                            </div>
                        </div>
                        <?php else: ?>
                        <div class="col-12">
                            <div class="input-group input-group-sm">
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="width: 120px;">Laboratoire :</span>
                                    </div>
                                    <select role_name="Laboratoire" class="form-control select2nc prestataire_select">
                                    </select>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>

                        <?php if(Auth::user()->has_role('BET')): ?>
                        <div class="col-12">
                            <div class="input-group input-group-sm">
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="width: 120px;">BET :</span>
                                    </div>
                                    <input id="<?php echo e(Auth::user()->id); ?>" role_name="BET" disabled class="form-control prestataire_fixed" value="<?php echo e(Auth::user()->organisme_ste); ?>">

                                </div>
                            </div>
                        </div>
                        <?php else: ?>
                        <div class="col-12">
                            <div class="input-group input-group-sm">
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="width: 120px;">BET :</span>
                                    </div>
                                    <select role_name="BET" class="form-control select2nc prestataire_select">
                                    </select>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>


                        <?php else: ?>
                        <table class="table table-hover datatables dataTable no-footer display nowrap">
                            <thead>
                                <th>Raison sociale</th>
                                <th>Mission</th>
                            </thead>
                            <tbody>
                                <tr>
                                    <?php if(Auth::user()->role->name=="BET"): ?>
                                    <td style="font-weight: 500; color: #1E85E1;"><a type="Laboratoire" style="color: <?php echo e(!is_null($dossier_rehab->laboratoire)?'#94AC09':'#1E85E1'); ?> !important;" item_id="<?php echo e(is_null($dossier_rehab->laboratoire)?'-':$dossier_rehab->laboratoire->id); ?>" class="prestataire_info_btn" href="javascript:;"><i class="fa-solid fa-building"></i>&nbsp<?php echo e(is_null($dossier_rehab->laboratoire)?'Non spécifié':$dossier_rehab->laboratoire->organisme_ste); ?></a></td>

                                    <?php else: ?>
                                    <td style="font-weight: 500; color: #1a8fb8;"><a type="Laboratoire" style="color: <?php echo e(!is_null($dossier_rehab->laboratoire)?'#94AC09':'#808080'); ?> !important;" item_id="<?php echo e(is_null($dossier_rehab->laboratoire)?'-':$dossier_rehab->laboratoire->id); ?>" class="prestataire_info_btn" href="javascript:;"><i class="fa-solid fa-building"></i>&nbsp<?php echo e(is_null($dossier_rehab->laboratoire)?'Non spécifié':$dossier_rehab->laboratoire->organisme_ste); ?></a></td>

                                    <?php endif; ?>
                                    <td>Laboratoire</td>
                                </tr>
                                <tr>
                                    <td style="font-weight: 500; color: #1a8fb8;"><a item_id="<?php echo e(is_null($dossier_rehab->bet)?'-':$dossier_rehab->bet->id); ?>" class="prestataire_info_btn" href="javascript:;"><i class="fa-solid fa-building"></i>&nbsp<?php echo e(is_null($dossier_rehab->bet)?'-':$dossier_rehab->bet->organisme_ste); ?></a></td>
                                    <td>Bureau d'études</td>
                                </tr>

                            </tbody>
                        </table>
                        <?php endif; ?>

                        <?php if($mode!='create'): ?>
                        <h6>Traitement</h6>
                        <div class="row ml-2 m-step success">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Saisie de la demande</b>
                            </div>
                        </div>

                        <div class="row mt-2" style="width: 100%;">
                            <div class="col-12 mb-2 m-step-af <?php echo e($dossier_rehab->check_step_in_log('AIDE_FRONTALE_1')?'success':'pending'); ?>">
                                <div class="row ml-2 m-step <?php echo e($dossier_rehab->check_step_in_log('AIDE_FRONTALE_1')?'success':'pending'); ?>" style="text-align: center; width: 100%; display: block;">
                                    <div>
                                        <i class="pending-icon fa-regular fa-clock"></i>
                                        <i class="success-icon fa-solid fa-check"></i>
                                        <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                        <b class="ml-1">Aide frontale N°1</b>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row ml-2 m-step <?php echo e($dossier_rehab->check_step_in_log('AVANCEMENT_25')?'success':'pending'); ?>">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Avancement de 25%</b>
                            </div>
                        </div>


                        <div class="row mt-2" style="width: 100%;">
                            <div class="col-12 mb-2 m-step-af <?php echo e($dossier_rehab->check_step_in_log('AIDE_FRONTALE_2')?'success':'pending'); ?>">
                                <div class="row ml-2 m-step <?php echo e($dossier_rehab->check_step_in_log('AIDE_FRONTALE_2')?'success':'pending'); ?>" style="text-align: center; width: 100%; display: block;">
                                    <div>
                                        <i class="pending-icon fa-regular fa-clock"></i>
                                        <i class="success-icon fa-solid fa-check"></i>
                                        <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                        <b class="ml-1">Aide frontale N°2</b>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row ml-2 m-step <?php echo e($dossier_rehab->check_step_in_log('AVANCEMENT_50')?'success':'pending'); ?>">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Avancement de 50% </b>
                            </div>
                        </div>


                        <div class="row mt-2" style="width: 100%;">
                            <div class="col-12 mb-2 m-step-af <?php echo e($dossier_rehab->check_step_in_log('AIDE_FRONTALE_3')?'success':'pending'); ?>">
                                <div class="row ml-2 m-step <?php echo e($dossier_rehab->check_step_in_log('AIDE_FRONTALE_3')?'success':'pending'); ?>" style="text-align: center; width: 100%; display: block;">
                                    <div>
                                        <i class="pending-icon fa-regular fa-clock"></i>
                                        <i class="success-icon fa-solid fa-check"></i>
                                        <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                        <b class="ml-1">Aide frontale N°3</b>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row ml-2 m-step <?php echo e($dossier_rehab->check_step_in_log('AVANCEMENT_100')?'success':'pending'); ?>">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <i class="success-icon fa-solid fa-check"></i>
                                <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                <b class="ml-1">Achèvement des travaux</b>
                            </div>
                        </div>
                        <div class="row mt-2" style="width: 100%;">
                            <div class="col-12 mb-2 m-step-af <?php echo e($dossier_rehab->check_step_in_log('AIDE_FRONTALE_4')?'success':'pending'); ?>">
                                <div class="row ml-2 m-step <?php echo e($dossier_rehab->check_step_in_log('AIDE_FRONTALE_4')?'success':'pending'); ?>" style="text-align: center; width: 100%; display: block;">
                                    <div>
                                        <i class="pending-icon fa-regular fa-clock"></i>
                                        <i class="success-icon fa-solid fa-check"></i>
                                        <i class="error-icon fa-solid fa-circle-exclamation"></i>
                                        <b class="ml-1">Aide frontale N°4</b>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <?php endif; ?>

                        <?php if(Auth::user()->has_role("BET,Laboratoire")): ?>
                        <button id="save_btn" style="width: 100%; background: #fcfcfc  !important; border: 1px #a1a1a1 solid !important;" type="button" class="btn mt-2">
                            <span style="display: none;" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                            Enregistrer
                        </button>
                        <?php endif; ?>
                        <?php if($mode!='create'): ?>
                       



                        <h6>Conversion en dossier de reconstruction</h6>

                        <?php if(Auth::user()->has_role('BET')): ?>
                        <?php if($dossier_rehab->pending_conversion==0): ?>
                        <button id="request_conversion_btn" type="button" class="btn btn-warning" style="width: 100%;">
                            <i class="fa-solid fa-repeat"></i>&nbspDemander la conversion
                        </button>
                        <?php else: ?>
                        <div class="row ml-2 m-step pending" style="color:#b86600">
                            <div>
                                <i class="pending-icon fa-regular fa-clock"></i>
                                <b class="ml-1">Demande de conversion en cours</b>
                            </div>
                        </div>
                        <?php endif; ?>
                        <?php endif; ?>

                        <?php if(Auth::user()->has_role('Administrateur')): ?>
                        <?php if($dossier_rehab->pending_conversion==1): ?>
                        <p>&nbsp&nbsp&nbsp<i class="fa-solid fa-circle-info"></i>&nbspUne demande de conversion en dossier de reconstruction à été soumise le <?php echo e($dossier_rehab->formated_conversion_request_date()); ?></p>
                        <hr style="width: 100%;">
                        <div class="row ml-2 " style="width: 100%;">
                            <div class="col-md-6 col-12">
                                <button id="switch_reconstruction_btn" type="button" class="btn btn-warning" style="width: 100%;">
                                    <i class="fa-solid fa-repeat"></i>&nbspAccepter
                                </button>
                            </div>
                            <div class="col-md-6 col-12">
                                <button id="deny_reconstruction_conversion_btn" type="button" class="btn btn-danger" style="width: 100%;">
                                    <i class="fa-solid fa-repeat"></i>&nbspRefuser
                                </button>
                            </div>
                        </div>
                        <?php else: ?>
                        <p>&nbsp&nbsp&nbsp<i class="fa-solid fa-circle-info"></i>&nbspAucune demande de conversion.</p>

                        <?php endif; ?>
                        <?php endif; ?>

                        <?php if(Auth::user()->has_role('Administrateur')): ?>
                        <h6>Suppression de dossier</h6>
                        <button id="delete_btn" type="button" class="btn btn-danger" style="width: 100%;">
                            <i class="fa-solid fa-trash"></i>&nbspSupprimer le dossier
                        </button>
                        <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="tab-pane fade" id="verification" role="tabpanel" aria-labelledby="verification-tab">
            <?php if(Auth::user()->has_role("Vérificateur,Administrateur") && $mode!='create'): ?>
            <?php echo $__env->make('dossiers_rehab/verification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        </div>
    </div>

    <?php echo $__env->make('dossiers_rehab.modals', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php if(Auth::user()->has_role("Vérificateur") && $mode!='create'): ?>
    <?php echo $__env->make('dossiers_rehab.modals_verification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
    <?php $__env->stopSection(); ?>

    <?php $__env->startPush('added_scripts'); ?>
    <script src="<?php echo e(asset('js/dossiers_rehab/show.js').'?t='.time()); ?>"></script>
    <script src="<?php echo e(asset('js/dossiers_rehab/petitionnaire_modal.js').'?t='.time()); ?>"></script>
    <?php if(Auth::user()->has_role('Vérificateur,Administrateur')): ?>
    <script src="<?php echo e(asset('js/dossiers_rehab/verification.js').'?t='.time()); ?>"></script>
    <?php endif; ?>

    <script>
        var provinces = <?php echo json_encode($provinces, JSON_PRETTY_PRINT, 512) ?>;
        var cercles = <?php echo json_encode($cercles, JSON_PRETTY_PRINT, 512) ?>;
        var communes = <?php echo json_encode($communes, JSON_PRETTY_PRINT, 512) ?>;
        var douars = <?php echo json_encode($douars, JSON_PRETTY_PRINT, 512) ?>;

        <?php if($dossier_rehab != null): ?>
        var dossier_rehab = <?php echo json_encode($dossier_rehab, JSON_PRETTY_PRINT, 512) ?>;
        <?php else: ?>
        var dossier_rehab = {};
        <?php endif; ?>
        $(document).ready(function() {
            for (var i = 0; i < dossier_rehab.petitionnaires.length; i++) {
                petitionnaires_add(dossier_rehab.petitionnaires[i]);
            }
        });
    </script>

    <?php if(Auth::user()->has_role("Vérificateur,Administrateur") && $mode!='create'): ?>
    <script>
        $(document).ready(function() {
            for (var i = 0; i < dossier_rehab.petitionnaires.length; i++) {
                v_petitionnaires_add(dossier_rehab.petitionnaires[i]);
            }
        });
    </script>
    <?php endif; ?>
    <?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/batirc6/public_html/resources/views/dossiers_rehab/show.blade.php ENDPATH**/ ?>