<?php $__env->startSection('added_css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/datatable/datatables.min.css')); ?>" />
<link rel="stylesheet" type="text/css" href="<?php echo e(asset('chart.js/dist/Chart.min.css')); ?>">
<script src="<?php echo e(asset('chart.js/dist/Chart.js')); ?>"></script>
<style>
    .m-footer {
        color: #ff1308 !important;
        font-weight: 600;
    }

    .small-box>.inner {
        padding: 0.75rem;
    }

    .small-box {
        margin-bottom: 10px;
    }

    .text-styling {
        font-size: 14px;
        color: #000;
    }

    .text-center {
        font-size: 14px;
        color: #000;
    }

    .table>thead>tr>th {
        background: #e8e8e8;
        color: #000000 !important;
        font-weight: 400;
        padding-left: 8px;
        border-bottom: 1px #cbcbcb solid !important;
        text-transform: uppercase;
        font-weight: 500;
        font-size: 0.70rem;
    }

    .m-thead {
        font-family: Lato;
        font-weight: 700 !important;
        font-size: 15px !important;
    }

    .m-thead-mobile {
        font-family: Lato;
        font-weight: 600 !important;
        font-size: 13px !important;
    }

    .costume-img-2 {
        max-width: unset !important;
        width: auto;
        margin: 2px 4px !important;
        /* height: 260px; */
        background-size: cover;
        background-position: center;
        background-repeat: no-repeat;
        /* display: inline-block; */
        float: none;
        border-radius: 4px;
        transition: transform 0.2s, 0.35s ease-in-out !important;
        cursor: pointer;
    }

    .photo_side_bar {
        background: #fdfdfd;
        width: 40%;
        position: fixed;
        right: -55%;
        height: 100%;
        z-index: 9999999999;
        box-shadow: 0px 10px 30px 0px rgb(0 0 0 / 30%);
        transition: all 0.35s;
        opacity: 0;
        top: 45px;
    }

    .photo_side_bar.active {
        right: 0px;
        opacity: 1;
    }

    [type=radio]:checked+label,
    [type=radio]:not(:checked)+label {
        font-weight: 300;
        position: relative;
        padding-left: 35px;
        cursor: pointer;
        display: inline-block;
        height: 25px;
        line-height: 25px;
        -webkit-transition: .28s ease;
        -o-transition: .28s ease;
        transition: .28s ease;
        -webkit-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none;
        font-size: 14px;
        font-weight: 400;
    }

    .document_preview_modal {
        width: 60%;
        height: 90%;
        background: #f2f2f2;
        position: fixed;
        z-index: 999999999999;
        left: -20%;
        top: 80%;
        pointer-events: none;
        opacity: 0;
        border-radius: 8px;
        border: 1px gray solid;
        box-shadow: 1px 3px 16px 8px rgb(0 0 0 / 13%) !important;
        transform: scale(0.15);
        transition: all 0.35s ease-in-out !important;
    }

    .document_preview_modal.active {
        transform: scale(1);
        pointer-events: all;
        opacity: 1;
        left: 20%;
        top: 20px;

    }

    .document_preview_modal_close>i {
        font-size: 20px;
        position: absolute;
        right: 12px;
        top: 12px;
        transition: all 0.2s, 0.15s ease-in-out !important;
    }

    .document_preview_modal_close>i:hover {
        font-size: 20px;
        position: absolute;
        right: 12px;
        top: 12px;
        color: red;
        cursor: pointer;
    }

    .document_preview_modal>iframe {
        height: calc(100% - 60px);
        display: block;
        width: calc(100% - 40px);
        border: 1px #d5d5d5 solid;
        margin: 50px 20px 30px 20px;
        border-radius: 8px;
        box-shadow: 1px 3px 9px 0px rgb(0 0 0 / 13%) !important;
    }

    .document_preview_modal>span {
        position: absolute;
        top: 12px;
        left: 20px;
        font-weight: 500;
        font-size: 14px;
    }

    .document_preview_modal_loader {
        position: absolute;
        top: calc(50% - 50px);
        height: 100px;
        width: 100px;
        left: calc(50% - 50px);
        opacity: 0;
        transition: all 0.25s, 0.25s ease-in-out !important;
        pointer-events: none;
    }

    .document_preview_modal_loader.active {

        opacity: 1;

    }

    .document_preview_modal_doc {
        opacity: 0;
        pointer-events: none;
        transition: all 0.25s, 0.25s ease-in-out !important;
    }

    .document_preview_modal_doc.active {
        opacity: 1;
        pointer-events: all;

    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="document_preview_modal">
    <div class="document_preview_modal_close">
        <i class="fa-solid fa-xmark"></i>
    </div>
    <span><i class="fa-solid fa-file-pdf"></i><span class="document_preview_modal_title">DOUCMENT</span></span>
    <iframe class="document_preview_modal_doc" scr=""></iframe>

    <div class="document_preview_modal_loader active">
        <img src="/images/loader/motion-blur-2.svg">
    </div>
</div>
<div style="padding-top: 16px;margin-left: 8px">
    <div class="row">
        <div class="col-9">
            <nav class="hk-breadcrumb" aria-label="breadcrumb">
                <ol class="breadcrumb breadcrumb-light bg-transparent">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('projets')); ?>">Projets</a></li>
                    <li class="breadcrumb-item " aria-current="page">Projet : <?php echo e($projet->nom); ?></li>
                </ol>
            </nav>


            <?php echo $__env->make('projets.situation_projet', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php echo $__env->make('projets.details_etat_avancement', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php echo $__env->make('projets.details_stock', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <div class="col-12 col-md-3 " style="padding-top: 8px;">
            <div class="row" style="background: #f2f2f2; padding: 8px; border-radius: 6px; border: 1px #d2d2d2 solid;">
                <i style="text-align: center; margin: auto; font-size:20px; color: #d07979;" class="fa-regular fa-building-circle-arrow-right"></i>
                <b class="mt-2" style="font-size: 0.8rem;color: #2273ae;width:100%;text-align: center;">Projet : <?php echo e($projet->nom); ?></b>

                <div class="col-12 mt-4">
                    <div class="input-group input-group-sm">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 120px;">Promoteur :</span>
                            </div>
                            <input readonly class="form-control" value="<?php echo e($projet->promoteur->societe); ?>">
                        </div>
                    </div>
                </div>

                <div class="col-12 mt-1">
                    <div class="input-group input-group-sm">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 120px;">Nbr Immeubles :</span>
                            </div>
                            <input readonly class="form-control" value="<?php echo e($projet->immeubles->count()); ?>">
                        </div>
                    </div>
                </div>

                <div class="col-12 mt-1">
                    <div class="input-group input-group-sm">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 120px;">Nbr Appartements :</span>
                            </div>
                            <input readonly class="form-control" value="<?php echo e($projet->appartements->count()); ?>">
                        </div>
                    </div>
                </div>

                <div class="col-12 mt-1">
                    <div class="input-group input-group-sm">
                        <div class="input-group mb-1">
                            <div class="input-group-prepend">
                                <span class="input-group-text" style="width: 120px;">Taux affectation :</span>
                            </div>
                            <div class="progress mb-1" style="width: 65%;margin-top: 6px;">
                                <div class="progress-bar bg-info" role="progressbar" style="width: <?php echo e($taux_affectation); ?>%;" aria-valuenow="<?php echo e($taux_affectation); ?>" aria-valuemin="0" aria-valuemax="100"> <span style="float: right;"><?php echo e($taux_affectation); ?>%</span></div>
                            </div>
                        </div>
                    </div>
                </div>


                <h6>Traitement</h6>
                <div class="row ml-2 m-step <?php echo e($projet->specific_document('OUVERTURE_CHANTIER')?'success':'pending'); ?>">
                    <div>
                        <i class="pending-icon fa-regular fa-clock"></i>
                        <i class="success-icon fa-solid fa-check"></i>
                        <i class="error-icon fa-solid fa-circle-exclamation"></i>
                        <b class="ml-1">Ouverture du chantier</b>
                    </div>
                </div>

                <div class="row ml-2 m-step <?php echo e($projet->specific_document('RECEPTION_PROVISOIRE')?'success':'pending'); ?>">
                    <div>
                        <i class="pending-icon fa-regular fa-clock"></i>
                        <i class="success-icon fa-solid fa-check"></i>
                        <i class="error-icon fa-solid fa-circle-exclamation"></i>
                        <b class="ml-1">Réception provisoire</b>
                    </div>
                </div>

                <div class="row ml-2 m-step <?php echo e($projet->specific_document('TR_ECLATEMENT_TITRES_1') ?'success':'pending'); ?>">
                    <div>
                        <i class="pending-icon fa-regular fa-clock"></i>
                        <i class="success-icon fa-solid fa-check"></i>
                        <i class="error-icon fa-solid fa-circle-exclamation"></i>
                        <b class="ml-1">Eclatement des titres fonciers</b>
                    </div>
                </div>

                <div class="row ml-2 m-step <?php echo e($projet->specific_document('TR_PERMIS_HABITER1') ?'success':'pending'); ?>">
                    <div>
                        <i class="pending-icon fa-regular fa-clock"></i>
                        <i class="success-icon fa-solid fa-check"></i>
                        <i class="error-icon fa-solid fa-circle-exclamation"></i>
                        <b class="ml-1">Permis d'habiter</b>
                    </div>
                </div>


                <?php if(Auth::user()->has_role('promoteur,admin')): ?>
                <button id="save_projet" style="width: 100%; background: #fcfcfc  !important; border: 1px #a1a1a1 solid !important;" type="button" class="btn mt-2">
                    <span style="display: none;" class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                    Enregistrer
                </button>
                <?php endif; ?>
            </div>


        </div>
    </div>
</div>
<?php echo $__env->make('projets.modals_show', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('added_scripts'); ?>
<script>
    var projet = <?php echo json_encode($projet, 15, 512) ?>;
    var provinces = <?php echo json_encode($provinces, 15, 512) ?>;
    var arrondissements = <?php echo json_encode($arrondissements, 15, 512) ?>;
    var annexes_administratives = <?php echo json_encode($annexes_administratives, 15, 512) ?>;
    var douars = <?php echo json_encode($douars, 15, 512) ?>;

      $("body").on("click", '.document_preview_img', function() {
        $(".document_preview_modal_loader").addClass("active");
        $(".document_preview_modal_doc").removeClass("active");
        var document = $(this).attr('document');
        var title = $(this).attr('title');
        $(".document_preview_modal").addClass("active");
        $(".document_preview_modal_title").text(title);

        setTimeout(function() {

            $('.document_preview_modal_doc')[0].contentWindow.location.replace(document);
            $(".document_preview_modal_loader").removeClass("active");
            $(".document_preview_modal_doc").addClass("active");
        }, 1500);

    });

    $(".document_preview_modal_close").click(function() {
        $(".document_preview_modal").removeClass("active");
    });
</script>
<script src="<?php echo e(asset('js/projets/show.js').'?t='.time()); ?>"></script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vsbcasa/public_html/resources/views/projets/show.blade.php ENDPATH**/ ?>