<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="_token" content="<?php echo e(csrf_token()); ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
    <meta http-equiv="cache-control" content="private, max-age=0, no-cache">
    <meta http-equiv="pragma" content="no-cache">
    <meta http-equiv="expires" content="0">
    <link rel="icon" href="<?php echo e(asset('images/favicon.png')); ?>">
    <title><?php echo e(config('app.name')); ?></title>
    <?php echo $__env->make('inc.css_links', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <style>
        .form-group {
            margin-bottom: 1rem !important;
        }

        @font-face {
            font-family: Lato;
            src: url("<?php echo e(asset(' fonts/Lato/lato-v11-latin-ext_latin-700.ttf')); ?>");
        }


        @font-face {
            font-family: Roboto-Condensed;
            src: url("<?php echo e(asset(' fonts/roboto/RobotoCondensed-Regular.ttf')); ?>");
        }


        @font-face {
            font-family: Lato2;
            src: url("<?php echo e(asset(' fonts/Lato/lato-v11-latin-ext_latin-regular.ttf')); ?>");
        }

        .lato-bold {
            font-family: 'Lato2';
            font-weight: bold;
        }

        body,
        h1,
        h2,
        h3,
        h4,
        h5,
        h6 {
            font-family: 'Roboto-Condensed', 'Lato2';

        }

        label {
            font-family: 'Roboto-Condensed', 'Lato2';
            font-weight: bold;
        }

        .nav-tabs {
            font-family: 'Roboto-Condensed', 'Lato2' !important;
            font-weight: bold;
        }


        .table th,
        .table thead th {
            font-family: Lato;
            font-weight: 600;
            font-size: 13px;
        }

        .btn {
            font-family: Lato, 'Lato2';
            font-weight: bold;
            font-size: 12px;
        }

        .form-control {
            height: 35px !important;
        }

        .btn {
            font-size: 15px;
        }
    </style>
</head>

<body class="hold-transition login-page" style="background: rgb(228,228,228);background: linear-gradient(354deg, rgba(228,228,228,1) 0%, rgba(255,255,255,1) 100%);">

    <div class="container h-p100" style="margin-top:10% !important;border:0 !important;background: none !important;max-width: none !important;">
        <div class="row align-items-center justify-content-md-center h-p100">
            <div class="col-lg-5 col-md-5 col-12">
                <div class="login-box">
                    <div class="login-box-body" style="border-radius: 8px;">
                        <div class="row ">

                            <div class="col-12">
                                <img style="height: 140px;margin: auto;display: block;" src="<?php echo e(asset('images/logo/logo_app_ns.svg')); ?>" alt="">
                            </div>


                        </div>

                        <br>
                        <h5 class="login-box-msg mt-3 " style="padding-top:1rem;border-top: 1px #adadad dashed;line-height: 1.5rem;font-family: 'Roboto';color: #949494 !important;">Bienvenue sur la Plateforme Bâtir. Pour finaliser votre inscription, veuillez créer un mot de passe pour votre compte : <br> <strong style="color: #ca3d3d; text-decoration: underline; font-weight: 400; font-family: 'Roboto';"><?php echo e($user->email); ?></strong>.</h5>
                        <br>


                        <div class="form-group has-feedback">
                            <input style="font-family: 'Roboto';" id="password" type="password" class="form-control rounded" placeholder="Mot de passe" name="password" required>
                            <span class="ion ion-email form-control-feedback"><i class="fa fa-key"></i></span>

                        </div>
                        <div class="form-group has-feedback">
                            <input style="font-family: 'Roboto';" id="password_confirmation" type="password" class="form-control rounded" placeholder="Confirmation" name="password_confirmation" required>
                            <span class="ion ion-email form-control-feedback"><i class="fa fa-key"></i></span>
                        </div>
                        <div class="row">
                            <div class="col-12 text-center">
                                <button id="save_btn" style="border-radius: 6px !important; background: #29ABE2 !important; color: white; font-weight: 400 !important; font-family: 'Roboto'; text-decoration: none;" type="submit" class="btn "><i class="fa-solid fa-floppy-disk"></i>&nbspEnregistrer</button>

                             </div>
                        </div>

                    </div>
                    <!-- /.login-box-body -->
                </div>
                <!-- /.login-box -->
            </div>
        </div>

    </div>

    <?php echo $__env->make('inc.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script>
        var user_id = '<?php echo e($user->id); ?>';
        var token = '<?php echo e($token); ?>';

        $("#save_btn").click(function() {
            var csrfToken = document.querySelector('meta[name="_token"]').getAttribute("content");
            $.ajax({
                url: '/invitation-save-pwd',
                type: 'post',
                data: {
                    _token: csrfToken,
                    user_id: user_id,
                    token: token,
                    password: $("#password").val(),
                    password_confirmation: $("#password_confirmation").val(),
                },
                success: function(response) {
                    if (response.success == 0) {
                        Swal.fire({
                            icon: 'error',
                            title: 'TamkinInvest',
                            text: response.message,
                        })
                    } else {
                        location.href = "<?php echo e(url('/dashboard')); ?>";
                    }
                }
            });
        });
    </script>
</body>

</html><?php /**PATH /home/u207500317/domains/tamkininvest.ma/public_html/resources/views/invitation/show.blade.php ENDPATH**/ ?>