<div class="row mt-2">
    <div class="col-12">
        <div class="card">
            <div class="card-body">
                <h6 class="card-title"><i class="fa-solid fa-file-contract mr-1"></i>Dossier de permis de construire</h6>


                <table class="table rtable datatables table-striped no-footer display nowrap">
                    <thead>
                        <th>Document</th>
                        <th>Type du fichier</th>
                        <th>Date dépôt</th>
                        <th>Date document</th>
                        <th style="display:none;">Vérification de dépôt</th>
                        <th></th>
                        <th></th>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $permis_construire_documents_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><i class="fa-solid fa-file-pdf"></i>&nbsp<?php echo e($document['name']); ?>

                                <?php if($document['document']!=null && $document['validation']==1): ?>
                                <span style="font-weight:bold;color:<?php echo e($document['document']->decision_color()); ?>"> - <?php echo e($document['document']->decision_full()); ?></span>
                                <?php endif; ?>
                            </td>
                            <td>Fichier <?php echo e(strtoupper($document['file_type'])); ?></td>
                            <td>
                                <?php if(is_null($document['document'])): ?>
                                <span type_document="<?php echo e($document['type_document']); ?>" class="download_depot_date" style="color:gray">Aucun fichier importé</span>
                                <?php else: ?>
                                <span type_document="<?php echo e($document['type_document']); ?>" class="download_depot_date" style="color:black"><?php echo e($document['document']->formated_created_at()); ?> - <span style="color:coral"><?php echo e($document['document']->user->organisme_ste); ?> <span></span>
                                        <?php endif; ?>
                            </td>

                            <td style="display:none;">
                                <?php if(is_null($document['document'])): ?>
                                <span type_document="<?php echo e($document['type_document']); ?>" class="download_depot_date" style="color:gray">Aucun fichier importé</span>
                                <?php else: ?>

                                <a href="javascript:;" document_id="<?php echo e($document['document']->id); ?>" type_document="<?php echo e($document['type_document']); ?>" class="document_decision" style="<?php echo e((Auth::user()->role->name == "Architecte" ?'':'pointer-events:none;text-decoration:none;')); ?>;color:<?php echo e($document['document']->decision_color()); ?> !important"><?php echo e($document['document']->decision_full()); ?></a>
                                <a href="javascript:;" data-toggle="popover" title="Commentaire" data-content="<?php echo e($document['document']->commentaire); ?>" document_id="<?php echo e($document['document']->id); ?>" style="display:<?php echo e(strlen($document['document']->commentaire)>0?'inline-block':'none'); ?>;margin-left:6px;color:darkorange" class="fa-solid fa-comment-dots document_comments"></a>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if(!is_null($document['document'])): ?>
                                <span><?php echo e($document['document']->formated_date_document()); ?> </span>
                                <?php else: ?>
                                <span type_document="<?php echo e($document['type_document']); ?>" style="color:gray">Aucun fichier importé</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if((Auth::user()->has_role($document['w_roles']) && $document['active']==1) || $document['w_roles']=='all'): ?>
                                <button date_doc="<?php echo e($document['date_doc']); ?>" type_document="<?php echo e($document['type_document']); ?>" file_type="<?php echo e($document['file_type']); ?>" type="button" style="background: transparent !important; border: unset; box-shadow: unset !important;" class="btn btn-light upload_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if(is_null($document['document'])): ?>
                                <button type_document="<?php echo e($document['type_document']); ?>" file_id="" disabled style="background: transparent !important; border: unset; box-shadow: unset !important;" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download "></i>&nbsp;Télécharger</button>
                                <?php else: ?>
                                <button type_document="<?php echo e($document['type_document']); ?>" file_id="<?php echo e($document['document']->id); ?>" type="button" style="background: transparent !important; border: unset; box-shadow: unset !important;" class="btn btn-success download_doc_link"><i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>



                <h6>Autorisation de construire</h6>
                <div class="row">
                    <div class="col-md-4 col-12">
                        <div style="background: #f8f8f8; padding: 8px; border: 1px silver dashed; border-radius: 8px;">
                            <div>
                                <?php if(is_null($autorisation_construire_document['document'])): ?>
                                <i type_document="<?php echo e($autorisation_construire_document['type_document']); ?>" style="font-size: 2rem; display: block; margin: auto; text-align: center;color: gray; border-bottom: 1px silver dashed; padding: 8px;" class="fa-solid fa-file-circle-xmark upload_doc_icon"></i>
                                <?php else: ?>
                                <i type_document="<?php echo e($autorisation_construire_document['type_document']); ?>" style="font-size: 2rem; display: block; margin: auto; text-align: center;color: #68a334; border-bottom: 1px silver dashed; padding: 8px;" class="fa-solid fa-file-circle-check upload_doc_icon"></i>

                                <?php endif; ?>

                                <?php if(is_null($autorisation_construire_document['document'])): ?>
                                <b type_document="<?php echo e($autorisation_construire_document['type_document']); ?>" class="mt-2 upload_doc_no_file_label" style="color:gray;display: block; margin: auto;text-align: center;">Aucun fichier importé </b>
                                <?php endif; ?>
                                <div class="mt-1" style="margin: auto; display: block;text-align: center;">
                                    <?php if((Auth::user()->has_role($autorisation_construire_document['w_roles']) && $autorisation_construire_document['active']==1 )|| $document['w_roles']=='all'): ?>
                                    <button type_document="<?php echo e($autorisation_construire_document['type_document']); ?>" file_type="<?php echo e($autorisation_construire_document['file_type']); ?>" type="button" class="btn btn-light upload_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                                    <?php endif; ?>
                                    <?php if(is_null($autorisation_construire_document['document'])): ?>
                                    <button disabled type_document="<?php echo e($autorisation_construire_document['type_document']); ?>" file_id="" type="button" class="btn btn-success download_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Télécharger</button>
                                    <?php else: ?>
                                    <button type_document="<?php echo e($autorisation_construire_document['type_document']); ?>" file_id="<?php echo e($autorisation_construire_document['document']->id); ?>" type="button" class="btn btn-success download_doc_link"> <i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                                    <?php endif; ?>
                                </div>


                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 col-12">
                        <div class="row">
                            <div class="col-12">
                                <b style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Date de l'autorisation</b>
                                <?php if(is_null($autorisation_construire_document['document'])): ?>
                                <b type_document="<?php echo e($autorisation_construire_document['type_document']); ?>" class="mt-1 download_doc_date" style="color:gray;display: block; margin: auto;text-align: center;">Aucun fichier importé </b>
                                <?php else: ?>
                                <b type_document="<?php echo e($autorisation_construire_document['type_document']); ?>" class="mt-1 download_doc_date" style="color:black;display: block; margin: auto;text-align: center;"><?php echo e($autorisation_construire_document['document']->formated_date_document()); ?></b>
                                <?php endif; ?>
                            </div>
                            <div class="col-12 mt-3">
                                <b style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Date de dépot</b>
                                <?php if(is_null($autorisation_construire_document['document'])): ?>
                                <b type_document="<?php echo e($autorisation_construire_document['type_document']); ?>" class="mt-1 download_depot_date" style="color:gray;display: block; margin: auto;text-align: center;">Aucun fichier importé </b>
                                <?php else: ?>
                                <b type_document="<?php echo e($autorisation_construire_document['type_document']); ?>" class="mt-1 download_depot_date" style="color:black;display: block; margin: auto;text-align: center;"><?php echo e($autorisation_construire_document['document']->formated_created_at()); ?></b>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php if(Auth::user()->has_role("admin,moa,chef_projet,entreprise")): ?>
        <div class="card mt-2">
            <div class="card-body">
                <h6 class="card-title"><i class="fa-solid fa-building mr-1"></i>Entreprises et forunisseurs</h6>


                <?php if(Auth::user()->has_role("admin,moa,chef_projet")): ?>
                <div class="row mt-1">
                    <div class="col-12">
                        <div class="row mt-1">
                            <div class="col-6">
                                <?php if(is_null($demande_contrat_enterprise)): ?>
                                <button id="entreprise_table_add_btn" class="btn"><i class="fa-solid fa-circle-plus mr-1"></i>Ajouter</button>

                                <?php endif; ?>

                            </div>
                        </div>

                        <table class="table table-striped datatables dataTable no-footer display nowrap" id="entreprise_table">
                            <thead>
                                <th>Entreprise</th>
                                <th>Ville</th>
                                <th>Téléphone</th>
                                <th>Prix de l'offre</th>
                                <th>Devis</th>
                                <th></th>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>



                <div class="row mt-1" style="border-radius: 6px;border: 1px #e2e2e2 solid;background: #fcfcfc;">
                    <div class="col-12">

                        <h5>• Entreprise retnus : </h5>

                        <?php if(is_null($demande_contrat_enterprise)): ?>
                        <span style="color: gray;">Aucune entreprise n'a été sélectionnée</span>
                        <?php else: ?>
                        <div class="row ">
                            <div class="col-12 col-sm-4">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="width: 100px;">Entreprise :</span>
                                    </div>
                                    <input style="background: unset;border: unset;border-bottom: 1px #ced4da dashed;" readonly="" class="form-control" value="<?php echo e($demande_contrat_enterprise->prestataire->organisme_ste); ?>">
                                </div>
                            </div>

                            <div class="col-12 col-sm-4">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="width: 100px;">Ville :</span>
                                    </div>
                                    <input style="background: unset;border: unset;border-bottom: 1px #ced4da dashed;" readonly="" class="form-control" value="<?php echo e($demande_contrat_enterprise->prestataire->ville->nom); ?>">
                                </div>
                            </div>

                            <div class="col-12 col-sm-4">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="width: 100px;">Téléphone :</span>
                                    </div>
                                    <input style="background: unset;border: unset;border-bottom: 1px #ced4da dashed;" readonly="" class="form-control" value="<?php echo e($demande_contrat_enterprise->prestataire->tel); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="row mt-1">

                            <div class="col-12 col-sm-4">
                                <div class="input-group">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" style="width: 100px;">Honoraire :</span>
                                    </div>
                                    <?php if($demande_contrat_enterprise->etat=="uploaded"): ?>
                                    <input style="background: unset;border: unset;border-bottom: 1px #ced4da dashed;" readonly="" class="form-control" value="<?php echo e(number_format( $demande_devis_enterprise->prix_offre,2,'.',' ')); ?>">
                                    <?php else: ?>
                                    <input style="background: unset;border: unset;border-bottom: 1px #ced4da dashed;" readonly="" class="form-control" value="En attente...">
                                    <?php endif; ?>
                                </div>
                            </div>

                            <?php if($demande_contrat_enterprise->etat=="uploaded"): ?>

                            <button file_id="<?php echo e($demande_contrat_enterprise->contrat_file_id); ?>" style="border: unset !important;background: unset !important;box-shadow: unset !important;" type_document="CONTRAT" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download mr-1"></i>Télécharger le contrat</button>
                            <?php else: ?>
                            <span style="color: gray;">Aucun fichier importé</span>

                            <?php endif; ?>


                        </div>

                        <?php endif; ?>


                    </div>

                </div>

                <?php else: ?>

                <?php if(Auth::user()->has_role('entreprise')): ?>
                <?php if(!is_null($demnande_devis)): ?>

                <?php if($demnande_devis->etat=="en_cours"): ?>
                <div class="row mt-2">
                    <div class="col-12">
                        <div class="card" style="background: #fad3a0;">
                            <div class="card-body">
                                <h6 class="card-title"><i class="fa-solid fa-file-signature mr-1"></i>Demande de devis</h6>
                                <div class="row">
                                    <div class="col-8">
                                        <p>Une demande de devis a été effectuée par <b><?php echo e($demnande_devis->projet->mao->prenom); ?> <?php echo e($demnande_devis->projet->mao->nom); ?></b> le <b><?php echo e($demnande_devis->created_at); ?> </b>.</p>
                                        <p>Pour répondre à la demande, veuillez charger le devis et indiquer le prix de l'offre.</p>
                                    </div>
                                    <div class="col-4">
                                        <button file_type="pdf" type_document="DEVIS" file_id="" type="button" class="btn btn-success upload_doc_link"> <i class="fa-solid fa-upload mr-1"></i>Charger le devis</button>
                                        <button disabled file_id="" type_document="DEVIS" file_id="" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download mr-1"></i>Télécharger le devis</button>

                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <?php if($demnande_devis->etat=="devis_uploaded"): ?>
                <div class="row mt-2">
                    <div class="col-12">
                        <div class="card" style="background: #b5dba6;">
                            <div class="card-body">
                                <h6 class="card-title"><i class="fa-solid fa-file-signature mr-1"></i>Demande de devis</h6>
                                <div class="row">
                                    <div class="col-8">
                                        <p>Une demande de devis a été effectuée par <b><?php echo e($demnande_devis->projet->mao->prenom); ?> <?php echo e($demnande_devis->projet->mao->nom); ?></b> le <b><?php echo e($demnande_devis->created_at); ?> </b>.</p>
                                        <p>Vous avez répondu à la demande de devis le <?php echo e($demnande_devis->file->formated_created_at()); ?>, avec un prix de l'offre de <b><?php echo e(number_format($demnande_devis->prix_offre,2,'.',' ')); ?></b> MAD</p>
                                    </div>
                                    <div class="col-4">
                                        <button file_id="<?php echo e($demnande_devis->file_id); ?>" type_document="DEVIS" file_id="" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download mr-1"></i>Télécharger le devis</button>

                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <?php endif; ?>


                <?php if(!is_null($demande_contrat)): ?>

                <?php if($demande_contrat->etat=="en_cours"): ?>
                <div class="row mt-2">
                    <div class="col-12">
                        <div class="card" style="background: #fad3a0;">
                            <div class="card-body">
                                <h6 class="card-title"><i class="fa-regular fa-circle-check mr-1"></i>Offre de prix acceptée</h6>
                                <div class="row">
                                    <div class="col-8">
                                        <p>Votre offre a été validée par <?php echo e($demande_contrat->projet->mao->prenom); ?> <?php echo e($demande_contrat->projet->mao->nom); ?> e <b><?php echo e($demnande_devis->created_at); ?></b>.</p>
                                        <p>Merci de bien vouloir charger le contrat.</p>
                                    </div>
                                    <div class="col-4">
                                        <button type_document="CONTRAT" file_type="pdf" file_id="" type="button" class="btn btn-success upload_doc_link"> <i class="fa-solid fa-upload mr-1"></i>Charger le contrat</button>
                                        <button disabled file_id="" type_document="CONTRAT" file_id="" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download mr-1"></i>Télécharger le contrat</button>

                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <?php if($demande_contrat->etat=="uploaded"): ?>
                <div class="row mt-2">
                    <div class="col-12">
                        <div class="card" style="background: #b5dba6;">
                            <div class="card-body">
                                <h6 class="card-title"><i class="fa-solid fa-file-signature mr-1"></i>Offre de prix acceptée</h6>
                                <div class="row">
                                    <div class="col-8">
                                        <p>Contrat chargé le <?php echo e($demande_contrat->contrat_file->formated_created_at()); ?></p>
                                    </div>
                                    <div class="col-4">
                                        <button file_id="<?php echo e($demande_contrat->contrat_file_id); ?>" type_document="CONTRAT" file_id="" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download mr-1"></i>Télécharger le contrat</button>

                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <?php endif; ?>
                <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>


        <div class="card mt-2">
            <div class="card-body">
                <h6 class="card-title"><i class="fa-solid fa-file-contract mr-1"></i>Fondations</h6>


                <h5>• Dossier des réceptions</h6>

                    <table class="table rtable datatables table-striped no-footer display nowrap">
                        <thead>
                            <th>Document</th>
                            <th>Type du fichier</th>
                            <th>Date dépôt</th>
                            <th>Date document</th>
                            <th style="display:none;">Vérification de dépôt</th>
                            <th></th>
                            <th></th>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $fondations_documents_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><i class="fa-solid fa-file-pdf"></i>&nbsp<?php echo e($document['name']); ?>

                                    <?php if($document['document']!=null && $document['validation']==1): ?>
                                    <span style="font-weight:bold;color:<?php echo e($document['document']->decision_color()); ?>"> - <?php echo e($document['document']->decision_full()); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>Fichier <?php echo e(strtoupper($document['file_type'])); ?></td>
                                <td>
                                    <?php if(is_null($document['document'])): ?>
                                    <span type_document="<?php echo e($document['type_document']); ?>" class="download_depot_date" style="color:gray">Aucun fichier importé</span>
                                    <?php else: ?>
                                    <span type_document="<?php echo e($document['type_document']); ?>" class="download_depot_date" style="color:black"><?php echo e($document['document']->formated_created_at()); ?> - <span style="color:coral"><?php echo e($document['document']->user->organisme_ste); ?> <span></span>
                                            <?php endif; ?>
                                </td>

                                <td style="display:none;">
                                    <?php if(is_null($document['document'])): ?>
                                    <span type_document="<?php echo e($document['type_document']); ?>" class="download_depot_date" style="color:gray">Aucun fichier importé</span>
                                    <?php else: ?>

                                    <a href="javascript:;" document_id="<?php echo e($document['document']->id); ?>" type_document="<?php echo e($document['type_document']); ?>" class="document_decision" style="<?php echo e((Auth::user()->role->name == "Architecte" ?'':'pointer-events:none;text-decoration:none;')); ?>;color:<?php echo e($document['document']->decision_color()); ?> !important"><?php echo e($document['document']->decision_full()); ?></a>
                                    <a href="javascript:;" data-toggle="popover" title="Commentaire" data-content="<?php echo e($document['document']->commentaire); ?>" document_id="<?php echo e($document['document']->id); ?>" style="display:<?php echo e(strlen($document['document']->commentaire)>0?'inline-block':'none'); ?>;margin-left:6px;color:darkorange" class="fa-solid fa-comment-dots document_comments"></a>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if(!is_null($document['document'])): ?>
                                    <span><?php echo e($document['document']->formated_date_document()); ?> </span>
                                    <?php else: ?>
                                    <span type_document="<?php echo e($document['type_document']); ?>" style="color:gray">Aucun fichier importé</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if((Auth::user()->has_role($document['w_roles']) && $document['active']==1) || $document['w_roles']=='all'): ?>
                                    <button date_doc="<?php echo e($document['date_doc']); ?>" type_document="<?php echo e($document['type_document']); ?>" file_type="<?php echo e($document['file_type']); ?>" type="button" style="background: transparent !important; border: unset; box-shadow: unset !important;" class="btn btn-light upload_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if(is_null($document['document'])): ?>
                                    <button type_document="<?php echo e($document['type_document']); ?>" file_id="" disabled style="background: transparent !important; border: unset; box-shadow: unset !important;" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download "></i>&nbsp;Télécharger</button>
                                    <?php else: ?>
                                    <button type_document="<?php echo e($document['type_document']); ?>" file_id="<?php echo e($document['document']->id); ?>" type="button" style="background: transparent !important; border: unset; box-shadow: unset !important;" class="btn btn-success download_doc_link"><i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>


                    <h6>Photos et vidéos</h6>
                    <div class="row">
                        <?php $__currentLoopData = $fondation_phototheque; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photos_group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <h6 style="font-size: 0.8rem; margin-left: 8px; color: #797979;"><?php echo e($photos_group['name']); ?></h6>
                        <div class="col-6">
                            <button type_document="<?php echo e($photos_group['type_document']); ?>" type="button" class="btn btn-light upload_photo_link"> <i class="fa-solid fa-plus"></i>&nbsp;Ajouter</button>
                            <button type_document="<?php echo e($photos_group['type_document']); ?>" type="button" disabled class="btn btn-danger delete_photo_link"> <i class="fa-solid fa-trash"></i>&nbsp;Supprimer</button>
                        </div>
                        <div id="photos_<?php echo e($photos_group['type_document']); ?>" class="phototheque hk-gallery mt-1" type_document="<?php echo e($photos_group['type_document']); ?>" style="width: 100%;border-radius:6px;border:1px #949494 solid;height:120px;overflow-x: auto;white-space: nowrap;padding:4px">
                            <?php $__currentLoopData = $photos_group['photos']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a class="costume-img" href="<?php echo e($photo->documentUrl()); ?>" style="margin: 0px;">
                                <img data-src="<?php echo e($photo->documentUrl()); ?>" style="border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="<?php echo e($photo->documentUrl()); ?>" class="gallery-img costume-img hk-gallery">
                                </br>
                                <input item_id="<?php echo e($photo->id); ?>" type_document="<?php echo e($photos_group['type_document']); ?>" class="select_photo_cb" style="margin: auto;display: block;position: relative;" type="checkbox">
                            </a>


                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
            </div>
        </div>


        <div class="card mt-2">
            <div class="card-body">
                <h6 class="card-title"><i class="fa-solid fa-file-contract mr-1"></i>Structure</h6>
                <h5>• Dossier des réceptions</h6>
                    <table class="table rtable datatables table-striped no-footer display nowrap">
                        <thead>
                            <th>Document</th>
                            <th>Type du fichier</th>
                            <th>Date dépôt</th>
                            <th>Date document</th>
                            <th style="display:none;">Vérification de dépôt</th>
                            <th></th>
                            <th></th>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $structure_files_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><i class="fa-solid fa-file-pdf"></i>&nbsp<?php echo e($document['name']); ?>

                                    <?php if($document['document']!=null && $document['validation']==1): ?>
                                    <span style="font-weight:bold;color:<?php echo e($document['document']->decision_color()); ?>"> - <?php echo e($document['document']->decision_full()); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>Fichier <?php echo e(strtoupper($document['file_type'])); ?></td>
                                <td>
                                    <?php if(is_null($document['document'])): ?>
                                    <span type_document="<?php echo e($document['type_document']); ?>" class="download_depot_date" style="color:gray">Aucun fichier importé</span>
                                    <?php else: ?>
                                    <span type_document="<?php echo e($document['type_document']); ?>" class="download_depot_date" style="color:black"><?php echo e($document['document']->formated_created_at()); ?> - <span style="color:coral"><?php echo e($document['document']->user->organisme_ste); ?> <span></span>
                                            <?php endif; ?>
                                </td>

                                <td style="display:none;">
                                    <?php if(is_null($document['document'])): ?>
                                    <span type_document="<?php echo e($document['type_document']); ?>" class="download_depot_date" style="color:gray">Aucun fichier importé</span>
                                    <?php else: ?>

                                    <a href="javascript:;" document_id="<?php echo e($document['document']->id); ?>" type_document="<?php echo e($document['type_document']); ?>" class="document_decision" style="<?php echo e((Auth::user()->role->name == "Architecte" ?'':'pointer-events:none;text-decoration:none;')); ?>;color:<?php echo e($document['document']->decision_color()); ?> !important"><?php echo e($document['document']->decision_full()); ?></a>
                                    <a href="javascript:;" data-toggle="popover" title="Commentaire" data-content="<?php echo e($document['document']->commentaire); ?>" document_id="<?php echo e($document['document']->id); ?>" style="display:<?php echo e(strlen($document['document']->commentaire)>0?'inline-block':'none'); ?>;margin-left:6px;color:darkorange" class="fa-solid fa-comment-dots document_comments"></a>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if(!is_null($document['document'])): ?>
                                    <span><?php echo e($document['document']->formated_date_document()); ?> </span>
                                    <?php else: ?>
                                    <span type_document="<?php echo e($document['type_document']); ?>" style="color:gray">Aucun fichier importé</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if((Auth::user()->has_role($document['w_roles']) && $document['active']==1) || $document['w_roles']=='all'): ?>
                                    <button date_doc="<?php echo e($document['date_doc']); ?>" type_document="<?php echo e($document['type_document']); ?>" file_type="<?php echo e($document['file_type']); ?>" type="button" style="background: transparent !important; border: unset; box-shadow: unset !important;" class="btn btn-light upload_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if(is_null($document['document'])): ?>
                                    <button type_document="<?php echo e($document['type_document']); ?>" file_id="" disabled style="background: transparent !important; border: unset; box-shadow: unset !important;" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download "></i>&nbsp;Télécharger</button>
                                    <?php else: ?>
                                    <button type_document="<?php echo e($document['type_document']); ?>" file_id="<?php echo e($document['document']->id); ?>" type="button" style="background: transparent !important; border: unset; box-shadow: unset !important;" class="btn btn-success download_doc_link"><i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>


                    <h6>Photos et vidéos</h6>
                    <div class="row">
                        <?php $__currentLoopData = $structure_phototheque; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photos_group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <h6 style="font-size: 0.8rem; margin-left: 8px; color: #797979;"><?php echo e($photos_group['name']); ?></h6>
                        <div class="col-6">
                            <button type_document="<?php echo e($photos_group['type_document']); ?>" type="button" class="btn btn-light upload_photo_link"> <i class="fa-solid fa-plus"></i>&nbsp;Ajouter</button>
                            <button type_document="<?php echo e($photos_group['type_document']); ?>" type="button" disabled class="btn btn-danger delete_photo_link"> <i class="fa-solid fa-trash"></i>&nbsp;Supprimer</button>
                        </div>
                        <div id="photos_<?php echo e($photos_group['type_document']); ?>" class="phototheque hk-gallery mt-1" type_document="<?php echo e($photos_group['type_document']); ?>" style="width: 100%;border-radius:6px;border:1px #949494 solid;height:120px;overflow-x: auto;white-space: nowrap;padding:4px">
                            <?php $__currentLoopData = $photos_group['photos']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a class="costume-img" href="<?php echo e($photo->documentUrl()); ?>" style="margin: 0px;">
                                <img data-src="<?php echo e($photo->documentUrl()); ?>" style="border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="<?php echo e($photo->documentUrl()); ?>" class="gallery-img costume-img hk-gallery">
                                </br>
                                <input item_id="<?php echo e($photo->id); ?>" type_document="<?php echo e($photos_group['type_document']); ?>" class="select_photo_cb" style="margin: auto;display: block;position: relative;" type="checkbox">
                            </a>


                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
            </div>
        </div>



        <div class="card mt-2">
            <div class="card-body">
                <h6 class="card-title"><i class="fa-solid fa-file-contract mr-1"></i>L'enveloppe</h6>

                <h5>• Autorisation de construire</h5>
                <div class="row">
                    <div class="col-md-4 col-12">
                        <div style="background: #f8f8f8; padding: 8px; border: 1px silver dashed; border-radius: 8px;">
                            <div>
                                <?php if(is_null($enveloppe_pvdocument['document'])): ?>
                                <i type_document="<?php echo e($enveloppe_pvdocument['type_document']); ?>" style="font-size: 2rem; display: block; margin: auto; text-align: center;color: gray; border-bottom: 1px silver dashed; padding: 8px;" class="fa-solid fa-file-circle-xmark upload_doc_icon"></i>
                                <?php else: ?>
                                <i type_document="<?php echo e($enveloppe_pvdocument['type_document']); ?>" style="font-size: 2rem; display: block; margin: auto; text-align: center;color: #68a334; border-bottom: 1px silver dashed; padding: 8px;" class="fa-solid fa-file-circle-check upload_doc_icon"></i>

                                <?php endif; ?>

                                <?php if(is_null($enveloppe_pvdocument['document'])): ?>
                                <b type_document="<?php echo e($enveloppe_pvdocument['type_document']); ?>" class="mt-2 upload_doc_no_file_label" style="color:gray;display: block; margin: auto;text-align: center;">Aucun fichier importé </b>
                                <?php endif; ?>
                                <div class="mt-1" style="margin: auto; display: block;text-align: center;">
                                    <?php if((Auth::user()->has_role($enveloppe_pvdocument['w_roles']) && $enveloppe_pvdocument['active']==1 )|| $document['w_roles']=='all'): ?>
                                    <button type_document="<?php echo e($enveloppe_pvdocument['type_document']); ?>" file_type="<?php echo e($enveloppe_pvdocument['file_type']); ?>" type="button" class="btn btn-light upload_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                                    <?php endif; ?>
                                    <?php if(is_null($enveloppe_pvdocument['document'])): ?>
                                    <button disabled type_document="<?php echo e($enveloppe_pvdocument['type_document']); ?>" file_id="" type="button" class="btn btn-success download_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Télécharger</button>
                                    <?php else: ?>
                                    <button type_document="<?php echo e($enveloppe_pvdocument['type_document']); ?>" file_id="<?php echo e($enveloppe_pvdocument['document']->id); ?>" type="button" class="btn btn-success download_doc_link"> <i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                                    <?php endif; ?>
                                </div>


                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 col-12">
                        <div class="row">
                            <div class="col-12">
                                <b style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Date de l'autorisation</b>
                                <?php if(is_null($enveloppe_pvdocument['document'])): ?>
                                <b type_document="<?php echo e($enveloppe_pvdocument['type_document']); ?>" class="mt-1 download_doc_date" style="color:gray;display: block; margin: auto;text-align: center;">Aucun fichier importé </b>
                                <?php else: ?>
                                <b type_document="<?php echo e($enveloppe_pvdocument['type_document']); ?>" class="mt-1 download_doc_date" style="color:black;display: block; margin: auto;text-align: center;"><?php echo e($enveloppe_pvdocument['document']->formated_date_document()); ?></b>
                                <?php endif; ?>
                            </div>
                            <div class="col-12 mt-3">
                                <b style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Date de dépot</b>
                                <?php if(is_null($enveloppe_pvdocument['document'])): ?>
                                <b type_document="<?php echo e($enveloppe_pvdocument['type_document']); ?>" class="mt-1 download_depot_date" style="color:gray;display: block; margin: auto;text-align: center;">Aucun fichier importé </b>
                                <?php else: ?>
                                <b type_document="<?php echo e($enveloppe_pvdocument['type_document']); ?>" class="mt-1 download_depot_date" style="color:black;display: block; margin: auto;text-align: center;"><?php echo e($enveloppe_pvdocument['document']->formated_created_at()); ?></b>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <h6>Photos et vidéos</h6>
                <div class="row">
                    <?php $__currentLoopData = $enveloppe_phototheque; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photos_group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <h6 style="font-size: 0.8rem; margin-left: 8px; color: #797979;"><?php echo e($photos_group['name']); ?></h6>
                    <div class="col-6">
                        <button type_document="<?php echo e($photos_group['type_document']); ?>" type="button" class="btn btn-light upload_photo_link"> <i class="fa-solid fa-plus"></i>&nbsp;Ajouter</button>
                        <button type_document="<?php echo e($photos_group['type_document']); ?>" type="button" disabled class="btn btn-danger delete_photo_link"> <i class="fa-solid fa-trash"></i>&nbsp;Supprimer</button>
                    </div>
                    <div id="photos_<?php echo e($photos_group['type_document']); ?>" class="phototheque hk-gallery mt-1" type_document="<?php echo e($photos_group['type_document']); ?>" style="width: 100%;border-radius:6px;border:1px #949494 solid;height:120px;overflow-x: auto;white-space: nowrap;padding:4px">
                        <?php $__currentLoopData = $photos_group['photos']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a class="costume-img" href="<?php echo e($photo->documentUrl()); ?>" style="margin: 0px;">
                            <img data-src="<?php echo e($photo->documentUrl()); ?>" style="border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="<?php echo e($photo->documentUrl()); ?>" class="gallery-img costume-img hk-gallery">
                            </br>
                            <input item_id="<?php echo e($photo->id); ?>" type_document="<?php echo e($photos_group['type_document']); ?>" class="select_photo_cb" style="margin: auto;display: block;position: relative;" type="checkbox">
                        </a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>



        <div class="card mt-2">
            <div class="card-body">
                <h6 class="card-title"><i class="fa-solid fa-file-contract mr-1"></i>Finitions et fin des travaux</h6>
                <h5>• Dossier des réceptions</h6>
                    <table class="table rtable datatables table-striped no-footer display nowrap">
                        <thead>
                            <th>Document</th>
                            <th>Type du fichier</th>
                            <th>Date dépôt</th>
                            <th>Date document</th>
                            <th style="display:none;">Vérification de dépôt</th>
                            <th></th>
                            <th></th>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $fin_travaux_documents_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><i class="fa-solid fa-file-pdf"></i>&nbsp<?php echo e($document['name']); ?>

                                    <?php if($document['document']!=null && $document['validation']==1): ?>
                                    <span style="font-weight:bold;color:<?php echo e($document['document']->decision_color()); ?>"> - <?php echo e($document['document']->decision_full()); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>Fichier <?php echo e(strtoupper($document['file_type'])); ?></td>
                                <td>
                                    <?php if(is_null($document['document'])): ?>
                                    <span type_document="<?php echo e($document['type_document']); ?>" class="download_depot_date" style="color:gray">Aucun fichier importé</span>
                                    <?php else: ?>
                                    <span type_document="<?php echo e($document['type_document']); ?>" class="download_depot_date" style="color:black"><?php echo e($document['document']->formated_created_at()); ?> - <span style="color:coral"><?php echo e($document['document']->user->organisme_ste); ?> <span></span>
                                            <?php endif; ?>
                                </td>

                                <td style="display:none;">
                                    <?php if(is_null($document['document'])): ?>
                                    <span type_document="<?php echo e($document['type_document']); ?>" class="download_depot_date" style="color:gray">Aucun fichier importé</span>
                                    <?php else: ?>

                                    <a href="javascript:;" document_id="<?php echo e($document['document']->id); ?>" type_document="<?php echo e($document['type_document']); ?>" class="document_decision" style="<?php echo e((Auth::user()->role->name == "Architecte" ?'':'pointer-events:none;text-decoration:none;')); ?>;color:<?php echo e($document['document']->decision_color()); ?> !important"><?php echo e($document['document']->decision_full()); ?></a>
                                    <a href="javascript:;" data-toggle="popover" title="Commentaire" data-content="<?php echo e($document['document']->commentaire); ?>" document_id="<?php echo e($document['document']->id); ?>" style="display:<?php echo e(strlen($document['document']->commentaire)>0?'inline-block':'none'); ?>;margin-left:6px;color:darkorange" class="fa-solid fa-comment-dots document_comments"></a>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if(!is_null($document['document'])): ?>
                                    <span><?php echo e($document['document']->formated_date_document()); ?> </span>
                                    <?php else: ?>
                                    <span type_document="<?php echo e($document['type_document']); ?>" style="color:gray">Aucun fichier importé</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if((Auth::user()->has_role($document['w_roles']) && $document['active']==1) || $document['w_roles']=='all'): ?>
                                    <button date_doc="<?php echo e($document['date_doc']); ?>" type_document="<?php echo e($document['type_document']); ?>" file_type="<?php echo e($document['file_type']); ?>" type="button" style="background: transparent !important; border: unset; box-shadow: unset !important;" class="btn btn-light upload_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if(is_null($document['document'])): ?>
                                    <button type_document="<?php echo e($document['type_document']); ?>" file_id="" disabled style="background: transparent !important; border: unset; box-shadow: unset !important;" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download "></i>&nbsp;Télécharger</button>
                                    <?php else: ?>
                                    <button type_document="<?php echo e($document['type_document']); ?>" file_id="<?php echo e($document['document']->id); ?>" type="button" style="background: transparent !important; border: unset; box-shadow: unset !important;" class="btn btn-success download_doc_link"><i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>


                    <h6>Photos et vidéos</h6>
                    <div class="row">
                        <?php $__currentLoopData = $fin_travaux_phototheque; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photos_group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <h6 style="font-size: 0.8rem; margin-left: 8px; color: #797979;"><?php echo e($photos_group['name']); ?></h6>
                        <div class="col-6">
                            <button type_document="<?php echo e($photos_group['type_document']); ?>" type="button" class="btn btn-light upload_photo_link"> <i class="fa-solid fa-plus"></i>&nbsp;Ajouter</button>
                            <button type_document="<?php echo e($photos_group['type_document']); ?>" type="button" disabled class="btn btn-danger delete_photo_link"> <i class="fa-solid fa-trash"></i>&nbsp;Supprimer</button>
                        </div>
                        <div id="photos_<?php echo e($photos_group['type_document']); ?>" class="phototheque hk-gallery mt-1" type_document="<?php echo e($photos_group['type_document']); ?>" style="width: 100%;border-radius:6px;border:1px #949494 solid;height:120px;overflow-x: auto;white-space: nowrap;padding:4px">
                            <?php $__currentLoopData = $photos_group['photos']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a class="costume-img" href="<?php echo e($photo->documentUrl()); ?>" style="margin: 0px;">
                                <img data-src="<?php echo e($photo->documentUrl()); ?>" style="border: 1px #cacaca solid;padding: 0px;margin: 0px;" src="<?php echo e($photo->documentUrl()); ?>" class="gallery-img costume-img hk-gallery">
                                </br>
                                <input item_id="<?php echo e($photo->id); ?>" type_document="<?php echo e($photos_group['type_document']); ?>" class="select_photo_cb" style="margin: auto;display: block;position: relative;" type="checkbox">
                            </a>


                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
            </div>
        </div>



        <div class="card mt-2">
            <div class="card-body">
                <h6 class="card-title"><i class="fa-solid fa-file-contract mr-1"></i>Permis d'habiter</h6>

              
                <div class="row">
                    <div class="col-md-4 col-12">
                        <div style="background: #f8f8f8; padding: 8px; border: 1px silver dashed; border-radius: 8px;">
                            <div>
                                <?php if(is_null($permis_habiter['document'])): ?>
                                <i type_document="<?php echo e($permis_habiter['type_document']); ?>" style="font-size: 2rem; display: block; margin: auto; text-align: center;color: gray; border-bottom: 1px silver dashed; padding: 8px;" class="fa-solid fa-file-circle-xmark upload_doc_icon"></i>
                                <?php else: ?>
                                <i type_document="<?php echo e($permis_habiter['type_document']); ?>" style="font-size: 2rem; display: block; margin: auto; text-align: center;color: #68a334; border-bottom: 1px silver dashed; padding: 8px;" class="fa-solid fa-file-circle-check upload_doc_icon"></i>

                                <?php endif; ?>

                                <?php if(is_null($permis_habiter['document'])): ?>
                                <b type_document="<?php echo e($permis_habiter['type_document']); ?>" class="mt-2 upload_doc_no_file_label" style="color:gray;display: block; margin: auto;text-align: center;">Aucun fichier importé </b>
                                <?php endif; ?>
                                <div class="mt-1" style="margin: auto; display: block;text-align: center;">
                                    <?php if((Auth::user()->has_role($permis_habiter['w_roles']) && $permis_habiter['active']==1 )|| $document['w_roles']=='all'): ?>
                                    <button type_document="<?php echo e($permis_habiter['type_document']); ?>" file_type="<?php echo e($permis_habiter['file_type']); ?>" type="button" class="btn btn-light upload_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                                    <?php endif; ?>
                                    <?php if(is_null($permis_habiter['document'])): ?>
                                    <button disabled type_document="<?php echo e($permis_habiter['type_document']); ?>" file_id="" type="button" class="btn btn-success download_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Télécharger</button>
                                    <?php else: ?>
                                    <button type_document="<?php echo e($permis_habiter['type_document']); ?>" file_id="<?php echo e($permis_habiter['document']->id); ?>" type="button" class="btn btn-success download_doc_link"> <i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                                    <?php endif; ?>
                                </div>


                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 col-12">
                        <div class="row">
                            <div class="col-12">
                                <b style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Date du permis</b>
                                <?php if(is_null($permis_habiter['document'])): ?>
                                <b type_document="<?php echo e($permis_habiter['type_document']); ?>" class="mt-1 download_doc_date" style="color:gray;display: block; margin: auto;text-align: center;">Aucun fichier importé </b>
                                <?php else: ?>
                                <b type_document="<?php echo e($permis_habiter['type_document']); ?>" class="mt-1 download_doc_date" style="color:black;display: block; margin: auto;text-align: center;"><?php echo e($permis_habiter['document']->formated_date_document()); ?></b>
                                <?php endif; ?>
                            </div>
                            <div class="col-12 mt-3">
                                <b style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Date de dépot</b>
                                <?php if(is_null($permis_habiter['document'])): ?>
                                <b type_document="<?php echo e($permis_habiter['type_document']); ?>" class="mt-1 download_depot_date" style="color:gray;display: block; margin: auto;text-align: center;">Aucun fichier importé </b>
                                <?php else: ?>
                                <b type_document="<?php echo e($permis_habiter['type_document']); ?>" class="mt-1 download_depot_date" style="color:black;display: block; margin: auto;text-align: center;"><?php echo e($permis_habiter['document']->formated_created_at()); ?></b>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>

                
            </div>
        </div>
    </div>
</div><?php /**PATH /home/u207500317/domains/seagreen-ostrich-285320.hostingersite.com/public_html/resources/views/projets/projet_tab.blade.php ENDPATH**/ ?>