
<?php $__env->startSection('added_css'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<style>
    .table>tbody>tr>td,
    .table>tfoot>tr>td,
    .table>thead>tr>td {
        font-size: 0.70rem;
    }
</style>

<style>
    .bootstrap-timepicker-widget.dropdown-menu {
        z-index: 9999999999999 !important;
    }

    .participant_card {
        float: left;
        margin: 6px;
        width: 100px;
        height: 120px;
        border: 1px #cfcfcf solid;
        padding: 8px;
        border-radius: 8px;
        background: #f8f8f8;
        transition: all 0.3s ease-out;
    }

    .participant_card.host {
        background: #c1fcb6;
        pointer-events: none;
        border: 2px solid #115555;
    }

    .participant_card.selected {
        background: #c1fcb6;

        border: 2px solid #115555;
    }

    .participant_card:hover {
        background: #eeeeee;
        transform: scale(1.1);
        cursor: pointer;
    }

    .participant_card img {
        width: 58px;
        height: 58px;
        border: 1px gray solid;
        display: block;
        margin: auto;
    }

    [type=radio]:checked+label,
    [type=radio]:not(:checked)+label {
        font-weight: 400 !important;

    }
</style>


<nav class="hk-breadcrumb" aria-label="breadcrumb">

    <ol class="breadcrumb breadcrumb-light bg-transparent">
        <li class="breadcrumb-item"><a href="<?php echo e(route('projets')); ?>">Projet</a></li>
        <li class="breadcrumb-item"><b>Projet N° <?php echo e($projet->numero); ?></b>

    </ol>
</nav>

<div class="row mt-2">
    <div class="col-12 col-sm-9">
        <ul class="nav nav-tabs " role="tablist">
            <li class="nav-item">
                <a class="nav-link active" id="preparation-tab" data-toggle="tab" href="#preparation" role="tab" aria-controls="preparation" aria-selected="true"><i class="fa-solid fa-calendar-check mr-1"></i>Préparation</a>
            </li>
            <?php if($prestataire_retenu || Auth::user()->has_role('admin,moa,chef_projet,entreprise')): ?>
            <li class="nav-item">
                <a class="nav-link" id="projet-tab" data-toggle="tab" href="#projet" role="tab" aria-controls="projet" aria-selected="false"><i class="fa-solid fa-person-digging mr-1"></i>Projet</a>
            </li>
            <?php endif; ?>
            <?php if($prestataire_retenu || Auth::user()->has_role('admin,moa,chef_projet')): ?>
            <li class="nav-item">
                <a class="nav-link" id="visualisation3d-tab" data-toggle="tab" href="#visualisation3d" role="tab" aria-controls="visualisation3d" aria-selected="false"><i class="fa-brands fa-unity mr-1"></i>Visualisation 3d</a>
            </li>
            <?php endif; ?>
            <?php if($prestataire_retenu || Auth::user()->has_role('admin,moa,chef_projet')): ?>
            <li class="nav-item disabled">
                <a class="nav-link" id="reunion-tab" data-toggle="tab" href="#reunion" role="tab" aria-controls="reunion" aria-selected="false"><i class="fa-regular fa-comments mr-1"></i>Réunions</a>
            </li>
            <?php endif; ?>

            <?php if($prestataire_retenu || Auth::user()->has_role('admin,moa,chef_projet')): ?>
            <li class="nav-item disabled">
                <a class="nav-link" id="paiements-tab" data-toggle="tab" href="#paiements" role="tab" aria-controls="paiements" aria-selected="false"><i class="fa-solid fa-receipt mr-1"></i>Paiements</a>
            </li>
            <?php endif; ?>

            <?php if($prestataire_retenu || Auth::user()->has_role('admin,moa,chef_projet')): ?>
            <li class="nav-item disabled">
                <a class="nav-link" id="echantillons-tab" data-toggle="tab" href="#echantillons" role="tab" aria-controls="echantillons" aria-selected="false"><i class="fa-solid fa-list-check mr-1"></i>Echantillons/validations</a>
            </li>
            <?php endif; ?>
            <!-- <li class="nav-item">
                <a class="nav-link" id="documents-tab" data-toggle="tab" href="#documents" role="tab" aria-controls="documents" aria-selected="false"><i class="fa-regular fa-file-line mr-1s"></i>Documents/Fichiers de dessins</a>
            </li> -->

        </ul>
        <div class="tab-content" style="padding:8px">
            <div class="tab-pane fade show active" id="preparation" role="tabpanel" aria-labelledby="preparation-tab">


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <h6 class="card-title"><i class="fa-regular fa-circle-question mr-1"></i>Informations générales</h6>

                                <div class="row">
                                    <div class="col-12 col-sm-7">

                                        <div class="row mt-1" style="border: 1px dashed gray; padding: 8px; border-radius: 8px; background: #f8f8f8;">
                                            <div class="col-2">
                                                <img src="<?php echo e($projet->mao->avatar()); ?>" class="user-image rounded-circle" style="border: #1e6f6c solid; border-width: 2px;width: 80px;height: 80px;">

                                            </div>
                                            <div class="col-5" style="display: block;margin: auto 0px;">
                                                <b class="mb-2" style="font-size: 0.85rem;color: #115555; "><?php echo e($projet->mao->nom); ?> <?php echo e($projet->mao->prenom); ?> <?php echo e($projet->mao->type_client=="Personne morale"?("(".$projet->mao->organisme_ste.")"):""); ?></b>
                                                <br>

                                                <b style="font-size: 0.7rem; color: #7a7a7a; font-style: italic;">Type du client : <b style="font-size: 0.7rem; color: #c75c1b; font-style: italic;"><?php echo e($projet->mao->type_client); ?> </b> </b>
                                            </div>

                                            <div class="col-5" style="display: block;margin: auto 0px;">
                                                <b class="mb-2" style="font-size: 0.85rem;color: #115555; "><i class="fa-regular fa-envelope mr-1"></i><?php echo e($projet->mao->email); ?> </b>
                                                <br>
                                                <b style="font-size: 0.7;color: #115555; "><i class="fa-solid fa-phone mr-1"></i><?php echo e($projet->mao->tel); ?> </b>
                                            </div>
                                        </div>
                                        <div class="row  mt-2">
                                            <div class="col-12 col-sm-5">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" style="width: 100px;">Region</span>
                                                    </div>
                                                    <input readonly class="form-control" value="<?php echo e($projet->lot->lotissement->region->nom); ?>">
                                                </div>
                                            </div>

                                            <div class="col-12 col-sm-7">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" style="width: 140px;">Province</span>
                                                    </div>
                                                    <input readonly class="form-control" value="<?php echo e($projet->lot->lotissement->ville->province->nom); ?>">
                                                </div>
                                            </div>


                                        </div>

                                        <div class="row mt-1">
                                            <div class="col-12 col-sm-5">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" style="width: 100px;">Ville</span>
                                                    </div>
                                                    <input readonly class="form-control" value="<?php echo e($projet->lot->lotissement->ville->nom); ?>">
                                                </div>
                                            </div>
                                            <div class="col-12 col-sm-7">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" style="width: 140px;">Lotissement</span>
                                                    </div>
                                                    <input readonly class="form-control" value="R+<?php echo e($projet->lot->lotissement->nom); ?>">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row mt-1">
                                            <div class="col-12 col-sm-5">
                                                <div class="input-group input-group-sm mb-2">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" style="width: 100px;">Lot</span>
                                                    </div>
                                                    <input readonly class="form-control" value="R+<?php echo e($projet->lot->numero); ?>">

                                                </div>
                                            </div>
                                            <div class="col-12 col-sm-7">
                                                <div class="input-group input-group-sm mb-2">
                                                    <div class="input-group-prepend">
                                                        <span class="input-group-text" style="width: 140px;">Référence foncière</span>
                                                    </div>
                                                    <input readonly class="form-control" value="<?php echo e($projet->lot->ref_fonciere); ?>">

                                                </div>
                                            </div>
                                        </div>


                                        <div class="row">
                                            <div class="col-12 col-lg-6">
                                                <h6 style="font-size: 0.85rem;font-weight: 500;color: #003a62;">• Intitulé</h6>

                                                <textarea <?php echo e(($projet->chef_projet_id!=Auth::user()->id  && $projet->user_id!=Auth::user()->id )?'disabled':''); ?> class="form-control" rows="5" style="width: 100%;"><?php echo e($projet->intitule); ?></textarea>
                                            </div>

                                            <div class="col-12  col-lg-6">
                                                <h6 style="font-size: 0.85rem;font-weight: 500;color: #003a62;">• Cahier des charges : </h6>
                                                <div style="background: #fdfdfd; padding: 8px; border: 1px #d2d2d2 solid; border-radius: 6px;">
                                                    <div>
                                                        <i style="font-size: 1.5rem; display: block; margin: auto; text-align: center;color: #196767; border-bottom: 1px silver dashed; padding: 4px;" class="fa-solid fa-file-contract"></i>
                                                        <b style="width: 100%;text-align: center;display: block;color: gray;">Cahier des charges</b>
                                                        <div class="mt-1" style="margin: auto; display: block;text-align: center;">
                                                            <button id="<?php echo e($projet->lot->lotissement->id); ?>" type="button" class="btn cahier_charges_a"> <i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>


                                        <div class="input-group input-group-sm mb-2 mt-2">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text" style="width: 160px;">Prix acquisition du terrain</span>
                                            </div>
                                            <input type="number" id="prix_acquisition_terrain" <?php echo e(Auth::user()->id==$projet->user_id?'':'disabled'); ?> class="form-control" value="<?php echo e($projet->prix_acquisition_terrain); ?>">
                                            <div class="input-group-append">
                                                <span class="input-group-text">MAD</span>
                                            </div>
                                        </div>

                                        <h6 style="font-size: 0.85rem;font-weight: 500;color: #003a62;">• Charges / taxes : </h6>
                                        <div class="row mt-1">
                                            <?php if(Auth::user()->has_role('chef_projet,admin') ): ?>
                                            <div class="col-6">
                                                <button id="charges_taxes_add" class="btn"><i class="fa-solid fa-circle-plus mr-1 "></i>Ajouter</button>
                                                <button id="charges_taxes_delete" disabled class="mr-3 btn btn-danger "><i class="fa-regular fa-trash-can mr-1"></i>Supprimer</button>
                                            </div>
                                            <?php endif; ?>
                                        </div>
                                        <table class="table table-striped datatables dataTable no-footer display nowrap" id="charges_taxes_table">
                                            <thead>
                                                <th>Charge</th>
                                                <th>Montant</th>
                                            </thead>
                                            <tbody>

                                            </tbody>
                                        </table>

                                    </div>

                                    <div class="col-12 col-sm-5">

                                        <div id="image_sat_div" style="min-height: 400px; background: rgb(242, 242, 242); height: 100%; width: 100%; border-radius: 4px; border: 1px solid rgb(198, 198, 198); position: relative;">

                                        </div>
                                    </div>



                                </div>

                            </div>
                        </div>
                    </div>
                </div>




                <div class="row mt-2">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header card-header-action">
                                <h5 class="card-title"><i class="fa-solid fa-circle-info mr-1"></i>Descriptif du projet</h5>
                                <div class="d-flex align-items-center card-action-wrap">
                                    <a class="inline-block mr-15" data-toggle="collapse" href="#collapse_3" aria-expanded="true">
                                        <i style="font-size: 1.25rem;" class="zmdi zmdi-chevron-down"></i>
                                    </a>
                                </div>
                            </div>


                            <div id="collapse_3" class="collapse show">
                                <div class="card-body">

                                    <!-- <div class="row">
                                        <div class="col-12">
                                            <h6 style="font-size: 0.85rem;font-weight: 500;color: #003a62;">• Expression de besoin</h6>

                                        </div>
                                    </div> -->

                                    <div class="row">
                                        <div class="col-12">
                                            <h6 style="font-size: 0.85rem;font-weight: 500;color: #003a62;">• Programme architectural</h6>
                                            <?php echo $__env->make('projets/cf_form', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


                                            <div class="col-12" style="border-top: 1px #b9b9b9 solid; padding-top: 7px;">
                                                <?php if($projet->cp_formulaire_etat=="en_attente"): ?>
                                                <i class="fa-regular fa-hourglass-half mr-1"></i><span style=" font-size: 0.85rem;">Etat de la validation : </span><b> En attente</b>
                                                <button style="margin-top: 0px !important;float: right;" id="send_for_validation_form_cp_btn" class="btn mt-1"><i class="fa-solid fa-share mr-1"></i></i>Envoyer pour validation</button>
                                                <?php endif; ?>

                                                <?php if($projet->cp_formulaire_etat=="uploaded"): ?>
                                                <i class="fa-regular fa-hourglass-half mr-1"></i><span style=" font-size: 0.85rem;">Etat de la validation : </span><b> En attente de la validation</b>
                                                
                                                <?php endif; ?>

                                                <?php if($projet->cp_formulaire_etat=="accepted"): ?>
                                                <div style="color: #39af39;">
                                                    <i class="fa-regular fa-thumbs-up mr-1"></i><span style="font-size: 0.85rem;">Etat de la validation : </span><b> Validé par le client</b>

                                                </div>
                                                <?php endif; ?>


                                                <?php if($projet->cp_formulaire_etat=="rejected"): ?>
                                                <div style="color: #ff4848;">
                                                    <i class="fa-solid fa-xmark mr-1"></i><span style="font-size: 0.85rem;">Etat de la validation : </span><b> Rejeté par le client</b>
                                                    <button style="margin-top: 0px !important;float: right;" id="send_for_validation_form_cp_btn" class="btn mt-1"><i class="fa-solid fa-share mr-1"></i></i>Envoyer pour validation</button>

                                                </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>

                                    <h6 style="font-size: 0.85rem;font-weight: 500;color: #003a62;display:none">• Intérêt du client : </h6>
                                    <div class="row" style="display: none;">

                                        <div class="col-12 col-sm-6">
                                            <div class="input-group input-group-sm mb-2 mt-2">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text" style="width: 140px;">Intérêt du client</span>
                                                </div>
                                                <select <?php echo e($projet->chef_projet_id!=Auth::user()->id?'disabled':''); ?> id="interet_client" class="form-control select2nc">
                                                    <option <?php echo e($projet->interet_client=="Personnel"?'selected':''); ?> value="Personnel">Personnel</option>
                                                    <option <?php echo e($projet->interet_client=="Investissement nouveau programme"?'selected':''); ?> value="Investissement nouveau programme">Investissement nouveau programme</option>
                                                    <option <?php echo e($projet->interet_client=="Autre investissement"?'selected':''); ?> value="Autre investissement">Autre investissement</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-12 col-sm-6 autre_investissement_div" style="display:<?php echo e($projet->interet_client=='Autre investissement'?'block':'none'); ?>">
                                            <div class="input-group input-group-sm mb-2 mt-2">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text" style="width: 140px;">Autre investissement</span>
                                                </div>
                                                <input <?php echo e($projet->chef_projet_id!=Auth::user()->id?'disabled':''); ?> id="autre_interet_client" class="form-control" value="<?php echo e($projet->autre_interet_client); ?>">
                                            </div>
                                        </div>

                                    </div>

                                    <div class="row" style="display: none;">
                                        <div class="col-12 col-sm-12">
                                            <h6 style="font-size: 0.85rem;font-weight: 500;color: #003a62;">• Description : </h6>
                                            <textarea <?php echo e($projet->chef_projet_id!=Auth::user()->id?'disabled':''); ?> id="descripition_projet" class="form-control" rows="5" style="width: 100%;"><?php echo e($projet->description); ?></textarea>
                                        </div>

                                    </div>

                                    <?php if($projet->arch_id!=null): ?>
                                    <div class="row mt-3">
                                        <div class="col-12 col-sm-6">
                                            <h6 style="font-size: 0.85rem;font-weight: 500;color: #003a62;">• Produits : </h6>
                                            <!-- <div class="row mt-1">
                                            <?php if(Auth::user()->has_role('arch') && $projet->arch_id==Auth::user()->id): ?>
                                            <div class="col-6">
                                                <button id="produits_table_add_btn" class="btn"><i class="fa-solid fa-circle-plus mr-1"></i>Ajouter</button>
                                                <button id="produits_table_delete_btn" disabled class="mr-3 btn btn-danger "><i class="fa-regular fa-trash-can mr-1"></i>Supprimer</button>
                                            </div>
                                            <?php endif; ?>
                                        </div> -->
                                            <table class="table table-striped datatables dataTable no-footer display nowrap" id="produits_table">
                                                <thead>
                                                    <th>Produit</th>
                                                    <th>Nombre d'unités</th>
                                                    <th>Surface vendable totale</th>
                                                </thead>
                                                <tbody>
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="col-12 col-sm-6">

                                            <h6 style="font-size: 0.85rem;font-weight: 500;color: #003a62;">• Esquisses : </h6>
                                            <table class="table table-striped datatables dataTable no-footer display nowrap" id="esquisses_table">
                                                <thead>
                                                    <th>Fichier</th>
                                                    <th>Type</th>
                                                    <th>Date dépôt</th>
                                                    <th>Téléchargement</th>
                                                </thead>
                                                <tbody>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>



                                    <?php endif; ?>


                                </div>

                            </div>
                        </div>
                    </div>
                </div>


                <?php if(Auth::user()->has_role("admin,moa,chef_projet")): ?>
                <div class="row mt-2">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <h6 class="card-title"><i class="fa-solid fa-users-gear mr-1"></i>Désignation des intervenants</h6>


                                <div class="row mt-1">
                                    <div class="col-12">

                                        <h6 style="font-size: 0.85rem;font-weight: 500;color: #003a62;">• Sélection des prestataires : </h6>
                                        <div class="input-group input-group-sm mb-2 col-6 mt-2">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text" style="width: 140px;">Type de prestataire</span>
                                            </div>
                                            <select id="intervenants_table_type_prestataire" class="form-control select2nc">
                                                <option selected value="arch">Architecte</option>
                                                <option value="igt">Ingénieur topographe</option>
                                                <option value="bet">Bureau d'étude</option>
                                                <option value="labo">Laboratoire</option>
                                                <option value="bc">Bureau de controle</option>
                                            </select>

                                        </div>
                                        <div class="row mt-1">
                                            <div class="col-6">
                                                <button id="intervenants_table_add_btn" class="btn"><i class="fa-solid fa-circle-plus mr-1"></i>Ajouter</button>
                                            </div>

                                        </div>





                                        <table class="table table-striped datatables dataTable no-footer display nowrap" id="intervenants_table">
                                            <thead>
                                                <th class="intervenants_table_type_th">Architecte</th>
                                                <th>Ville</th>
                                                <th>Téléphone</th>
                                                <th>Prix de l'offre</th>
                                                <th>Devis</th>
                                                <th>Détail</th>
                                                <th>Action</th>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>


                                </div>



                                <div class="row mt-1">
                                    <div class="col-12">

                                        <h6 style="font-size: 0.85rem;font-weight: 500;color: #003a62;">• Prestataires retnus : </h6>

                                        <table class="table table-striped datatables dataTable no-footer display nowrap" id="intervenants_retenus_table">
                                            <thead>
                                                <th>Prestataire</th>
                                                <th>Type</th>
                                                <th>Ville</th>
                                                <th>Téléphone</th>
                                                <th>Honoraires</th>
                                                <th>Contrat</th>
                                                <th>Actions</th>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>


                                    </div>

                                    <span style="color: #115555; float: right; font-size: 0.80rem; width: 100%; text-align: center; background: #f4f4f4; border-radius: 4px; border: 1px #d2d2d2 solid; padding: 8px; margin-top: 8px;">Total des honoraire : <b id="total_honoraires_txt">0</b> MAD</span>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>


                <?php else: ?>

                <?php if(Auth::user()->has_role('arch,bet,igt,labo')): ?>
                <?php if(!is_null($demnande_devis)): ?>


                <div class="row mt-2">
                    <div class="col-12">
                        <div class="card" style="background: <?php echo e($demnande_devis->etat=='devis_uploaded'?'#ddf6db':'#fffeef'); ?>;border: 2px #115555 solid;">
                            <div class="card-body">
                                <h6 class="card-title"><i class="fa-solid fa-file-signature mr-1"></i>Demande de devis</h6>



                                <div class="row">
                                    <div class="col-12 col-sm-6">
                                        <?php if($demnande_devis->etat=="devis_uploaded"): ?>
                                        <p>Une demande de devis a été effectuée par <b><?php echo e($demnande_devis->projet->mao->prenom); ?> <?php echo e($demnande_devis->projet->mao->nom); ?></b> le <b><?php echo e($demnande_devis->created_at); ?> </b>.</p>
                                        <p>Vous avez répondu à la demande de devis le <?php echo e($demnande_devis->file->formated_created_at()); ?>, avec un prix de l'offre de <b><?php echo e(number_format($demnande_devis->prix_offre,2,'.',' ')); ?></b> MAD</p>
                                        <?php else: ?>
                                        <p>Une demande de devis a été effectuée par <b><?php echo e($demnande_devis->projet->mao->prenom); ?> <?php echo e($demnande_devis->projet->mao->nom); ?></b> le <b><?php echo e($demnande_devis->created_at); ?> </b>.</p>
                                        <?php endif; ?>
                                        <?php if(Auth::user()->has_role('arch')): ?>
                                        <h6 style="font-size: 0.85rem;font-weight: 500;color: #003a62;">• Produits : </h6>
                                        <div class="row mt-1">
                                            <?php if(Auth::user()->has_role('arch') && $demnande_devis->etat=="en_cours"): ?>
                                            <div class="col-6">
                                                <button id="produits_table_add_btn" class="btn"><i class="fa-solid fa-circle-plus mr-1"></i>Ajouter</button>
                                                <button id="produits_table_delete_btn" disabled class="mr-3 btn btn-danger "><i class="fa-regular fa-trash-can mr-1"></i>Supprimer</button>
                                            </div>
                                            <?php endif; ?>
                                        </div>

                                        <table class="table table-striped datatables dataTable no-footer display nowrap" id="produits_proposition_table">
                                            <thead>
                                                <th>Produit</th>
                                                <th>Nombre d'unités</th>
                                                <th>surface vendable totale</th>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>

                                        <?php if(Auth::user()->has_role('arch')): ?>
                                        <h6 style="font-size: 0.85rem;font-weight: 500;color: #003a62;">• Coût estimatif : </h6>
                                        <div class="input-group input-group-sm mb-2 mt-2">
                                            <div class="input-group-prepend">
                                                <span class="input-group-text" style="width: 140px;">Coût estimatif</span>
                                            </div>
                                            <?php if($demnande_devis->etat=="devis_uploaded"): ?>
                                            <input readonly id="demande_devis_cout_estimatif" class="form-control" value="<?php echo e(number_format($demnande_devis->cout_estimatif,2,'.',' ')); ?>">
                                            <?php else: ?>
                                            <input id="demande_devis_cout_estimatif" class="form-control" value="0">
                                            <?php endif; ?>
                                            <div class="input-group-append">
                                                <span class="input-group-text">MAD</span>
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                        <?php endif; ?>
                                    </div>
                                    <div class="col-12 col-sm-6">

                                        <h6 style="font-size: 0.85rem;font-weight: 500;color: #003a62;">• Charger le devis : </h6>
                                        <?php if($demnande_devis->etat=="devis_uploaded"): ?>
                                        <button file_id="<?php echo e($demnande_devis->file_id); ?>" type_document="DEVIS" file_id="" type="button" class="btn  download_doc_link"><i class="fa-solid fa-download mr-1"></i>Télécharger le devis</button>
                                        <?php else: ?>
                                        <button file_type="pdf" type_document="DEVIS" file_id="" type="button" class="btn  upload_doc_link"> <i class="fa-solid fa-upload mr-1"></i>Charger le devis</button>
                                        <button disabled file_id="" type_document="DEVIS" file_id="" type="button" class="btn  download_doc_link"><i class="fa-solid fa-download mr-1"></i>Télécharger le devis</button>

                                        <?php endif; ?>

                                        <?php if(Auth::user()->has_role('arch') ): ?>
                                        <h6 style="font-size: 0.85rem;font-weight: 500;color: #003a62;">• Esquisses : </h6>
                                        <div class="row mt-1">
                                            <?php if(Auth::user()->has_role('arch') && $demnande_devis->etat=="en_cours"): ?>
                                            <div class="col-6">
                                                <button date_doc="0" file_type="pdf" type_document="ESQUISSE" id="proposition_esquisses_table_add_btn " class="btn upload_doc_link"><i class="fa-solid fa-circle-plus mr-1 "></i>Ajouter</button>
                                                <button id="proposition_esquisses_table_remove_btn" disabled class="mr-3 btn btn-danger "><i class="fa-regular fa-trash-can mr-1"></i>Supprimer</button>
                                            </div>
                                            <?php endif; ?>
                                        </div>
                                        <table class="table table-striped datatables dataTable no-footer display nowrap" id="proposition_esquisses_table">
                                            <thead>
                                                <th>Fichier</th>
                                                <th>Type</th>
                                                <th>Date dépôt</th>
                                                <th>Téléchargement</th>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                        <?php endif; ?>


                                        <?php if($demnande_devis->etat=="en_cours"): ?>
                                        <button style="float: right;" id="demande_devis_send_reponse_btn" class="btn mt-4"><i class="fa-solid fa-envelope-circle-check mr-1"></i>Envoyer votre réponse</button>
                                        <?php endif; ?>
                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>
                </div>



                <?php endif; ?>




                <?php if(!is_null($demande_contrat)): ?>

                <?php if($demande_contrat->rejected==0): ?>
                <?php if($demande_contrat->etat=="en_cours" ): ?>
                <div class="row mt-2">
                    <div class="col-12">
                        <div class="card" style="background: #fad3a0;border: 2px #a67a2b  solid;">
                            <div class="card-body">
                                <h6 class="card-title"><i class="fa-regular fa-circle-check mr-1"></i>Offre de prix acceptée</h6>
                                <div class="row">
                                    <div class="col-8">
                                        <p>Votre offre a été validée par <?php echo e($demande_contrat->projet->mao->prenom); ?> <?php echo e($demande_contrat->projet->mao->nom); ?> e <b><?php echo e($demnande_devis->created_at); ?></b>.</p>
                                        <p>Merci de bien vouloir charger le contrat.</p>
                                    </div>
                                    <div class="col-4">
                                        <button type_document="CONTRAT" file_type="pdf" file_id="" type="button" class="btn  upload_doc_link"> <i class="fa-solid fa-upload mr-1"></i>Charger le contrat</button>
                                        <button disabled file_id="" type_document="CONTRAT" file_id="" type="button" class="btn  download_doc_link"><i class="fa-solid fa-download mr-1"></i>Télécharger le contrat</button>

                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <?php if($demande_contrat->etat=="en_cours"): ?>
                                        <button style="float: right;" id="demande_contrat_send_reponse_btn" class="btn mt-4"><i class="fa-solid fa-envelope-circle-check mr-1"></i>Envoyer votre réponse</button>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <?php if($demande_contrat->etat=="uploaded"): ?>
                <div class="row mt-2">
                    <div class="col-12">
                        <div class="card" style="background: #ddf6db;border: 2px #115555  solid;">
                            <div class="card-body">
                                <h6 class="card-title"><i class="fa-solid fa-file-signature mr-1"></i>Offre de prix acceptée</h6>
                                <div class="row">
                                    <div class="col-8">
                                        <p>Contrat chargé le <?php echo e($demande_contrat->contrat_file->formated_created_at()); ?></p>
                                    </div>
                                    <div class="col-4">
                                        <button file_id="<?php echo e($demande_contrat->contrat_file_id); ?>" type_document="CONTRAT" file_id="" type="button" class="btn  download_doc_link"><i class="fa-solid fa-download mr-1"></i>Télécharger le contrat</button>

                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <?php else: ?>

                <div class="row mt-2">
                    <div class="col-12">
                        <div class="card" style="background: #ffbbbb; border: 2px #d14646 solid;">
                            <div class="card-body">
                                <h6 class="card-title" style="color: #822323;"><i class="fa-solid fa-triangle-exclamation mr-1"></i>Contrat refusé</h6>
                                <div class="row">
                                    <div class="col-8">
                                        <p>Le contrat chargé le <?php echo e($demande_contrat->contrat_file->formated_created_at()); ?> a été refusé par le client pour le motif suivant : <b><?php echo e($demande_contrat->motif_rejet); ?></b></p>
                                    </div>

                                </div>

                            </div>
                        </div>
                    </div>
                </div>

                <?php endif; ?>

                <?php endif; ?>

                <?php endif; ?>
                <?php endif; ?>

                <?php if(Auth::user()->has_role("moa") && is_null($etude_marche)): ?>
                <div class="row mt-2 mb-4">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <h6 class="card-title"><i class="fa-solid fa-magnifying-glass-chart mr-1"></i>Etude du marché</h6>
                                <div class="row">
                                    <div class="col-12">
                                        <p style="text-align: center;">Une étude de marché permettra de diagnostiquer rapidement votre lot et de vous fournir une estimation du chiffre d’affaires selon les prix de vente et les offres approximatives.
                                            Pour demander une étude de marché maerci de clique sur le lien ci-dessous</p>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-12">
                                        <button style="margin: auto;display: block;" id="demande_etude_marche_btn" class="btn"><i class="fa-solid fa-circle-plus mr-1"></i>Demander l'étude de marché</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <?php if(!is_null($etude_marche)): ?>
                <div class="row mt-2 mb-4">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <h6 class="card-title">
                                    <i class="fa-solid fa-magnifying-glass-chart mr-1"></i>Etude du marché - <b style="color:<?php echo e($etude_marche->etat_color()); ?>"><?php echo e($etude_marche->h_etat()); ?></b>
                                    <?php if(Auth::user()->has_role("admin,chef_projet,moa")): ?>
                                    <a style="float: right;" href="/etude_marche/show/<?php echo e($etude_marche->id); ?>"><i class="fa-solid fa-link mr-1"></i>Basculer vers l'etude du marché</a>
                                    <?php endif; ?>
                                </h6>
                                <div class="row">
                                    <div class="col-12 col-sm-3">
                                        <table class="table table-striped datatables dataTable no-footer display nowrap etude_marche_atouts_table">
                                            <thead>
                                                <th>Atouts</th>
                                            </thead>
                                            <tbody>
                                                <?php if(count($etude_marche->atouts)==0): ?>
                                                <tr>
                                                    <td>
                                                        <span>Aucune donnée disponible dans le tableau</span>
                                                    </td>
                                                </tr>
                                                <?php else: ?>

                                                <?php $__currentLoopData = $etude_marche->atouts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $atout): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <b style="color: #3b8512;" class="ml-1"><i class="fa-regular fa-thumbs-up mr-1"></i><?php echo e($atout->content); ?></b>
                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>
                                    </div>

                                    <div class="col-12 col-sm-3">
                                        <table class="table table-striped datatables dataTable no-footer display nowrap etude_marche_faiblesses_table">
                                            <thead>
                                                <th>Faiblesses</th>
                                            </thead>
                                            <tbody>
                                                <?php if(count($etude_marche->faiblesses)==0): ?>
                                                <tr>
                                                    <td>
                                                        <span>Aucune donnée disponible dans le tableau</span>
                                                    </td>
                                                </tr>
                                                <?php else: ?>
                                                <?php $__currentLoopData = $etude_marche->faiblesses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $faiblesse): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <b style="color: #fb5151;" class="ml-1"><i class="fa-regular fa-thumbs-down mr-1"></i><?php echo e($faiblesse->content); ?></b>
                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>

                                            </tbody>
                                        </table>
                                    </div>

                                    <div class="col-12 col-sm-6">
                                        <table class="table table-striped datatables dataTable no-footer display nowrap etude_marche_produits_table">
                                            <thead>
                                                <th>Produit</th>
                                                <th>Surface vendable (Estimation)</th>
                                                <th>Prix unitaire adopté</th>
                                                <th>Chiffre d'affaire</th>
                                            </thead>
                                            <tbody>
                                                <?php if(count($etude_marche->projet->produits)==0): ?>
                                                <tr>
                                                    <td colspan="4">
                                                        <span>Aucune donnée disponible dans le tableau</span>
                                                    </td>
                                                </tr>
                                                <?php else: ?>
                                                <?php $__currentLoopData = $etude_marche->projet->produits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td>
                                                        <b><?php echo e($produit->type); ?></b>
                                                    </td>
                                                    <td>
                                                        <b><?php echo e($produit->surface_vendable); ?> m²</b>
                                                    </td>

                                                    <?php if($etude_marche->etat=="en_cours"): ?>
                                                    <td>
                                                        <b>-</b>
                                                    </td>
                                                    <td>
                                                        <b>-</b>
                                                    </td>
                                                    <?php else: ?>
                                                    <td>
                                                        <b><?php echo e(number_format( $produit->pu_adopte,0,'.',' ')); ?> MAD</b>
                                                    </td>
                                                    <td>
                                                        <b><?php echo e(number_format( $produit->prix_total,0,'.',' ')); ?> MAD</b>
                                                    </td>
                                                    <?php endif; ?>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </tbody>
                                        </table>

                                        <span style="color: #ca8e3d; float: right; margin-right: 8px;">Total : <b><?php echo e(number_format( $etude_marche_cf,0,'.',' ')); ?></b> MAD</span>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

            </div>

            <div class="tab-pane fade" id="projet" role="tabpanel" aria-labelledby="projet">
                <?php echo $__env->make("projets/projet_tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="tab-pane fade" id="documents" role="tabpanel" aria-labelledby="documents">
                <?php echo $__env->make("projets/documents_fichiers_tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="tab-pane fade" id="visualisation3d" role="tabpanel" aria-labelledby="visualisation3d">
                <?php echo $__env->make("projets/3dview_tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="tab-pane fade" id="reunion" role="tabpanel" aria-labelledby="reunion">
                <?php echo $__env->make("projets/reunions_tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="tab-pane fade" id="paiements" role="tabpanel" aria-labelledby="paiements">
                <?php echo $__env->make("projets/paiements_tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="tab-pane fade" id="echantillons" role="tabpanel" aria-labelledby="echantillons">
                <?php echo $__env->make("projets/echantillons_tab", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>

    <div class="col-12 col-sm-3">
        <div class="row" style="background: #f9f9f9; padding: 8px; border-radius: 6px; border: 1px #d2d2d2 solid;">

            <div class="row ml-2 mt-1" style="width:100%">
                <span style="color: #115555;font-size: 0.9rem;"><i class="fa-solid fa-layer-group mr-1"></i>Référence foncière : <?php echo e($projet->lot->ref_fonciere); ?></span>
            </div>

        </div>

        <div class="row mt-1" style="background: #f9f9f9; padding: 8px; border-radius: 6px; border: 1px #d2d2d2 solid;">
            <div class="row">

                <div class="col-3">
                    <img src="<?php echo e($projet->chef_projet->avatar()); ?>" class="user-image rounded-circle" style="border: #1e6f6c solid; border-width: 2px;width:100%">

                </div>
                <div class="col-4" style="display: block;margin: auto 0px;">
                    <b style="font-size: 0.8rem;color: #115555; "><?php echo e($projet->chef_projet->nom); ?> <?php echo e($projet->chef_projet->prenom); ?></b>
                    <br>
                    <b style="font-size: 0.7rem; color: #7a7a7a; font-style: italic;">Chef du projet</b>
                </div>
            </div>

            <div class="row mt-1" style="width:100%">
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text" style="width: 180px;">Démarage des travaux</span>
                    </div>
                    <input readonly="" class="form-control" value="-">
                </div>
            </div>

            <div class="row mt-1" style="width:100%">
                <div class="input-group">
                    <div class="input-group-prepend">
                        <span class="input-group-text" style="width: 180px;">Date prévue de fin des travaux</span>
                    </div>
                    <input readonly="" class="form-control" value="-">
                </div>
            </div>
        </div>
        <div class="row mt-1">
            <div class="card" style="width: 100%;background: #f9f9f9;">
                <div class="card-body">
                    <h6 class="card-title"><i class="fa-solid fa-list-check mr-1"></i>Avancement <?php echo e($projet->avancement); ?></h6>

                    <div class="row <?php echo e($steps==0?'ml-2':'ml-4'); ?> mt-1" style="width:100%">
                        <span style="<?php echo e($steps<0?'color:#7a7a7a':''); ?> <?php echo e($steps==0?'color:#ee9e3e':''); ?> <?php echo e($steps>0?'color:#46b054':''); ?> "><i class="fa-solid <?php echo e($steps<0?'fa-clock':''); ?> <?php echo e($steps>0?'fa-check':''); ?> <?php echo e($steps==0?'fa-caret-right':''); ?>  mr-1"></i>Travaux préparatoires</span>
                    </div>
                    <div class="row <?php echo e($steps==1?'ml-2':'ml-4'); ?> mt-1" style="width:100%">
                        <span style="<?php echo e($steps<1?'color:#7a7a7a':''); ?> <?php echo e($steps==1?'color:#ee9e3e':''); ?> <?php echo e($steps>1?'color:#46b054':''); ?>"><i class="fa-regular <?php echo e($steps<1?'fa-clock':''); ?> <?php echo e($steps>1?'fa-check':''); ?> <?php echo e($steps==1?'fa-caret-right':''); ?> mr-1"></i>Autorisation de construire</span>
                    </div>
                    <div class="row <?php echo e($steps==2?'ml-2':'ml-4'); ?> mt-1" style="width:100%">
                        <span style="<?php echo e($steps<2?'color:#7a7a7a':''); ?> <?php echo e($steps==2?'color:#ee9e3e':''); ?> <?php echo e($steps>2?'color:#46b054':''); ?>"><i class="fa-regular <?php echo e($steps<2?'fa-clock':''); ?> <?php echo e($steps>2?'fa-check':''); ?> <?php echo e($steps==2?'fa-caret-right':''); ?> mr-1"></i>Fondations</span>
                    </div>
                    <div class="row <?php echo e($steps==3?'ml-2':'ml-4'); ?> mt-1" style="width:100%">
                        <span style="<?php echo e($steps<3?'color:#7a7a7a':''); ?> <?php echo e($steps==3?'color:#ee9e3e':''); ?> <?php echo e($steps>3?'color:#46b054':''); ?>"><i class="fa-regular <?php echo e($steps<3?'fa-clock':''); ?> <?php echo e($steps>3?'fa-check':''); ?> <?php echo e($steps==3?'fa-caret-right':''); ?> mr-1"></i>Structure</span>
                    </div>
                    <div class="row <?php echo e($steps==4?'ml-2':'ml-4'); ?> <?php echo e($steps>4?'ml-4':''); ?> mt-1" style="width:100%">
                        <span style="<?php echo e($steps<4?'color:#7a7a7a':''); ?> <?php echo e($steps==4?'color:#ee9e3e':''); ?> <?php echo e($steps>4?'color:#46b054':''); ?>"><i class="fa-regular <?php echo e($steps<4?'fa-clock':''); ?> <?php echo e($steps>4?'fa-check':''); ?> <?php echo e($steps==4?'fa-caret-right':''); ?> mr-1"></i>Enveloppe</span>
                    </div>
                    <div class="row <?php echo e($steps==5?'ml-2':'ml-4'); ?> <?php echo e($steps>5?'ml-4':''); ?> mt-1" style="width:100%">
                        <span style="<?php echo e($steps<5?'color:#7a7a7a':''); ?> <?php echo e($steps==5?'color:#ee9e3e':''); ?> <?php echo e($steps>5?'color:#46b054':''); ?>"><i class="fa-regular <?php echo e($steps<5?'fa-clock':''); ?> <?php echo e($steps>5?'fa-check':''); ?> <?php echo e($steps==5?'fa-caret-right':''); ?> mr-1"></i>Finitions et Fin des travaux</span>
                    </div>

                </div>
            </div>
        </div>

        <div class="row mt-1">
            <div class="card" style="width: 100%;background: #f9f9f9;">
                <div class="card-body">
                    <h6 class="card-title"><i class="fa-solid fa-user-gear mr-1"></i>Intervenants</h6>

                    <table class="table table-striped datatables dataTable no-footer display nowrap">
                        <thead>
                            <th style="width:100px">Mission</th>
                            <th>Prestataire</th>
                        </thead>
                        <tbody>
                            <tr>
                                <td><b>Architecte</b></td>
                                <td>
                                    <?php if(is_null($projet->architecte)): ?>
                                    <b style="color:gray">Non désigné</b>
                                    <?php else: ?>
                                    <b style="color:#115555"><?php echo e($projet->architecte->organisme_ste); ?></b>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td><b>Topographe</b></td>
                                <td>
                                    <?php if(is_null($projet->igt)): ?>
                                    <b style="color:gray">Non désigné</b>
                                    <?php else: ?>
                                    <b style="color:#115555"><?php echo e($projet->igt->organisme_ste); ?></b>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td><b>Laboratoire</b></td>
                                <td>
                                    <?php if(is_null($projet->laboratoire)): ?>
                                    <b style="color:gray">Non désigné</b>
                                    <?php else: ?>
                                    <b style="color:#115555"><?php echo e($projet->laboratoire->organisme_ste); ?></b>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td><b>Bureau d'étude</b></td>
                                <td>
                                    <?php if(is_null($projet->bet)): ?>
                                    <b style="color:gray">Non désigné</b>
                                    <?php else: ?>
                                    <b style="color:#115555"><?php echo e($projet->bet->organisme_ste); ?></b>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td><b>Bureau de controle</b></td>
                                <td>
                                    <?php if(is_null($projet->bc)): ?>
                                    <b style="color:gray">Non désigné</b>
                                    <?php else: ?>
                                    <b style="color:#115555"><?php echo e($projet->bc->organisme_ste); ?></b>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td><b>Entreprise</b></td>
                                <td>
                                    <?php if(is_null($projet->entreprise)): ?>
                                    <b style="color:gray">Non désigné</b>
                                    <?php else: ?>
                                    <b style="color:#115555"><?php echo e($projet->entreprise->organisme_ste); ?></b>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <?php if($readonly==false): ?>
        <div class="row mt-1">
            <div class="card" style="width: 100%;background: #f9f9f9;">
                <div class="card-body">
                    <h6 class="card-title"><i class="fa-solid fa-gear mr-1"></i>Actions</h6>
                    <button id="save_projet" style="width: 100%;" class="btn mt-1"><i class="fa-regular fa-floppy-disk mr-1"></i>Enregistrer les modifications</button>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php echo $__env->make('projets/modals', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('added_scripts'); ?>
<script>
    var projet_id = "<?php echo e($projet->id); ?>";
    var lot_id = "<?php echo e($projet->lot->id); ?>";
    var lot_lat = parseFloat("<?php echo e($projet->lot->lat); ?>");
    var lot_lng = parseFloat("<?php echo e($projet->lot->lng); ?>");

    var demande_devis = <?php echo json_encode($demnande_devis, 15, 512) ?>;

    var cp_formulaire_data = <?php echo json_encode($cp_formulaire_data, 15, 512) ?>
</script>

<script src="<?php echo e(asset('js/projets/image_sat.js').'?t='.time()); ?>"></script>
<script src="<?php echo e(asset('js/projets/show.js').'?t='.time()); ?>"></script>
<script src="<?php echo e(asset('js/projets/intervenants.js').'?t='.time()); ?>"></script>
<script src="<?php echo e(asset('js/projets/produits.js').'?t='.time()); ?>"></script>
<script src="<?php echo e(asset('js/projets/charges_taxes.js').'?t='.time()); ?>"></script>
<script src="<?php echo e(asset('js/projets/entreprise.js').'?t='.time()); ?>"></script>
<script src="<?php echo e(asset('js/projets/reunion.js').'?t='.time()); ?>"></script>
<script src="<?php echo e(asset('js/projets/form_cp.js').'?t='.time()); ?>"></script>

<script src="<?php echo e(asset('js/projets/echantillon.js').'?t='.time()); ?>"></script>
<script src="<?php echo e(asset('js/projets/paiements.js').'?t='.time()); ?>"></script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u447310764/domains/alomraneassist.ma/public_html/resources/views/projets/show.blade.php ENDPATH**/ ?>