<div class="card card-refresh mt-2" style="<?php echo e(Auth::user()->has_role('Observateur filiale,Laboratoire,Vérificateur,Observateur de suivi,Agence urbaine,Administrateur,Architecte,IGT,BET')?'':'display:none'); ?>">
    <div class="refresh-container">
        <div class="loader-pendulums"></div>
    </div>
    <div class="card-header card-header-action">
        <h5 style="margin: 2px !important;color: #2273ae;font-size: 15px;">Dossier de permis de construire</h5>
        <div class="d-flex align-items-center card-action-wrap">
            <a class="inline-block mr-15" data-toggle="collapse" href="#collapse_3" aria-expanded="true">
                <i class="zmdi zmdi-chevron-down"></i>
            </a>

        </div>
    </div>
    <div id="collapse_3" class="collapse show">
        <div class="card-body">
            <?php if(!Auth::user()->has_role('Vérificateur')): ?>
            <h6><input <?php echo e(Auth::user()->has_role('Architecte')?'':'disabled'); ?> <?php echo e($dossier->use_plan_type==1?'checked':''); ?> type="checkbox" class="use_plan_type">&nbspPlan type (Architecte)</h6>
            <div class="plan_type_div card <?php echo e($dossier->use_plan_type==0?'disabled':''); ?>">

                <table class="table rtable datatables table-striped no-footer display nowrap  ">
                    <thead>
                        <th style="text-align: left;">Plan type</th>
                        <th style="text-align: center;">Document</th>
                        <th style="text-align: center;">Etat</th>
                        <th style="text-align: center;">Téléchargement</th>

                    </thead>
                    <tbody>
                        <tr>
                            <td style="text-align: left;"><i class="fa-solid fa-sheet-plastic"></i>&nbspPlan type - Architecte</td>
                            <td style="text-align: center;">
                                <select class="plan_type_select form-control select2nc">
                                    <option <?php echo e(is_null($dossier->plan_type)?'selected':''); ?> value="">Veuillez sélectionner</option>
                                    <?php $__currentLoopData = $plans_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if( $plan_type->type=="PLAN_ARCHITECTE"): ?>
                                    <option <?php echo e($dossier->plan_type_id==$plan_type->id?'selected':''); ?> value="<?php echo e($plan_type->id); ?>">Plan type <?php echo e($plan_type->nom); ?></option>
                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </td>
                            <td style="text-align: center;"><span class="plan_type_etat" style="color:#575757">Aucun fichier sélectionné</span></td>
                            <td style="text-align: center;">
                                <button disabled type="button" class="btn btn-success download_plan_type_link"><i class="fa-solid fa-download "></i>&nbsp;Télécharger</button>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>


            <h6><input <?php echo e(Auth::user()->has_role('BET')?'':'disabled'); ?> <?php echo e($dossier->use_plan_type_bet==1?'checked':''); ?> type="checkbox" class="use_plan_type_bet">&nbspPlan type (BET)</h6>
            <div class="plan_type_bet_div card <?php echo e($dossier->use_plan_type_bet==0?'disabled':''); ?>">

                <table class="table rtable datatables table-striped no-footer display nowrap  ">
                    <thead>
                        <th style="text-align: left;">Plan type</th>
                        <th style="text-align: center;">Document</th>

                        <th style="text-align: center;">Téléchargement</th>

                    </thead>
                    <tbody>
                        <tr>
                            <td style="text-align: left;"><i class="fa-solid fa-sheet-plastic"></i>&nbspPlan type - BET</td>
                            <td style="text-align: center;">
                                <select class="plan_type_bet_select form-control select2nc">
                                    <option <?php echo e(is_null($dossier->plan_type)?'selected':''); ?> value="">Veuillez sélectionner</option>
                                    <?php $__currentLoopData = $plans_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if( $plan_type->type=="BET"): ?>
                                    <option <?php echo e($dossier->plan_type_bet_id==$plan_type->id?'selected':''); ?> value="<?php echo e($plan_type->id); ?>">Plan type <?php echo e($plan_type->nom); ?></option>
                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </td>
                            <td style="text-align: center;">
                                <button disabled type="button" class="btn btn-success download_plan_type_bet_link"><i class="fa-solid fa-download "></i>&nbsp;Télécharger</button>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <?php endif; ?>
            <h6 class="mt-3">Dossier de permis de construire</h6>

            <table class="table rtable datatables table-striped no-footer display nowrap">
                <thead>
                    <th>Document</th>
                    <th>Type du fichier</th>
                    <th>Date dépôt</th>
                    <th>Date document</th>
                    <th style="display:none;">Vérification de dépôt</th>
                    <th></th>
                    <th></th>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $permis_construire_documents_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $permis_construire_document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><i class="fa-solid fa-file-pdf"></i>&nbsp<?php echo e($permis_construire_document['name']); ?>

                            <?php if($permis_construire_document['document']!=null && $permis_construire_document['validation']==1): ?>
                            <span style="font-weight:bold;color:<?php echo e($permis_construire_document['document']->decision_color()); ?>"> - <?php echo e($permis_construire_document['document']->decision_full()); ?></span>
                            <?php endif; ?>
                        </td>
                        <td>Fichier <?php echo e(strtoupper($permis_construire_document['file_type'])); ?></td>
                        <td>
                            <?php if(is_null($permis_construire_document['document'])): ?>
                            <span type_document="<?php echo e($permis_construire_document['type_document']); ?>" class="download_depot_date" style="color:gray">Aucun fichier importé</span>
                            <?php else: ?>
                            <span type_document="<?php echo e($permis_construire_document['type_document']); ?>" class="download_depot_date" style="color:black"><?php echo e($permis_construire_document['document']->formated_created_at()); ?> - <span style="color:coral"><?php echo e($permis_construire_document['document']->user->organisme_ste); ?> <span></span>
                                    <?php endif; ?>
                        </td>

                        <td style="display:none;">
                            <?php if(is_null($permis_construire_document['document'])): ?>
                            <span type_document="<?php echo e($permis_construire_document['type_document']); ?>" class="download_depot_date" style="color:gray">Aucun fichier importé</span>
                            <?php else: ?>

                            <a href="javascript:;" document_id="<?php echo e($permis_construire_document['document']->id); ?>" type_document="<?php echo e($permis_construire_document['type_document']); ?>" class="document_decision" style="<?php echo e((Auth::user()->role->name == "Architecte" ?'':'pointer-events:none;text-decoration:none;')); ?>;color:<?php echo e($permis_construire_document['document']->decision_color()); ?> !important"><?php echo e($permis_construire_document['document']->decision_full()); ?></a>
                            <a href="javascript:;" data-toggle="popover" title="Commentaire" data-content="<?php echo e($permis_construire_document['document']->commentaire); ?>" document_id="<?php echo e($permis_construire_document['document']->id); ?>" style="display:<?php echo e(strlen($permis_construire_document['document']->commentaire)>0?'inline-block':'none'); ?>;margin-left:6px;color:darkorange" class="fa-solid fa-comment-dots document_comments"></a>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if(!is_null($permis_construire_document['document'])): ?>
                            <span><?php echo e($permis_construire_document['document']->formated_date_document()); ?> </span>
                            <?php else: ?>
                            <span type_document="<?php echo e($permis_construire_document['type_document']); ?>" style="color:gray">Aucun fichier importé</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if(Auth::user()->has_role($permis_construire_document['w_roles']) && $permis_construire_document['active']==1): ?>
                            <button type_document="<?php echo e($permis_construire_document['type_document']); ?>" file_type="<?php echo e($permis_construire_document['file_type']); ?>" type="button" class="btn btn-light upload_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if(is_null($permis_construire_document['document'])): ?>
                            <button type_document="<?php echo e($permis_construire_document['type_document']); ?>" file_id="" disabled type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download "></i>&nbsp;Télécharger</button>
                            <?php else: ?>
                            <button type_document="<?php echo e($permis_construire_document['type_document']); ?>" file_id="<?php echo e($permis_construire_document['document']->id); ?>" type="button" class="btn btn-success download_doc_link"><i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                            <?php endif; ?>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <h6>Autorisation de construire</h6>
            <div class="row">
                <div class="col-md-4 col-12">
                    <div style="background: #f8f8f8; padding: 8px; border: 1px silver dashed; border-radius: 8px;">
                        <div>
                            <?php if(is_null($autorisation_construire_document['document'])): ?>
                            <i type_document="<?php echo e($autorisation_construire_document['type_document']); ?>" style="font-size: 2rem; display: block; margin: auto; text-align: center;color: gray; border-bottom: 1px silver dashed; padding: 8px;" class="fa-solid fa-file-circle-xmark upload_doc_icon"></i>
                            <?php else: ?>
                            <i type_document="<?php echo e($autorisation_construire_document['type_document']); ?>" style="font-size: 2rem; display: block; margin: auto; text-align: center;color: #68a334; border-bottom: 1px silver dashed; padding: 8px;" class="fa-solid fa-file-circle-check upload_doc_icon"></i>
                            <span style="width: 100%; display: block; text-align: center;"> Etat de la validation :
                                <span style="font-weight:bold;color:<?php echo e($autorisation_construire_document['document']->decision_color()); ?>"> - <?php echo e($autorisation_construire_document['document']->decision_full()); ?></span>
                            </span>
                            <?php endif; ?>

                            <?php if(is_null($autorisation_construire_document['document'])): ?>
                            <b type_document="<?php echo e($autorisation_construire_document['type_document']); ?>" class="mt-2 upload_doc_no_file_label" style="color:gray;display: block; margin: auto;text-align: center;">Aucun fichier importé </b>
                            <?php endif; ?>
                            <div style="margin: auto; display: block;text-align: center;">
                                <?php if(Auth::user()->has_role($autorisation_construire_document['w_roles']) && $autorisation_construire_document['active']==1): ?>
                                <button type_document="<?php echo e($autorisation_construire_document['type_document']); ?>" file_type="<?php echo e($autorisation_construire_document['file_type']); ?>" type="button" class="btn btn-light upload_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Importer</button>
                                <?php endif; ?>
                                <?php if(is_null($autorisation_construire_document['document'])): ?>
                                <button disabled type_document="<?php echo e($autorisation_construire_document['type_document']); ?>" file_id="" type="button" class="btn btn-success download_doc_link"> <i class="fa-solid fa-plus"></i>&nbsp;Télécharger</button>
                                <?php else: ?>
                                <button type_document="<?php echo e($autorisation_construire_document['type_document']); ?>" file_id="<?php echo e($autorisation_construire_document['document']->id); ?>" type="button" class="btn btn-success download_doc_link"> <i class="fa-solid fa-download"></i>&nbsp;Télécharger</button>
                                <?php endif; ?>
                            </div>


                        </div>
                    </div>
                </div>

                <div class="col-md-4 col-12">
                    <div class="row">
                        <div class="col-12">
                            <b style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Date de l'autorisation</b>
                            <?php if(is_null($autorisation_construire_document['document'])): ?>
                            <b type_document="<?php echo e($autorisation_construire_document['type_document']); ?>" class="mt-1 download_doc_date" style="color:gray;display: block; margin: auto;text-align: center;">Aucun fichier importé </b>
                            <?php else: ?>
                            <b type_document="<?php echo e($autorisation_construire_document['type_document']); ?>" class="mt-1 download_doc_date" style="color:black;display: block; margin: auto;text-align: center;"><?php echo e($autorisation_construire_document['document']->formated_date_document()); ?></b>
                            <?php endif; ?>
                        </div>
                        <div class="col-12 mt-3">
                            <b style="color:#4f7c28;display: block; margin: auto;text-align: center;border-bottom: 1px #e3e3e3 dashed;">Date de dépot</b>
                            <?php if(is_null($autorisation_construire_document['document'])): ?>
                            <b type_document="<?php echo e($autorisation_construire_document['type_document']); ?>" class="mt-1 download_depot_date" style="color:gray;display: block; margin: auto;text-align: center;">Aucun fichier importé </b>
                            <?php else: ?>
                            <b type_document="<?php echo e($autorisation_construire_document['type_document']); ?>" class="mt-1 download_depot_date" style="color:black;display: block; margin: auto;text-align: center;"><?php echo e($autorisation_construire_document['document']->formated_created_at()); ?></b>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH /home/batirc6/public_html/resources/views/dossiers/detail_permis_construire.blade.php ENDPATH**/ ?>